"use strict";

exports.__esModule = true;
var TOKENIZE_POLICY = {
  characters: {
    tokenizeString: null,
    isAtomic: function isAtomic(str) {
      return str.length <= 1;
    }
  },
  words: {
    tokenizeString: function tokenizeString(str) {
      return str.match(/(\s*\S[\S\xA0]*)/g);
    },
    isAtomic: function isAtomic(str) {
      return (/^\s*[\S\xA0]*\s*$/.test(str)
      );
    }
  }
};

exports.default = TOKENIZE_POLICY;
module.exports = exports["default"];