"use strict";
(() => {
var exports = {};
exports.id = 18702;
exports.ids = [18702,64820];
exports.modules = {

/***/ 74449:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1388);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40968);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_head__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__]);
_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const PageTitle = ({
  title
}) => {
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)();
  const titleText = `${Array.isArray(title) ? title.filter(Boolean).join(' - ') : title} - ${settings.currentSettings.applicationTitle}`;
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx((next_head__WEBPACK_IMPORTED_MODULE_1___default()), {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("title", {
      children: titleText
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PageTitle);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 25279:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(74449);
/* harmony import */ var _app_components_PermissionEdit__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(33181);
/* harmony import */ var _app_components_QuotaSelector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(86957);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__, _app_components_PermissionEdit__WEBPACK_IMPORTED_MODULE_3__, axios__WEBPACK_IMPORTED_MODULE_7__, swr__WEBPACK_IMPORTED_MODULE_11__]);
([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__, _app_components_PermissionEdit__WEBPACK_IMPORTED_MODULE_3__, axios__WEBPACK_IMPORTED_MODULE_7__, swr__WEBPACK_IMPORTED_MODULE_11__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.defineMessages)({
  users: {
    "id": "components.Settings.SettingsUsers.users",
    "defaultMessage": 'Users'
  },
  userSettings: {
    "id": "components.Settings.SettingsUsers.userSettings",
    "defaultMessage": 'User Settings'
  },
  userSettingsDescription: {
    "id": "components.Settings.SettingsUsers.userSettingsDescription",
    "defaultMessage": 'Configure global and default user settings.'
  },
  toastSettingsSuccess: {
    "id": "components.Settings.SettingsUsers.toastSettingsSuccess",
    "defaultMessage": 'User settings saved successfully!'
  },
  toastSettingsFailure: {
    "id": "components.Settings.SettingsUsers.toastSettingsFailure",
    "defaultMessage": 'Something went wrong while saving settings.'
  },
  localLogin: {
    "id": "components.Settings.SettingsUsers.localLogin",
    "defaultMessage": 'Enable Local Sign-In'
  },
  localLoginTip: {
    "id": "components.Settings.SettingsUsers.localLoginTip",
    "defaultMessage": 'Allow users to sign in using their email address and password, instead of Plex OAuth'
  },
  newPlexLogin: {
    "id": "components.Settings.SettingsUsers.newPlexLogin",
    "defaultMessage": 'Enable New Plex Sign-In'
  },
  newPlexLoginTip: {
    "id": "components.Settings.SettingsUsers.newPlexLoginTip",
    "defaultMessage": 'Allow Plex users to sign in without first being imported'
  },
  movieRequestLimitLabel: {
    "id": "components.Settings.SettingsUsers.movieRequestLimitLabel",
    "defaultMessage": 'Global Movie Request Limit'
  },
  tvRequestLimitLabel: {
    "id": "components.Settings.SettingsUsers.tvRequestLimitLabel",
    "defaultMessage": 'Global Series Request Limit'
  },
  defaultPermissions: {
    "id": "components.Settings.SettingsUsers.defaultPermissions",
    "defaultMessage": 'Default Permissions'
  },
  defaultPermissionsTip: {
    "id": "components.Settings.SettingsUsers.defaultPermissionsTip",
    "defaultMessage": 'Initial permissions assigned to new users'
  }
});

const SettingsUsers = () => {
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__.useToasts)();
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.useIntl)();
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_11__["default"])('/api/v1/settings/main');

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {});
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      title: [intl.formatMessage(messages.users), intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].settings */ .Z.settings)]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
      className: "mb-6",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.userSettings)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("p", {
        className: "description",
        children: intl.formatMessage(messages.userSettingsDescription)
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
      className: "section",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(formik__WEBPACK_IMPORTED_MODULE_8__.Formik, {
        initialValues: {
          localLogin: data?.localLogin,
          newPlexLogin: data?.newPlexLogin,
          movieQuotaLimit: data?.defaultQuotas.movie.quotaLimit ?? 0,
          movieQuotaDays: data?.defaultQuotas.movie.quotaDays ?? 7,
          tvQuotaLimit: data?.defaultQuotas.tv.quotaLimit ?? 0,
          tvQuotaDays: data?.defaultQuotas.tv.quotaDays ?? 7,
          defaultPermissions: data?.defaultPermissions ?? 0
        },
        enableReinitialize: true,
        onSubmit: async values => {
          try {
            await axios__WEBPACK_IMPORTED_MODULE_7__["default"].post('/api/v1/settings/main', {
              localLogin: values.localLogin,
              newPlexLogin: values.newPlexLogin,
              defaultQuotas: {
                movie: {
                  quotaLimit: values.movieQuotaLimit,
                  quotaDays: values.movieQuotaDays
                },
                tv: {
                  quotaLimit: values.tvQuotaLimit,
                  quotaDays: values.tvQuotaDays
                }
              },
              defaultPermissions: values.defaultPermissions
            });
            (0,swr__WEBPACK_IMPORTED_MODULE_11__.mutate)('/api/v1/settings/public');
            addToast(intl.formatMessage(messages.toastSettingsSuccess), {
              autoDismiss: true,
              appearance: 'success'
            });
          } catch (e) {
            addToast(intl.formatMessage(messages.toastSettingsFailure), {
              autoDismiss: true,
              appearance: 'error'
            });
          } finally {
            revalidate();
          }
        },
        children: ({
          isSubmitting,
          values,
          setFieldValue
        }) => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_8__.Form, {
            className: "section",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("label", {
                htmlFor: "localLogin",
                className: "checkbox-label",
                children: [intl.formatMessage(messages.localLogin), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
                  className: "label-tip",
                  children: intl.formatMessage(messages.localLoginTip)
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(formik__WEBPACK_IMPORTED_MODULE_8__.Field, {
                  type: "checkbox",
                  id: "localLogin",
                  name: "localLogin",
                  onChange: () => {
                    setFieldValue('localLogin', !values.localLogin);
                  }
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("label", {
                htmlFor: "newPlexLogin",
                className: "checkbox-label",
                children: [intl.formatMessage(messages.newPlexLogin), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
                  className: "label-tip",
                  children: intl.formatMessage(messages.newPlexLoginTip)
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(formik__WEBPACK_IMPORTED_MODULE_8__.Field, {
                  type: "checkbox",
                  id: "newPlexLogin",
                  name: "newPlexLogin",
                  onChange: () => {
                    setFieldValue('newPlexLogin', !values.newPlexLogin);
                  }
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("label", {
                htmlFor: "applicationTitle",
                className: "text-label",
                children: intl.formatMessage(messages.movieRequestLimitLabel)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_app_components_QuotaSelector__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                  onChange: setFieldValue,
                  dayFieldName: "movieQuotaDays",
                  limitFieldName: "movieQuotaLimit",
                  mediaType: "movie",
                  defaultDays: values.movieQuotaDays,
                  defaultLimit: values.movieQuotaLimit
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("label", {
                htmlFor: "applicationTitle",
                className: "text-label",
                children: intl.formatMessage(messages.tvRequestLimitLabel)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_app_components_QuotaSelector__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                  onChange: setFieldValue,
                  dayFieldName: "tvQuotaDays",
                  limitFieldName: "tvQuotaLimit",
                  mediaType: "tv",
                  defaultDays: values.tvQuotaDays,
                  defaultLimit: values.tvQuotaLimit
                })
              })]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
              role: "group",
              "aria-labelledby": "group-label",
              className: "form-group",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
                className: "form-row",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("span", {
                  id: "group-label",
                  className: "group-label",
                  children: [intl.formatMessage(messages.defaultPermissions), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
                    className: "label-tip",
                    children: intl.formatMessage(messages.defaultPermissionsTip)
                  })]
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
                  className: "form-input-area",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
                    className: "max-w-lg",
                    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_app_components_PermissionEdit__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP, {
                      currentPermission: values.defaultPermissions,
                      onUpdate: newPermissions => setFieldValue('defaultPermissions', newPermissions)
                    })
                  })
                })]
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
              className: "actions",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
                className: "flex justify-end",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
                  className: "ml-3 inline-flex rounded-md shadow-sm",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                    buttonType: "primary",
                    type: "submit",
                    disabled: isSubmitting,
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_6__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
                      children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].save */ .Z.save)
                    })]
                  })
                })
              })
            })]
          });
        }
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsUsers);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 59692:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(91865);
/* harmony import */ var _app_components_Settings_SettingsUsers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(25279);
/* harmony import */ var _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(75691);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(86799);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_0__, _app_components_Settings_SettingsUsers__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__]);
([_app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_0__, _app_components_Settings_SettingsUsers__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const SettingsUsersPage = () => {
  (0,_app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__/* .Permission.ADMIN */ .y3.ADMIN);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Settings_SettingsUsers__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {})
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsUsersPage);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12135:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/outline");

/***/ }),

/***/ 2296:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 3280:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/app-router-context.js");

/***/ }),

/***/ 92796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 64406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 11751:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/add-path-prefix.js");

/***/ }),

/***/ 46220:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/compare-states.js");

/***/ }),

/***/ 10299:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-next-pathname-info.js");

/***/ }),

/***/ 23938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 35789:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-next-pathname-info.js");

/***/ }),

/***/ 1897:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-bot.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 28854:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 34567:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/path-has-prefix.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 93297:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 40968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 13126:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 95927:
/***/ ((module) => {

module.exports = require("react-toast-notifications");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 15941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [80676,41664,1388,61439,19998,80210,86799,33173,35754,86957,33181], () => (__webpack_exec__(59692)));
module.exports = __webpack_exports__;

})();