"use strict";
(() => {
var exports = {};
exports.id = 62447;
exports.ids = [62447,64820];
exports.modules = {

/***/ 98435:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_utils_typeHelpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(66234);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);





const ListItem = ({
  title,
  className,
  children
}) => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      className: "max-w-6xl py-4 sm:grid sm:grid-cols-3 sm:gap-4",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("dt", {
        className: "block text-sm font-bold text-gray-400",
        children: title
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("dd", {
        className: "flex text-sm text-white sm:col-span-2 sm:mt-0",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
          className: `flex-grow ${className}`,
          children: children
        })
      })]
    })
  });
};

const List = ({
  title,
  subTitle,
  children
}) => {
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h3", {
        className: "heading",
        children: title
      }), subTitle && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("p", {
        className: "description",
        children: subTitle
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
      className: "section border-t border-gray-800",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("dl", {
        className: "divide-y divide-gray-800",
        children: children
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_app_utils_typeHelpers__WEBPACK_IMPORTED_MODULE_1__/* .withProperties */ .W)(List, {
  Item: ListItem
}));

/***/ }),

/***/ 9172:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(22796);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(80210);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(61185);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(5152);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(next_dynamic__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_3__, _headlessui_react__WEBPACK_IMPORTED_MODULE_5__, swr__WEBPACK_IMPORTED_MODULE_10__]);
([_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_3__, _headlessui_react__WEBPACK_IMPORTED_MODULE_5__, swr__WEBPACK_IMPORTED_MODULE_10__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);










 // dyanmic is having trouble extracting the props for react-markdown here so we are just ignoring it since its really
// only children we are using
// eslint-disable-next-line @typescript-eslint/no-explicit-any



const ReactMarkdown = next_dynamic__WEBPACK_IMPORTED_MODULE_7___default()(() => Promise.resolve(/* import() */).then(__webpack_require__.bind(__webpack_require__, 23135)), {
  ssr: false,
  loadableGenerated: {
    modules: ["../components/Settings/SettingsAbout/Releases/index.tsx -> " + 'react-markdown']
  }
});
const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.defineMessages)({
  releases: {
    "id": "components.Settings.SettingsAbout.Releases.releases",
    "defaultMessage": 'Releases'
  },
  releasedataMissing: {
    "id": "components.Settings.SettingsAbout.Releases.releasedataMissing",
    "defaultMessage": 'Release data is currently unavailable.'
  },
  versionChangelog: {
    "id": "components.Settings.SettingsAbout.Releases.versionChangelog",
    "defaultMessage": '{version} Changelog'
  },
  viewongithub: {
    "id": "components.Settings.SettingsAbout.Releases.viewongithub",
    "defaultMessage": 'View on GitHub'
  },
  latestversion: {
    "id": "components.Settings.SettingsAbout.Releases.latestversion",
    "defaultMessage": 'Latest'
  },
  currentversion: {
    "id": "components.Settings.SettingsAbout.Releases.currentversion",
    "defaultMessage": 'Current'
  },
  viewchangelog: {
    "id": "components.Settings.SettingsAbout.Releases.viewchangelog",
    "defaultMessage": 'View Changelog'
  }
});
const REPO_RELEASE_API = 'https://api.github.com/repos/sct/overseerr/releases?per_page=20';

const Release = ({
  currentVersion,
  release,
  isLatest
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.useIntl)();
  const {
    0: isModalOpen,
    1: setModalOpen
  } = (0,react__WEBPACK_IMPORTED_MODULE_8__.useState)(false);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    className: "flex w-full flex-col space-y-3 rounded-md bg-gray-800 px-4 py-2 shadow-md ring-1 ring-gray-700 sm:flex-row sm:space-y-0 sm:space-x-3",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_5__.Transition, {
      as: react__WEBPACK_IMPORTED_MODULE_8__.Fragment,
      enter: "transition-opacity duration-300",
      enterFrom: "opacity-0",
      enterTo: "opacity-100",
      leave: "transition-opacity duration-300",
      leaveFrom: "opacity-100",
      leaveTo: "opacity-0",
      show: isModalOpen,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_Modal__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        onCancel: () => setModalOpen(false),
        title: intl.formatMessage(messages.versionChangelog, {
          version: release.name
        }),
        cancelText: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_4__/* ["default"].close */ .Z.close),
        okText: intl.formatMessage(messages.viewongithub),
        onOk: () => {
          window.open(release.html_url, '_blank');
        },
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
          className: "prose",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(ReactMarkdown, {
            children: release.body
          })
        })
      })
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
      className: "flex w-full flex-grow items-center justify-center space-x-2 truncate sm:justify-start",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("span", {
        className: "truncate text-lg font-bold",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
          className: "mr-2 whitespace-nowrap text-xs font-normal",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(react_intl__WEBPACK_IMPORTED_MODULE_9__.FormattedRelativeTime, {
            value: Math.floor((new Date(release.created_at).getTime() - Date.now()) / 1000),
            updateIntervalInSeconds: 1,
            numeric: "auto"
          })
        }), release.name]
      }), isLatest && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        badgeType: "success",
        children: intl.formatMessage(messages.latestversion)
      }), release.name.includes(currentVersion) && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        badgeType: "primary",
        children: intl.formatMessage(messages.currentversion)
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      buttonType: "primary",
      onClick: () => setModalOpen(true),
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_6__.DocumentTextIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("span", {
        children: intl.formatMessage(messages.viewchangelog)
      })]
    })]
  });
};

const Releases = ({
  currentVersion
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.useIntl)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_10__["default"])(REPO_RELEASE_API);

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {});
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
      className: "text-gray-300",
      children: intl.formatMessage(messages.releasedataMissing)
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("h3", {
      className: "heading",
      children: intl.formatMessage(messages.releases)
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
      className: "section space-y-3",
      children: data.map((release, index) => {
        return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(Release, {
            release: release,
            currentVersion: currentVersion,
            isLatest: index === 0
          })
        }, `release-${release.id}`);
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Releases);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 7798:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13555);
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(98435);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Settings_SettingsAbout_Releases__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(9172);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(80210);
/* harmony import */ var _app_pages_error__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(35635);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__, _app_components_Settings_SettingsAbout_Releases__WEBPACK_IMPORTED_MODULE_5__, _app_pages_error__WEBPACK_IMPORTED_MODULE_7__, swr__WEBPACK_IMPORTED_MODULE_10__]);
([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__, _app_components_Settings_SettingsAbout_Releases__WEBPACK_IMPORTED_MODULE_5__, _app_pages_error__WEBPACK_IMPORTED_MODULE_7__, swr__WEBPACK_IMPORTED_MODULE_10__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);














const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.defineMessages)({
  about: {
    "id": "components.Settings.SettingsAbout.about",
    "defaultMessage": 'About'
  },
  overseerrinformation: {
    "id": "components.Settings.SettingsAbout.overseerrinformation",
    "defaultMessage": 'About Overseerr'
  },
  version: {
    "id": "components.Settings.SettingsAbout.version",
    "defaultMessage": 'Version'
  },
  totalmedia: {
    "id": "components.Settings.SettingsAbout.totalmedia",
    "defaultMessage": 'Total Media'
  },
  totalrequests: {
    "id": "components.Settings.SettingsAbout.totalrequests",
    "defaultMessage": 'Total Requests'
  },
  gettingsupport: {
    "id": "components.Settings.SettingsAbout.gettingsupport",
    "defaultMessage": 'Getting Support'
  },
  githubdiscussions: {
    "id": "components.Settings.SettingsAbout.githubdiscussions",
    "defaultMessage": 'GitHub Discussions'
  },
  timezone: {
    "id": "components.Settings.SettingsAbout.timezone",
    "defaultMessage": 'Time Zone'
  },
  appDataPath: {
    "id": "components.Settings.SettingsAbout.appDataPath",
    "defaultMessage": 'Data Directory'
  },
  supportoverseerr: {
    "id": "components.Settings.SettingsAbout.supportoverseerr",
    "defaultMessage": 'Support Overseerr'
  },
  helppaycoffee: {
    "id": "components.Settings.SettingsAbout.helppaycoffee",
    "defaultMessage": 'Help Pay for Coffee'
  },
  documentation: {
    "id": "components.Settings.SettingsAbout.documentation",
    "defaultMessage": 'Documentation'
  },
  preferredmethod: {
    "id": "components.Settings.SettingsAbout.preferredmethod",
    "defaultMessage": 'Preferred'
  },
  outofdate: {
    "id": "components.Settings.SettingsAbout.outofdate",
    "defaultMessage": 'Out of Date'
  },
  uptodate: {
    "id": "components.Settings.SettingsAbout.uptodate",
    "defaultMessage": 'Up to Date'
  },
  betawarning: {
    "id": "components.Settings.SettingsAbout.betawarning",
    "defaultMessage": 'This is BETA software. Features may be broken and/or unstable. Please report any issues on GitHub!'
  },
  runningDevelop: {
    "id": "components.Settings.SettingsAbout.runningDevelop",
    "defaultMessage": 'You are running the <code>develop</code> branch of Overseerr, which is only recommended for those contributing to development or assisting with bleeding-edge testing.'
  }
});

const SettingsAbout = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.useIntl)();
  const {
    data,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_10__["default"])('/api/v1/settings/about');
  const {
    data: status
  } = (0,swr__WEBPACK_IMPORTED_MODULE_10__["default"])('/api/v1/status');

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {});
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_pages_error__WEBPACK_IMPORTED_MODULE_7__["default"], {
      statusCode: 500
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      title: [intl.formatMessage(messages.about), intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].settings */ .Z.settings)]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
      className: "mt-6 rounded-md border border-indigo-500 bg-indigo-400 bg-opacity-20 p-4 backdrop-blur",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
        className: "flex",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
          className: "flex-shrink-0",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_8__.InformationCircleIcon, {
            className: "h-5 w-5 text-gray-100"
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)("div", {
          className: "ml-3 flex-1 md:flex md:justify-between",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("p", {
            className: "text-sm leading-5 text-gray-100",
            children: intl.formatMessage(messages.betawarning)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("p", {
            className: "mt-3 text-sm leading-5 md:mt-0 md:ml-6",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("a", {
              href: "http://github.com/sct/overseerr",
              className: "whitespace-nowrap font-medium text-gray-100 transition duration-150 ease-in-out hover:text-white",
              target: "_blank",
              rel: "noreferrer",
              children: "GitHub \u2192"
            })
          })]
        })]
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
      className: "section",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        title: intl.formatMessage(messages.overseerrinformation),
        children: [data.version.startsWith('develop-') && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          title: intl.formatMessage(messages.runningDevelop, {
            code: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("code", {
              className: "bg-opacity-50",
              children: msg
            })
          })
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__/* ["default"].Item */ .Z.Item, {
          title: intl.formatMessage(messages.version),
          className: "flex flex-row items-center truncate",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("code", {
            className: "truncate",
            children: data.version.replace('develop-', '')
          }), status?.commitTag !== 'local' && (status?.updateAvailable ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("a", {
            href: data.version.startsWith('develop-') ? `https://github.com/sct/overseerr/compare/${status.commitTag}...develop` : 'https://github.com/sct/overseerr/releases',
            target: "_blank",
            rel: "noopener noreferrer",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
              badgeType: "warning",
              className: "ml-2 !cursor-pointer transition hover:bg-yellow-400",
              children: intl.formatMessage(messages.outofdate)
            })
          }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("a", {
            href: data.version.startsWith('develop-') ? 'https://github.com/sct/overseerr/commits/develop' : 'https://github.com/sct/overseerr/releases',
            target: "_blank",
            rel: "noopener noreferrer",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
              badgeType: "success",
              className: "ml-2 !cursor-pointer transition hover:bg-green-400",
              children: intl.formatMessage(messages.uptodate)
            })
          }))]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__/* ["default"].Item */ .Z.Item, {
          title: intl.formatMessage(messages.totalmedia),
          children: intl.formatNumber(data.totalMediaItems)
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__/* ["default"].Item */ .Z.Item, {
          title: intl.formatMessage(messages.totalrequests),
          children: intl.formatNumber(data.totalRequests)
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__/* ["default"].Item */ .Z.Item, {
          title: intl.formatMessage(messages.appDataPath),
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("code", {
            children: data.appDataPath
          })
        }), data.tz && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__/* ["default"].Item */ .Z.Item, {
          title: intl.formatMessage(messages.timezone),
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("code", {
            children: data.tz
          })
        })]
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
      className: "section",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        title: intl.formatMessage(messages.gettingsupport),
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__/* ["default"].Item */ .Z.Item, {
          title: intl.formatMessage(messages.documentation),
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("a", {
            href: "https://docs.overseerr.dev",
            target: "_blank",
            rel: "noreferrer",
            className: "text-indigo-500 transition duration-300 hover:underline",
            children: "https://docs.overseerr.dev"
          })
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__/* ["default"].Item */ .Z.Item, {
          title: intl.formatMessage(messages.githubdiscussions),
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("a", {
            href: "https://github.com/sct/overseerr/discussions",
            target: "_blank",
            rel: "noreferrer",
            className: "text-indigo-500 transition duration-300 hover:underline",
            children: "https://github.com/sct/overseerr/discussions"
          })
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__/* ["default"].Item */ .Z.Item, {
          title: "Discord",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("a", {
            href: "https://discord.gg/overseerr",
            target: "_blank",
            rel: "noreferrer",
            className: "text-indigo-500 transition duration-300 hover:underline",
            children: "https://discord.gg/overseerr"
          })
        })]
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
      className: "section",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        title: intl.formatMessage(messages.supportoverseerr),
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsxs)(_app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__/* ["default"].Item */ .Z.Item, {
          title: `${intl.formatMessage(messages.helppaycoffee)} ☕️`,
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("a", {
            href: "https://github.com/sponsors/sct",
            target: "_blank",
            rel: "noreferrer",
            className: "text-indigo-500 transition duration-300 hover:underline",
            children: "https://github.com/sponsors/sct"
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
            className: "ml-2",
            children: intl.formatMessage(messages.preferredmethod)
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Common_List__WEBPACK_IMPORTED_MODULE_2__/* ["default"].Item */ .Z.Item, {
          title: "",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("a", {
            href: "https://patreon.com/overseerr",
            target: "_blank",
            rel: "noreferrer",
            className: "text-indigo-500 transition duration-300 hover:underline",
            children: "https://patreon.com/overseerr"
          })
        })]
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx("div", {
      className: "section",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_11__.jsx(_app_components_Settings_SettingsAbout_Releases__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        currentVersion: data.version
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsAbout);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 10143:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Settings_SettingsAbout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7798);
/* harmony import */ var _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91865);
/* harmony import */ var _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(75691);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(86799);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Settings_SettingsAbout__WEBPACK_IMPORTED_MODULE_0__, _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__]);
([_app_components_Settings_SettingsAbout__WEBPACK_IMPORTED_MODULE_0__, _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const SettingsAboutPage = () => {
  (0,_app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__/* .Permission.ADMIN */ .y3.ADMIN);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Settings_SettingsAbout__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {})
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsAboutPage);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 66234:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "W": () => (/* binding */ withProperties)
/* harmony export */ });
/**
 * Helps type objects with an arbitrary number of properties that are
 * usually being defined at export.
 *
 * @param component Main object you want to apply properties to
 * @param properties Object of properties you want to type on the main component
 */
function withProperties(component, properties) {
  Object.keys(properties).forEach(key => {
    Object.assign(component, {
      [key]: properties[key]
    });
  });
  return component;
}

/***/ }),

/***/ 12135:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/outline");

/***/ }),

/***/ 98802:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/solid");

/***/ }),

/***/ 3280:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/app-router-context.js");

/***/ }),

/***/ 92796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 94957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 50744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 35843:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 95832:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/loadable.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 64406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 11751:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/add-path-prefix.js");

/***/ }),

/***/ 46220:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/compare-states.js");

/***/ }),

/***/ 10299:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-next-pathname-info.js");

/***/ }),

/***/ 23938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 35789:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-next-pathname-info.js");

/***/ }),

/***/ 1897:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-bot.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 28854:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 34567:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/path-has-prefix.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 93297:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 40968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 66405:
/***/ ((module) => {

module.exports = require("react-dom");

/***/ }),

/***/ 13126:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 61185:
/***/ ((module) => {

module.exports = import("@headlessui/react");;

/***/ }),

/***/ 23135:
/***/ ((module) => {

module.exports = import("react-markdown");;

/***/ }),

/***/ 15941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [80676,41664,25675,5152,1388,61439,19998,80210,86799,35635,13555,99073,7292,22796,33173,35754], () => (__webpack_exec__(10143)));
module.exports = __webpack_exports__;

})();