"use strict";
exports.id = 83785;
exports.ids = [83785];
exports.modules = {

/***/ 83785:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61439);
/* harmony import */ var _app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(95909);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(15941);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__, axios__WEBPACK_IMPORTED_MODULE_6__, swr__WEBPACK_IMPORTED_MODULE_11__]);
([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__, axios__WEBPACK_IMPORTED_MODULE_6__, swr__WEBPACK_IMPORTED_MODULE_11__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.defineMessages)({
  telegramsettingssaved: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.telegramsettingssaved",
    "defaultMessage": 'Telegram notification settings saved successfully!'
  },
  telegramsettingsfailed: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.telegramsettingsfailed",
    "defaultMessage": 'Telegram notification settings failed to save.'
  },
  telegramChatId: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.telegramChatId",
    "defaultMessage": 'Chat ID'
  },
  telegramChatIdTipLong: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.telegramChatIdTipLong",
    "defaultMessage": '<TelegramBotLink>Start a chat</TelegramBotLink>, add <GetIdBotLink>@get_id_bot</GetIdBotLink>, and issue the <code>/my_id</code> command'
  },
  sendSilently: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.sendSilently",
    "defaultMessage": 'Send Silently'
  },
  sendSilentlyDescription: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.sendSilentlyDescription",
    "defaultMessage": 'Send notifications with no sound'
  },
  validationTelegramChatId: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.validationTelegramChatId",
    "defaultMessage": 'You must provide a valid chat ID'
  }
});

const UserTelegramSettings = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.useIntl)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__.useToasts)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_8__.useRouter)();
  const {
    user
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_3__/* .useUser */ .aF)({
    id: Number(router.query.userId)
  });
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_11__["default"])(user ? `/api/v1/user/${user?.id}/settings/notifications` : null);
  const UserNotificationsTelegramSchema = yup__WEBPACK_IMPORTED_MODULE_12__.object().shape({
    telegramChatId: yup__WEBPACK_IMPORTED_MODULE_12__.string().when('types', {
      is: types => !!types,
      then: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable().required(intl.formatMessage(messages.validationTelegramChatId)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable()
    }).matches(/^-?\d+$/, intl.formatMessage(messages.validationTelegramChatId))
  });

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {});
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Formik, {
    initialValues: {
      telegramChatId: data?.telegramChatId,
      telegramSendSilently: data?.telegramSendSilently,
      types: data?.notificationTypes.telegram ?? 0
    },
    validationSchema: UserNotificationsTelegramSchema,
    enableReinitialize: true,
    onSubmit: async values => {
      try {
        await axios__WEBPACK_IMPORTED_MODULE_6__["default"].post(`/api/v1/user/${user?.id}/settings/notifications`, {
          pgpKey: data?.pgpKey,
          discordId: data?.discordId,
          pushbulletAccessToken: data?.pushbulletAccessToken,
          pushoverApplicationToken: data?.pushoverApplicationToken,
          pushoverUserKey: data?.pushoverUserKey,
          telegramChatId: values.telegramChatId,
          telegramSendSilently: values.telegramSendSilently,
          notificationTypes: {
            telegram: values.types
          }
        });
        addToast(intl.formatMessage(messages.telegramsettingssaved), {
          appearance: 'success',
          autoDismiss: true
        });
      } catch (e) {
        addToast(intl.formatMessage(messages.telegramsettingsfailed), {
          appearance: 'error',
          autoDismiss: true
        });
      } finally {
        revalidate();
      }
    },
    children: ({
      errors,
      touched,
      isSubmitting,
      isValid,
      values,
      setFieldValue,
      setFieldTouched
    }) => {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_7__.Form, {
        className: "section",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
            htmlFor: "telegramChatId",
            className: "text-label",
            children: [intl.formatMessage(messages.telegramChatId), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-required",
              children: "*"
            }), data?.telegramBotUsername && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-tip",
              children: intl.formatMessage(messages.telegramChatIdTipLong, {
                TelegramBotLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("a", {
                  href: `https://telegram.me/${data.telegramBotUsername}`,
                  target: "_blank",
                  rel: "noreferrer",
                  children: msg
                }),
                GetIdBotLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("a", {
                  href: "https://telegram.me/get_id_bot",
                  target: "_blank",
                  rel: "noreferrer",
                  children: msg
                }),
                code: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("code", {
                  children: msg
                })
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
                id: "telegramChatId",
                name: "telegramChatId",
                type: "text"
              })
            }), errors.telegramChatId && touched.telegramChatId && typeof errors.telegramChatId === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "error",
              children: errors.telegramChatId
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
            htmlFor: "telegramSendSilently",
            className: "checkbox-label",
            children: [intl.formatMessage(messages.sendSilently), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-tip",
              children: intl.formatMessage(messages.sendSilentlyDescription)
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
            className: "form-input-area",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
              type: "checkbox",
              id: "telegramSendSilently",
              name: "telegramSendSilently"
            })
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP, {
          user: user,
          currentTypes: values.types,
          onUpdate: newTypes => {
            setFieldValue('types', newTypes);
            setFieldTouched('types');
          },
          error: errors.types && touched.types ? errors.types : undefined
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
          className: "actions",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
            className: "flex justify-end",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "ml-3 inline-flex rounded-md shadow-sm",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                buttonType: "primary",
                type: "submit",
                disabled: isSubmitting || !isValid,
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_5__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
                  children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_4__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_4__/* ["default"].save */ .Z.save)
                })]
              })
            })
          })
        })]
      });
    }
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserTelegramSettings);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;