"use strict";
exports.id = 71473;
exports.ids = [71473];
exports.modules = {

/***/ 71473:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "s": () => (/* binding */ InteractionContext),
  "o": () => (/* binding */ InteractionProvider)
});

// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(16689);
var external_react_default = /*#__PURE__*/__webpack_require__.n(external_react_);
;// CONCATENATED MODULE: ./src/hooks/useInteraction.ts

const INTERACTION_TYPE = {
  MOUSE: 'mouse',
  PEN: 'pen',
  TOUCH: 'touch'
};
const UPDATE_INTERVAL = 1000; // Throttle updates to the type to prevent flip flopping

const useInteraction = () => {
  const {
    0: isTouch,
    1: setIsTouch
  } = (0,external_react_.useState)(false);
  (0,external_react_.useEffect)(() => {
    const hasTapEvent = ('ontouchstart' in window);
    setIsTouch(hasTapEvent);
    let localTouch = hasTapEvent;
    let lastTouchUpdate = Date.now();

    const shouldUpdate = () => lastTouchUpdate + UPDATE_INTERVAL < Date.now();

    const onMouseMove = () => {
      if (localTouch && shouldUpdate()) {
        setTimeout(() => {
          if (shouldUpdate()) {
            setIsTouch(false);
            localTouch = false;
          }
        }, UPDATE_INTERVAL);
      }
    };

    const onTouchStart = () => {
      lastTouchUpdate = Date.now();

      if (!localTouch) {
        setIsTouch(true);
        localTouch = true;
      }
    };

    const onPointerMove = e => {
      const {
        pointerType
      } = e;

      switch (pointerType) {
        case INTERACTION_TYPE.TOUCH:
        case INTERACTION_TYPE.PEN:
          return onTouchStart();

        default:
          return onMouseMove();
      }
    };

    if (hasTapEvent) {
      window.addEventListener('mousemove', onMouseMove);
      window.addEventListener('touchstart', onTouchStart);
    } else {
      window.addEventListener('pointerdown', onPointerMove);
      window.addEventListener('pointermove', onPointerMove);
    }

    return () => {
      if (hasTapEvent) {
        window.removeEventListener('mousemove', onMouseMove);
        window.removeEventListener('touchstart', onTouchStart);
      } else {
        window.removeEventListener('pointerdown', onPointerMove);
        window.removeEventListener('pointermove', onPointerMove);
      }
    };
  }, []);
  return isTouch;
};

/* harmony default export */ const hooks_useInteraction = (useInteraction);
// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(20997);
;// CONCATENATED MODULE: ./src/context/InteractionContext.tsx



const InteractionContext = /*#__PURE__*/external_react_default().createContext({
  isTouch: false
});
const InteractionProvider = ({
  children
}) => {
  const isTouch = hooks_useInteraction();
  return /*#__PURE__*/jsx_runtime_.jsx(InteractionContext.Provider, {
    value: {
      isTouch
    },
    children: children
  });
};

/***/ })

};
;