"use strict";
exports.id = 62249;
exports.ids = [62249];
exports.modules = {

/***/ 74449:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1388);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(40968);
/* harmony import */ var next_head__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_head__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__]);
_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];




const PageTitle = ({
  title
}) => {
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z)();
  const titleText = `${Array.isArray(title) ? title.filter(Boolean).join(' - ') : title} - ${settings.currentSettings.applicationTitle}`;
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx((next_head__WEBPACK_IMPORTED_MODULE_1___default()), {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_2__.jsx("title", {
      children: titleText
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PageTitle);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 54302:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_use_clipboard__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4856);
/* harmony import */ var react_use_clipboard__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_use_clipboard__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);






const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_2__.defineMessages)({
  copied: {
    "id": "components.Settings.copied",
    "defaultMessage": 'Copied API key to clipboard.'
  }
});

const CopyButton = ({
  textToCopy
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_2__.useIntl)();
  const [isCopied, setCopied] = react_use_clipboard__WEBPACK_IMPORTED_MODULE_4___default()(textToCopy, {
    successDuration: 1000
  });
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_3__.useToasts)();
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    if (isCopied) {
      addToast(intl.formatMessage(messages.copied), {
        appearance: 'info',
        autoDismiss: true
      });
    }
  }, [isCopied, addToast, intl]);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("button", {
    onClick: e => {
      e.preventDefault();
      setCopied();
    },
    className: "input-action",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__.ClipboardDocumentIcon, {})
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CopyButton);

/***/ }),

/***/ 62249:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61903);
/* harmony import */ var _app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(63145);
/* harmony import */ var _app_components_LanguageSelector__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(41466);
/* harmony import */ var _app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(72134);
/* harmony import */ var _app_components_Settings_CopyButton__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(54302);
/* harmony import */ var _app_components_Settings_SettingsBadge__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(75294);
/* harmony import */ var _app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(99819);
/* harmony import */ var _app_hooks_useLocale__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(84541);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(15941);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__, _app_components_LanguageSelector__WEBPACK_IMPORTED_MODULE_5__, _app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_6__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_11__, axios__WEBPACK_IMPORTED_MODULE_15__, swr__WEBPACK_IMPORTED_MODULE_19__]);
([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__, _app_components_LanguageSelector__WEBPACK_IMPORTED_MODULE_5__, _app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_6__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_11__, axios__WEBPACK_IMPORTED_MODULE_15__, swr__WEBPACK_IMPORTED_MODULE_19__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
























const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_17__.defineMessages)({
  general: {
    "id": "components.Settings.SettingsMain.general",
    "defaultMessage": 'General'
  },
  generalsettings: {
    "id": "components.Settings.SettingsMain.generalsettings",
    "defaultMessage": 'General Settings'
  },
  generalsettingsDescription: {
    "id": "components.Settings.SettingsMain.generalsettingsDescription",
    "defaultMessage": 'Configure global and default settings for Overseerr.'
  },
  apikey: {
    "id": "components.Settings.SettingsMain.apikey",
    "defaultMessage": 'API Key'
  },
  applicationTitle: {
    "id": "components.Settings.SettingsMain.applicationTitle",
    "defaultMessage": 'Application Title'
  },
  applicationurl: {
    "id": "components.Settings.SettingsMain.applicationurl",
    "defaultMessage": 'Application URL'
  },
  region: {
    "id": "components.Settings.SettingsMain.region",
    "defaultMessage": 'Discover Region'
  },
  regionTip: {
    "id": "components.Settings.SettingsMain.regionTip",
    "defaultMessage": 'Filter content by regional availability'
  },
  originallanguage: {
    "id": "components.Settings.SettingsMain.originallanguage",
    "defaultMessage": 'Discover Language'
  },
  originallanguageTip: {
    "id": "components.Settings.SettingsMain.originallanguageTip",
    "defaultMessage": 'Filter content by original language'
  },
  toastApiKeySuccess: {
    "id": "components.Settings.SettingsMain.toastApiKeySuccess",
    "defaultMessage": 'New API key generated successfully!'
  },
  toastApiKeyFailure: {
    "id": "components.Settings.SettingsMain.toastApiKeyFailure",
    "defaultMessage": 'Something went wrong while generating a new API key.'
  },
  toastSettingsSuccess: {
    "id": "components.Settings.SettingsMain.toastSettingsSuccess",
    "defaultMessage": 'Settings saved successfully!'
  },
  toastSettingsFailure: {
    "id": "components.Settings.SettingsMain.toastSettingsFailure",
    "defaultMessage": 'Something went wrong while saving settings.'
  },
  hideAvailable: {
    "id": "components.Settings.SettingsMain.hideAvailable",
    "defaultMessage": 'Hide Available Media'
  },
  csrfProtection: {
    "id": "components.Settings.SettingsMain.csrfProtection",
    "defaultMessage": 'Enable CSRF Protection'
  },
  csrfProtectionTip: {
    "id": "components.Settings.SettingsMain.csrfProtectionTip",
    "defaultMessage": 'Set external API access to read-only (requires HTTPS)'
  },
  csrfProtectionHoverTip: {
    "id": "components.Settings.SettingsMain.csrfProtectionHoverTip",
    "defaultMessage": 'Do NOT enable this setting unless you understand what you are doing!'
  },
  cacheImages: {
    "id": "components.Settings.SettingsMain.cacheImages",
    "defaultMessage": 'Enable Image Caching'
  },
  cacheImagesTip: {
    "id": "components.Settings.SettingsMain.cacheImagesTip",
    "defaultMessage": 'Cache externally sourced images (requires a significant amount of disk space)'
  },
  trustProxy: {
    "id": "components.Settings.SettingsMain.trustProxy",
    "defaultMessage": 'Enable Proxy Support'
  },
  trustProxyTip: {
    "id": "components.Settings.SettingsMain.trustProxyTip",
    "defaultMessage": 'Allow Overseerr to correctly register client IP addresses behind a proxy'
  },
  validationApplicationTitle: {
    "id": "components.Settings.SettingsMain.validationApplicationTitle",
    "defaultMessage": 'You must provide an application title'
  },
  validationApplicationUrl: {
    "id": "components.Settings.SettingsMain.validationApplicationUrl",
    "defaultMessage": 'You must provide a valid URL'
  },
  validationApplicationUrlTrailingSlash: {
    "id": "components.Settings.SettingsMain.validationApplicationUrlTrailingSlash",
    "defaultMessage": 'URL must not end in a trailing slash'
  },
  partialRequestsEnabled: {
    "id": "components.Settings.SettingsMain.partialRequestsEnabled",
    "defaultMessage": 'Allow Partial Series Requests'
  },
  locale: {
    "id": "components.Settings.SettingsMain.locale",
    "defaultMessage": 'Display Language'
  }
});

const SettingsMain = () => {
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_18__.useToasts)();
  const {
    user: currentUser,
    hasPermission: userHasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_11__/* .useUser */ .aF)();
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_17__.useIntl)();
  const {
    setLocale
  } = (0,_app_hooks_useLocale__WEBPACK_IMPORTED_MODULE_10__/* ["default"] */ .Z)();
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_19__["default"])('/api/v1/settings/main');
  const {
    data: userData
  } = (0,swr__WEBPACK_IMPORTED_MODULE_19__["default"])(currentUser ? `/api/v1/user/${currentUser.id}/settings/main` : null);
  const MainSettingsSchema = yup__WEBPACK_IMPORTED_MODULE_20__.object().shape({
    applicationTitle: yup__WEBPACK_IMPORTED_MODULE_20__.string().required(intl.formatMessage(messages.validationApplicationTitle)),
    applicationUrl: yup__WEBPACK_IMPORTED_MODULE_20__.string().url(intl.formatMessage(messages.validationApplicationUrl)).test('no-trailing-slash', intl.formatMessage(messages.validationApplicationUrlTrailingSlash), value => !value || !value.endsWith('/'))
  });

  const regenerate = async () => {
    try {
      await axios__WEBPACK_IMPORTED_MODULE_15__["default"].post('/api/v1/settings/main/regenerate');
      revalidate();
      addToast(intl.formatMessage(messages.toastApiKeySuccess), {
        autoDismiss: true,
        appearance: 'success'
      });
    } catch (e) {
      addToast(intl.formatMessage(messages.toastApiKeyFailure), {
        autoDismiss: true,
        appearance: 'error'
      });
    }
  };

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {});
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      title: [intl.formatMessage(messages.general), intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_12__/* ["default"].settings */ .Z.settings)]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
      className: "mb-6",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.generalsettings)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("p", {
        className: "description",
        children: intl.formatMessage(messages.generalsettingsDescription)
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
      className: "section",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(formik__WEBPACK_IMPORTED_MODULE_16__.Formik, {
        initialValues: {
          applicationTitle: data?.applicationTitle,
          applicationUrl: data?.applicationUrl,
          csrfProtection: data?.csrfProtection,
          hideAvailable: data?.hideAvailable,
          locale: data?.locale ?? 'en',
          region: data?.region,
          originalLanguage: data?.originalLanguage,
          partialRequestsEnabled: data?.partialRequestsEnabled,
          trustProxy: data?.trustProxy,
          cacheImages: data?.cacheImages
        },
        enableReinitialize: true,
        validationSchema: MainSettingsSchema,
        onSubmit: async values => {
          try {
            await axios__WEBPACK_IMPORTED_MODULE_15__["default"].post('/api/v1/settings/main', {
              applicationTitle: values.applicationTitle,
              applicationUrl: values.applicationUrl,
              csrfProtection: values.csrfProtection,
              hideAvailable: values.hideAvailable,
              locale: values.locale,
              region: values.region,
              originalLanguage: values.originalLanguage,
              partialRequestsEnabled: values.partialRequestsEnabled,
              trustProxy: values.trustProxy,
              cacheImages: values.cacheImages
            });
            (0,swr__WEBPACK_IMPORTED_MODULE_19__.mutate)('/api/v1/settings/public');
            (0,swr__WEBPACK_IMPORTED_MODULE_19__.mutate)('/api/v1/status');

            if (setLocale) {
              setLocale(userData?.locale ? userData.locale : values.locale);
            }

            addToast(intl.formatMessage(messages.toastSettingsSuccess), {
              autoDismiss: true,
              appearance: 'success'
            });
          } catch (e) {
            addToast(intl.formatMessage(messages.toastSettingsFailure), {
              autoDismiss: true,
              appearance: 'error'
            });
          } finally {
            revalidate();
          }
        },
        children: ({
          errors,
          touched,
          isSubmitting,
          isValid,
          values,
          setFieldValue
        }) => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_16__.Form, {
            className: "section",
            "data-testid": "settings-main-form",
            children: [userHasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_11__/* .Permission.ADMIN */ .y3.ADMIN) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("label", {
                htmlFor: "apiKey",
                className: "text-label",
                children: intl.formatMessage(messages.apikey)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
                  className: "form-input-field",
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                    type: "text",
                    id: "apiKey",
                    className: "rounded-l-only",
                    value: data?.apiKey,
                    readOnly: true
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_app_components_Settings_CopyButton__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                    textToCopy: data?.apiKey ?? ''
                  }, data?.apiKey), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("button", {
                    onClick: e => {
                      e.preventDefault();
                      regenerate();
                    },
                    className: "input-action",
                    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_14__.ArrowPathIcon, {})
                  })]
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("label", {
                htmlFor: "applicationTitle",
                className: "text-label",
                children: intl.formatMessage(messages.applicationTitle)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(formik__WEBPACK_IMPORTED_MODULE_16__.Field, {
                    id: "applicationTitle",
                    name: "applicationTitle",
                    type: "text"
                  })
                }), errors.applicationTitle && touched.applicationTitle && typeof errors.applicationTitle === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                  className: "error",
                  children: errors.applicationTitle
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("label", {
                htmlFor: "applicationUrl",
                className: "text-label",
                children: intl.formatMessage(messages.applicationurl)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(formik__WEBPACK_IMPORTED_MODULE_16__.Field, {
                    id: "applicationUrl",
                    name: "applicationUrl",
                    type: "text",
                    inputMode: "url"
                  })
                }), errors.applicationUrl && touched.applicationUrl && typeof errors.applicationUrl === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                  className: "error",
                  children: errors.applicationUrl
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("label", {
                htmlFor: "trustProxy",
                className: "checkbox-label",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                  className: "mr-2",
                  children: intl.formatMessage(messages.trustProxy)
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_app_components_Settings_SettingsBadge__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                  badgeType: "restartRequired"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                  className: "label-tip",
                  children: intl.formatMessage(messages.trustProxyTip)
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(formik__WEBPACK_IMPORTED_MODULE_16__.Field, {
                  type: "checkbox",
                  id: "trustProxy",
                  name: "trustProxy",
                  onChange: () => {
                    setFieldValue('trustProxy', !values.trustProxy);
                  }
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("label", {
                htmlFor: "csrfProtection",
                className: "checkbox-label",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                  className: "mr-2",
                  children: intl.formatMessage(messages.csrfProtection)
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_app_components_Settings_SettingsBadge__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                  badgeType: "advanced",
                  className: "mr-2"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_app_components_Settings_SettingsBadge__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                  badgeType: "restartRequired"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                  className: "label-tip",
                  children: intl.formatMessage(messages.csrfProtectionTip)
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_app_components_Common_Tooltip__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                  content: intl.formatMessage(messages.csrfProtectionHoverTip),
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(formik__WEBPACK_IMPORTED_MODULE_16__.Field, {
                    type: "checkbox",
                    id: "csrfProtection",
                    name: "csrfProtection",
                    onChange: () => {
                      setFieldValue('csrfProtection', !values.csrfProtection);
                    }
                  })
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("label", {
                htmlFor: "cacheImages",
                className: "checkbox-label",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                  className: "mr-2",
                  children: intl.formatMessage(messages.cacheImages)
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_app_components_Settings_SettingsBadge__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                  badgeType: "experimental"
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                  className: "label-tip",
                  children: intl.formatMessage(messages.cacheImagesTip)
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(formik__WEBPACK_IMPORTED_MODULE_16__.Field, {
                  type: "checkbox",
                  id: "cacheImages",
                  name: "cacheImages",
                  onChange: () => {
                    setFieldValue('cacheImages', !values.cacheImages);
                  }
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("label", {
                htmlFor: "locale",
                className: "text-label",
                children: intl.formatMessage(messages.locale)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(formik__WEBPACK_IMPORTED_MODULE_16__.Field, {
                    as: "select",
                    id: "locale",
                    name: "locale",
                    children: Object.keys(_app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_9__/* .availableLanguages */ .m).map(key => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("option", {
                      value: _app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_9__/* .availableLanguages */ .m[key].code,
                      lang: _app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_9__/* .availableLanguages */ .m[key].code,
                      children: _app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_9__/* .availableLanguages */ .m[key].display
                    }, key))
                  })
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("label", {
                htmlFor: "region",
                className: "text-label",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                  children: intl.formatMessage(messages.region)
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                  className: "label-tip",
                  children: intl.formatMessage(messages.regionTip)
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                    value: values.region ?? '',
                    name: "region",
                    onChange: setFieldValue
                  })
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("label", {
                htmlFor: "originalLanguage",
                className: "text-label",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                  children: intl.formatMessage(messages.originallanguage)
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                  className: "label-tip",
                  children: intl.formatMessage(messages.originallanguageTip)
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_app_components_LanguageSelector__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                    setFieldValue: setFieldValue,
                    value: values.originalLanguage
                  })
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("label", {
                htmlFor: "hideAvailable",
                className: "checkbox-label",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                  className: "mr-2",
                  children: intl.formatMessage(messages.hideAvailable)
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_app_components_Settings_SettingsBadge__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z, {
                  badgeType: "experimental"
                })]
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(formik__WEBPACK_IMPORTED_MODULE_16__.Field, {
                  type: "checkbox",
                  id: "hideAvailable",
                  name: "hideAvailable",
                  onChange: () => {
                    setFieldValue('hideAvailable', !values.hideAvailable);
                  }
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("label", {
                htmlFor: "partialRequestsEnabled",
                className: "checkbox-label",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                  className: "mr-2",
                  children: intl.formatMessage(messages.partialRequestsEnabled)
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(formik__WEBPACK_IMPORTED_MODULE_16__.Field, {
                  type: "checkbox",
                  id: "partialRequestsEnabled",
                  name: "partialRequestsEnabled",
                  onChange: () => {
                    setFieldValue('partialRequestsEnabled', !values.partialRequestsEnabled);
                  }
                })
              })]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
              className: "actions",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("div", {
                className: "flex justify-end",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                  className: "ml-3 inline-flex rounded-md shadow-sm",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                    buttonType: "primary",
                    type: "submit",
                    disabled: isSubmitting || !isValid,
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_13__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_21__.jsx("span", {
                      children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_12__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_12__/* ["default"].save */ .Z.save)
                    })]
                  })
                })
              })
            })]
          });
        }
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsMain);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;