"use strict";
exports.id = 61046;
exports.ids = [61046];
exports.modules = {

/***/ 61046:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "L8": () => (/* binding */ verifyAndResubscribePushSubscription),
/* harmony export */   "U2": () => (/* binding */ getPushSubscription),
/* harmony export */   "ax": () => (/* binding */ unsubscribeToPushNotifications),
/* harmony export */   "hR": () => (/* binding */ verifyPushSubscription),
/* harmony export */   "rR": () => (/* binding */ subscribeToPushNotifications)
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99648);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([axios__WEBPACK_IMPORTED_MODULE_0__]);
axios__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];
 // Taken from https://www.npmjs.com/package/web-push

function urlBase64ToUint8Array(base64String) {
  const padding = '='.repeat((4 - base64String.length % 4) % 4);
  const base64 = `${base64String}${padding}`.replace(/-/g, '+').replace(/_/g, '/');
  const rawData = window.atob(base64);
  const outputArray = new Uint8Array(rawData.length);

  for (let i = 0; i < rawData.length; ++i) outputArray[i] = rawData.charCodeAt(i);

  return outputArray;
}

const getPushSubscription = async () => {
  const registration = await navigator.serviceWorker.ready;
  const subscription = await registration.pushManager.getSubscription();
  return {
    registration,
    subscription
  };
};
const verifyPushSubscription = async (userId, currentSettings) => {
  if (!('serviceWorker' in navigator) || !userId) {
    return false;
  }

  try {
    const {
      subscription
    } = await getPushSubscription();

    if (!subscription) {
      return false;
    }

    const appServerKey = subscription.options?.applicationServerKey;

    if (!(appServerKey instanceof ArrayBuffer)) {
      return false;
    }

    const currentServerKey = new Uint8Array(appServerKey).toString();
    const expectedServerKey = urlBase64ToUint8Array(currentSettings.vapidPublic).toString();
    const endpoint = subscription.endpoint;
    const {
      data
    } = await axios__WEBPACK_IMPORTED_MODULE_0__["default"].get(`/api/v1/user/${userId}/pushSubscription/${encodeURIComponent(endpoint)}`);
    return expectedServerKey === currentServerKey && data.endpoint === endpoint;
  } catch {
    return false;
  }
};
const verifyAndResubscribePushSubscription = async (userId, currentSettings) => {
  const isValid = await verifyPushSubscription(userId, currentSettings);

  if (isValid) {
    return true;
  }

  if (currentSettings.enablePushRegistration) {
    try {
      // Unsubscribe from the backend to clear the existing push subscription (keys and endpoint)
      await unsubscribeToPushNotifications(userId); // Subscribe again to generate a fresh push subscription with updated keys and endpoint

      await subscribeToPushNotifications(userId, currentSettings);
      return true;
    } catch (error) {
      throw new Error(`[SW] Resubscribe failed: ${error.message}`);
    }
  }

  return false;
};
const subscribeToPushNotifications = async (userId, currentSettings) => {
  if (!('serviceWorker' in navigator) || !userId || !currentSettings.enablePushRegistration) {
    return false;
  }

  try {
    const {
      registration
    } = await getPushSubscription();

    if (!registration) {
      return false;
    }

    const subscription = await registration.pushManager.subscribe({
      userVisibleOnly: true,
      applicationServerKey: currentSettings.vapidPublic
    });
    const {
      endpoint,
      keys
    } = subscription.toJSON();

    if (keys?.p256dh && keys?.auth) {
      await axios__WEBPACK_IMPORTED_MODULE_0__["default"].post('/api/v1/user/registerPushSubscription', {
        endpoint,
        p256dh: keys.p256dh,
        auth: keys.auth,
        userAgent: navigator.userAgent
      });
      return true;
    }

    return false;
  } catch (error) {
    throw new Error(`Issue subscribing to push notifications: ${error.message}`);
  }
};
const unsubscribeToPushNotifications = async (userId, endpoint) => {
  if (!('serviceWorker' in navigator) || !userId) {
    return;
  }

  try {
    const {
      subscription
    } = await getPushSubscription();

    if (!subscription) {
      return false;
    }

    const {
      endpoint: currentEndpoint
    } = subscription.toJSON();

    if (!endpoint || endpoint === currentEndpoint) {
      await subscription.unsubscribe();
      return true;
    }
  } catch (error) {
    throw new Error(`Issue unsubscribing to push notifications: ${error.message}`);
  }
};
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;