"use strict";
exports.id = 48490;
exports.ids = [48490];
exports.modules = {

/***/ 76631:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);



const Header = ({
  children,
  extraMargin = 0,
  subtext
}) => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
    className: "mt-8 md:flex md:items-center md:justify-between",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
      className: `min-w-0 flex-1 mx-${extraMargin}`,
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h2", {
        className: "mb-4 truncate text-2xl font-bold leading-7 text-gray-100 sm:overflow-visible sm:text-4xl sm:leading-9 md:mb-0",
        "data-testid": "page-header",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("span", {
          className: "text-overseerr",
          children: children
        })
      }), subtext && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
        className: "mt-2 text-gray-400",
        children: subtext
      })]
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Header);

/***/ }),

/***/ 5339:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_PersonCard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(68229);
/* harmony import */ var _app_components_TitleCard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61276);
/* harmony import */ var _app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(33056);
/* harmony import */ var _app_hooks_useVerticalScroll__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(15736);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(80210);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_PersonCard__WEBPACK_IMPORTED_MODULE_0__, _app_components_TitleCard__WEBPACK_IMPORTED_MODULE_1__, _app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_2__]);
([_app_components_PersonCard__WEBPACK_IMPORTED_MODULE_0__, _app_components_TitleCard__WEBPACK_IMPORTED_MODULE_1__, _app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_2__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);










const ListView = ({
  items,
  isEmpty,
  isLoading,
  onScrollBottom,
  isReachingEnd,
  plexItems
}) => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_5__.useIntl)();
  (0,_app_hooks_useVerticalScroll__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(onScrollBottom, !isLoading && !isEmpty && !isReachingEnd);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.Fragment, {
    children: [isEmpty && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("div", {
      className: "mt-64 w-full text-center text-2xl text-gray-400",
      children: intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_4__/* ["default"].noresults */ .Z.noresults)
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsxs)("ul", {
      className: "cards-vertical",
      children: [plexItems?.map((title, index) => {
        return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("li", {
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_app_components_TitleCard_TmdbTitleCard__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
            id: title.tmdbId,
            tmdbId: title.tmdbId,
            type: title.mediaType,
            canExpand: true
          })
        }, `${title.ratingKey}-${index}`);
      }), items?.map((title, index) => {
        let titleCard;

        switch (title.mediaType) {
          case 'movie':
            titleCard = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
              id: title.id,
              image: title.posterPath,
              status: title.mediaInfo?.status,
              summary: title.overview,
              title: title.title,
              userScore: title.voteAverage,
              year: title.releaseDate,
              mediaType: title.mediaType,
              inProgress: (title.mediaInfo?.downloadStatus ?? []).length > 0,
              canExpand: true
            });
            break;

          case 'tv':
            titleCard = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
              id: title.id,
              image: title.posterPath,
              status: title.mediaInfo?.status,
              summary: title.overview,
              title: title.name,
              userScore: title.voteAverage,
              year: title.firstAirDate,
              mediaType: title.mediaType,
              inProgress: (title.mediaInfo?.downloadStatus ?? []).length > 0,
              canExpand: true
            });
            break;

          case 'collection':
            titleCard = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
              id: title.id,
              image: title.posterPath,
              summary: title.overview,
              title: title.title,
              mediaType: title.mediaType,
              canExpand: true
            });
            break;

          case 'person':
            titleCard = /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_app_components_PersonCard__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
              personId: title.id,
              name: title.name,
              profilePath: title.profilePath,
              canExpand: true
            });
            break;
        }

        return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("li", {
          children: titleCard
        }, `${title.id}-${index}`);
      }), isLoading && !isReachingEnd && [...Array(20)].map((_item, i) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx("li", {
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_6__.jsx(_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_1__/* ["default"].Placeholder */ .Z.Placeholder, {
          canExpand: true
        })
      }, `placeholder-${i}`))]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ListView);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 15736:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(46517);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);


const IS_SCROLLING_CHECK_THROTTLE = 200;
const BUFFER_HEIGHT = 200;
/**
 * useVerticalScroll is a custom hook to handle infinite scrolling
 *
 * @param callback Callback is executed when page reaches bottom
 * @param shouldFetch Disables callback if true
 */

const useVerticalScroll = (callback, shouldFetch) => {
  const {
    0: isScrolling,
    1: setScrolling
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(false);
  const scrollingTimer = (0,react__WEBPACK_IMPORTED_MODULE_1__.useRef)();

  const runCallback = () => {
    if (shouldFetch) {
      const scrollTop = Math.max(window.pageYOffset, document.documentElement.scrollTop, document.body.scrollTop);

      if (window.innerHeight + scrollTop >= document.documentElement.offsetHeight - BUFFER_HEIGHT) {
        callback();
      }
    }
  };

  const debouncedCallback = (0,lodash__WEBPACK_IMPORTED_MODULE_0__.debounce)(runCallback, 50);
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    runCallback();
  });
  (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
    const onScroll = () => {
      if (scrollingTimer.current !== undefined) {
        clearTimeout(scrollingTimer.current);
      }

      if (!isScrolling) {
        setScrolling(true);
      }

      scrollingTimer.current = setTimeout(() => {
        setScrolling(false);
      }, IS_SCROLLING_CHECK_THROTTLE);
      debouncedCallback();
    };

    const onResize = () => {
      debouncedCallback();
    };

    window.addEventListener('scroll', onScroll, {
      passive: true
    });
    window.addEventListener('resize', onResize, {
      passive: true
    });
    return () => {
      window.removeEventListener('scroll', onScroll);
      window.removeEventListener('resize', onResize);

      if (scrollingTimer.current !== undefined) {
        clearTimeout(scrollingTimer.current);
      }
    };
  });
  return isScrolling;
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useVerticalScroll);

/***/ })

};
;