"use strict";
exports.id = 41899;
exports.ids = [41899];
exports.modules = {

/***/ 41899:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61903);
/* harmony import */ var _app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(95909);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(80210);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(15941);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__, axios__WEBPACK_IMPORTED_MODULE_6__, swr__WEBPACK_IMPORTED_MODULE_11__]);
([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__, axios__WEBPACK_IMPORTED_MODULE_6__, swr__WEBPACK_IMPORTED_MODULE_11__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.defineMessages)({
  pushbulletsettingssaved: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.pushbulletsettingssaved",
    "defaultMessage": 'Pushbullet notification settings saved successfully!'
  },
  pushbulletsettingsfailed: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.pushbulletsettingsfailed",
    "defaultMessage": 'Pushbullet notification settings failed to save.'
  },
  pushbulletAccessToken: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.pushbulletAccessToken",
    "defaultMessage": 'Access Token'
  },
  pushbulletAccessTokenTip: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.pushbulletAccessTokenTip",
    "defaultMessage": 'Create a token from your <PushbulletSettingsLink>Account Settings</PushbulletSettingsLink>'
  },
  validationPushbulletAccessToken: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.validationPushbulletAccessToken",
    "defaultMessage": 'You must provide an access token'
  }
});

const UserPushbulletSettings = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.useIntl)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__.useToasts)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_8__.useRouter)();
  const {
    user
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__/* .useUser */ .aF)({
    id: Number(router.query.userId)
  });
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_11__["default"])(user ? `/api/v1/user/${user?.id}/settings/notifications` : null);
  const UserNotificationsPushbulletSchema = yup__WEBPACK_IMPORTED_MODULE_12__.object().shape({
    pushbulletAccessToken: yup__WEBPACK_IMPORTED_MODULE_12__.string().when('types', {
      is: types => !!types,
      then: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable().required(intl.formatMessage(messages.validationPushbulletAccessToken)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable()
    })
  });

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {});
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Formik, {
    initialValues: {
      pushbulletAccessToken: data?.pushbulletAccessToken,
      types: data?.notificationTypes.pushbullet ?? 0
    },
    validationSchema: UserNotificationsPushbulletSchema,
    enableReinitialize: true,
    onSubmit: async values => {
      try {
        await axios__WEBPACK_IMPORTED_MODULE_6__["default"].post(`/api/v1/user/${user?.id}/settings/notifications`, {
          pgpKey: data?.pgpKey,
          discordId: data?.discordId,
          pushbulletAccessToken: values.pushbulletAccessToken,
          pushoverApplicationToken: data?.pushoverApplicationToken,
          pushoverUserKey: data?.pushoverUserKey,
          telegramChatId: data?.telegramChatId,
          telegramSendSilently: data?.telegramSendSilently,
          notificationTypes: {
            pushbullet: values.types
          }
        });
        addToast(intl.formatMessage(messages.pushbulletsettingssaved), {
          appearance: 'success',
          autoDismiss: true
        });
      } catch (e) {
        addToast(intl.formatMessage(messages.pushbulletsettingsfailed), {
          appearance: 'error',
          autoDismiss: true
        });
      } finally {
        revalidate();
      }
    },
    children: ({
      errors,
      touched,
      isSubmitting,
      isValid,
      values,
      setFieldValue,
      setFieldTouched
    }) => {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_7__.Form, {
        className: "section",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
            htmlFor: "pushbulletAccessToken",
            className: "text-label",
            children: [intl.formatMessage(messages.pushbulletAccessToken), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-required",
              children: "*"
            }), data?.pushbulletAccessToken && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-tip",
              children: intl.formatMessage(messages.pushbulletAccessTokenTip, {
                PushbulletSettingsLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("a", {
                  href: "https://www.pushbullet.com/#settings/account",
                  className: "text-white transition duration-300 hover:underline",
                  target: "_blank",
                  rel: "noreferrer",
                  children: msg
                })
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                as: "field",
                id: "pushbulletAccessToken",
                name: "pushbulletAccessToken",
                type: "text"
              })
            }), errors.pushbulletAccessToken && touched.pushbulletAccessToken && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "error",
              children: errors.pushbulletAccessToken
            })]
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP, {
          user: user,
          currentTypes: values.types,
          onUpdate: newTypes => {
            setFieldValue('types', newTypes);
            setFieldTouched('types');
          },
          error: errors.types && touched.types ? errors.types : undefined
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
          className: "actions",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
            className: "flex justify-end",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "ml-3 inline-flex rounded-md shadow-sm",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                buttonType: "primary",
                type: "submit",
                disabled: isSubmitting || !isValid,
                children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].save */ .Z.save)
              })
            })
          })
        })]
      });
    }
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserPushbulletSettings);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;