"use strict";
exports.id = 33173;
exports.ids = [33173];
exports.modules = {

/***/ 33173:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(86799);
/* harmony import */ var _server_lib_permissions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(44941);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_0__]);
_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];








const SettingsLink = ({
  children,
  tabType,
  currentPath,
  route,
  regex,
  hidden = false,
  isMobile = false
}) => {
  if (hidden) {
    return null;
  }

  if (isMobile) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("option", {
      value: route,
      children: children
    });
  }

  let linkClasses = 'px-1 py-4 ml-8 text-sm font-medium leading-5 transition duration-300 border-b-2 border-transparent whitespace-nowrap first:ml-0';
  let activeLinkColor = 'text-indigo-500 border-indigo-600';
  let inactiveLinkColor = 'text-gray-500 border-transparent hover:text-gray-300 hover:border-gray-400 focus:text-gray-300 focus:border-gray-400';

  if (tabType === 'button') {
    linkClasses = 'px-3 py-2 text-sm font-medium transition duration-300 rounded-md whitespace-nowrap mx-2 my-1';
    activeLinkColor = 'bg-indigo-700';
    inactiveLinkColor = 'bg-gray-800 hover:bg-gray-700 focus:bg-gray-700';
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx((next_link__WEBPACK_IMPORTED_MODULE_2___default()), {
    href: route,
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("a", {
      className: `${linkClasses} ${currentPath.match(regex) ? activeLinkColor : inactiveLinkColor}`,
      "aria-current": "page",
      children: children
    })
  });
};

const SettingsTabs = ({
  tabType = 'default',
  settingsRoutes
}) => {
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_3__.useRouter)();
  const {
    user: currentUser
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_0__/* .useUser */ .aF)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.Fragment, {
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
      className: "sm:hidden",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("label", {
        htmlFor: "tabs",
        className: "sr-only",
        children: "Select a Tab"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("select", {
        onChange: e => {
          router.push(e.target.value);
        },
        onBlur: e => {
          router.push(e.target.value);
        },
        defaultValue: settingsRoutes.find(route => !!router.pathname.match(route.regex))?.route,
        "aria-label": "Selected Tab",
        children: settingsRoutes.filter(route => !route.hidden && (route.requiredPermission ? (0,_server_lib_permissions__WEBPACK_IMPORTED_MODULE_1__/* .hasPermission */ .F)(route.requiredPermission, currentUser?.permissions ?? 0, route.permissionType) : true)).map((route, index) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(SettingsLink, {
          tabType: tabType,
          currentPath: router.pathname,
          route: route.route,
          regex: route.regex,
          hidden: route.hidden ?? false,
          isMobile: true,
          children: route.text
        }, `mobile-settings-link-${index}`))
      })]
    }), tabType === 'button' ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
      className: "hidden sm:block",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("nav", {
        className: "-mx-2 -my-1 flex flex-wrap",
        "aria-label": "Tabs",
        children: settingsRoutes.map((route, index) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(SettingsLink, {
          tabType: tabType,
          currentPath: router.pathname,
          route: route.route,
          regex: route.regex,
          hidden: route.hidden ?? false,
          children: route.content ?? route.text
        }, `button-settings-link-${index}`))
      })
    }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
      className: "hide-scrollbar hidden overflow-x-scroll border-b border-gray-600 sm:block",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("nav", {
        className: "flex",
        "data-testid": "settings-nav-desktop",
        children: settingsRoutes.filter(route => !route.hidden && (route.requiredPermission ? (0,_server_lib_permissions__WEBPACK_IMPORTED_MODULE_1__/* .hasPermission */ .F)(route.requiredPermission, currentUser?.permissions ?? 0, route.permissionType) : true)).map((route, index) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(SettingsLink, {
          tabType: tabType,
          currentPath: router.pathname,
          route: route.route,
          regex: route.regex,
          children: route.text
        }, `standard-settings-link-${index}`))
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsTabs);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;