"use strict";
exports.id = 32553;
exports.ids = [32553];
exports.modules = {

/***/ 32553:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74449);
/* harmony import */ var _app_components_LanguageSelector__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(41466);
/* harmony import */ var _app_components_QuotaSelector__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(86957);
/* harmony import */ var _app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(72134);
/* harmony import */ var _app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(99819);
/* harmony import */ var _app_hooks_useLocale__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(84541);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(1388);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(80210);
/* harmony import */ var _app_pages_error__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(35635);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(15941);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_components_LanguageSelector__WEBPACK_IMPORTED_MODULE_4__, _app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_6__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_9__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__, _app_pages_error__WEBPACK_IMPORTED_MODULE_12__, axios__WEBPACK_IMPORTED_MODULE_14__, swr__WEBPACK_IMPORTED_MODULE_20__]);
([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_components_LanguageSelector__WEBPACK_IMPORTED_MODULE_4__, _app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_6__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_9__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__, _app_pages_error__WEBPACK_IMPORTED_MODULE_12__, axios__WEBPACK_IMPORTED_MODULE_14__, swr__WEBPACK_IMPORTED_MODULE_20__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);

























const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_18__.defineMessages)({
  general: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.general",
    "defaultMessage": 'General'
  },
  generalsettings: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.generalsettings",
    "defaultMessage": 'General Settings'
  },
  displayName: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.displayName",
    "defaultMessage": 'Display Name'
  },
  accounttype: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.accounttype",
    "defaultMessage": 'Account Type'
  },
  plexuser: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.plexuser",
    "defaultMessage": 'Plex User'
  },
  localuser: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.localuser",
    "defaultMessage": 'Local User'
  },
  role: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.role",
    "defaultMessage": 'Role'
  },
  owner: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.owner",
    "defaultMessage": 'Owner'
  },
  admin: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.admin",
    "defaultMessage": 'Admin'
  },
  user: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.user",
    "defaultMessage": 'User'
  },
  toastSettingsSuccess: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.toastSettingsSuccess",
    "defaultMessage": 'Settings saved successfully!'
  },
  toastSettingsFailure: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.toastSettingsFailure",
    "defaultMessage": 'Something went wrong while saving settings.'
  },
  region: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.region",
    "defaultMessage": 'Discover Region'
  },
  regionTip: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.regionTip",
    "defaultMessage": 'Filter content by regional availability'
  },
  originallanguage: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.originallanguage",
    "defaultMessage": 'Discover Language'
  },
  originallanguageTip: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.originallanguageTip",
    "defaultMessage": 'Filter content by original language'
  },
  movierequestlimit: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.movierequestlimit",
    "defaultMessage": 'Movie Request Limit'
  },
  seriesrequestlimit: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.seriesrequestlimit",
    "defaultMessage": 'Series Request Limit'
  },
  enableOverride: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.enableOverride",
    "defaultMessage": 'Override Global Limit'
  },
  applanguage: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.applanguage",
    "defaultMessage": 'Display Language'
  },
  languageDefault: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.languageDefault",
    "defaultMessage": 'Default ({language})'
  },
  discordId: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.discordId",
    "defaultMessage": 'Discord User ID'
  },
  discordIdTip: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.discordIdTip",
    "defaultMessage": 'The <FindDiscordIdLink>multi-digit ID number</FindDiscordIdLink> associated with your Discord user account'
  },
  validationDiscordId: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.validationDiscordId",
    "defaultMessage": 'You must provide a valid Discord user ID'
  },
  plexwatchlistsyncmovies: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.plexwatchlistsyncmovies",
    "defaultMessage": 'Auto-Request Movies'
  },
  plexwatchlistsyncmoviestip: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.plexwatchlistsyncmoviestip",
    "defaultMessage": 'Automatically request movies on your <PlexWatchlistSupportLink>Plex Watchlist</PlexWatchlistSupportLink>'
  },
  plexwatchlistsyncseries: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.plexwatchlistsyncseries",
    "defaultMessage": 'Auto-Request Series'
  },
  plexwatchlistsyncseriestip: {
    "id": "components.UserProfile.UserSettings.UserGeneralSettings.plexwatchlistsyncseriestip",
    "defaultMessage": 'Automatically request series on your <PlexWatchlistSupportLink>Plex Watchlist</PlexWatchlistSupportLink>'
  }
});

const UserGeneralSettings = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_18__.useIntl)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_19__.useToasts)();
  const {
    locale,
    setLocale
  } = (0,_app_hooks_useLocale__WEBPACK_IMPORTED_MODULE_8__/* ["default"] */ .Z)();
  const {
    0: movieQuotaEnabled,
    1: setMovieQuotaEnabled
  } = (0,react__WEBPACK_IMPORTED_MODULE_17__.useState)(false);
  const {
    0: tvQuotaEnabled,
    1: setTvQuotaEnabled
  } = (0,react__WEBPACK_IMPORTED_MODULE_17__.useState)(false);
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_16__.useRouter)();
  const {
    user,
    hasPermission,
    revalidate: revalidateUser
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__/* .useUser */ .aF)({
    id: Number(router.query.userId)
  });
  const {
    user: currentUser,
    hasPermission: currentHasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__/* .useUser */ .aF)();
  const {
    currentSettings
  } = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_9__/* ["default"] */ .Z)();
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_20__["default"])(user ? `/api/v1/user/${user?.id}/settings/main` : null);
  const UserGeneralSettingsSchema = yup__WEBPACK_IMPORTED_MODULE_21__.object().shape({
    discordId: yup__WEBPACK_IMPORTED_MODULE_21__.string().nullable().matches(/^\d{17,19}$/, intl.formatMessage(messages.validationDiscordId))
  });
  (0,react__WEBPACK_IMPORTED_MODULE_17__.useEffect)(() => {
    setMovieQuotaEnabled(data?.movieQuotaLimit != undefined && data?.movieQuotaDays != undefined);
    setTvQuotaEnabled(data?.tvQuotaLimit != undefined && data?.tvQuotaDays != undefined);
  }, [data]);

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {});
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(_app_pages_error__WEBPACK_IMPORTED_MODULE_12__["default"], {
      statusCode: 500
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      title: [intl.formatMessage(messages.general), intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_11__/* ["default"].usersettings */ .Z.usersettings)]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
      className: "mb-6",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.generalsettings)
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(formik__WEBPACK_IMPORTED_MODULE_15__.Formik, {
      initialValues: {
        displayName: data?.username,
        discordId: data?.discordId,
        locale: data?.locale,
        region: data?.region,
        originalLanguage: data?.originalLanguage,
        movieQuotaLimit: data?.movieQuotaLimit,
        movieQuotaDays: data?.movieQuotaDays,
        tvQuotaLimit: data?.tvQuotaLimit,
        tvQuotaDays: data?.tvQuotaDays,
        watchlistSyncMovies: data?.watchlistSyncMovies,
        watchlistSyncTv: data?.watchlistSyncTv
      },
      validationSchema: UserGeneralSettingsSchema,
      enableReinitialize: true,
      onSubmit: async values => {
        try {
          await axios__WEBPACK_IMPORTED_MODULE_14__["default"].post(`/api/v1/user/${user?.id}/settings/main`, {
            username: values.displayName,
            discordId: values.discordId,
            locale: values.locale,
            region: values.region,
            originalLanguage: values.originalLanguage,
            movieQuotaLimit: movieQuotaEnabled ? values.movieQuotaLimit : null,
            movieQuotaDays: movieQuotaEnabled ? values.movieQuotaDays : null,
            tvQuotaLimit: tvQuotaEnabled ? values.tvQuotaLimit : null,
            tvQuotaDays: tvQuotaEnabled ? values.tvQuotaDays : null,
            watchlistSyncMovies: values.watchlistSyncMovies,
            watchlistSyncTv: values.watchlistSyncTv
          });

          if (currentUser?.id === user?.id && setLocale) {
            setLocale(values.locale ? values.locale : currentSettings.locale);
          }

          addToast(intl.formatMessage(messages.toastSettingsSuccess), {
            autoDismiss: true,
            appearance: 'success'
          });
        } catch (e) {
          addToast(intl.formatMessage(messages.toastSettingsFailure), {
            autoDismiss: true,
            appearance: 'error'
          });
        } finally {
          revalidate();
          revalidateUser();
        }
      },
      children: ({
        errors,
        touched,
        isSubmitting,
        isValid,
        values,
        setFieldValue
      }) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_15__.Form, {
          className: "section",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("label", {
              className: "text-label",
              children: intl.formatMessage(messages.accounttype)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
              className: "mb-1 text-sm font-medium leading-5 text-gray-400 sm:mt-2",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
                className: "flex max-w-lg items-center",
                children: user?.userType === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__/* .UserType.PLEX */ .FW.PLEX ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                  badgeType: "warning",
                  children: intl.formatMessage(messages.plexuser)
                }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                  badgeType: "default",
                  children: intl.formatMessage(messages.localuser)
                })
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("label", {
              className: "text-label",
              children: intl.formatMessage(messages.role)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
              className: "mb-1 text-sm font-medium leading-5 text-gray-400 sm:mt-2",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
                className: "flex max-w-lg items-center",
                children: user?.id === 1 ? intl.formatMessage(messages.owner) : hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__/* .Permission.ADMIN */ .y3.ADMIN) ? intl.formatMessage(messages.admin) : intl.formatMessage(messages.user)
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("label", {
              htmlFor: "displayName",
              className: "text-label",
              children: intl.formatMessage(messages.displayName)
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: "form-input-area",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
                className: "form-input-field",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(formik__WEBPACK_IMPORTED_MODULE_15__.Field, {
                  id: "displayName",
                  name: "displayName",
                  type: "text",
                  placeholder: user?.plexUsername ? user.plexUsername : user?.email
                })
              }), errors.displayName && touched.displayName && typeof errors.displayName === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
                className: "error",
                children: errors.displayName
              })]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("label", {
              htmlFor: "discordId",
              className: "text-label",
              children: [intl.formatMessage(messages.discordId), currentUser?.id === user?.id && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                className: "label-tip",
                children: intl.formatMessage(messages.discordIdTip, {
                  FindDiscordIdLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("a", {
                    href: "https://support.discord.com/hc/en-us/articles/206346498-Where-can-I-find-my-User-Server-Message-ID-",
                    target: "_blank",
                    rel: "noreferrer",
                    children: msg
                  })
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: "form-input-area",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
                className: "form-input-field",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(formik__WEBPACK_IMPORTED_MODULE_15__.Field, {
                  id: "discordId",
                  name: "discordId",
                  type: "text"
                })
              }), errors.discordId && touched.discordId && typeof errors.discordId === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
                className: "error",
                children: errors.discordId
              })]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("label", {
              htmlFor: "locale",
              className: "text-label",
              children: intl.formatMessage(messages.applanguage)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
              className: "form-input-area",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
                className: "form-input-field",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_15__.Field, {
                  as: "select",
                  id: "locale",
                  name: "locale",
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("option", {
                    value: "",
                    lang: locale,
                    children: intl.formatMessage(messages.languageDefault, {
                      language: _app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_7__/* .availableLanguages */ .m[currentSettings.locale].display
                    })
                  }), Object.keys(_app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_7__/* .availableLanguages */ .m).map(key => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("option", {
                    value: _app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_7__/* .availableLanguages */ .m[key].code,
                    lang: _app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_7__/* .availableLanguages */ .m[key].code,
                    children: _app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_7__/* .availableLanguages */ .m[key].display
                  }, key))]
                })
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("label", {
              htmlFor: "displayName",
              className: "text-label",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                children: intl.formatMessage(messages.region)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                className: "label-tip",
                children: intl.formatMessage(messages.regionTip)
              })]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
              className: "form-input-area",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
                className: "form-input-field",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(_app_components_RegionSelector__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                  name: "region",
                  value: values.region ?? '',
                  isUserSetting: true,
                  onChange: setFieldValue
                })
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("label", {
              htmlFor: "originalLanguage",
              className: "text-label",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                children: intl.formatMessage(messages.originallanguage)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                className: "label-tip",
                children: intl.formatMessage(messages.originallanguageTip)
              })]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
              className: "form-input-area",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
                className: "form-input-field",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(_app_components_LanguageSelector__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                  setFieldValue: setFieldValue,
                  serverValue: currentSettings.originalLanguage,
                  value: values.originalLanguage,
                  isUserSettings: true
                })
              })
            })]
          }), currentHasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__/* .Permission.MANAGE_USERS */ .y3.MANAGE_USERS) && !hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__/* .Permission.MANAGE_USERS */ .y3.MANAGE_USERS) && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.Fragment, {
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("label", {
                htmlFor: "movieQuotaLimit",
                className: "text-label",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                  children: intl.formatMessage(messages.movierequestlimit)
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                  className: "flex flex-col",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                    className: "mb-4 flex items-center",
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("input", {
                      type: "checkbox",
                      checked: movieQuotaEnabled,
                      onChange: () => setMovieQuotaEnabled(s => !s)
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                      className: "ml-2 text-gray-300",
                      children: intl.formatMessage(messages.enableOverride)
                    })]
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(_app_components_QuotaSelector__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                    isDisabled: !movieQuotaEnabled,
                    dayFieldName: "movieQuotaDays",
                    limitFieldName: "movieQuotaLimit",
                    mediaType: "movie",
                    onChange: setFieldValue,
                    defaultDays: values.movieQuotaDays,
                    defaultLimit: values.movieQuotaLimit,
                    dayOverride: !movieQuotaEnabled ? data?.globalMovieQuotaDays : undefined,
                    limitOverride: !movieQuotaEnabled ? data?.globalMovieQuotaLimit : undefined
                  })]
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("label", {
                htmlFor: "tvQuotaLimit",
                className: "text-label",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                  children: intl.formatMessage(messages.seriesrequestlimit)
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                  className: "flex flex-col",
                  children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
                    className: "mb-4 flex items-center",
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("input", {
                      type: "checkbox",
                      checked: tvQuotaEnabled,
                      onChange: () => setTvQuotaEnabled(s => !s)
                    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                      className: "ml-2 text-gray-300",
                      children: intl.formatMessage(messages.enableOverride)
                    })]
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(_app_components_QuotaSelector__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                    isDisabled: !tvQuotaEnabled,
                    dayFieldName: "tvQuotaDays",
                    limitFieldName: "tvQuotaLimit",
                    mediaType: "tv",
                    onChange: setFieldValue,
                    defaultDays: values.tvQuotaDays,
                    defaultLimit: values.tvQuotaLimit,
                    dayOverride: !tvQuotaEnabled ? data?.globalTvQuotaDays : undefined,
                    limitOverride: !tvQuotaEnabled ? data?.globalTvQuotaLimit : undefined
                  })]
                })
              })]
            })]
          }), hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__/* .Permission.AUTO_REQUEST */ .y3.AUTO_REQUEST, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__/* .Permission.AUTO_REQUEST_MOVIE */ .y3.AUTO_REQUEST_MOVIE], {
            type: 'or'
          }) && user?.userType === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__/* .UserType.PLEX */ .FW.PLEX && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("label", {
              htmlFor: "watchlistSyncMovies",
              className: "checkbox-label",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                children: intl.formatMessage(messages.plexwatchlistsyncmovies)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                className: "label-tip",
                children: intl.formatMessage(messages.plexwatchlistsyncmoviestip, {
                  PlexWatchlistSupportLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("a", {
                    href: "https://support.plex.tv/articles/universal-watchlist/",
                    className: "text-white transition duration-300 hover:underline",
                    target: "_blank",
                    rel: "noreferrer",
                    children: msg
                  })
                })
              })]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
              className: "form-input-area",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(formik__WEBPACK_IMPORTED_MODULE_15__.Field, {
                type: "checkbox",
                id: "watchlistSyncMovies",
                name: "watchlistSyncMovies",
                onChange: () => {
                  setFieldValue('watchlistSyncMovies', !values.watchlistSyncMovies);
                }
              })
            })]
          }), hasPermission([_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__/* .Permission.AUTO_REQUEST */ .y3.AUTO_REQUEST, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__/* .Permission.AUTO_REQUEST_TV */ .y3.AUTO_REQUEST_TV], {
            type: 'or'
          }) && user?.userType === _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__/* .UserType.PLEX */ .FW.PLEX && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)("label", {
              htmlFor: "watchlistSyncTv",
              className: "checkbox-label",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                children: intl.formatMessage(messages.plexwatchlistsyncseries)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                className: "label-tip",
                children: intl.formatMessage(messages.plexwatchlistsyncseriestip, {
                  PlexWatchlistSupportLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("a", {
                    href: "https://support.plex.tv/articles/universal-watchlist/",
                    className: "text-white transition duration-300 hover:underline",
                    target: "_blank",
                    rel: "noreferrer",
                    children: msg
                  })
                })
              })]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
              className: "form-input-area",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(formik__WEBPACK_IMPORTED_MODULE_15__.Field, {
                type: "checkbox",
                id: "watchlistSyncTv",
                name: "watchlistSyncTv",
                onChange: () => {
                  setFieldValue('watchlistSyncTv', !values.watchlistSyncTv);
                }
              })
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
            className: "actions",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("div", {
              className: "flex justify-end",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                className: "ml-3 inline-flex rounded-md shadow-sm",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                  buttonType: "primary",
                  type: "submit",
                  disabled: isSubmitting || !isValid,
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_13__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_22__.jsx("span", {
                    children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_11__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_11__/* ["default"].save */ .Z.save)
                  })]
                })
              })
            })
          })]
        });
      }
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserGeneralSettings);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;