"use strict";
exports.id = 28575;
exports.ids = [28575];
exports.modules = {

/***/ 99488:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__);




const LibraryItem = ({
  isEnabled,
  name,
  onToggle
}) => {
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("li", {
    className: "col-span-1 flex rounded-md shadow-sm",
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("div", {
      className: "flex flex-1 items-center justify-between truncate rounded-md border-t border-b border-r border-gray-700 bg-gray-600",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("div", {
        className: "flex-1 cursor-default truncate px-4 py-6 text-sm leading-5",
        children: name
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("div", {
        className: "flex-shrink-0 pr-2",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("span", {
          role: "checkbox",
          tabIndex: 0,
          "aria-checked": isEnabled,
          onClick: () => onToggle(),
          onKeyDown: e => {
            if (e.key === 'Enter') {
              onToggle();
            }
          },
          className: `${isEnabled ? 'bg-indigo-600' : 'bg-gray-700'} relative inline-flex h-6 w-11 flex-shrink-0 cursor-pointer rounded-full border-2 border-transparent transition-colors duration-200 ease-in-out focus:outline-none focus:ring`,
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsxs)("span", {
            "aria-hidden": "true",
            className: `${isEnabled ? 'translate-x-5' : 'translate-x-0'} relative inline-block h-5 w-5 rounded-full bg-white shadow transition duration-200 ease-in-out`,
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("span", {
              className: `${isEnabled ? 'opacity-0 duration-100 ease-out' : 'opacity-100 duration-200 ease-in'} absolute inset-0 flex h-full w-full items-center justify-center transition-opacity`,
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__.XMarkIcon, {
                className: "h-3 w-3 text-gray-400"
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx("span", {
              className: `${isEnabled ? 'opacity-100 duration-200 ease-in' : 'opacity-0 duration-100 ease-out'} absolute inset-0 flex h-full w-full items-center justify-center transition-opacity`,
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_1__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_0__.CheckIcon, {
                className: "h-3 w-3 text-indigo-600"
              })
            })]
          })
        })
      })]
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LibraryItem);

/***/ }),

/***/ 28575:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13555);
/* harmony import */ var _app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(99073);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(61903);
/* harmony import */ var _app_components_Settings_LibraryItem__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(99488);
/* harmony import */ var _app_components_Settings_SettingsBadge__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(75294);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(46517);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(15941);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__, axios__WEBPACK_IMPORTED_MODULE_11__, swr__WEBPACK_IMPORTED_MODULE_17__]);
([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__, axios__WEBPACK_IMPORTED_MODULE_11__, swr__WEBPACK_IMPORTED_MODULE_17__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.defineMessages)({
  plex: {
    "id": "components.Settings.plex",
    "defaultMessage": 'Plex'
  },
  plexsettings: {
    "id": "components.Settings.plexsettings",
    "defaultMessage": 'Plex Settings'
  },
  plexsettingsDescription: {
    "id": "components.Settings.plexsettingsDescription",
    "defaultMessage": 'Configure the settings for your Plex server. Overseerr scans your Plex libraries to determine content availability.'
  },
  serverpreset: {
    "id": "components.Settings.serverpreset",
    "defaultMessage": 'Server'
  },
  serverLocal: {
    "id": "components.Settings.serverLocal",
    "defaultMessage": 'local'
  },
  serverRemote: {
    "id": "components.Settings.serverRemote",
    "defaultMessage": 'remote'
  },
  serverSecure: {
    "id": "components.Settings.serverSecure",
    "defaultMessage": 'secure'
  },
  serverpresetManualMessage: {
    "id": "components.Settings.serverpresetManualMessage",
    "defaultMessage": 'Manual configuration'
  },
  serverpresetRefreshing: {
    "id": "components.Settings.serverpresetRefreshing",
    "defaultMessage": 'Retrieving servers…'
  },
  serverpresetLoad: {
    "id": "components.Settings.serverpresetLoad",
    "defaultMessage": 'Press the button to load available servers'
  },
  toastPlexRefresh: {
    "id": "components.Settings.toastPlexRefresh",
    "defaultMessage": 'Retrieving server list from Plex…'
  },
  toastPlexRefreshSuccess: {
    "id": "components.Settings.toastPlexRefreshSuccess",
    "defaultMessage": 'Plex server list retrieved successfully!'
  },
  toastPlexRefreshFailure: {
    "id": "components.Settings.toastPlexRefreshFailure",
    "defaultMessage": 'Failed to retrieve Plex server list.'
  },
  toastPlexConnecting: {
    "id": "components.Settings.toastPlexConnecting",
    "defaultMessage": 'Attempting to connect to Plex…'
  },
  toastPlexConnectingSuccess: {
    "id": "components.Settings.toastPlexConnectingSuccess",
    "defaultMessage": 'Plex connection established successfully!'
  },
  toastPlexConnectingFailure: {
    "id": "components.Settings.toastPlexConnectingFailure",
    "defaultMessage": 'Failed to connect to Plex.'
  },
  settingUpPlexDescription: {
    "id": "components.Settings.settingUpPlexDescription",
    "defaultMessage": 'To set up Plex, you can either enter the details manually or select a server retrieved from <RegisterPlexTVLink>plex.tv</RegisterPlexTVLink>. Press the button to the right of the dropdown to fetch the list of available servers.'
  },
  hostname: {
    "id": "components.Settings.hostname",
    "defaultMessage": 'Hostname or IP Address'
  },
  port: {
    "id": "components.Settings.port",
    "defaultMessage": 'Port'
  },
  enablessl: {
    "id": "components.Settings.enablessl",
    "defaultMessage": 'Use SSL'
  },
  plexlibraries: {
    "id": "components.Settings.plexlibraries",
    "defaultMessage": 'Plex Libraries'
  },
  plexlibrariesDescription: {
    "id": "components.Settings.plexlibrariesDescription",
    "defaultMessage": 'The libraries Overseerr scans for titles. Set up and save your Plex connection settings, then click the button below if no libraries are listed.'
  },
  scanning: {
    "id": "components.Settings.scanning",
    "defaultMessage": 'Syncing…'
  },
  scan: {
    "id": "components.Settings.scan",
    "defaultMessage": 'Sync Libraries'
  },
  manualscan: {
    "id": "components.Settings.manualscan",
    "defaultMessage": 'Manual Library Scan'
  },
  manualscanDescription: {
    "id": "components.Settings.manualscanDescription",
    "defaultMessage": "Normally, this will only be run once every 24 hours. Overseerr will check your Plex server's recently added more aggressively. If this is your first time configuring Plex, a one-time full manual library scan is recommended!"
  },
  notrunning: {
    "id": "components.Settings.notrunning",
    "defaultMessage": 'Not Running'
  },
  currentlibrary: {
    "id": "components.Settings.currentlibrary",
    "defaultMessage": 'Current Library: {name}'
  },
  librariesRemaining: {
    "id": "components.Settings.librariesRemaining",
    "defaultMessage": 'Libraries Remaining: {count}'
  },
  startscan: {
    "id": "components.Settings.startscan",
    "defaultMessage": 'Start Scan'
  },
  cancelscan: {
    "id": "components.Settings.cancelscan",
    "defaultMessage": 'Cancel Scan'
  },
  validationHostnameRequired: {
    "id": "components.Settings.validationHostnameRequired",
    "defaultMessage": 'You must provide a valid hostname or IP address'
  },
  validationPortRequired: {
    "id": "components.Settings.validationPortRequired",
    "defaultMessage": 'You must provide a valid port number'
  },
  webAppUrl: {
    "id": "components.Settings.webAppUrl",
    "defaultMessage": '<WebAppLink>Web App</WebAppLink> URL'
  },
  webAppUrlTip: {
    "id": "components.Settings.webAppUrlTip",
    "defaultMessage": 'Optionally direct users to the web app on your server instead of the "hosted" web app'
  },
  tautulliSettings: {
    "id": "components.Settings.tautulliSettings",
    "defaultMessage": 'Tautulli Settings'
  },
  tautulliSettingsDescription: {
    "id": "components.Settings.tautulliSettingsDescription",
    "defaultMessage": 'Optionally configure the settings for your Tautulli server. Overseerr fetches watch history data for your Plex media from Tautulli.'
  },
  urlBase: {
    "id": "components.Settings.urlBase",
    "defaultMessage": 'URL Base'
  },
  tautulliApiKey: {
    "id": "components.Settings.tautulliApiKey",
    "defaultMessage": 'API Key'
  },
  externalUrl: {
    "id": "components.Settings.externalUrl",
    "defaultMessage": 'External URL'
  },
  validationApiKey: {
    "id": "components.Settings.validationApiKey",
    "defaultMessage": 'You must provide an API key'
  },
  validationUrl: {
    "id": "components.Settings.validationUrl",
    "defaultMessage": 'You must provide a valid URL'
  },
  validationUrlTrailingSlash: {
    "id": "components.Settings.validationUrlTrailingSlash",
    "defaultMessage": 'URL must not end in a trailing slash'
  },
  validationUrlBaseLeadingSlash: {
    "id": "components.Settings.validationUrlBaseLeadingSlash",
    "defaultMessage": 'URL base must have a leading slash'
  },
  validationUrlBaseTrailingSlash: {
    "id": "components.Settings.validationUrlBaseTrailingSlash",
    "defaultMessage": 'URL base must not end in a trailing slash'
  },
  toastTautulliSettingsSuccess: {
    "id": "components.Settings.toastTautulliSettingsSuccess",
    "defaultMessage": 'Tautulli settings saved successfully!'
  },
  toastTautulliSettingsFailure: {
    "id": "components.Settings.toastTautulliSettingsFailure",
    "defaultMessage": 'Something went wrong while saving Tautulli settings.'
  }
});

const SettingsPlex = ({
  onComplete
}) => {
  const {
    0: isSyncing,
    1: setIsSyncing
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
  const {
    0: isRefreshingPresets,
    1: setIsRefreshingPresets
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(false);
  const {
    0: availableServers,
    1: setAvailableServers
  } = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(null);
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_17__["default"])('/api/v1/settings/plex');
  const {
    data: dataTautulli,
    mutate: revalidateTautulli
  } = (0,swr__WEBPACK_IMPORTED_MODULE_17__["default"])('/api/v1/settings/tautulli');
  const {
    data: dataSync,
    mutate: revalidateSync
  } = (0,swr__WEBPACK_IMPORTED_MODULE_17__["default"])('/api/v1/settings/plex/sync', {
    refreshInterval: 1000
  });
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_15__.useIntl)();
  const {
    addToast,
    removeToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_16__.useToasts)();
  const PlexSettingsSchema = yup__WEBPACK_IMPORTED_MODULE_18__.object().shape({
    hostname: yup__WEBPACK_IMPORTED_MODULE_18__.string().nullable().required(intl.formatMessage(messages.validationHostnameRequired)).matches(/^(((([a-z]|\d|_|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])):((([a-z]|\d|_|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))@)?(([a-z]|\d|_|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])$/i, intl.formatMessage(messages.validationHostnameRequired)),
    port: yup__WEBPACK_IMPORTED_MODULE_18__.number().nullable().required(intl.formatMessage(messages.validationPortRequired)),
    webAppUrl: yup__WEBPACK_IMPORTED_MODULE_18__.string().nullable().url(intl.formatMessage(messages.validationUrl))
  });
  const TautulliSettingsSchema = yup__WEBPACK_IMPORTED_MODULE_18__.object().shape({
    tautulliHostname: yup__WEBPACK_IMPORTED_MODULE_18__.string().when(['tautulliPort', 'tautulliApiKey'], {
      is: value => !!value,
      then: yup__WEBPACK_IMPORTED_MODULE_18__.string().nullable().required(intl.formatMessage(messages.validationHostnameRequired)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_18__.string().nullable()
    }).matches(/^(([a-z]|\d|_|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*)?([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])$/i, intl.formatMessage(messages.validationHostnameRequired)),
    tautulliPort: yup__WEBPACK_IMPORTED_MODULE_18__.number().when(['tautulliHostname', 'tautulliApiKey'], {
      is: value => !!value,
      then: yup__WEBPACK_IMPORTED_MODULE_18__.number().typeError(intl.formatMessage(messages.validationPortRequired)).nullable().required(intl.formatMessage(messages.validationPortRequired)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_18__.number().typeError(intl.formatMessage(messages.validationPortRequired)).nullable()
    }),
    tautulliUrlBase: yup__WEBPACK_IMPORTED_MODULE_18__.string().test('leading-slash', intl.formatMessage(messages.validationUrlBaseLeadingSlash), value => !value || value.startsWith('/')).test('no-trailing-slash', intl.formatMessage(messages.validationUrlBaseTrailingSlash), value => !value || !value.endsWith('/')),
    tautulliApiKey: yup__WEBPACK_IMPORTED_MODULE_18__.string().when(['tautulliHostname', 'tautulliPort'], {
      is: value => !!value,
      then: yup__WEBPACK_IMPORTED_MODULE_18__.string().nullable().required(intl.formatMessage(messages.validationApiKey)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_18__.string().nullable()
    }),
    tautulliExternalUrl: yup__WEBPACK_IMPORTED_MODULE_18__.string().url(intl.formatMessage(messages.validationUrl)).test('no-trailing-slash', intl.formatMessage(messages.validationUrlTrailingSlash), value => !value || !value.endsWith('/'))
  }, [['tautulliHostname', 'tautulliPort'], ['tautulliHostname', 'tautulliApiKey'], ['tautulliPort', 'tautulliApiKey']]);
  const activeLibraries = data?.libraries.filter(library => library.enabled).map(library => library.id) ?? [];
  const availablePresets = (0,react__WEBPACK_IMPORTED_MODULE_14__.useMemo)(() => {
    const finalPresets = [];
    availableServers?.forEach(dev => {
      dev.connection.forEach(conn => finalPresets.push({
        name: dev.name,
        ssl: conn.protocol === 'https',
        uri: conn.uri,
        address: conn.address,
        port: conn.port,
        local: conn.local,
        status: conn.status === 200,
        message: conn.message
      }));
    });
    return (0,lodash__WEBPACK_IMPORTED_MODULE_13__.orderBy)(finalPresets, ['status', 'ssl'], ['desc', 'desc']);
  }, [availableServers]);

  const syncLibraries = async () => {
    setIsSyncing(true);
    const params = {
      sync: true
    };

    if (activeLibraries.length > 0) {
      params.enable = activeLibraries.join(',');
    }

    await axios__WEBPACK_IMPORTED_MODULE_11__["default"].get('/api/v1/settings/plex/library', {
      params
    });
    setIsSyncing(false);
    revalidate();
  };

  const refreshPresetServers = async () => {
    setIsRefreshingPresets(true);
    let toastId;

    try {
      addToast(intl.formatMessage(messages.toastPlexRefresh), {
        autoDismiss: false,
        appearance: 'info'
      }, id => {
        toastId = id;
      });
      const response = await axios__WEBPACK_IMPORTED_MODULE_11__["default"].get('/api/v1/settings/plex/devices/servers');

      if (response.data) {
        setAvailableServers(response.data);
      }

      if (toastId) {
        removeToast(toastId);
      }

      addToast(intl.formatMessage(messages.toastPlexRefreshSuccess), {
        autoDismiss: true,
        appearance: 'success'
      });
    } catch (e) {
      if (toastId) {
        removeToast(toastId);
      }

      addToast(intl.formatMessage(messages.toastPlexRefreshFailure), {
        autoDismiss: true,
        appearance: 'error'
      });
    } finally {
      setIsRefreshingPresets(false);
    }
  };

  const startScan = async () => {
    await axios__WEBPACK_IMPORTED_MODULE_11__["default"].post('/api/v1/settings/plex/sync', {
      start: true
    });
    revalidateSync();
  };

  const cancelScan = async () => {
    await axios__WEBPACK_IMPORTED_MODULE_11__["default"].post('/api/v1/settings/plex/sync', {
      cancel: true
    });
    revalidateSync();
  };

  const toggleLibrary = async libraryId => {
    setIsSyncing(true);

    if (activeLibraries.includes(libraryId)) {
      const params = {};

      if (activeLibraries.length > 1) {
        params.enable = activeLibraries.filter(id => id !== libraryId).join(',');
      }

      await axios__WEBPACK_IMPORTED_MODULE_11__["default"].get('/api/v1/settings/plex/library', {
        params
      });
    } else {
      await axios__WEBPACK_IMPORTED_MODULE_11__["default"].get('/api/v1/settings/plex/library', {
        params: {
          enable: [...activeLibraries, libraryId].join(',')
        }
      });
    }

    setIsSyncing(false);
    revalidate();
  };

  if ((!data || !dataTautulli) && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {});
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
      title: [intl.formatMessage(messages.plex), intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].settings */ .Z.settings)]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
      className: "mb-6",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.plexsettings)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("p", {
        className: "description",
        children: intl.formatMessage(messages.plexsettingsDescription)
      }), !!onComplete && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
        className: "section",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
          title: intl.formatMessage(messages.settingUpPlexDescription, {
            RegisterPlexTVLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("a", {
              href: "https://plex.tv",
              className: "text-white transition duration-300 hover:underline",
              target: "_blank",
              rel: "noreferrer",
              children: msg
            })
          }),
          type: "info"
        })
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(formik__WEBPACK_IMPORTED_MODULE_12__.Formik, {
      initialValues: {
        hostname: data?.ip,
        port: data?.port ?? 32400,
        useSsl: data?.useSsl,
        selectedPreset: undefined,
        webAppUrl: data?.webAppUrl
      },
      validationSchema: PlexSettingsSchema,
      onSubmit: async values => {
        let toastId = null;

        try {
          addToast(intl.formatMessage(messages.toastPlexConnecting), {
            autoDismiss: false,
            appearance: 'info'
          }, id => {
            toastId = id;
          });
          await axios__WEBPACK_IMPORTED_MODULE_11__["default"].post('/api/v1/settings/plex', {
            ip: values.hostname,
            port: Number(values.port),
            useSsl: values.useSsl,
            webAppUrl: values.webAppUrl
          });
          syncLibraries();

          if (toastId) {
            removeToast(toastId);
          }

          addToast(intl.formatMessage(messages.toastPlexConnectingSuccess), {
            autoDismiss: true,
            appearance: 'success'
          });

          if (onComplete) {
            onComplete();
          }
        } catch (e) {
          if (toastId) {
            removeToast(toastId);
          }

          addToast(intl.formatMessage(messages.toastPlexConnectingFailure), {
            autoDismiss: true,
            appearance: 'error'
          });
        }
      },
      children: ({
        errors,
        touched,
        values,
        handleSubmit,
        setFieldValue,
        isSubmitting,
        isValid
      }) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("form", {
          className: "section",
          onSubmit: handleSubmit,
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("label", {
              htmlFor: "preset",
              className: "text-label",
              children: intl.formatMessage(messages.serverpreset)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "form-input-area",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
                className: "form-input-field",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("select", {
                  id: "preset",
                  name: "preset",
                  value: values.selectedPreset,
                  disabled: !availableServers || isRefreshingPresets,
                  className: "rounded-l-only",
                  onChange: async e => {
                    const targPreset = availablePresets[Number(e.target.value)];

                    if (targPreset) {
                      setFieldValue('hostname', targPreset.address);
                      setFieldValue('port', targPreset.port);
                      setFieldValue('useSsl', targPreset.ssl);
                    }
                  },
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("option", {
                    value: "manual",
                    children: availableServers || isRefreshingPresets ? isRefreshingPresets ? intl.formatMessage(messages.serverpresetRefreshing) : intl.formatMessage(messages.serverpresetManualMessage) : intl.formatMessage(messages.serverpresetLoad)
                  }), availablePresets.map((server, index) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("option", {
                    value: index,
                    disabled: !server.status,
                    children: `
                            ${server.name} (${server.address})
                            [${server.local ? intl.formatMessage(messages.serverLocal) : intl.formatMessage(messages.serverRemote)}]${server.ssl ? ` [${intl.formatMessage(messages.serverSecure)}]` : ''}
                            ${server.status ? '' : '(' + server.message + ')'}
                          `
                  }, `preset-server-${index}`))]
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("button", {
                  onClick: e => {
                    e.preventDefault();
                    refreshPresetServers();
                  },
                  className: "input-action",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__.ArrowPathIcon, {
                    className: isRefreshingPresets ? 'animate-spin' : '',
                    style: {
                      animationDirection: 'reverse'
                    }
                  })
                })]
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("label", {
              htmlFor: "hostname",
              className: "text-label",
              children: [intl.formatMessage(messages.hostname), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                className: "label-required",
                children: "*"
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
              className: "form-input-area",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
                className: "form-input-field",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                  className: "inline-flex cursor-default items-center rounded-l-md border border-r-0 border-gray-500 bg-gray-800 px-3 text-gray-100 sm:text-sm",
                  children: values.useSsl ? 'https://' : 'http://'
                }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(formik__WEBPACK_IMPORTED_MODULE_12__.Field, {
                  type: "text",
                  inputMode: "url",
                  id: "hostname",
                  name: "hostname",
                  className: "rounded-r-only"
                })]
              }), errors.hostname && touched.hostname && typeof errors.hostname === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                className: "error",
                children: errors.hostname
              })]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("label", {
              htmlFor: "port",
              className: "text-label",
              children: [intl.formatMessage(messages.port), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                className: "label-required",
                children: "*"
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
              className: "form-input-area",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(formik__WEBPACK_IMPORTED_MODULE_12__.Field, {
                type: "text",
                inputMode: "numeric",
                id: "port",
                name: "port",
                className: "short"
              }), errors.port && touched.port && typeof errors.port === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                className: "error",
                children: errors.port
              })]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("label", {
              htmlFor: "ssl",
              className: "checkbox-label",
              children: intl.formatMessage(messages.enablessl)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "form-input-area",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(formik__WEBPACK_IMPORTED_MODULE_12__.Field, {
                type: "checkbox",
                id: "useSsl",
                name: "useSsl",
                onChange: () => {
                  setFieldValue('useSsl', !values.useSsl);
                }
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("label", {
              htmlFor: "webAppUrl",
              className: "text-label",
              children: [intl.formatMessage(messages.webAppUrl, {
                WebAppLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("a", {
                  href: "https://support.plex.tv/articles/200288666-opening-plex-web-app/",
                  target: "_blank",
                  rel: "noreferrer",
                  children: msg
                })
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Settings_SettingsBadge__WEBPACK_IMPORTED_MODULE_7__/* ["default"] */ .Z, {
                badgeType: "advanced",
                className: "ml-2"
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                className: "label-tip",
                children: intl.formatMessage(messages.webAppUrlTip)
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
              className: "form-input-area",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                className: "form-input-field",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(formik__WEBPACK_IMPORTED_MODULE_12__.Field, {
                  type: "text",
                  inputMode: "url",
                  id: "webAppUrl",
                  name: "webAppUrl",
                  placeholder: "https://app.plex.tv/desktop"
                })
              }), errors.webAppUrl && touched.webAppUrl && typeof errors.webAppUrl === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                className: "error",
                children: errors.webAppUrl
              })]
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
            className: "actions",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "flex justify-end",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                className: "ml-3 inline-flex rounded-md shadow-sm",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                  buttonType: "primary",
                  type: "submit",
                  disabled: isSubmitting || !isValid,
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_9__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                    children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].save */ .Z.save)
                  })]
                })
              })
            })
          })]
        });
      }
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
      className: "mt-10 mb-6",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.plexlibraries)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("p", {
        className: "description",
        children: intl.formatMessage(messages.plexlibrariesDescription)
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
      className: "section",
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        onClick: () => syncLibraries(),
        disabled: isSyncing || !data?.ip || !data?.port,
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__.ArrowPathIcon, {
          className: isSyncing ? 'animate-spin' : '',
          style: {
            animationDirection: 'reverse'
          }
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
          children: isSyncing ? intl.formatMessage(messages.scanning) : intl.formatMessage(messages.scan)
        })]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("ul", {
        className: "mt-6 grid grid-cols-1 gap-5 sm:grid-cols-2 sm:gap-6 lg:grid-cols-4",
        children: data?.libraries.map(library => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Settings_LibraryItem__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
          name: library.name,
          isEnabled: library.enabled,
          onToggle: () => toggleLibrary(library.id)
        }, `setting-library-${library.id}`))
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
      className: "mt-10 mb-6",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.manualscan)
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("p", {
        className: "description",
        children: intl.formatMessage(messages.manualscanDescription)
      })]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
      className: "section",
      children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
        className: "rounded-md bg-gray-800 p-4",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
          className: "relative mb-6 h-8 w-full overflow-hidden rounded-full bg-gray-600",
          children: [dataSync?.running && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
            className: "h-8 bg-indigo-600 transition-all duration-200 ease-in-out",
            style: {
              width: `${Math.round(dataSync.progress / dataSync.total * 100)}%`
            }
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
            className: "absolute inset-0 flex h-8 w-full items-center justify-center text-sm",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
              children: dataSync?.running ? `${dataSync.progress} of ${dataSync.total}` : 'Not running'
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
          className: "flex w-full flex-col sm:flex-row",
          children: [dataSync?.running && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.Fragment, {
            children: [dataSync.currentLibrary && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "mb-2 mr-0 flex items-center sm:mb-0 sm:mr-2",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                children: intl.formatMessage(messages.currentlibrary, {
                  name: dataSync.currentLibrary.name
                })
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "flex items-center",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_Badge__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                badgeType: "warning",
                children: intl.formatMessage(messages.librariesRemaining, {
                  count: dataSync.currentLibrary ? dataSync.libraries.slice(dataSync.libraries.findIndex(library => library.id === dataSync.currentLibrary?.id) + 1).length : 0
                })
              })
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
            className: "flex-1 text-right",
            children: !dataSync?.running ? /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
              buttonType: "warning",
              onClick: () => startScan(),
              disabled: isSyncing || !activeLibraries.length,
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__.MagnifyingGlassIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                children: intl.formatMessage(messages.startscan)
              })]
            }) : /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
              buttonType: "danger",
              onClick: () => cancelScan(),
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_10__.XMarkIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                children: intl.formatMessage(messages.cancelscan)
              })]
            })
          })]
        })]
      })
    }), !onComplete && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.Fragment, {
      children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
        className: "mt-10 mb-6",
        children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("h3", {
          className: "heading",
          children: intl.formatMessage(messages.tautulliSettings)
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("p", {
          className: "description",
          children: intl.formatMessage(messages.tautulliSettingsDescription)
        })]
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(formik__WEBPACK_IMPORTED_MODULE_12__.Formik, {
        initialValues: {
          tautulliHostname: dataTautulli?.hostname,
          tautulliPort: dataTautulli?.port ?? 8181,
          tautulliUseSsl: dataTautulli?.useSsl,
          tautulliUrlBase: dataTautulli?.urlBase,
          tautulliApiKey: dataTautulli?.apiKey,
          tautulliExternalUrl: dataTautulli?.externalUrl
        },
        validationSchema: TautulliSettingsSchema,
        onSubmit: async values => {
          try {
            await axios__WEBPACK_IMPORTED_MODULE_11__["default"].post('/api/v1/settings/tautulli', {
              hostname: values.tautulliHostname,
              port: Number(values.tautulliPort),
              useSsl: values.tautulliUseSsl,
              urlBase: values.tautulliUrlBase,
              apiKey: values.tautulliApiKey,
              externalUrl: values.tautulliExternalUrl
            });
            addToast(intl.formatMessage(messages.toastTautulliSettingsSuccess), {
              autoDismiss: true,
              appearance: 'success'
            });
          } catch (e) {
            addToast(intl.formatMessage(messages.toastTautulliSettingsFailure), {
              autoDismiss: true,
              appearance: 'error'
            });
          } finally {
            revalidateTautulli();
          }
        },
        children: ({
          errors,
          touched,
          values,
          handleSubmit,
          setFieldValue,
          isSubmitting,
          isValid
        }) => {
          return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("form", {
            className: "section",
            onSubmit: handleSubmit,
            children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("label", {
                htmlFor: "tautulliHostname",
                className: "text-label",
                children: [intl.formatMessage(messages.hostname), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
                  className: "form-input-field",
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                    className: "inline-flex cursor-default items-center rounded-l-md border border-r-0 border-gray-500 bg-gray-800 px-3 text-gray-100 sm:text-sm",
                    children: values.tautulliUseSsl ? 'https://' : 'http://'
                  }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(formik__WEBPACK_IMPORTED_MODULE_12__.Field, {
                    type: "text",
                    inputMode: "url",
                    id: "tautulliHostname",
                    name: "tautulliHostname",
                    className: "rounded-r-only"
                  })]
                }), errors.tautulliHostname && touched.tautulliHostname && typeof errors.tautulliHostname === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                  className: "error",
                  children: errors.tautulliHostname
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("label", {
                htmlFor: "tautulliPort",
                className: "text-label",
                children: [intl.formatMessage(messages.port), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(formik__WEBPACK_IMPORTED_MODULE_12__.Field, {
                  type: "text",
                  inputMode: "numeric",
                  id: "tautulliPort",
                  name: "tautulliPort",
                  className: "short",
                  autoComplete: "off",
                  "data-1pignore": "true",
                  "data-lpignore": "true",
                  "data-bwignore": "true"
                }), errors.tautulliPort && touched.tautulliPort && typeof errors.tautulliPort === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                  className: "error",
                  children: errors.tautulliPort
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("label", {
                htmlFor: "tautulliUseSsl",
                className: "checkbox-label",
                children: intl.formatMessage(messages.enablessl)
              }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                className: "form-input-area",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(formik__WEBPACK_IMPORTED_MODULE_12__.Field, {
                  type: "checkbox",
                  id: "tautulliUseSsl",
                  name: "tautulliUseSsl",
                  onChange: () => {
                    setFieldValue('tautulliUseSsl', !values.tautulliUseSsl);
                  }
                })
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("label", {
                htmlFor: "tautulliUrlBase",
                className: "text-label",
                children: intl.formatMessage(messages.urlBase)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(formik__WEBPACK_IMPORTED_MODULE_12__.Field, {
                    type: "text",
                    inputMode: "url",
                    id: "tautulliUrlBase",
                    name: "tautulliUrlBase",
                    autoComplete: "off",
                    "data-1pignore": "true",
                    "data-lpignore": "true",
                    "data-bwignore": "true"
                  })
                }), errors.tautulliUrlBase && touched.tautulliUrlBase && typeof errors.tautulliUrlBase === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                  className: "error",
                  children: errors.tautulliUrlBase
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("label", {
                htmlFor: "tautulliApiKey",
                className: "text-label",
                children: [intl.formatMessage(messages.tautulliApiKey), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                  className: "label-required",
                  children: "*"
                })]
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                    as: "field",
                    id: "tautulliApiKey",
                    name: "tautulliApiKey"
                  })
                }), errors.tautulliApiKey && touched.tautulliApiKey && typeof errors.tautulliApiKey === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                  className: "error",
                  children: errors.tautulliApiKey
                })]
              })]
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
              className: "form-row",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("label", {
                htmlFor: "tautulliExternalUrl",
                className: "text-label",
                children: intl.formatMessage(messages.externalUrl)
              }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)("div", {
                className: "form-input-area",
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                  className: "form-input-field",
                  children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(formik__WEBPACK_IMPORTED_MODULE_12__.Field, {
                    type: "text",
                    inputMode: "url",
                    id: "tautulliExternalUrl",
                    name: "tautulliExternalUrl",
                    autoComplete: "off",
                    "data-1pignore": "true",
                    "data-lpignore": "true",
                    "data-bwignore": "true"
                  })
                }), errors.tautulliExternalUrl && touched.tautulliExternalUrl && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                  className: "error",
                  children: errors.tautulliExternalUrl
                })]
              })]
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
              className: "actions",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("div", {
                className: "flex justify-end",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                  className: "ml-3 inline-flex rounded-md shadow-sm",
                  children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                    buttonType: "primary",
                    type: "submit",
                    disabled: isSubmitting || !isValid,
                    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_9__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_19__.jsx("span", {
                      children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_8__/* ["default"].save */ .Z.save)
                    })]
                  })
                })
              })
            })]
          });
        }
      })]
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SettingsPlex);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;