import {useId as $gfhJl$useId, isIPhone as $gfhJl$isIPhone, isAndroid as $gfhJl$isAndroid, filterDOMProps as $gfhJl$filterDOMProps, mergeProps as $gfhJl$mergeProps, isIOS as $gfhJl$isIOS} from "@react-aria/utils";
import {useState as $gfhJl$useState, useCallback as $gfhJl$useCallback, useMemo as $gfhJl$useMemo} from "react";
import {useFocus as $gfhJl$useFocus, useFocusWithin as $gfhJl$useFocusWithin, useScrollWheel as $gfhJl$useScrollWheel} from "@react-aria/interactions";
import {useFormattedTextField as $gfhJl$useFormattedTextField} from "@react-aria/textfield";
import {useLocalizedStringFormatter as $gfhJl$useLocalizedStringFormatter, useNumberFormatter as $gfhJl$useNumberFormatter} from "@react-aria/i18n";
import {useSpinButton as $gfhJl$useSpinButton} from "@react-aria/spinbutton";

function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ /*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 

var $c3ef0f8b54adbb57$exports = {};
var $fb78e0f6ab6349ed$exports = {};
$fb78e0f6ab6349ed$exports = {
    "decrease": (args)=>`خفض ${args.fieldLabel}`,
    "increase": (args)=>`زيادة ${args.fieldLabel}`,
    "numberField": `حقل رقمي`
};


var $2776acdd9959a647$exports = {};
$2776acdd9959a647$exports = {
    "decrease": (args)=>`Намаляване ${args.fieldLabel}`,
    "increase": (args)=>`Усилване ${args.fieldLabel}`,
    "numberField": `Номер на полето`
};


var $741954410a365ad3$exports = {};
$741954410a365ad3$exports = {
    "decrease": (args)=>`Snížit ${args.fieldLabel}`,
    "increase": (args)=>`Zvýšit ${args.fieldLabel}`,
    "numberField": `Číselné pole`
};


var $8321ed0f8ab642f0$exports = {};
$8321ed0f8ab642f0$exports = {
    "decrease": (args)=>`Reducer ${args.fieldLabel}`,
    "increase": (args)=>`Øg ${args.fieldLabel}`,
    "numberField": `Talfelt`
};


var $92978e0c4ecafa32$exports = {};
$92978e0c4ecafa32$exports = {
    "decrease": (args)=>`${args.fieldLabel} verringern`,
    "increase": (args)=>`${args.fieldLabel} erhöhen`,
    "numberField": `Nummernfeld`
};


var $ac5ff71962864a84$exports = {};
$ac5ff71962864a84$exports = {
    "decrease": (args)=>`Μείωση ${args.fieldLabel}`,
    "increase": (args)=>`Αύξηση ${args.fieldLabel}`,
    "numberField": `Πεδίο αριθμού`
};


var $efe4685e2440d8be$exports = {};
$efe4685e2440d8be$exports = {
    "decrease": (args)=>`Decrease ${args.fieldLabel}`,
    "increase": (args)=>`Increase ${args.fieldLabel}`,
    "numberField": `Number field`
};


var $e50a9a48739b90e1$exports = {};
$e50a9a48739b90e1$exports = {
    "decrease": (args)=>`Reducir ${args.fieldLabel}`,
    "increase": (args)=>`Aumentar ${args.fieldLabel}`,
    "numberField": `Campo de número`
};


var $6e0d5294ecbb8ab6$exports = {};
$6e0d5294ecbb8ab6$exports = {
    "decrease": (args)=>`Vähenda ${args.fieldLabel}`,
    "increase": (args)=>`Suurenda ${args.fieldLabel}`,
    "numberField": `Numbri väli`
};


var $e7129d65f607f77f$exports = {};
$e7129d65f607f77f$exports = {
    "decrease": (args)=>`Vähennä ${args.fieldLabel}`,
    "increase": (args)=>`Lisää ${args.fieldLabel}`,
    "numberField": `Numerokenttä`
};


var $d72adf5b20573e34$exports = {};
$d72adf5b20573e34$exports = {
    "decrease": (args)=>`Diminuer ${args.fieldLabel}`,
    "increase": (args)=>`Augmenter ${args.fieldLabel}`,
    "numberField": `Champ de nombre`
};


var $a25c707e88b844a7$exports = {};
$a25c707e88b844a7$exports = {
    "decrease": (args)=>`הקטן ${args.fieldLabel}`,
    "increase": (args)=>`הגדל ${args.fieldLabel}`,
    "numberField": `שדה מספר`
};


var $69b41140b9a4ca54$exports = {};
$69b41140b9a4ca54$exports = {
    "decrease": (args)=>`Smanji ${args.fieldLabel}`,
    "increase": (args)=>`Povećaj ${args.fieldLabel}`,
    "numberField": `Polje broja`
};


var $81dab28f37f59d1a$exports = {};
$81dab28f37f59d1a$exports = {
    "decrease": (args)=>`${args.fieldLabel} csökkentése`,
    "increase": (args)=>`${args.fieldLabel} növelése`,
    "numberField": `Számmező`
};


var $866555b31f2d7711$exports = {};
$866555b31f2d7711$exports = {
    "decrease": (args)=>`Riduci ${args.fieldLabel}`,
    "increase": (args)=>`Aumenta ${args.fieldLabel}`,
    "numberField": `Campo numero`
};


var $dafcd55d52b9d371$exports = {};
$dafcd55d52b9d371$exports = {
    "decrease": (args)=>`${args.fieldLabel}を縮小`,
    "increase": (args)=>`${args.fieldLabel}を拡大`,
    "numberField": `数値フィールド`
};


var $f090c1f8c5da0145$exports = {};
$f090c1f8c5da0145$exports = {
    "decrease": (args)=>`${args.fieldLabel} 감소`,
    "increase": (args)=>`${args.fieldLabel} 증가`,
    "numberField": `번호 필드`
};


var $6f10f3a13360a75c$exports = {};
$6f10f3a13360a75c$exports = {
    "decrease": (args)=>`Sumažinti ${args.fieldLabel}`,
    "increase": (args)=>`Padidinti ${args.fieldLabel}`,
    "numberField": `Numerio laukas`
};


var $47432cefd4b7bd1b$exports = {};
$47432cefd4b7bd1b$exports = {
    "decrease": (args)=>`Samazināšana ${args.fieldLabel}`,
    "increase": (args)=>`Palielināšana ${args.fieldLabel}`,
    "numberField": `Skaitļu lauks`
};


var $dc578a950a2bf23d$exports = {};
$dc578a950a2bf23d$exports = {
    "decrease": (args)=>`Reduser ${args.fieldLabel}`,
    "increase": (args)=>`Øk ${args.fieldLabel}`,
    "numberField": `Tallfelt`
};


var $353f1bfca4dc395a$exports = {};
$353f1bfca4dc395a$exports = {
    "decrease": (args)=>`${args.fieldLabel} verlagen`,
    "increase": (args)=>`${args.fieldLabel} verhogen`,
    "numberField": `Getalveld`
};


var $241bc0bbd870e982$exports = {};
$241bc0bbd870e982$exports = {
    "decrease": (args)=>`Zmniejsz ${args.fieldLabel}`,
    "increase": (args)=>`Zwiększ ${args.fieldLabel}`,
    "numberField": `Pole numeru`
};


var $da3005c7bd72b0a8$exports = {};
$da3005c7bd72b0a8$exports = {
    "decrease": (args)=>`Diminuir ${args.fieldLabel}`,
    "increase": (args)=>`Aumentar ${args.fieldLabel}`,
    "numberField": `Campo de número`
};


var $cf48bfc540882310$exports = {};
$cf48bfc540882310$exports = {
    "decrease": (args)=>`Diminuir ${args.fieldLabel}`,
    "increase": (args)=>`Aumentar ${args.fieldLabel}`,
    "numberField": `Campo numérico`
};


var $b63a28c481ab9ee3$exports = {};
$b63a28c481ab9ee3$exports = {
    "decrease": (args)=>`Scădere ${args.fieldLabel}`,
    "increase": (args)=>`Creștere ${args.fieldLabel}`,
    "numberField": `Câmp numeric`
};


var $19f9df95c2464ab6$exports = {};
$19f9df95c2464ab6$exports = {
    "decrease": (args)=>`Уменьшение ${args.fieldLabel}`,
    "increase": (args)=>`Увеличение ${args.fieldLabel}`,
    "numberField": `Числовое поле`
};


var $b272932a685e8482$exports = {};
$b272932a685e8482$exports = {
    "decrease": (args)=>`Znížiť ${args.fieldLabel}`,
    "increase": (args)=>`Zvýšiť ${args.fieldLabel}`,
    "numberField": `Číselné pole`
};


var $cbaf8b5b61f9e544$exports = {};
$cbaf8b5b61f9e544$exports = {
    "decrease": (args)=>`Upadati ${args.fieldLabel}`,
    "increase": (args)=>`Povečajte ${args.fieldLabel}`,
    "numberField": `Številčno polje`
};


var $e0a3af6ac1449b2f$exports = {};
$e0a3af6ac1449b2f$exports = {
    "decrease": (args)=>`Decrease ${args.fieldLabel}`,
    "increase": (args)=>`Increase ${args.fieldLabel}`,
    "numberField": `Number field`
};


var $71e167d2458a6019$exports = {};
$71e167d2458a6019$exports = {
    "decrease": (args)=>`Minska ${args.fieldLabel}`,
    "increase": (args)=>`Öka ${args.fieldLabel}`,
    "numberField": `Nummerfält`
};


var $3719245abc082946$exports = {};
$3719245abc082946$exports = {
    "decrease": (args)=>`${args.fieldLabel} azalt`,
    "increase": (args)=>`${args.fieldLabel} arttır`,
    "numberField": `Sayı alanı`
};


var $2ccc589e2f51824d$exports = {};
$2ccc589e2f51824d$exports = {
    "decrease": (args)=>`Зменшити ${args.fieldLabel}`,
    "increase": (args)=>`Збільшити ${args.fieldLabel}`,
    "numberField": `Поле номера`
};


var $e1103cb9b4c13942$exports = {};
$e1103cb9b4c13942$exports = {
    "decrease": (args)=>`降低 ${args.fieldLabel}`,
    "increase": (args)=>`提高 ${args.fieldLabel}`,
    "numberField": `数字字段`
};


var $448607634f80dccb$exports = {};
$448607634f80dccb$exports = {
    "decrease": (args)=>`縮小 ${args.fieldLabel}`,
    "increase": (args)=>`放大 ${args.fieldLabel}`,
    "numberField": `數字欄位`
};


$c3ef0f8b54adbb57$exports = {
    "ar-AE": $fb78e0f6ab6349ed$exports,
    "bg-BG": $2776acdd9959a647$exports,
    "cs-CZ": $741954410a365ad3$exports,
    "da-DK": $8321ed0f8ab642f0$exports,
    "de-DE": $92978e0c4ecafa32$exports,
    "el-GR": $ac5ff71962864a84$exports,
    "en-US": $efe4685e2440d8be$exports,
    "es-ES": $e50a9a48739b90e1$exports,
    "et-EE": $6e0d5294ecbb8ab6$exports,
    "fi-FI": $e7129d65f607f77f$exports,
    "fr-FR": $d72adf5b20573e34$exports,
    "he-IL": $a25c707e88b844a7$exports,
    "hr-HR": $69b41140b9a4ca54$exports,
    "hu-HU": $81dab28f37f59d1a$exports,
    "it-IT": $866555b31f2d7711$exports,
    "ja-JP": $dafcd55d52b9d371$exports,
    "ko-KR": $f090c1f8c5da0145$exports,
    "lt-LT": $6f10f3a13360a75c$exports,
    "lv-LV": $47432cefd4b7bd1b$exports,
    "nb-NO": $dc578a950a2bf23d$exports,
    "nl-NL": $353f1bfca4dc395a$exports,
    "pl-PL": $241bc0bbd870e982$exports,
    "pt-BR": $da3005c7bd72b0a8$exports,
    "pt-PT": $cf48bfc540882310$exports,
    "ro-RO": $b63a28c481ab9ee3$exports,
    "ru-RU": $19f9df95c2464ab6$exports,
    "sk-SK": $b272932a685e8482$exports,
    "sl-SI": $cbaf8b5b61f9e544$exports,
    "sr-SP": $e0a3af6ac1449b2f$exports,
    "sv-SE": $71e167d2458a6019$exports,
    "tr-TR": $3719245abc082946$exports,
    "uk-UA": $2ccc589e2f51824d$exports,
    "zh-CN": $e1103cb9b4c13942$exports,
    "zh-TW": $448607634f80dccb$exports
};







function $81397a9303501bda$export$23f548e970bdf099(props, state, inputRef) {
    let { id: id , decrementAriaLabel: decrementAriaLabel , incrementAriaLabel: incrementAriaLabel , isDisabled: isDisabled , isReadOnly: isReadOnly , isRequired: isRequired , minValue: minValue , maxValue: maxValue , autoFocus: autoFocus , validationState: validationState , label: label , formatOptions: formatOptions , onBlur: onBlur = ()=>{} , onFocus: onFocus , onFocusChange: onFocusChange , onKeyDown: onKeyDown , onKeyUp: onKeyUp , description: description , errorMessage: errorMessage , ...otherProps } = props;
    let { increment: increment , incrementToMax: incrementToMax , decrement: decrement , decrementToMin: decrementToMin , numberValue: numberValue , commit: commit  } = state;
    const stringFormatter = (0, $gfhJl$useLocalizedStringFormatter)((0, (/*@__PURE__*/$parcel$interopDefault($c3ef0f8b54adbb57$exports))));
    let inputId = (0, $gfhJl$useId)(id);
    let { focusProps: focusProps  } = (0, $gfhJl$useFocus)({
        onBlur: ()=>{
            // Set input value to normalized valid value
            commit();
        }
    });
    let { spinButtonProps: spinButtonProps , incrementButtonProps: incButtonProps , decrementButtonProps: decButtonProps  } = (0, $gfhJl$useSpinButton)({
        isDisabled: isDisabled,
        isReadOnly: isReadOnly,
        isRequired: isRequired,
        maxValue: maxValue,
        minValue: minValue,
        onIncrement: increment,
        onIncrementToMax: incrementToMax,
        onDecrement: decrement,
        onDecrementToMin: decrementToMin,
        value: numberValue,
        textValue: state.inputValue
    });
    let [focusWithin, setFocusWithin] = (0, $gfhJl$useState)(false);
    let { focusWithinProps: focusWithinProps  } = (0, $gfhJl$useFocusWithin)({
        isDisabled: isDisabled,
        onFocusWithinChange: setFocusWithin
    });
    let onWheel = (0, $gfhJl$useCallback)((e)=>{
        // if on a trackpad, users can scroll in both X and Y at once, check the magnitude of the change
        // if it's mostly in the X direction, then just return, the user probably doesn't mean to inc/dec
        // this isn't perfect, events come in fast with small deltas and a part of the scroll may give a false indication
        // especially if the user is scrolling near 45deg
        if (Math.abs(e.deltaY) <= Math.abs(e.deltaX)) return;
        if (e.deltaY > 0) increment();
        else if (e.deltaY < 0) decrement();
    }, [
        decrement,
        increment
    ]);
    // If the input isn't supposed to receive input, disable scrolling.
    let scrollingDisabled = isDisabled || isReadOnly || !focusWithin;
    (0, $gfhJl$useScrollWheel)({
        onScroll: onWheel,
        isDisabled: scrollingDisabled
    }, inputRef);
    // The inputMode attribute influences the software keyboard that is shown on touch devices.
    // Browsers and operating systems are quite inconsistent about what keys are available, however.
    // We choose between numeric and decimal based on whether we allow negative and fractional numbers,
    // and based on testing on various devices to determine what keys are available in each inputMode.
    let numberFormatter = (0, $gfhJl$useNumberFormatter)(formatOptions);
    let intlOptions = (0, $gfhJl$useMemo)(()=>numberFormatter.resolvedOptions(), [
        numberFormatter
    ]);
    let hasDecimals = intlOptions.maximumFractionDigits > 0;
    let hasNegative = isNaN(state.minValue) || state.minValue < 0;
    let inputMode = "numeric";
    if ((0, $gfhJl$isIPhone)()) {
        // iPhone doesn't have a minus sign in either numeric or decimal.
        // Note this is only for iPhone, not iPad, which always has both
        // minus and decimal in numeric.
        if (hasNegative) inputMode = "text";
        else if (hasDecimals) inputMode = "decimal";
    } else if ((0, $gfhJl$isAndroid)()) {
        // Android numeric has both a decimal point and minus key.
        // decimal does not have a minus key.
        if (hasNegative) inputMode = "numeric";
        else if (hasDecimals) inputMode = "decimal";
    }
    let onChange = (value)=>{
        state.setInputValue(value);
    };
    let domProps = (0, $gfhJl$filterDOMProps)(props);
    let { labelProps: labelProps , inputProps: textFieldProps , descriptionProps: descriptionProps , errorMessageProps: errorMessageProps  } = (0, $gfhJl$useFormattedTextField)({
        ...otherProps,
        ...domProps,
        label: label,
        autoFocus: autoFocus,
        isDisabled: isDisabled,
        isReadOnly: isReadOnly,
        isRequired: isRequired,
        validationState: validationState,
        value: state.inputValue,
        defaultValue: undefined,
        autoComplete: "off",
        "aria-label": props["aria-label"] || null,
        "aria-labelledby": props["aria-labelledby"] || null,
        id: inputId,
        type: "text",
        inputMode: inputMode,
        onChange: onChange,
        onBlur: onBlur,
        onFocus: onFocus,
        onFocusChange: onFocusChange,
        onKeyDown: onKeyDown,
        onKeyUp: onKeyUp,
        description: description,
        errorMessage: errorMessage
    }, state, inputRef);
    let inputProps = (0, $gfhJl$mergeProps)(spinButtonProps, focusProps, textFieldProps, {
        // override the spinbutton role, we can't focus a spin button with VO
        role: null,
        // ignore aria-roledescription on iOS so that required state will announce when it is present
        "aria-roledescription": !(0, $gfhJl$isIOS)() ? stringFormatter.format("numberField") : null,
        "aria-valuemax": null,
        "aria-valuemin": null,
        "aria-valuenow": null,
        "aria-valuetext": null,
        autoCorrect: "off",
        spellCheck: "false"
    });
    let onButtonPressStart = (e)=>{
        // If focus is already on the input, keep it there so we don't hide the
        // software keyboard when tapping the increment/decrement buttons.
        if (document.activeElement === inputRef.current) return;
        // Otherwise, when using a mouse, move focus to the input.
        // On touch, or with a screen reader, focus the button so that the software
        // keyboard does not appear and the screen reader cursor is not moved off the button.
        if (e.pointerType === "mouse") inputRef.current.focus();
        else e.target.focus();
    };
    // Determine the label for the increment and decrement buttons. There are 4 cases:
    //
    // 1. With a visible label that is a string: aria-label: `Increase ${props.label}`
    // 2. With a visible label that is JSX: aria-label: 'Increase', aria-labelledby: '${incrementId} ${labelId}'
    // 3. With an aria-label: aria-label: `Increase ${props['aria-label']}`
    // 4. With an aria-labelledby: aria-label: 'Increase', aria-labelledby: `${incrementId} ${props['aria-labelledby']}`
    //
    // (1) and (2) could possibly be combined and both use aria-labelledby. However, placing the label in
    // the aria-label string rather than using aria-labelledby gives more flexibility to translators to change
    // the order or add additional words around the label if needed.
    let fieldLabel = props["aria-label"] || (typeof props.label === "string" ? props.label : "");
    let ariaLabelledby;
    if (!fieldLabel) ariaLabelledby = props.label != null ? labelProps.id : props["aria-labelledby"];
    let incrementId = (0, $gfhJl$useId)();
    let decrementId = (0, $gfhJl$useId)();
    let incrementButtonProps = (0, $gfhJl$mergeProps)(incButtonProps, {
        "aria-label": incrementAriaLabel || stringFormatter.format("increase", {
            fieldLabel: fieldLabel
        }).trim(),
        id: ariaLabelledby && !incrementAriaLabel ? incrementId : null,
        "aria-labelledby": ariaLabelledby && !incrementAriaLabel ? `${incrementId} ${ariaLabelledby}` : null,
        "aria-controls": inputId,
        excludeFromTabOrder: true,
        preventFocusOnPress: true,
        allowFocusWhenDisabled: true,
        isDisabled: !state.canIncrement,
        onPressStart: onButtonPressStart
    });
    let decrementButtonProps = (0, $gfhJl$mergeProps)(decButtonProps, {
        "aria-label": decrementAriaLabel || stringFormatter.format("decrease", {
            fieldLabel: fieldLabel
        }).trim(),
        id: ariaLabelledby && !decrementAriaLabel ? decrementId : null,
        "aria-labelledby": ariaLabelledby && !decrementAriaLabel ? `${decrementId} ${ariaLabelledby}` : null,
        "aria-controls": inputId,
        excludeFromTabOrder: true,
        preventFocusOnPress: true,
        allowFocusWhenDisabled: true,
        isDisabled: !state.canDecrement,
        onPressStart: onButtonPressStart
    });
    return {
        groupProps: {
            role: "group",
            "aria-disabled": isDisabled,
            "aria-invalid": validationState === "invalid" ? "true" : undefined,
            ...focusWithinProps
        },
        labelProps: labelProps,
        inputProps: inputProps,
        incrementButtonProps: incrementButtonProps,
        decrementButtonProps: decrementButtonProps,
        errorMessageProps: errorMessageProps,
        descriptionProps: descriptionProps
    };
}




export {$81397a9303501bda$export$23f548e970bdf099 as useNumberField};
//# sourceMappingURL=module.js.map
