import { AriaMenuProps, MenuTriggerType } from "@react-types/menu";
import { DOMAttributes, KeyboardDelegate, FocusableElement } from "@react-types/shared";
import { RefObject, Key, ReactNode } from "react";
import { TreeState } from "@react-stately/tree";
import { AriaButtonProps } from "@react-types/button";
import { MenuTriggerState } from "@react-stately/menu";
export interface MenuAria {
    /** Props for the menu element. */
    menuProps: DOMAttributes;
}
export interface AriaMenuOptions<T> extends Omit<AriaMenuProps<T>, 'children'> {
    /** Whether the menu uses virtual scrolling. */
    isVirtualized?: boolean;
    /**
     * An optional keyboard delegate implementation for type to select,
     * to override the default.
     */
    keyboardDelegate?: KeyboardDelegate;
}
/**
 * Provides the behavior and accessibility implementation for a menu component.
 * A menu displays a list of actions or options that a user can choose.
 * @param props - Props for the menu.
 * @param state - State for the menu, as returned by `useListState`.
 */
export function useMenu<T>(props: AriaMenuOptions<T>, state: TreeState<T>, ref: RefObject<HTMLElement>): MenuAria;
export interface AriaMenuTriggerProps {
    /** The type of menu that the menu trigger opens. */
    type?: 'menu' | 'listbox';
    /** Whether menu trigger is disabled. */
    isDisabled?: boolean;
    /** How menu is triggered. */
    trigger?: MenuTriggerType;
}
export interface MenuTriggerAria<T> {
    /** Props for the menu trigger element. */
    menuTriggerProps: AriaButtonProps;
    /** Props for the menu. */
    menuProps: AriaMenuOptions<T>;
}
/**
 * Provides the behavior and accessibility implementation for a menu trigger.
 * @param props - Props for the menu trigger.
 * @param state - State for the menu trigger.
 */
export function useMenuTrigger<T>(props: AriaMenuTriggerProps, state: MenuTriggerState, ref: RefObject<Element>): MenuTriggerAria<T>;
export interface MenuItemAria {
    /** Props for the menu item element. */
    menuItemProps: DOMAttributes;
    /** Props for the main text element inside the menu item. */
    labelProps: DOMAttributes;
    /** Props for the description text element inside the menu item, if any. */
    descriptionProps: DOMAttributes;
    /** Props for the keyboard shortcut text element inside the item, if any. */
    keyboardShortcutProps: DOMAttributes;
    /** Whether the item is currently focused. */
    isFocused: boolean;
    /** Whether the item is currently selected. */
    isSelected: boolean;
    /** Whether the item is currently in a pressed state. */
    isPressed: boolean;
    /** Whether the item is disabled. */
    isDisabled: boolean;
}
export interface AriaMenuItemProps {
    /**
     * Whether the menu item is disabled.
     * @deprecated - pass disabledKeys to useTreeState instead.
     */
    isDisabled?: boolean;
    /**
     * Whether the menu item is selected.
     * @deprecated - pass selectedKeys to useTreeState instead.
     */
    isSelected?: boolean;
    /** A screen reader only label for the menu item. */
    'aria-label'?: string;
    /** The unique key for the menu item. */
    key?: Key;
    /**
     * Handler that is called when the menu should close after selecting an item.
     * @deprecated - pass to the menu instead.
     */
    onClose?: () => void;
    /**
     * Whether the menu should close when the menu item is selected.
     * @default true
     */
    closeOnSelect?: boolean;
    /** Whether the menu item is contained in a virtual scrolling menu. */
    isVirtualized?: boolean;
    /**
     * Handler that is called when the user activates the item.
     * @deprecated - pass to the menu instead.
     */
    onAction?: (key: Key) => void;
}
/**
 * Provides the behavior and accessibility implementation for an item in a menu.
 * See `useMenu` for more details about menus.
 * @param props - Props for the item.
 * @param state - State for the menu, as returned by `useTreeState`.
 */
export function useMenuItem<T>(props: AriaMenuItemProps, state: TreeState<T>, ref: RefObject<FocusableElement>): MenuItemAria;
export interface AriaMenuSectionProps {
    /** The heading for the section. */
    heading?: ReactNode;
    /** An accessibility label for the section. Required if `heading` is not present. */
    'aria-label'?: string;
}
export interface MenuSectionAria {
    /** Props for the wrapper list item. */
    itemProps: DOMAttributes;
    /** Props for the heading element, if any. */
    headingProps: DOMAttributes;
    /** Props for the group element. */
    groupProps: DOMAttributes;
}
/**
 * Provides the behavior and accessibility implementation for a section in a menu.
 * See `useMenu` for more details about menus.
 * @param props - Props for the section.
 */
export function useMenuSection(props: AriaMenuSectionProps): MenuSectionAria;
export type { AriaMenuProps } from '@react-types/menu';

//# sourceMappingURL=types.d.ts.map
