"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const imageproxy_1 = __importDefault(require("../lib/imageproxy"));
const logger_1 = __importDefault(require("../logger"));
const express_1 = require("express");
const router = (0, express_1.Router)();
const tmdbImageProxy = new imageproxy_1.default('tmdb', 'https://image.tmdb.org', {
    rateLimitOptions: {
        maxRequests: 20,
        maxRPS: 50,
    },
});
/**
 * Image Proxy
 */
router.get('/*', async (req, res) => {
    const imagePath = req.path.replace('/image', '');
    try {
        const imageData = await tmdbImageProxy.getImage(imagePath);
        res.writeHead(200, {
            'Content-Type': `image/${imageData.meta.extension}`,
            'Content-Length': imageData.imageBuffer.length,
            'Cache-Control': `public, max-age=${imageData.meta.curRevalidate}`,
            'OS-Cache-Key': imageData.meta.cacheKey,
            'OS-Cache-Status': imageData.meta.cacheMiss ? 'MISS' : 'HIT',
        });
        res.end(imageData.imageBuffer);
    }
    catch (e) {
        logger_1.default.error('Failed to proxy image', {
            imagePath,
            errorMessage: e.message,
        });
        res.status(500).send();
    }
});
exports.default = router;
