"use strict";
(() => {
var exports = {};
exports.id = 88761;
exports.ids = [88761,64820];
exports.modules = {

/***/ 70162:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61439);
/* harmony import */ var _app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(95909);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(15941);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__, axios__WEBPACK_IMPORTED_MODULE_5__, swr__WEBPACK_IMPORTED_MODULE_10__]);
([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__, axios__WEBPACK_IMPORTED_MODULE_5__, swr__WEBPACK_IMPORTED_MODULE_10__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);














const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_8__.defineMessages)({
  agentenabled: {
    "id": "components.Settings.Notifications.NotificationsPushover.agentenabled",
    "defaultMessage": 'Enable Agent'
  },
  accessToken: {
    "id": "components.Settings.Notifications.NotificationsPushover.accessToken",
    "defaultMessage": 'Application API Token'
  },
  accessTokenTip: {
    "id": "components.Settings.Notifications.NotificationsPushover.accessTokenTip",
    "defaultMessage": '<ApplicationRegistrationLink>Register an application</ApplicationRegistrationLink> for use with Overseerr'
  },
  userToken: {
    "id": "components.Settings.Notifications.NotificationsPushover.userToken",
    "defaultMessage": 'User or Group Key'
  },
  userTokenTip: {
    "id": "components.Settings.Notifications.NotificationsPushover.userTokenTip",
    "defaultMessage": 'Your 30-character <UsersGroupsLink>user or group identifier</UsersGroupsLink>'
  },
  sound: {
    "id": "components.Settings.Notifications.NotificationsPushover.sound",
    "defaultMessage": 'Notification Sound'
  },
  deviceDefault: {
    "id": "components.Settings.Notifications.NotificationsPushover.deviceDefault",
    "defaultMessage": 'Device Default'
  },
  validationAccessTokenRequired: {
    "id": "components.Settings.Notifications.NotificationsPushover.validationAccessTokenRequired",
    "defaultMessage": 'You must provide a valid application token'
  },
  validationUserTokenRequired: {
    "id": "components.Settings.Notifications.NotificationsPushover.validationUserTokenRequired",
    "defaultMessage": 'You must provide a valid user or group key'
  },
  pushoversettingssaved: {
    "id": "components.Settings.Notifications.NotificationsPushover.pushoversettingssaved",
    "defaultMessage": 'Pushover notification settings saved successfully!'
  },
  pushoversettingsfailed: {
    "id": "components.Settings.Notifications.NotificationsPushover.pushoversettingsfailed",
    "defaultMessage": 'Pushover notification settings failed to save.'
  },
  toastPushoverTestSending: {
    "id": "components.Settings.Notifications.NotificationsPushover.toastPushoverTestSending",
    "defaultMessage": 'Sending Pushover test notification…'
  },
  toastPushoverTestSuccess: {
    "id": "components.Settings.Notifications.NotificationsPushover.toastPushoverTestSuccess",
    "defaultMessage": 'Pushover test notification sent!'
  },
  toastPushoverTestFailed: {
    "id": "components.Settings.Notifications.NotificationsPushover.toastPushoverTestFailed",
    "defaultMessage": 'Pushover test notification failed to send.'
  },
  validationTypes: {
    "id": "components.Settings.Notifications.NotificationsPushover.validationTypes",
    "defaultMessage": 'You must select at least one notification type'
  }
});

const NotificationsPushover = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_8__.useIntl)();
  const {
    addToast,
    removeToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_9__.useToasts)();
  const {
    0: isTesting,
    1: setIsTesting
  } = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(false);
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_10__["default"])('/api/v1/settings/notifications/pushover');
  const {
    data: soundsData
  } = (0,swr__WEBPACK_IMPORTED_MODULE_10__["default"])(data?.options.accessToken ? `/api/v1/settings/notifications/pushover/sounds?token=${data.options.accessToken}` : null);
  const NotificationsPushoverSchema = yup__WEBPACK_IMPORTED_MODULE_11__.object().shape({
    accessToken: yup__WEBPACK_IMPORTED_MODULE_11__.string().when('enabled', {
      is: true,
      then: yup__WEBPACK_IMPORTED_MODULE_11__.string().nullable().required(intl.formatMessage(messages.validationAccessTokenRequired)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_11__.string().nullable()
    }).matches(/^[a-z\d]{30}$/i, intl.formatMessage(messages.validationAccessTokenRequired)),
    userToken: yup__WEBPACK_IMPORTED_MODULE_11__.string().when('enabled', {
      is: true,
      then: yup__WEBPACK_IMPORTED_MODULE_11__.string().nullable().required(intl.formatMessage(messages.validationUserTokenRequired)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_11__.string().nullable()
    }).matches(/^[a-z\d]{30}$/i, intl.formatMessage(messages.validationUserTokenRequired))
  });

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {});
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(formik__WEBPACK_IMPORTED_MODULE_6__.Formik, {
    initialValues: {
      enabled: data?.enabled,
      types: data?.types,
      accessToken: data?.options.accessToken,
      userToken: data?.options.userToken,
      sound: data?.options.sound
    },
    validationSchema: NotificationsPushoverSchema,
    onSubmit: async values => {
      try {
        await axios__WEBPACK_IMPORTED_MODULE_5__["default"].post('/api/v1/settings/notifications/pushover', {
          enabled: values.enabled,
          types: values.types,
          options: {
            accessToken: values.accessToken,
            userToken: values.userToken
          }
        });
        addToast(intl.formatMessage(messages.pushoversettingssaved), {
          appearance: 'success',
          autoDismiss: true
        });
      } catch (e) {
        addToast(intl.formatMessage(messages.pushoversettingsfailed), {
          appearance: 'error',
          autoDismiss: true
        });
      } finally {
        revalidate();
      }
    },
    children: ({
      errors,
      touched,
      isSubmitting,
      values,
      isValid,
      setFieldValue,
      setFieldTouched
    }) => {
      const testSettings = async () => {
        setIsTesting(true);
        let toastId;

        try {
          addToast(intl.formatMessage(messages.toastPushoverTestSending), {
            autoDismiss: false,
            appearance: 'info'
          }, id => {
            toastId = id;
          });
          await axios__WEBPACK_IMPORTED_MODULE_5__["default"].post('/api/v1/settings/notifications/pushover/test', {
            enabled: true,
            types: values.types,
            options: {
              accessToken: values.accessToken,
              userToken: values.userToken,
              sound: values.sound
            }
          });

          if (toastId) {
            removeToast(toastId);
          }

          addToast(intl.formatMessage(messages.toastPushoverTestSuccess), {
            autoDismiss: true,
            appearance: 'success'
          });
        } catch (e) {
          if (toastId) {
            removeToast(toastId);
          }

          addToast(intl.formatMessage(messages.toastPushoverTestFailed), {
            autoDismiss: true,
            appearance: 'error'
          });
        } finally {
          setIsTesting(false);
        }
      };

      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_6__.Form, {
        className: "section",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("label", {
            htmlFor: "enabled",
            className: "checkbox-label",
            children: [intl.formatMessage(messages.agentenabled), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
              className: "label-required",
              children: "*"
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
            className: "form-input-area",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(formik__WEBPACK_IMPORTED_MODULE_6__.Field, {
              type: "checkbox",
              id: "enabled",
              name: "enabled"
            })
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("label", {
            htmlFor: "accessToken",
            className: "text-label",
            children: [intl.formatMessage(messages.accessToken), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
              className: "label-required",
              children: "*"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
              className: "label-tip",
              children: intl.formatMessage(messages.accessTokenTip, {
                ApplicationRegistrationLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("a", {
                  href: "https://pushover.net/api#registration",
                  className: "text-white transition duration-300 hover:underline",
                  target: "_blank",
                  rel: "noreferrer",
                  children: msg
                })
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(formik__WEBPACK_IMPORTED_MODULE_6__.Field, {
                id: "accessToken",
                name: "accessToken",
                type: "text"
              })
            }), errors.accessToken && touched.accessToken && typeof errors.accessToken === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
              className: "error",
              children: errors.accessToken
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("label", {
            htmlFor: "userToken",
            className: "text-label",
            children: [intl.formatMessage(messages.userToken), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
              className: "label-required",
              children: "*"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
              className: "label-tip",
              children: intl.formatMessage(messages.userTokenTip, {
                UsersGroupsLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("a", {
                  href: "https://pushover.net/api#identifiers",
                  className: "text-white transition duration-300 hover:underline",
                  target: "_blank",
                  rel: "noreferrer",
                  children: msg
                })
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(formik__WEBPACK_IMPORTED_MODULE_6__.Field, {
                id: "userToken",
                name: "userToken",
                type: "text"
              })
            }), errors.userToken && touched.userToken && typeof errors.userToken === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
              className: "error",
              children: errors.userToken
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("label", {
            htmlFor: "sound",
            className: "text-label",
            children: intl.formatMessage(messages.sound)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
            className: "form-input-area",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_6__.Field, {
                as: "select",
                id: "sound",
                name: "sound",
                disabled: !soundsData?.length,
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("option", {
                  value: "",
                  children: intl.formatMessage(messages.deviceDefault)
                }), soundsData?.map((sound, index) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("option", {
                  value: sound.name,
                  children: sound.description
                }, `sound-${index}`))]
              })
            })
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP, {
          currentTypes: values.enabled ? values.types : 0,
          onUpdate: newTypes => {
            setFieldValue('types', newTypes);
            setFieldTouched('types');

            if (newTypes) {
              setFieldValue('enabled', true);
            }
          },
          error: values.enabled && !values.types && touched.types ? intl.formatMessage(messages.validationTypes) : undefined
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("div", {
          className: "actions",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)("div", {
            className: "flex justify-end",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
              className: "ml-3 inline-flex rounded-md shadow-sm",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                buttonType: "warning",
                disabled: isSubmitting || !isValid || isTesting,
                onClick: e => {
                  e.preventDefault();
                  testSettings();
                },
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_4__.BeakerIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
                  children: isTesting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__/* ["default"].testing */ .Z.testing) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__/* ["default"].test */ .Z.test)
                })]
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
              className: "ml-3 inline-flex rounded-md shadow-sm",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                buttonType: "primary",
                type: "submit",
                disabled: isSubmitting || !isValid || isTesting || values.enabled && !values.types,
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_4__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_12__.jsx("span", {
                  children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_3__/* ["default"].save */ .Z.save)
                })]
              })
            })]
          })
        })]
      });
    }
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationsPushover);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 42886:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Settings_Notifications_NotificationsPushover__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(70162);
/* harmony import */ var _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(91865);
/* harmony import */ var _app_components_Settings_SettingsNotifications__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(26433);
/* harmony import */ var _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(75691);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(86799);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Settings_Notifications_NotificationsPushover__WEBPACK_IMPORTED_MODULE_0__, _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__, _app_components_Settings_SettingsNotifications__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__]);
([_app_components_Settings_Notifications_NotificationsPushover__WEBPACK_IMPORTED_MODULE_0__, _app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__, _app_components_Settings_SettingsNotifications__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







const NotificationsPage = () => {
  (0,_app_hooks_useRouteGuard__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__/* .Permission.ADMIN */ .y3.ADMIN);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_app_components_Settings_SettingsLayout__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_app_components_Settings_SettingsNotifications__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_app_components_Settings_Notifications_NotificationsPushover__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {})
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NotificationsPage);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 12135:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/outline");

/***/ }),

/***/ 98802:
/***/ ((module) => {

module.exports = require("@heroicons/react/24/solid");

/***/ }),

/***/ 2296:
/***/ ((module) => {

module.exports = require("formik");

/***/ }),

/***/ 46517:
/***/ ((module) => {

module.exports = require("lodash");

/***/ }),

/***/ 3280:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/app-router-context.js");

/***/ }),

/***/ 92796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 34014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 78524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 78020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 64406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 24964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 11751:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/add-path-prefix.js");

/***/ }),

/***/ 46220:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/compare-states.js");

/***/ }),

/***/ 10299:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-next-pathname-info.js");

/***/ }),

/***/ 23938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 29565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 35789:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-next-pathname-info.js");

/***/ }),

/***/ 1897:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-bot.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 28854:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-path.js");

/***/ }),

/***/ 91292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 34567:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/path-has-prefix.js");

/***/ }),

/***/ 80979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 93297:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/remove-trailing-slash.js");

/***/ }),

/***/ 36052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 84226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 95052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 59232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 40968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 71853:
/***/ ((module) => {

module.exports = require("next/router");

/***/ }),

/***/ 16689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 13126:
/***/ ((module) => {

module.exports = require("react-intl");

/***/ }),

/***/ 95927:
/***/ ((module) => {

module.exports = require("react-toast-notifications");

/***/ }),

/***/ 20997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 75609:
/***/ ((module) => {

module.exports = require("yup");

/***/ }),

/***/ 99648:
/***/ ((module) => {

module.exports = import("axios");;

/***/ }),

/***/ 15941:
/***/ ((module) => {

module.exports = import("swr");;

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [80676,41664,1388,61439,19998,80210,86799,33173,17969,92012,35754,26433], () => (__webpack_exec__(42886)));
module.exports = __webpack_exports__;

})();