"use strict";
exports.id = 80693;
exports.ids = [80693];
exports.modules = {

/***/ 80693:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61903);
/* harmony import */ var _app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(95909);
/* harmony import */ var _app_components_Settings_Notifications_NotificationsEmail__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(61492);
/* harmony import */ var _app_components_Settings_SettingsBadge__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(75294);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(80210);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(15941);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__, _app_components_Settings_Notifications_NotificationsEmail__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__, axios__WEBPACK_IMPORTED_MODULE_9__, swr__WEBPACK_IMPORTED_MODULE_14__]);
([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__, _app_components_Settings_Notifications_NotificationsEmail__WEBPACK_IMPORTED_MODULE_4__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__, axios__WEBPACK_IMPORTED_MODULE_9__, swr__WEBPACK_IMPORTED_MODULE_14__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);


















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.defineMessages)({
  emailsettingssaved: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.emailsettingssaved",
    "defaultMessage": 'Email notification settings saved successfully!'
  },
  emailsettingsfailed: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.emailsettingsfailed",
    "defaultMessage": 'Email notification settings failed to save.'
  },
  pgpPublicKey: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.pgpPublicKey",
    "defaultMessage": 'PGP Public Key'
  },
  pgpPublicKeyTip: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.pgpPublicKeyTip",
    "defaultMessage": 'Encrypt email messages using <OpenPgpLink>OpenPGP</OpenPgpLink>'
  },
  validationPgpPublicKey: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.validationPgpPublicKey",
    "defaultMessage": 'You must provide a valid PGP public key'
  }
});

const UserEmailSettings = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.useIntl)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_13__.useToasts)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_11__.useRouter)();
  const {
    user
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_6__/* .useUser */ .aF)({
    id: Number(router.query.userId)
  });
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_14__["default"])(user ? `/api/v1/user/${user?.id}/settings/notifications` : null);
  const UserNotificationsEmailSchema = yup__WEBPACK_IMPORTED_MODULE_15__.object().shape({
    pgpKey: yup__WEBPACK_IMPORTED_MODULE_15__.string().nullable().matches(/-----BEGIN PGP PUBLIC KEY BLOCK-----.+-----END PGP PUBLIC KEY BLOCK-----/s, intl.formatMessage(messages.validationPgpPublicKey))
  });

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {});
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(formik__WEBPACK_IMPORTED_MODULE_10__.Formik, {
    initialValues: {
      pgpKey: data?.pgpKey,
      types: data?.notificationTypes.email ?? _app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__/* .ALL_NOTIFICATIONS */ .rK
    },
    validationSchema: UserNotificationsEmailSchema,
    enableReinitialize: true,
    onSubmit: async values => {
      try {
        await axios__WEBPACK_IMPORTED_MODULE_9__["default"].post(`/api/v1/user/${user?.id}/settings/notifications`, {
          pgpKey: values.pgpKey,
          discordId: data?.discordId,
          pushbulletAccessToken: data?.pushbulletAccessToken,
          pushoverApplicationToken: data?.pushoverApplicationToken,
          pushoverUserKey: data?.pushoverUserKey,
          telegramChatId: data?.telegramChatId,
          telegramSendSilently: data?.telegramSendSilently,
          notificationTypes: {
            email: values.types
          }
        });
        addToast(intl.formatMessage(messages.emailsettingssaved), {
          appearance: 'success',
          autoDismiss: true
        });
      } catch (e) {
        addToast(intl.formatMessage(messages.emailsettingsfailed), {
          appearance: 'error',
          autoDismiss: true
        });
      } finally {
        revalidate();
      }
    },
    children: ({
      errors,
      touched,
      isSubmitting,
      isValid,
      values,
      setFieldValue,
      setFieldTouched
    }) => {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_10__.Form, {
        className: "section",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("label", {
            htmlFor: "pgpKey",
            className: "text-label",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
              className: "mr-2",
              children: intl.formatMessage(messages.pgpPublicKey)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Settings_SettingsBadge__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
              badgeType: "advanced"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
              className: "label-tip",
              children: intl.formatMessage(messages.pgpPublicKeyTip, {
                OpenPgpLink: _app_components_Settings_Notifications_NotificationsEmail__WEBPACK_IMPORTED_MODULE_4__/* .OpenPgpLink */ .P
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                as: "field",
                type: "textarea",
                id: "pgpKey",
                name: "pgpKey",
                rows: "10",
                className: "font-mono text-xs"
              })
            }), errors.pgpKey && touched.pgpKey && typeof errors.pgpKey === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
              className: "error",
              children: errors.pgpKey
            })]
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .ZP, {
          user: user,
          currentTypes: values.types,
          onUpdate: newTypes => {
            setFieldValue('types', newTypes);
            setFieldTouched('types');
          },
          error: errors.types && touched.types ? errors.types : undefined
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
          className: "actions",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
            className: "flex justify-end",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
              className: "ml-3 inline-flex rounded-md shadow-sm",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                buttonType: "primary",
                type: "submit",
                disabled: isSubmitting || !isValid,
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
                  children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_7__/* ["default"].save */ .Z.save)
                })]
              })
            })
          })
        })]
      });
    }
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserEmailSettings);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;