"use strict";
exports.id = 79199;
exports.ids = [79199];
exports.modules = {

/***/ 79199:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(61439);
/* harmony import */ var _app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(95909);
/* harmony import */ var _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1388);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(80210);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(15941);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__, axios__WEBPACK_IMPORTED_MODULE_6__, swr__WEBPACK_IMPORTED_MODULE_11__]);
([_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__, _app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__, axios__WEBPACK_IMPORTED_MODULE_6__, swr__WEBPACK_IMPORTED_MODULE_11__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.defineMessages)({
  pushoversettingssaved: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.pushoversettingssaved",
    "defaultMessage": 'Pushover notification settings saved successfully!'
  },
  pushoversettingsfailed: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.pushoversettingsfailed",
    "defaultMessage": 'Pushover notification settings failed to save.'
  },
  pushoverApplicationToken: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.pushoverApplicationToken",
    "defaultMessage": 'Application API Token'
  },
  pushoverApplicationTokenTip: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.pushoverApplicationTokenTip",
    "defaultMessage": '<ApplicationRegistrationLink>Register an application</ApplicationRegistrationLink> for use with {applicationTitle}'
  },
  pushoverUserKey: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.pushoverUserKey",
    "defaultMessage": 'User or Group Key'
  },
  pushoverUserKeyTip: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.pushoverUserKeyTip",
    "defaultMessage": 'Your 30-character <UsersGroupsLink>user or group identifier</UsersGroupsLink>'
  },
  sound: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.sound",
    "defaultMessage": 'Notification Sound'
  },
  deviceDefault: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.deviceDefault",
    "defaultMessage": 'Device Default'
  },
  validationPushoverApplicationToken: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.validationPushoverApplicationToken",
    "defaultMessage": 'You must provide a valid application token'
  },
  validationPushoverUserKey: {
    "id": "components.UserProfile.UserSettings.UserNotificationSettings.validationPushoverUserKey",
    "defaultMessage": 'You must provide a valid user or group key'
  }
});

const UserPushoverSettings = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_9__.useIntl)();
  const settings = (0,_app_hooks_useSettings__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_10__.useToasts)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_8__.useRouter)();
  const {
    user
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__/* .useUser */ .aF)({
    id: Number(router.query.userId)
  });
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_11__["default"])(user ? `/api/v1/user/${user?.id}/settings/notifications` : null);
  const {
    data: soundsData
  } = (0,swr__WEBPACK_IMPORTED_MODULE_11__["default"])(data?.pushoverApplicationToken ? `/api/v1/settings/notifications/pushover/sounds?token=${data.pushoverApplicationToken}` : null);
  const UserNotificationsPushoverSchema = yup__WEBPACK_IMPORTED_MODULE_12__.object().shape({
    pushoverApplicationToken: yup__WEBPACK_IMPORTED_MODULE_12__.string().when('types', {
      is: types => !!types,
      then: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable().required(intl.formatMessage(messages.validationPushoverApplicationToken)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable()
    }).matches(/^[a-z\d]{30}$/i, intl.formatMessage(messages.validationPushoverApplicationToken)),
    pushoverUserKey: yup__WEBPACK_IMPORTED_MODULE_12__.string().when('types', {
      is: types => !!types,
      then: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable().required(intl.formatMessage(messages.validationPushoverUserKey)),
      otherwise: yup__WEBPACK_IMPORTED_MODULE_12__.string().nullable()
    }).matches(/^[a-z\d]{30}$/i, intl.formatMessage(messages.validationPushoverUserKey))
  });

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {});
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Formik, {
    initialValues: {
      pushoverApplicationToken: data?.pushoverApplicationToken,
      pushoverUserKey: data?.pushoverUserKey,
      types: data?.notificationTypes.pushover ?? 0
    },
    validationSchema: UserNotificationsPushoverSchema,
    enableReinitialize: true,
    onSubmit: async values => {
      try {
        await axios__WEBPACK_IMPORTED_MODULE_6__["default"].post(`/api/v1/user/${user?.id}/settings/notifications`, {
          pgpKey: data?.pgpKey,
          discordId: data?.discordId,
          pushbulletAccessToken: data?.pushbulletAccessToken,
          pushoverApplicationToken: values.pushoverApplicationToken,
          pushoverUserKey: values.pushoverUserKey,
          telegramChatId: data?.telegramChatId,
          telegramSendSilently: data?.telegramSendSilently,
          notificationTypes: {
            pushover: values.types
          }
        });
        addToast(intl.formatMessage(messages.pushoversettingssaved), {
          appearance: 'success',
          autoDismiss: true
        });
      } catch (e) {
        addToast(intl.formatMessage(messages.pushoversettingsfailed), {
          appearance: 'error',
          autoDismiss: true
        });
      } finally {
        revalidate();
      }
    },
    children: ({
      errors,
      touched,
      isSubmitting,
      isValid,
      values,
      setFieldValue,
      setFieldTouched
    }) => {
      return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_7__.Form, {
        className: "section",
        children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
            htmlFor: "pushoverApplicationToken",
            className: "text-label",
            children: [intl.formatMessage(messages.pushoverApplicationToken), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-required",
              children: "*"
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-tip",
              children: intl.formatMessage(messages.pushoverApplicationTokenTip, {
                ApplicationRegistrationLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("a", {
                  href: "https://pushover.net/api#registration",
                  className: "text-white transition duration-300 hover:underline",
                  target: "_blank",
                  rel: "noreferrer",
                  children: msg
                }),
                applicationTitle: settings.currentSettings.applicationTitle
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
                id: "pushoverApplicationToken",
                name: "pushoverApplicationToken",
                type: "text"
              })
            }), errors.pushoverApplicationToken && touched.pushoverApplicationToken && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "error",
              children: errors.pushoverApplicationToken
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("label", {
            htmlFor: "pushoverUserKey",
            className: "checkbox-label",
            children: [intl.formatMessage(messages.pushoverUserKey), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "label-tip",
              children: intl.formatMessage(messages.pushoverUserKeyTip, {
                UsersGroupsLink: msg => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("a", {
                  href: "https://pushover.net/api#identifiers",
                  className: "text-white transition duration-300 hover:underline",
                  target: "_blank",
                  rel: "noreferrer",
                  children: msg
                })
              })
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
            className: "form-input-area",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
                id: "pushoverUserKey",
                name: "pushoverUserKey",
                type: "text"
              })
            }), errors.pushoverUserKey && touched.pushoverUserKey && typeof errors.pushoverUserKey === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "error",
              children: errors.pushoverUserKey
            })]
          })]
        }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)("div", {
          className: "form-row",
          children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("label", {
            htmlFor: "sound",
            className: "text-label",
            children: intl.formatMessage(messages.sound)
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
            className: "form-input-area",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
              className: "form-input-field",
              children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_7__.Field, {
                as: "select",
                id: "sound",
                name: "sound",
                disabled: !soundsData?.length,
                children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
                  value: "",
                  children: intl.formatMessage(messages.deviceDefault)
                }), soundsData?.map((sound, index) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("option", {
                  value: sound.name,
                  children: sound.description
                }, `sound-${index}`))]
              })
            })
          })]
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_NotificationTypeSelector__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .ZP, {
          user: user,
          currentTypes: values.types,
          onUpdate: newTypes => {
            setFieldValue('types', newTypes);
            setFieldTouched('types');
          },
          error: errors.types && touched.types ? errors.types : undefined
        }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
          className: "actions",
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("div", {
            className: "flex justify-end",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx("span", {
              className: "ml-3 inline-flex rounded-md shadow-sm",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_13__.jsx(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                buttonType: "primary",
                type: "submit",
                disabled: isSubmitting || !isValid,
                children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_5__/* ["default"].save */ .Z.save)
              })
            })
          })
        })]
      });
    }
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserPushoverSettings);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;