"use strict";
exports.id = 68229;
exports.ids = [68229];
exports.modules = {

/***/ 68229:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(7292);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(41664);
/* harmony import */ var next_link__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_link__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__]);
_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







const PersonCard = ({
  personId,
  name,
  subName,
  profilePath,
  canExpand = false
}) => {
  const {
    0: isHovered,
    1: setHovered
  } = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx((next_link__WEBPACK_IMPORTED_MODULE_2___default()), {
    href: `/person/${personId}`,
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("a", {
      className: canExpand ? 'w-full' : 'w-36 sm:w-36 md:w-44',
      onMouseEnter: () => {
        setHovered(true);
      },
      onMouseLeave: () => setHovered(false),
      onKeyDown: e => {
        if (e.key === 'Enter') {
          setHovered(true);
        }
      },
      role: "link",
      tabIndex: 0,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
        className: `relative ${canExpand ? 'w-full' : 'w-36 sm:w-36 md:w-44'} transform-gpu cursor-pointer rounded-xl text-white shadow ring-1 transition duration-150 ease-in-out ${isHovered ? 'scale-105 bg-gray-700 ring-gray-500' : 'scale-100 bg-gray-800 ring-gray-700'}`,
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
          style: {
            paddingBottom: '150%'
          },
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsxs)("div", {
            className: "absolute inset-0 flex h-full w-full flex-col items-center p-2",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
              className: "relative mt-2 mb-4 flex h-1/2 w-full justify-center",
              children: profilePath ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
                className: "relative h-full w-3/4 overflow-hidden rounded-full ring-1 ring-gray-700",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_Common_CachedImage__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
                  src: `https://image.tmdb.org/t/p/w600_and_h900_bestv2${profilePath}`,
                  alt: "",
                  layout: "fill",
                  objectFit: "cover"
                })
              }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_1__.UserCircleIcon, {
                className: "h-full"
              })
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
              className: "w-full truncate text-center font-bold",
              children: name
            }), subName && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
              className: "overflow-hidden whitespace-normal text-center text-sm text-gray-300",
              style: {
                WebkitLineClamp: 2,
                display: '-webkit-box',
                overflow: 'hidden',
                WebkitBoxOrient: 'vertical'
              },
              children: subName
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
              className: `absolute bottom-0 left-0 right-0 h-12 rounded-b-xl bg-gradient-to-t ${isHovered ? 'from-gray-800' : 'from-gray-900'}`
            })]
          })
        })
      })
    })
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PersonCard);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;