"use strict";
exports.id = 64468;
exports.ids = [64468];
exports.modules = {

/***/ 64468:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "$V": () => (/* binding */ genreColorMap),
/* harmony export */   "GR": () => (/* binding */ countActiveFilters),
/* harmony export */   "Wm": () => (/* binding */ prepareFilterValues),
/* harmony export */   "o3": () => (/* binding */ sliderTitles)
/* harmony export */ });
/* unused harmony exports colorTones, QueryFilterOptions */
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var zod__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9926);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([zod__WEBPACK_IMPORTED_MODULE_1__]);
zod__WEBPACK_IMPORTED_MODULE_1__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];


const colorTones = {
  red: ['991B1B', 'FCA5A5'],
  darkred: ['1F2937', 'F87171'],
  blue: ['032541', '01b4e4'],
  lightblue: ['1F2937', '60A5FA'],
  darkblue: ['1F2937', '2864d2'],
  orange: ['92400E', 'FCD34D'],
  lightgreen: ['065F46', '6EE7B7'],
  green: ['087d29', '21cb51'],
  purple: ['5B21B6', 'C4B5FD'],
  yellow: ['777e0d', 'e4ed55'],
  darkorange: ['552c01', 'd47c1d'],
  black: ['1F2937', 'D1D5DB'],
  pink: ['9D174D', 'F9A8D4'],
  darkpurple: ['480c8b', 'a96bef']
};
const genreColorMap = {
  0: colorTones.black,
  28: colorTones.red,
  // Action
  12: colorTones.darkpurple,
  // Adventure
  16: colorTones.blue,
  // Animation
  35: colorTones.orange,
  // Comedy
  80: colorTones.darkblue,
  // Crime
  99: colorTones.lightgreen,
  // Documentary
  18: colorTones.pink,
  // Drama
  10751: colorTones.yellow,
  // Family
  14: colorTones.lightblue,
  // Fantasy
  36: colorTones.orange,
  // History
  27: colorTones.black,
  // Horror
  10402: colorTones.blue,
  // Music
  9648: colorTones.purple,
  // Mystery
  10749: colorTones.pink,
  // Romance
  878: colorTones.lightblue,
  // Science Fiction
  10770: colorTones.red,
  // TV Movie
  53: colorTones.black,
  // Thriller
  10752: colorTones.darkred,
  // War
  37: colorTones.orange,
  // Western
  10759: colorTones.darkpurple,
  // Action & Adventure
  10762: colorTones.blue,
  // Kids
  10763: colorTones.black,
  // News
  10764: colorTones.darkorange,
  // Reality
  10765: colorTones.lightblue,
  // Sci-Fi & Fantasy
  10766: colorTones.pink,
  // Soap
  10767: colorTones.lightgreen,
  // Talk
  10768: colorTones.darkred // War & Politics

};
const sliderTitles = (0,react_intl__WEBPACK_IMPORTED_MODULE_0__.defineMessages)({
  recentrequests: {
    "id": "components.Discover.recentrequests",
    "defaultMessage": 'Recent Requests'
  },
  popularmovies: {
    "id": "components.Discover.popularmovies",
    "defaultMessage": 'Popular Movies'
  },
  populartv: {
    "id": "components.Discover.populartv",
    "defaultMessage": 'Popular Series'
  },
  upcomingtv: {
    "id": "components.Discover.upcomingtv",
    "defaultMessage": 'Upcoming Series'
  },
  recentlyAdded: {
    "id": "components.Discover.recentlyAdded",
    "defaultMessage": 'Recently Added'
  },
  upcoming: {
    "id": "components.Discover.upcoming",
    "defaultMessage": 'Upcoming Movies'
  },
  trending: {
    "id": "components.Discover.trending",
    "defaultMessage": 'Trending'
  },
  plexwatchlist: {
    "id": "components.Discover.plexwatchlist",
    "defaultMessage": 'Your Plex Watchlist'
  },
  moviegenres: {
    "id": "components.Discover.moviegenres",
    "defaultMessage": 'Movie Genres'
  },
  tvgenres: {
    "id": "components.Discover.tvgenres",
    "defaultMessage": 'Series Genres'
  },
  studios: {
    "id": "components.Discover.studios",
    "defaultMessage": 'Studios'
  },
  networks: {
    "id": "components.Discover.networks",
    "defaultMessage": 'Networks'
  },
  tmdbmoviekeyword: {
    "id": "components.Discover.tmdbmoviekeyword",
    "defaultMessage": 'TMDB Movie Keyword'
  },
  tmdbtvkeyword: {
    "id": "components.Discover.tmdbtvkeyword",
    "defaultMessage": 'TMDB Series Keyword'
  },
  tmdbmoviegenre: {
    "id": "components.Discover.tmdbmoviegenre",
    "defaultMessage": 'TMDB Movie Genre'
  },
  tmdbtvgenre: {
    "id": "components.Discover.tmdbtvgenre",
    "defaultMessage": 'TMDB Series Genre'
  },
  tmdbnetwork: {
    "id": "components.Discover.tmdbnetwork",
    "defaultMessage": 'TMDB Network'
  },
  tmdbstudio: {
    "id": "components.Discover.tmdbstudio",
    "defaultMessage": 'TMDB Studio'
  },
  tmdbsearch: {
    "id": "components.Discover.tmdbsearch",
    "defaultMessage": 'TMDB Search'
  },
  tmdbmoviestreamingservices: {
    "id": "components.Discover.tmdbmoviestreamingservices",
    "defaultMessage": 'TMDB Movie Streaming Services'
  },
  tmdbtvstreamingservices: {
    "id": "components.Discover.tmdbtvstreamingservices",
    "defaultMessage": 'TMDB TV Streaming Services'
  }
});
const QueryFilterOptions = zod__WEBPACK_IMPORTED_MODULE_1__.z.object({
  sortBy: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  primaryReleaseDateGte: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  primaryReleaseDateLte: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  firstAirDateGte: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  firstAirDateLte: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  studio: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  genre: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  keywords: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  language: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  withRuntimeGte: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  withRuntimeLte: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  voteAverageGte: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  voteAverageLte: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  voteCountLte: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  voteCountGte: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  watchRegion: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional(),
  watchProviders: zod__WEBPACK_IMPORTED_MODULE_1__.z.string().optional()
});
const prepareFilterValues = inputValues => {
  const filterValues = {};
  const values = QueryFilterOptions.parse(inputValues);

  if (values.sortBy) {
    filterValues.sortBy = values.sortBy;
  }

  if (values.primaryReleaseDateGte) {
    filterValues.primaryReleaseDateGte = values.primaryReleaseDateGte;
  }

  if (values.primaryReleaseDateLte) {
    filterValues.primaryReleaseDateLte = values.primaryReleaseDateLte;
  }

  if (values.firstAirDateGte) {
    filterValues.firstAirDateGte = values.firstAirDateGte;
  }

  if (values.firstAirDateLte) {
    filterValues.firstAirDateLte = values.firstAirDateLte;
  }

  if (values.studio) {
    filterValues.studio = values.studio;
  }

  if (values.genre) {
    filterValues.genre = values.genre;
  }

  if (values.keywords) {
    filterValues.keywords = values.keywords;
  }

  if (values.language) {
    filterValues.language = values.language;
  }

  if (values.withRuntimeGte) {
    filterValues.withRuntimeGte = values.withRuntimeGte;
  }

  if (values.withRuntimeLte) {
    filterValues.withRuntimeLte = values.withRuntimeLte;
  }

  if (values.voteAverageGte) {
    filterValues.voteAverageGte = values.voteAverageGte;
  }

  if (values.voteAverageLte) {
    filterValues.voteAverageLte = values.voteAverageLte;
  }

  if (values.voteCountGte) {
    filterValues.voteCountGte = values.voteCountGte;
  }

  if (values.voteCountLte) {
    filterValues.voteCountLte = values.voteCountLte;
  }

  if (values.watchProviders) {
    filterValues.watchProviders = values.watchProviders;
  }

  if (values.watchRegion) {
    filterValues.watchRegion = values.watchRegion;
  }

  return filterValues;
};
const countActiveFilters = filterValues => {
  let totalCount = 0;
  const clonedFilters = Object.assign({}, filterValues);

  if (clonedFilters.voteAverageGte || filterValues.voteAverageLte) {
    totalCount += 1;
    delete clonedFilters.voteAverageGte;
    delete clonedFilters.voteAverageLte;
  }

  if (clonedFilters.voteCountGte || filterValues.voteCountLte) {
    totalCount += 1;
    delete clonedFilters.voteCountGte;
    delete clonedFilters.voteCountLte;
  }

  if (clonedFilters.withRuntimeGte || filterValues.withRuntimeLte) {
    totalCount += 1;
    delete clonedFilters.withRuntimeGte;
    delete clonedFilters.withRuntimeLte;
  }

  if (clonedFilters.watchProviders) {
    totalCount += 1;
    delete clonedFilters.watchProviders;
    delete clonedFilters.watchRegion;
  }

  totalCount += Object.keys(clonedFilters).length;
  return totalCount;
};
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;