"use strict";
exports.id = 4551;
exports.ids = [4551];
exports.modules = {

/***/ 4551:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(99819);
/* harmony import */ var _app_hooks_useClickOutside__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(12965);
/* harmony import */ var _app_hooks_useLocale__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(84541);
/* harmony import */ var _headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(61185);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(98802);
/* harmony import */ var _heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_headlessui_react__WEBPACK_IMPORTED_MODULE_3__]);
_headlessui_react__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];









const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_6__.defineMessages)({
  displaylanguage: {
    "id": "components.Layout.LanguagePicker.displaylanguage",
    "defaultMessage": 'Display Language'
  }
});

const LanguagePicker = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_6__.useIntl)();
  const dropdownRef = (0,react__WEBPACK_IMPORTED_MODULE_5__.useRef)(null);
  const {
    locale,
    setLocale
  } = (0,_app_hooks_useLocale__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z)();
  const {
    0: isDropdownOpen,
    1: setDropdownOpen
  } = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  (0,_app_hooks_useClickOutside__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z)(dropdownRef, () => setDropdownOpen(false));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
    className: "relative",
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("button", {
        className: `rounded-full p-1 hover:bg-gray-600 hover:text-white focus:bg-gray-600 focus:text-white focus:outline-none focus:ring-1 focus:ring-gray-500 sm:p-2 ${isDropdownOpen ? 'bg-gray-600 text-white' : 'text-gray-400'}`,
        "aria-label": "Language Picker",
        onClick: () => setDropdownOpen(true),
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_heroicons_react_24_solid__WEBPACK_IMPORTED_MODULE_4__.LanguageIcon, {
          className: "h-6 w-6"
        })
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx(_headlessui_react__WEBPACK_IMPORTED_MODULE_3__.Transition, {
      as: "div",
      show: isDropdownOpen,
      enter: "transition ease-out duration-100",
      enterFrom: "opacity-0 scale-95",
      enterTo: "opacity-100 scale-100",
      leave: "transition ease-in duration-75",
      leaveFrom: "opacity-100 scale-100",
      leaveTo: "opacity-0 scale-95",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
        className: "absolute right-0 mt-2 w-56 origin-top-right rounded-md shadow-lg",
        ref: dropdownRef,
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("div", {
          className: "rounded-md bg-gray-700 px-3 py-2 ring-1 ring-black ring-opacity-5",
          children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsxs)("div", {
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("label", {
              htmlFor: "language",
              className: "block pb-2 text-sm font-bold leading-5 text-gray-300",
              children: intl.formatMessage(messages.displaylanguage)
            }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("select", {
              id: "language",
              className: "rounded-md",
              onChange: e => setLocale && setLocale(e.target.value),
              onBlur: e => setLocale && setLocale(e.target.value),
              defaultValue: locale,
              children: Object.keys(_app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_0__/* .availableLanguages */ .m).map(key => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_7__.jsx("option", {
                value: _app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_0__/* .availableLanguages */ .m[key].code,
                children: _app_context_LanguageContext__WEBPACK_IMPORTED_MODULE_0__/* .availableLanguages */ .m[key].display
              }, key))
            })]
          })
        })
      })
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LanguagePicker);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;