"use strict";
exports.id = 33056;
exports.ids = [33056];
exports.modules = {

/***/ 33056:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(61276);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(86799);
/* harmony import */ var react_intersection_observer__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(44009);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(15941);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__, react_intersection_observer__WEBPACK_IMPORTED_MODULE_2__, swr__WEBPACK_IMPORTED_MODULE_3__]);
([_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__, react_intersection_observer__WEBPACK_IMPORTED_MODULE_2__, swr__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);






const isMovie = movie => {
  return movie.title !== undefined;
};

const TmdbTitleCard = ({
  id,
  tmdbId,
  tvdbId,
  type,
  canExpand
}) => {
  const {
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .useUser */ .aF)();
  const {
    ref,
    inView
  } = (0,react_intersection_observer__WEBPACK_IMPORTED_MODULE_2__.useInView)({
    triggerOnce: true
  });
  const url = type === 'movie' ? `/api/v1/movie/${tmdbId}` : `/api/v1/tv/${tmdbId}`;
  const {
    data: title,
    error
  } = (0,swr__WEBPACK_IMPORTED_MODULE_3__["default"])(inView ? `${url}` : null);

  if (!title && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
      ref: ref,
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__/* ["default"].Placeholder */ .Z.Placeholder, {
        canExpand: canExpand
      })
    });
  }

  if (!title) {
    return hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__/* .Permission.ADMIN */ .y3.ADMIN) ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__/* ["default"].ErrorCard */ .Z.ErrorCard, {
      id: id,
      tmdbId: tmdbId,
      tvdbId: tvdbId,
      type: type
    }) : null;
  }

  return isMovie(title) ? /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
    id: title.id,
    image: title.posterPath,
    status: title.mediaInfo?.status,
    summary: title.overview,
    title: title.title,
    userScore: title.voteAverage,
    year: title.releaseDate,
    mediaType: 'movie',
    canExpand: canExpand
  }) : /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_app_components_TitleCard__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
    id: title.id,
    image: title.posterPath,
    status: title.mediaInfo?.status,
    summary: title.overview,
    title: title.name,
    userScore: title.voteAverage,
    year: title.firstAirDate,
    mediaType: 'tv',
    canExpand: canExpand
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TmdbTitleCard);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;