"use strict";
exports.id = 27208;
exports.ids = [27208];
exports.modules = {

/***/ 27208:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BA": () => (/* binding */ useUpdateQueryParams),
/* harmony export */   "HE": () => (/* binding */ useBatchUpdateQueryParams)
/* harmony export */ });
/* unused harmony exports filterQueryString, mergeQueryString, useQueryParams */
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(16689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }




/**
 * Returns a filtered object containing only key/value pairs that don't exist in the current
 * router path.
 *
 * @param router Nextjs router instance
 * @param filters Object containing key value pairs for filter items that should be cleaned
 */
const filterQueryString = (router, filters) => {
  const cleanedFilters = {};
  Object.keys(filters).forEach(key => {
    if (!router.pathname.match(new RegExp(`${key}`))) {
      cleanedFilters[key] = filters[key];
    }
  });
  return cleanedFilters;
};
/**
 * Takes a query paramter object and returns a new pathname and path
 * with the new values appended.
 *
 * - If the value already exists, it is updated.
 * - If a key with the value of null is passed, it will be removed from
 *   the current query paramters
 *
 * ## Example usage:
 *
 * If the current URL is `/foo?bar=test` and you want to add a new query parameter, you
 * can do the following:
 *
 * ```
 * const newRoute = mergeQueryString(router, { newParam: 'value' });
 * ```
 * NewRoute will become
 *
 * ```
 * {
 *  pathName: '/foo?bar=test&newParam=value',
 *   path: '/foo?bar=test&newParam=value'
 * }
 * ```
 *
 * @param router Nextjs router instance
 * @param query Key/value pair object containing query paramters
 */

const mergeQueryString = (router, query) => {
  const cleanedQuery = filterQueryString(router, router.query);
  const mergedQuery = Object.assign({}, cleanedQuery, query);
  const queryArray = [];
  Object.keys(mergedQuery).map(key => {
    if (mergedQuery[key]) {
      queryArray.push(`${key}=${mergedQuery[key]}`);
    }
  });
  const pathWithoutQuery = router.asPath.match(/(.*)\?.*/);
  const asPath = pathWithoutQuery ? pathWithoutQuery[1] : router.asPath;
  const pathname = `${router.pathname}${queryArray.length > 0 ? `?${queryArray.join('&')}` : ''}`;
  const path = `${asPath}${queryArray.length > 0 ? `?${queryArray.join('&')}` : ''}`;
  return {
    pathname,
    path
  };
};
/**
 * useQueryParams hook is used just to provide a callback with a nextjs
 * router instance attached to it. The returned method can be called with
 * an object of key/value pairs to route the user with the new query paramters
 */

const useQueryParams = () => {
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_0__.useRouter)();
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((query, routerAction = 'push') => {
    const newRoute = mergeQueryString(router, query);

    if (newRoute.path !== router.asPath) {
      if (routerAction === 'replace') {
        router.replace(newRoute.pathname, newRoute.path);
      } else {
        router.push(newRoute.pathname, newRoute.path);
      }
    }
  }, [router]);
};
const useUpdateQueryParams = filter => {
  const updateQueryParams = useQueryParams();
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((key, value) => {
    const query = _objectSpread(_objectSpread({}, filter), {}, {
      [key]: value
    });

    updateQueryParams(query, 'replace');
  }, [filter, updateQueryParams]);
};
const useBatchUpdateQueryParams = filter => {
  const updateQueryParams = useQueryParams();
  return (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(items => {
    const query = _objectSpread(_objectSpread({}, filter), items);

    updateQueryParams(query, 'replace');
  }, [filter, updateQueryParams]);
};

/***/ })

};
;