"use strict";
exports.id = 10385;
exports.ids = [10385];
exports.modules = {

/***/ 10385:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(13555);
/* harmony import */ var _app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(19998);
/* harmony import */ var _app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(61439);
/* harmony import */ var _app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(74449);
/* harmony import */ var _app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(61903);
/* harmony import */ var _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(86799);
/* harmony import */ var _app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(80210);
/* harmony import */ var _app_pages_error__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(35635);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(12135);
/* harmony import */ var _heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(99648);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(2296);
/* harmony import */ var formik__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(formik__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(71853);
/* harmony import */ var next_router__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(next_router__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(13126);
/* harmony import */ var react_intl__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(react_intl__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(95927);
/* harmony import */ var react_toast_notifications__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react_toast_notifications__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var swr__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(15941);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(75609);
/* harmony import */ var yup__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(yup__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(20997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__, _app_pages_error__WEBPACK_IMPORTED_MODULE_7__, axios__WEBPACK_IMPORTED_MODULE_9__, swr__WEBPACK_IMPORTED_MODULE_14__]);
([_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__, _app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__, _app_pages_error__WEBPACK_IMPORTED_MODULE_7__, axios__WEBPACK_IMPORTED_MODULE_9__, swr__WEBPACK_IMPORTED_MODULE_14__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);



















const messages = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.defineMessages)({
  password: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.password",
    "defaultMessage": 'Password'
  },
  currentpassword: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.currentpassword",
    "defaultMessage": 'Current Password'
  },
  newpassword: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.newpassword",
    "defaultMessage": 'New Password'
  },
  confirmpassword: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.confirmpassword",
    "defaultMessage": 'Confirm Password'
  },
  toastSettingsSuccess: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.toastSettingsSuccess",
    "defaultMessage": 'Password saved successfully!'
  },
  toastSettingsFailure: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.toastSettingsFailure",
    "defaultMessage": 'Something went wrong while saving the password.'
  },
  toastSettingsFailureVerifyCurrent: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.toastSettingsFailureVerifyCurrent",
    "defaultMessage": 'Something went wrong while saving the password. Was your current password entered correctly?'
  },
  validationCurrentPassword: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.validationCurrentPassword",
    "defaultMessage": 'You must provide your current password'
  },
  validationNewPassword: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.validationNewPassword",
    "defaultMessage": 'You must provide a new password'
  },
  validationNewPasswordLength: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.validationNewPasswordLength",
    "defaultMessage": 'Password is too short; should be a minimum of 8 characters'
  },
  validationConfirmPassword: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.validationConfirmPassword",
    "defaultMessage": 'You must confirm the new password'
  },
  validationConfirmPasswordSame: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.validationConfirmPasswordSame",
    "defaultMessage": 'Passwords must match'
  },
  noPasswordSet: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.noPasswordSet",
    "defaultMessage": 'This user account currently does not have a password set. Configure a password below to enable this account to sign in as a "local user."'
  },
  noPasswordSetOwnAccount: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.noPasswordSetOwnAccount",
    "defaultMessage": 'Your account currently does not have a password set. Configure a password below to enable sign-in as a "local user" using your email address.'
  },
  nopermissionDescription: {
    "id": "components.UserProfile.UserSettings.UserPasswordChange.nopermissionDescription",
    "defaultMessage": "You do not have permission to modify this user's password."
  }
});

const UserPasswordChange = () => {
  const intl = (0,react_intl__WEBPACK_IMPORTED_MODULE_12__.useIntl)();
  const {
    addToast
  } = (0,react_toast_notifications__WEBPACK_IMPORTED_MODULE_13__.useToasts)();
  const router = (0,next_router__WEBPACK_IMPORTED_MODULE_11__.useRouter)();
  const {
    user: currentUser
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .useUser */ .aF)();
  const {
    user,
    hasPermission
  } = (0,_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .useUser */ .aF)({
    id: Number(router.query.userId)
  });
  const {
    data,
    error,
    mutate: revalidate
  } = (0,swr__WEBPACK_IMPORTED_MODULE_14__["default"])(user ? `/api/v1/user/${user?.id}/settings/password` : null);
  const PasswordChangeSchema = yup__WEBPACK_IMPORTED_MODULE_15__.object().shape({
    currentPassword: yup__WEBPACK_IMPORTED_MODULE_15__.lazy(() => data?.hasPassword && currentUser?.id === user?.id ? yup__WEBPACK_IMPORTED_MODULE_15__.string().required(intl.formatMessage(messages.validationCurrentPassword)) : yup__WEBPACK_IMPORTED_MODULE_15__.mixed().optional()),
    newPassword: yup__WEBPACK_IMPORTED_MODULE_15__.string().required(intl.formatMessage(messages.validationNewPassword)).min(8, intl.formatMessage(messages.validationNewPasswordLength)),
    confirmPassword: yup__WEBPACK_IMPORTED_MODULE_15__.string().required(intl.formatMessage(messages.validationConfirmPassword)).oneOf([yup__WEBPACK_IMPORTED_MODULE_15__.ref('newPassword'), null], intl.formatMessage(messages.validationConfirmPasswordSame))
  });

  if (!data && !error) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_LoadingSpinner__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {});
  }

  if (!data) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_pages_error__WEBPACK_IMPORTED_MODULE_7__["default"], {
      statusCode: 500
    });
  }

  if (currentUser?.id !== user?.id && hasPermission(_app_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__/* .Permission.ADMIN */ .y3.ADMIN) && currentUser?.id !== 1) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
        className: "mb-6",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("h3", {
          className: "heading",
          children: intl.formatMessage(messages.password)
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
        title: intl.formatMessage(messages.nopermissionDescription),
        type: "error"
      })]
    });
  }

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.Fragment, {
    children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_PageTitle__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      title: [intl.formatMessage(messages.password), intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].usersettings */ .Z.usersettings), user?.displayName]
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
      className: "mb-6",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("h3", {
        className: "heading",
        children: intl.formatMessage(messages.password)
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(formik__WEBPACK_IMPORTED_MODULE_10__.Formik, {
      initialValues: {
        currentPassword: '',
        newPassword: '',
        confirmPassword: ''
      },
      validationSchema: PasswordChangeSchema,
      enableReinitialize: true,
      onSubmit: async (values, {
        resetForm
      }) => {
        try {
          await axios__WEBPACK_IMPORTED_MODULE_9__["default"].post(`/api/v1/user/${user?.id}/settings/password`, {
            currentPassword: values.currentPassword,
            newPassword: values.newPassword,
            confirmPassword: values.confirmPassword
          });
          addToast(intl.formatMessage(messages.toastSettingsSuccess), {
            autoDismiss: true,
            appearance: 'success'
          });
        } catch (e) {
          addToast(intl.formatMessage(data.hasPassword && user?.id === currentUser?.id ? messages.toastSettingsFailureVerifyCurrent : messages.toastSettingsFailure), {
            autoDismiss: true,
            appearance: 'error'
          });
        } finally {
          revalidate();
          resetForm();
        }
      },
      children: ({
        errors,
        touched,
        isSubmitting,
        isValid
      }) => {
        return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(formik__WEBPACK_IMPORTED_MODULE_10__.Form, {
          className: "section",
          children: [!data.hasPassword && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_Alert__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .Z, {
            type: "warning",
            title: intl.formatMessage(user?.id === currentUser?.id ? messages.noPasswordSetOwnAccount : messages.noPasswordSet)
          }), data.hasPassword && user?.id === currentUser?.id && /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
            className: "form-row pb-6",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("label", {
              htmlFor: "currentPassword",
              className: "text-label",
              children: intl.formatMessage(messages.currentpassword)
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
              className: "form-input-area",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
                className: "form-input-field",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                  as: "field",
                  id: "currentPassword",
                  name: "currentPassword",
                  type: "password",
                  autoComplete: "current-password"
                })
              }), errors.currentPassword && touched.currentPassword && typeof errors.currentPassword === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
                className: "error",
                children: errors.currentPassword
              })]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("label", {
              htmlFor: "newPassword",
              className: "text-label",
              children: intl.formatMessage(messages.newpassword)
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
              className: "form-input-area",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
                className: "form-input-field",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                  as: "field",
                  id: "newPassword",
                  name: "newPassword",
                  type: "password",
                  autoComplete: "new-password"
                })
              }), errors.newPassword && touched.newPassword && typeof errors.newPassword === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
                className: "error",
                children: errors.newPassword
              })]
            })]
          }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
            className: "form-row",
            children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("label", {
              htmlFor: "confirmPassword",
              className: "text-label",
              children: intl.formatMessage(messages.confirmpassword)
            }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)("div", {
              className: "form-input-area",
              children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
                className: "form-input-field",
                children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_app_components_Common_SensitiveInput__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                  as: "field",
                  id: "confirmPassword",
                  name: "confirmPassword",
                  type: "password",
                  autoComplete: "new-password"
                })
              }), errors.confirmPassword && touched.confirmPassword && typeof errors.confirmPassword === 'string' && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
                className: "error",
                children: errors.confirmPassword
              })]
            })]
          }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
            className: "actions",
            children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("div", {
              className: "flex justify-end",
              children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
                className: "ml-3 inline-flex rounded-md shadow-sm",
                children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsxs)(_app_components_Common_Button__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
                  buttonType: "primary",
                  type: "submit",
                  disabled: isSubmitting || !isValid,
                  children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx(_heroicons_react_24_outline__WEBPACK_IMPORTED_MODULE_8__.ArrowDownOnSquareIcon, {}), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_16__.jsx("span", {
                    children: isSubmitting ? intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].saving */ .Z.saving) : intl.formatMessage(_app_i18n_globalMessages__WEBPACK_IMPORTED_MODULE_6__/* ["default"].save */ .Z.save)
                  })]
                })
              })
            })
          })]
        });
      }
    })]
  });
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UserPasswordChange);
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;