import { ReactFormState } from "react-dom/client";

//#region src/react/rsc.d.ts
declare function renderToReadableStream<T>(data: T, options?: object): ReadableStream<Uint8Array>;
declare function createFromReadableStream<T>(stream: ReadableStream<Uint8Array>, options?: object): Promise<T>;
declare function registerClientReference<T>(proxy: T, id: string, name: string): T;
declare const registerServerReference: <T>(ref: T, id: string, name: string) => T;
declare function decodeReply(body: string | FormData, options?: unknown): Promise<unknown[]>;
declare function decodeAction(body: FormData): Promise<() => Promise<void>>;
declare function decodeFormState(actionResult: unknown, body: FormData): Promise<ReactFormState | undefined>;
declare const createTemporaryReferenceSet: () => unknown;
declare const encodeReply: (v: unknown[], options?: unknown) => Promise<string | FormData>;
declare const createClientTemporaryReferenceSet: () => unknown;
//#endregion
export { createClientTemporaryReferenceSet, createFromReadableStream, createTemporaryReferenceSet, decodeAction, decodeFormState, decodeReply, encodeReply, registerClientReference, registerServerReference, renderToReadableStream };