//#region src/types/index.d.ts
interface ImportManifestEntry {
  id: string;
  name: string;
  chunks: string[];
  async?: boolean;
}
interface BundlerConfig {
  [bundlerId: string]: ImportManifestEntry;
}
type ModuleMap = {
  [id: string]: {
    [exportName: string]: ImportManifestEntry;
  };
};
interface ServerConsumerManifest {
  moduleMap?: ModuleMap;
  serverModuleMap?: BundlerConfig;
  moduleLoading?: {
    prefix: string;
    crossOriign?: string;
  };
}
type CallServerCallback = (id: string, args: unknown[]) => unknown;
//#endregion
export { BundlerConfig, CallServerCallback, ModuleMap, ServerConsumerManifest };