import * as express from 'express';
import { UNSAFE_MiddlewareEnabled, unstable_RouterContextProvider, AppLoadContext, ServerBuild } from 'react-router';

/// <reference lib="dom.iterable" />

type MaybePromise<T> = T | Promise<T>;
/**
 * A function that returns the value to use as `context` in route `loader` and
 * `action` functions.
 *
 * You can think of this as an escape hatch that allows you to pass
 * environment/platform-specific values through to your loader/action, such as
 * values that are generated by Express middleware like `req.session`.
 */
type GetLoadContextFunction = (req: express.Request, res: express.Response) => UNSAFE_MiddlewareEnabled extends true ? MaybePromise<unstable_RouterContextProvider> : MaybePromise<AppLoadContext>;
type RequestHandler = (req: express.Request, res: express.Response, next: express.NextFunction) => Promise<void>;
/**
 * Returns a request handler for Express that serves the response using Remix.
 */
declare function createRequestHandler({ build, getLoadContext, mode, }: {
    build: ServerBuild | (() => Promise<ServerBuild>);
    getLoadContext?: GetLoadContextFunction;
    mode?: string;
}): RequestHandler;

export { type GetLoadContextFunction, type RequestHandler, createRequestHandler };
