import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { PassThrough } from "node:stream";
import { createReadableStreamFromReadable } from "@react-router/node";
import { ServerRouter, useNavigate, Link, Form, useLocation, useNavigation, UNSAFE_withComponentProps, Outlet, redirect, Meta, Links, ScrollRestoration, Scripts, useFetcher } from "react-router";
import { isbot } from "isbot";
import { renderToPipeableStream } from "react-dom/server";
import { s as sessionStorage, b as backendClient, a as authenticate } from "./app-CJbOlvXU.js";
import React, { memo, useState, useEffect, useCallback, useRef } from "react";
import { Alert, Form as Form$1, Button, InputGroup, Card, Spinner, Tabs, Tab, OverlayTrigger, Tooltip, Table, Badge, Modal } from "react-bootstrap";
import { lookup } from "mime-types";
import { createHash } from "node:crypto";
import { useDropzone } from "react-dropzone";
import "@react-router/express";
import "express";
import "http-proxy-middleware";
import "ws";
import "crypto";
const streamTimeout = 5e3;
function handleRequest(request, responseStatusCode, responseHeaders, routerContext, loadContext) {
  return new Promise((resolve, reject) => {
    let shellRendered = false;
    let userAgent = request.headers.get("user-agent");
    let readyOption = userAgent && isbot(userAgent) || routerContext.isSpaMode ? "onAllReady" : "onShellReady";
    const { pipe, abort } = renderToPipeableStream(
      /* @__PURE__ */ jsx(ServerRouter, { context: routerContext, url: request.url }),
      {
        [readyOption]() {
          shellRendered = true;
          const body2 = new PassThrough();
          const stream = createReadableStreamFromReadable(body2);
          responseHeaders.set("Content-Type", "text/html");
          resolve(
            new Response(stream, {
              headers: responseHeaders,
              status: responseStatusCode
            })
          );
          pipe(body2);
        },
        onShellError(error2) {
          reject(error2);
        },
        onError(error2) {
          responseStatusCode = 500;
          if (shellRendered) {
            console.error(error2);
          }
        }
      }
    );
    setTimeout(abort, streamTimeout + 1e3);
  });
}
const entryServer = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: handleRequest,
  streamTimeout
}, Symbol.toStringTag, { value: "Module" }));
const container$o = "_container_tmf9c_1";
const title$6 = "_title_tmf9c_11";
const logo$2 = "_logo_tmf9c_28";
const styles$r = {
  container: container$o,
  "title-container": "_title-container_tmf9c_11",
  title: title$6,
  logo: logo$2
};
const container$n = "_container_89ilb_1";
const styles$q = {
  container: container$n,
  "hamburger-icon": "_hamburger-icon_89ilb_22",
  "close-icon": "_close-icon_89ilb_28"
};
function HamburgerMenu(props) {
  const styleName = props.isOpen ? "close-icon" : "hamburger-icon";
  const icon = /* @__PURE__ */ jsx("div", { className: styles$q[styleName], onClick: props.onClick });
  return /* @__PURE__ */ jsx("div", { className: styles$q.container, children: icon });
}
const TopNavigation = memo(function TopNavigation2(props) {
  const { isHamburgerMenuOpen, onHamburgerMenuClick } = props;
  const navigate = useNavigate();
  return /* @__PURE__ */ jsxs("div", { className: styles$r["container"], children: [
    /* @__PURE__ */ jsx(HamburgerMenu, { isOpen: isHamburgerMenuOpen, onClick: onHamburgerMenuClick }),
    /* @__PURE__ */ jsxs("div", { className: styles$r["title-container"], onClick: () => navigate("/"), children: [
      /* @__PURE__ */ jsx("img", { className: styles$r["logo"], src: "/logo.svg" }),
      /* @__PURE__ */ jsx("div", { className: styles$r["title"], children: "Nzb DAV" })
    ] })
  ] });
});
const container$m = "_container_125hs_1";
const unstyled = "_unstyled_125hs_10";
const item$1 = "_item_125hs_15";
const selected = "_selected_125hs_29";
const title$5 = "_title_125hs_89";
const footer = "_footer_125hs_93";
const styles$p = {
  container: container$m,
  unstyled,
  item: item$1,
  selected,
  "queue-icon": "_queue-icon_125hs_44",
  "explore-icon": "_explore-icon_125hs_53",
  "settings-icon": "_settings-icon_125hs_71",
  "health-icon": "_health-icon_125hs_80",
  title: title$5,
  footer,
  "footer-item": "_footer-item_125hs_101",
  "github-link": "_github-link_125hs_108",
  "github-icon": "_github-icon_125hs_124",
  "logout-icon": "_logout-icon_125hs_133"
};
function className(classNames) {
  return {
    className: classNames.filter(Boolean).join(" ")
  };
}
const container$l = "_container_wtp8o_1";
const title$4 = "_title_wtp8o_6";
const bar = "_bar_wtp8o_11";
const max = "_max_wtp8o_17";
const live = "_live_wtp8o_25";
const active = "_active_wtp8o_32";
const caption = "_caption_wtp8o_39";
const styles$o = {
  container: container$l,
  title: title$4,
  bar,
  max,
  live,
  active,
  caption
};
function receiveMessage(onMessage) {
  return (event) => {
    var parsed = JSON.parse(event.data);
    onMessage(parsed.Topic, parsed.Message);
  };
}
const usenetConnectionsTopic = { "cxs": "state" };
function LiveUsenetConnections() {
  const navigate = useNavigate();
  const [connections, setConnections] = useState(null);
  const parts = (connections || "0|1|0").split("|");
  const [live2, max2, idle] = parts.map((x) => Number(x));
  const active2 = live2 - idle;
  const activePercent = 100 * (active2 / max2);
  const livePercent = 100 * (live2 / max2);
  useEffect(() => {
    let ws;
    let disposed = false;
    function connect() {
      ws = new WebSocket(window.location.origin.replace(/^http/, "ws"));
      ws.onmessage = receiveMessage((_, message) => setConnections(message));
      ws.onopen = () => ws.send(JSON.stringify(usenetConnectionsTopic));
      ws.onerror = () => {
        ws.close();
      };
      ws.onclose = onClose;
      return () => {
        disposed = true;
        ws.close();
      };
    }
    function onClose(e) {
      if (e.code == 1008) navigate("/login");
      !disposed && setTimeout(() => connect(), 1e3);
      setConnections(null);
    }
    return connect();
  }, [setConnections]);
  return /* @__PURE__ */ jsxs("div", { className: styles$o.container, children: [
    /* @__PURE__ */ jsx("div", { className: styles$o.title, children: "Usenet Connections" }),
    /* @__PURE__ */ jsxs("div", { className: styles$o.bar, children: [
      /* @__PURE__ */ jsx("div", { className: styles$o.max }),
      /* @__PURE__ */ jsx("div", { className: styles$o.live, style: { width: `${livePercent}%` } }),
      /* @__PURE__ */ jsx("div", { className: styles$o.active, style: { width: `${activePercent}%` } })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: styles$o.caption, children: [
      connections && `${live2} connected / ${max2} max`,
      !connections && `Loading...`
    ] }),
    connections && /* @__PURE__ */ jsxs("div", { className: styles$o.caption, children: [
      "( ",
      active2,
      " active )"
    ] })
  ] });
}
function LeftNavigation({ version }) {
  return /* @__PURE__ */ jsxs("div", { className: styles$p.container, children: [
    /* @__PURE__ */ jsxs(Item, { target: "/queue", children: [
      /* @__PURE__ */ jsx("div", { className: styles$p["queue-icon"] }),
      /* @__PURE__ */ jsx("div", { className: styles$p.title, children: "Queue & History" })
    ] }),
    /* @__PURE__ */ jsxs(Item, { target: "/explore", children: [
      /* @__PURE__ */ jsx("div", { className: styles$p["explore-icon"] }),
      /* @__PURE__ */ jsx("div", { className: styles$p.title, children: "Dav Explore" })
    ] }),
    /* @__PURE__ */ jsxs(Item, { target: "/health", children: [
      /* @__PURE__ */ jsx("div", { className: styles$p["health-icon"] }),
      /* @__PURE__ */ jsx("div", { className: styles$p.title, children: "Health" })
    ] }),
    /* @__PURE__ */ jsxs(Item, { target: "/settings", children: [
      /* @__PURE__ */ jsx("div", { className: styles$p["settings-icon"] }),
      /* @__PURE__ */ jsx("div", { className: styles$p.title, children: "Settings" })
    ] }),
    /* @__PURE__ */ jsx(LiveUsenetConnections, {}),
    /* @__PURE__ */ jsxs("div", { className: styles$p.footer, children: [
      /* @__PURE__ */ jsxs("div", { className: styles$p["footer-item"], children: [
        /* @__PURE__ */ jsx(Link, { to: "https://github.com/nzbdav-dev/nzbdav", className: styles$p["github-link"], children: "github" }),
        /* @__PURE__ */ jsx("div", { className: styles$p["github-icon"] })
      ] }),
      /* @__PURE__ */ jsx("div", { className: styles$p["footer-item"], children: "changelog" }),
      /* @__PURE__ */ jsxs("div", { className: styles$p["footer-item"], children: [
        "version: ",
        version || "unknown"
      ] }),
      /* @__PURE__ */ jsx("hr", {}),
      /* @__PURE__ */ jsxs(Form, { method: "post", action: "/logout", children: [
        /* @__PURE__ */ jsx("input", { name: "confirm", value: "true", type: "hidden" }),
        /* @__PURE__ */ jsxs("button", { className: styles$p.unstyled + " " + styles$p.item, type: "submit", children: [
          /* @__PURE__ */ jsx("div", { className: styles$p["logout-icon"] }),
          /* @__PURE__ */ jsx("div", { className: styles$p.title, children: "Logout" })
        ] })
      ] })
    ] })
  ] });
}
function Item({ target, children }) {
  var _a;
  const location = useLocation();
  const navigation = useNavigation();
  const pathname = ((_a = navigation.location) == null ? void 0 : _a.pathname) ?? location.pathname;
  const isSelected = pathname.startsWith(target);
  const classes = [styles$p.item, isSelected ? styles$p.selected : null];
  return /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx(Link, { ...className(classes), to: target, children }) });
}
const container$k = "_container_1v1fq_1";
const page = "_page_1v1fq_19";
const body = "_body_1v1fq_37";
const styles$n = {
  container: container$k,
  "top-navigation": "_top-navigation_1v1fq_10",
  page,
  "left-navigation": "_left-navigation_1v1fq_26",
  body,
  "hamburger-open": "_hamburger-open_1v1fq_62"
};
function PageLayout(props) {
  const [isHamburgerMenuOpen, setIsHamburgerMenuOpen] = useState(false);
  const isNavigating = Boolean(useNavigation().location);
  useEffect(() => {
    !isNavigating && setIsHamburgerMenuOpen(false);
  }, [isNavigating, setIsHamburgerMenuOpen]);
  const onHamburgerMenuClick = useCallback(function() {
    setIsHamburgerMenuOpen(!isHamburgerMenuOpen);
  }, [setIsHamburgerMenuOpen, isHamburgerMenuOpen]);
  const onBodyClick = useCallback(function() {
    setIsHamburgerMenuOpen(false);
  }, [setIsHamburgerMenuOpen]);
  let containerClassName = styles$n["container"];
  if (isHamburgerMenuOpen) containerClassName += " " + styles$n["hamburger-open"];
  return /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsxs("div", { className: containerClassName, children: [
    /* @__PURE__ */ jsx("div", { className: styles$n["top-navigation"], children: /* @__PURE__ */ jsx(
      props.topNavComponent,
      {
        isHamburgerMenuOpen,
        onHamburgerMenuClick
      }
    ) }),
    /* @__PURE__ */ jsxs("div", { className: styles$n["page"], children: [
      /* @__PURE__ */ jsx("div", { className: styles$n["left-navigation"], children: props.leftNavChild }),
      /* @__PURE__ */ jsx("div", { className: styles$n["body"], onClick: onBodyClick, children: props.bodyChild })
    ] })
  ] }) });
}
const container$j = "_container_1knun_1";
const styles$m = {
  container: container$j,
  "loader-ring": "_loader-ring_1knun_10",
  "loading-text": "_loading-text_1knun_34"
};
function Loading({ className: className2 }) {
  return /* @__PURE__ */ jsxs("div", { className: `${styles$m.container} ${className2 ? className2 : ""}`, children: [
    /* @__PURE__ */ jsx("div", { className: styles$m["loader-ring"] }),
    /* @__PURE__ */ jsx("div", { className: styles$m["loading-text"], children: "Loading..." })
  ] });
}
async function loader$7({
  request
}) {
  let path2 = new URL(request.url).pathname;
  if (path2 === "/login") return {
    useLayout: false
  };
  if (path2 === "/onboarding") return {
    useLayout: false
  };
  let session = await sessionStorage.getSession(request.headers.get("cookie"));
  let user = session.get("user");
  if (!user) return redirect("/login");
  return {
    useLayout: true,
    version: process.env.NZBDAV_VERSION
  };
}
function Layout({
  children
}) {
  return /* @__PURE__ */ jsxs("html", {
    lang: "en",
    "data-bs-theme": "dark",
    children: [/* @__PURE__ */ jsxs("head", {
      children: [/* @__PURE__ */ jsx("meta", {
        charSet: "utf-8"
      }), /* @__PURE__ */ jsx("meta", {
        name: "viewport",
        content: "width=device-width, initial-scale=1"
      }), /* @__PURE__ */ jsx("link", {
        rel: "icon",
        href: "/logo.svg"
      }), /* @__PURE__ */ jsx(Meta, {}), /* @__PURE__ */ jsx(Links, {})]
    }), /* @__PURE__ */ jsxs("body", {
      children: [children, /* @__PURE__ */ jsx(ScrollRestoration, {}), /* @__PURE__ */ jsx(Scripts, {})]
    })]
  });
}
const root = UNSAFE_withComponentProps(function App({
  loaderData
}) {
  var _a, _b;
  const {
    useLayout,
    version
  } = loaderData;
  const location = useLocation();
  const navigation = useNavigation();
  const isNavigating = Boolean(navigation.location);
  const isCurrentExplorePage = location.pathname.startsWith("/explore");
  const isNextExplorePage = (_b = (_a = navigation.location) == null ? void 0 : _a.pathname) == null ? void 0 : _b.startsWith("/explore");
  const showLoading = isNavigating && !(isCurrentExplorePage && isNextExplorePage);
  if (useLayout) {
    return /* @__PURE__ */ jsx(PageLayout, {
      topNavComponent: TopNavigation,
      bodyChild: showLoading ? /* @__PURE__ */ jsx(Loading, {}) : /* @__PURE__ */ jsx(Outlet, {}),
      leftNavChild: /* @__PURE__ */ jsx(LeftNavigation, {
        version
      })
    });
  }
  return /* @__PURE__ */ jsx(Outlet, {});
});
const route0 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  Layout,
  default: root,
  loader: loader$7
}, Symbol.toStringTag, { value: "Module" }));
const container$i = "_container_nv67c_1";
const logo$1 = "_logo_nv67c_13";
const title$3 = "_title_nv67c_17";
const alert$1 = "_alert_nv67c_25";
const styles$l = {
  container: container$i,
  logo: logo$1,
  title: title$3,
  alert: alert$1
};
async function loader$6({
  request
}) {
  let session = await sessionStorage.getSession(request.headers.get("cookie"));
  let user = session.get("user");
  if (user) return redirect("/");
  const isOnboarding = await backendClient.isOnboarding();
  if (!isOnboarding) return redirect("/login");
  return {
    error: null
  };
}
const route$5 = UNSAFE_withComponentProps(function Index({
  loaderData,
  actionData
}) {
  var pageData = actionData || loaderData;
  const [username, setUsername] = useState("");
  const [password, setPassword] = useState("");
  const [confirmPassword, setConfirmPassword] = useState("");
  const navigation = useNavigation();
  const isLoading = navigation.state == "submitting";
  var submitButtonDisabled = false;
  var submitButtonText = "Register";
  if (isLoading) {
    submitButtonDisabled = true;
    submitButtonText = "Registering...";
  } else if (username == "") {
    submitButtonDisabled = true;
    submitButtonText = "Username is required";
  } else if (password === "") {
    submitButtonDisabled = true;
    submitButtonText = "Password is required";
  } else if (password != confirmPassword) {
    submitButtonDisabled = true;
    submitButtonText = "Passwords must match";
  }
  return /* @__PURE__ */ jsx(Fragment, {
    children: /* @__PURE__ */ jsxs(Form, {
      className: styles$l["container"],
      method: "POST",
      children: [/* @__PURE__ */ jsx("img", {
        className: styles$l["logo"],
        src: "/logo.svg"
      }), /* @__PURE__ */ jsx("div", {
        className: styles$l["title"],
        children: "Nzb DAV"
      }), pageData.error && /* @__PURE__ */ jsx(Alert, {
        className: styles$l["alert"],
        variant: "danger",
        children: pageData.error
      }), !pageData.error && /* @__PURE__ */ jsxs(Alert, {
        className: styles$l["alert"],
        variant: "warning",
        children: [/* @__PURE__ */ jsx("p", {
          style: {
            marginBottom: "5px"
          },
          children: "Welcome!"
        }), "Register your admin account."]
      }), /* @__PURE__ */ jsx(Form$1.Control, {
        autoFocus: true,
        name: "username",
        type: "text",
        placeholder: "Username",
        value: username,
        onChange: (e) => setUsername(e.currentTarget.value)
      }), /* @__PURE__ */ jsx(Form$1.Control, {
        name: "password",
        type: "password",
        placeholder: "Password",
        value: password,
        onChange: (e) => setPassword(e.currentTarget.value)
      }), /* @__PURE__ */ jsx(Form$1.Control, {
        type: "password",
        placeholder: "Confirm Password",
        value: confirmPassword,
        onChange: (e) => setConfirmPassword(e.currentTarget.value)
      }), /* @__PURE__ */ jsx(Button, {
        type: "submit",
        variant: "primary",
        disabled: submitButtonDisabled,
        children: submitButtonText
      })]
    })
  });
});
async function action$4({
  request
}) {
  var _a, _b;
  try {
    const isOnboarding = await backendClient.isOnboarding();
    if (!isOnboarding) return redirect("/login");
    const formData = await request.formData();
    const username = (_a = formData.get("username")) == null ? void 0 : _a.toString();
    const password = (_b = formData.get("password")) == null ? void 0 : _b.toString();
    if (!username || !password) throw new Error("username and password required");
    var isSuccess = await backendClient.createAccount(username, password);
    if (!isSuccess) throw new Error("Unknown error creating account");
    let session = await sessionStorage.getSession(request.headers.get("cookie"));
    session.set("user", {
      username
    });
    return redirect("/", {
      headers: {
        "Set-Cookie": await sessionStorage.commitSession(session)
      }
    });
  } catch (error2) {
    if (error2 instanceof Error) {
      return {
        error: error2.message
      };
    }
    throw error2;
  }
}
const route1 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action: action$4,
  default: route$5,
  loader: loader$6
}, Symbol.toStringTag, { value: "Module" }));
const container$h = "_container_yygrw_1";
const tabs = "_tabs_yygrw_9";
const button = "_button_yygrw_25";
const styles$k = {
  container: container$h,
  tabs,
  button
};
const container$g = "_container_1vhlh_1";
const input$4 = "_input_1vhlh_20";
const styles$j = {
  container: container$g,
  "form-group": "_form-group_1vhlh_6",
  "justify-right": "_justify-right_1vhlh_10",
  "test-connection-button": "_test-connection-button_1vhlh_16",
  input: input$4
};
function UsenetSettings({ config, setNewConfig, onReadyToSave }) {
  const [isFetching, setIsFetching] = useState(false);
  const [isConnectionSuccessful, setIsConnectionSuccessful] = useState(false);
  const [testedConfig, setTestedConfig] = useState({});
  const isChangedSinceLastTest = isUsenetSettingsUpdated(config, testedConfig);
  const TestButtonLabel = isFetching ? "Testing Connection..." : !config["usenet.host"] ? "`Host` is required" : !config["usenet.port"] ? "`Port` is required" : !isPositiveInteger(config["usenet.port"]) ? "`Port` is invalid" : !config["usenet.user"] ? "`User` is required" : !config["usenet.pass"] ? "`Pass` is required" : !config["usenet.connections"] ? "`Max Connections` is required" : !config["usenet.connections-per-stream"] ? "`Connections Per Stream` is required" : !isPositiveInteger(config["usenet.connections"]) ? "`Max Connections` is invalid" : !config["usenet.connections-per-stream"] ? "`Connections Per Stream` is required" : !isPositiveInteger(config["usenet.connections-per-stream"]) ? "`Connections Per Stream` is invalid" : Number(config["usenet.connections-per-stream"]) > Number(config["usenet.connections"]) ? "`Connections Per Stream` is invalid" : !isChangedSinceLastTest && isConnectionSuccessful ? "Connected ✅" : !isChangedSinceLastTest && !isConnectionSuccessful ? "Test Connection ❌" : "Test Connection";
  const testButtonVariant = isFetching ? "secondary" : TestButtonLabel === "Connected ✅" ? "success" : TestButtonLabel.includes("Test Connection") ? "primary" : "danger";
  const IsTestButtonEnabled = TestButtonLabel == "Test Connection" || TestButtonLabel == "Test Connection ❌";
  const isReadyToSave = isConnectionSuccessful && !isChangedSinceLastTest;
  useEffect(() => {
    onReadyToSave && onReadyToSave(isReadyToSave);
  }, [isReadyToSave]);
  const onTestButtonClicked = useCallback(async () => {
    var _a;
    setIsFetching(true);
    const response = await fetch("/api/test-usenet-connection", {
      method: "POST",
      body: (() => {
        const form = new FormData();
        form.append("host", config["usenet.host"]);
        form.append("port", config["usenet.port"]);
        form.append("use-ssl", config["usenet.use-ssl"] || "false");
        form.append("user", config["usenet.user"]);
        form.append("pass", config["usenet.pass"]);
        return form;
      })()
    });
    const isConnectionSuccessful2 = response.ok && ((_a = await response.json()) == null ? void 0 : _a.connected) === true;
    setIsFetching(false);
    setTestedConfig(config);
    setIsConnectionSuccessful(isConnectionSuccessful2);
  }, [config, setIsFetching, setIsConnectionSuccessful]);
  return /* @__PURE__ */ jsxs("div", { className: styles$j.container, children: [
    /* @__PURE__ */ jsxs(Form$1.Group, { className: styles$j["form-group"], children: [
      /* @__PURE__ */ jsx(Form$1.Label, { children: "Host" }),
      /* @__PURE__ */ jsx(
        Form$1.Control,
        {
          type: "text",
          className: styles$j.input,
          value: config["usenet.host"] || "",
          onChange: (e) => setNewConfig({ ...config, "usenet.host": e.target.value })
        }
      )
    ] }),
    /* @__PURE__ */ jsxs(Form$1.Group, { className: styles$j["form-group"], children: [
      /* @__PURE__ */ jsx(Form$1.Label, { children: "Port" }),
      /* @__PURE__ */ jsx(
        Form$1.Control,
        {
          type: "text",
          className: styles$j.input,
          value: config["usenet.port"] || "",
          onChange: (e) => setNewConfig({ ...config, "usenet.port": e.target.value })
        }
      )
    ] }),
    /* @__PURE__ */ jsx("div", { className: styles$j["justify-right"], children: /* @__PURE__ */ jsx(
      Form$1.Check,
      {
        id: "use-ssl-checkbox",
        type: "checkbox",
        label: `Use SSL`,
        checked: config["usenet.use-ssl"] === "true",
        onChange: (e) => setNewConfig({ ...config, "usenet.use-ssl": "" + e.target.checked })
      }
    ) }),
    /* @__PURE__ */ jsx("br", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { className: styles$j["form-group"], children: [
      /* @__PURE__ */ jsx(Form$1.Label, { children: "User" }),
      /* @__PURE__ */ jsx(
        Form$1.Control,
        {
          type: "text",
          className: styles$j.input,
          value: config["usenet.user"] || "",
          onChange: (e) => setNewConfig({ ...config, "usenet.user": e.target.value })
        }
      )
    ] }),
    /* @__PURE__ */ jsxs(Form$1.Group, { className: styles$j["form-group"], children: [
      /* @__PURE__ */ jsx(Form$1.Label, { children: "Pass" }),
      /* @__PURE__ */ jsx(
        Form$1.Control,
        {
          className: styles$j.input,
          type: "password",
          value: config["usenet.pass"] || "",
          onChange: (e) => setNewConfig({ ...config, "usenet.pass": e.target.value })
        }
      )
    ] }),
    /* @__PURE__ */ jsxs(Form$1.Group, { className: styles$j["form-group"], children: [
      /* @__PURE__ */ jsx(Form$1.Label, { children: "Max Connections" }),
      /* @__PURE__ */ jsx(
        Form$1.Control,
        {
          className: styles$j.input,
          type: "text",
          placeholder: "50",
          value: config["usenet.connections"] || "",
          onChange: (e) => setNewConfig({ ...config, "usenet.connections": e.target.value })
        }
      )
    ] }),
    /* @__PURE__ */ jsxs(Form$1.Group, { className: styles$j["form-group"], children: [
      /* @__PURE__ */ jsx(Form$1.Label, { children: "Connections Per Stream" }),
      /* @__PURE__ */ jsx(
        Form$1.Control,
        {
          className: styles$j.input,
          type: "text",
          placeholder: "5",
          value: config["usenet.connections-per-stream"] || "",
          onChange: (e) => setNewConfig({ ...config, "usenet.connections-per-stream": e.target.value })
        }
      )
    ] }),
    /* @__PURE__ */ jsx("div", { className: styles$j["justify-right"], children: /* @__PURE__ */ jsx(
      Button,
      {
        className: styles$j["test-connection-button"],
        variant: testButtonVariant,
        disabled: !IsTestButtonEnabled,
        onClick: () => onTestButtonClicked(),
        children: TestButtonLabel
      }
    ) })
  ] });
}
function isUsenetSettingsUpdated(config, newConfig) {
  return config["usenet.host"] !== newConfig["usenet.host"] || config["usenet.port"] !== newConfig["usenet.port"] || config["usenet.use-ssl"] !== newConfig["usenet.use-ssl"] || config["usenet.user"] !== newConfig["usenet.user"] || config["usenet.pass"] !== newConfig["usenet.pass"] || config["usenet.connections"] !== newConfig["usenet.connections"] || config["usenet.connections-per-stream"] !== newConfig["usenet.connections-per-stream"];
}
function isPositiveInteger(value) {
  const num = Number(value);
  return Number.isInteger(num) && num > 0 && value.trim() === num.toString();
}
const container$f = "_container_wc504_1";
const input$3 = "_input_wc504_5";
const error$3 = "_error_wc504_13";
const styles$i = {
  container: container$f,
  input: input$3,
  error: error$3
};
function SabnzbdSettings({ config, setNewConfig }) {
  const onRefreshApiKey = useCallback(() => {
    setNewConfig({ ...config, "api.key": generateNewApiKey() });
  }, [setNewConfig, config]);
  return /* @__PURE__ */ jsxs("div", { className: styles$i.container, children: [
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(Form$1.Label, { htmlFor: "api-key-input", children: "API Key" }),
      /* @__PURE__ */ jsxs(InputGroup, { className: styles$i.input, children: [
        /* @__PURE__ */ jsx(
          Form$1.Control,
          {
            type: "text",
            id: "api-key-input",
            "aria-describedby": "api-key-help",
            value: config["api.key"],
            readOnly: true
          }
        ),
        /* @__PURE__ */ jsx(Button, { variant: "primary", onClick: onRefreshApiKey, children: "Refresh" })
      ] }),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "api-key-help", muted: true, children: "Use this API key when configuring your download client in Radarr or Sonarr." })
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(Form$1.Label, { htmlFor: "categories-input", children: "Categories" }),
      /* @__PURE__ */ jsx(
        Form$1.Control,
        {
          ...className([styles$i.input, !isValidCategories(config["api.categories"]) && styles$i.error]),
          type: "text",
          id: "categories-input",
          "aria-describedby": "categories-help",
          value: config["api.categories"],
          placeholder: "tv, movies, audio, software",
          onChange: (e) => setNewConfig({ ...config, "api.categories": e.target.value })
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "categories-help", muted: true, children: "Comma-separated categories. Only letters, numbers, and dashes are allowed." })
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(Form$1.Label, { htmlFor: "mount-dir-input", children: "Rclone Mount Directory" }),
      /* @__PURE__ */ jsx(
        Form$1.Control,
        {
          className: styles$i.input,
          type: "text",
          id: "mount-dir-input",
          "aria-describedby": "mount-dir-help",
          placeholder: "/mnt/nzbdav",
          value: config["rclone.mount-dir"],
          onChange: (e) => setNewConfig({ ...config, "rclone.mount-dir": e.target.value })
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "mount-dir-help", muted: true, children: `The location at which you've mounted (or will mount) the webdav root, through Rclone. This is used to tell Radarr / Sonarr where to look for completed "downloads."` })
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(Form$1.Label, { htmlFor: "max-queue-connections-input", children: "Max Connections for Queue Processing" }),
      /* @__PURE__ */ jsx(
        Form$1.Control,
        {
          ...className([styles$i.input, !isValidQueueConnections(config["api.max-queue-connections"]) && styles$i.error]),
          type: "text",
          id: "max-queue-connections-input",
          "aria-describedby": "max-queue-connections-help",
          placeholder: "All",
          value: config["api.max-queue-connections"],
          onChange: (e) => setNewConfig({ ...config, "api.max-queue-connections": e.target.value })
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "max-queue-connections-help", muted: true, children: "Queue processing tasks will not use any more than this number of connections. Will default to your overall Max Connections if left empty." })
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(Form$1.Label, { htmlFor: "duplicate-nzb-input", children: "Behavior for Duplicate NZBs" }),
      /* @__PURE__ */ jsxs(
        Form$1.Select,
        {
          className: styles$i.input,
          value: config["api.duplicate-nzb-behavior"],
          onChange: (e) => setNewConfig({ ...config, "api.duplicate-nzb-behavior": e.target.value }),
          children: [
            /* @__PURE__ */ jsx("option", { value: "increment", children: "Download again with (2) suffix" }),
            /* @__PURE__ */ jsx("option", { value: "mark-failed", children: "Mark the download as failed" })
          ]
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "max-queue-connections-help", muted: true, children: "When an NZB is added, a new folder is created in the webdav. What should we when the download folder for an NZB already exists?" })
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(
        Form$1.Check,
        {
          className: styles$i.input,
          type: "checkbox",
          id: "ensure-importable-video-checkbox",
          "aria-describedby": "ensure-importable-video-help",
          label: `Fail downloads for nzbs without video content`,
          checked: config["api.ensure-importable-video"] === "true",
          onChange: (e) => setNewConfig({ ...config, "api.ensure-importable-video": "" + e.target.checked })
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "ensure-importable-video-help", muted: true, children: "Whether to mark downloads as `failed` when no single video file is found inside the nzb. This will force Radarr / Sonarr to automatically look for a new nzb." })
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(
        Form$1.Check,
        {
          className: styles$i.input,
          type: "checkbox",
          id: "ensure-article-existence-checkbox",
          "aria-describedby": "ensure-article-existence-help",
          label: `Perform article health check during downloads`,
          checked: config["api.ensure-article-existence"] === "true",
          onChange: (e) => setNewConfig({ ...config, "api.ensure-article-existence": "" + e.target.checked })
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "ensure-article-existence-help", muted: true, children: "Whether to check for the existence of all articles within an NZB during queue processing. This process may be slow." })
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(
        Form$1.Check,
        {
          className: styles$i.input,
          type: "checkbox",
          id: "ignore-history-limit-checkbox",
          "aria-describedby": "ignore-history-limit-help",
          label: `Always send full History to Radarr/Sonarr`,
          checked: config["api.ignore-history-limit"] === "true",
          onChange: (e) => setNewConfig({ ...config, "api.ignore-history-limit": "" + e.target.checked })
        }
      ),
      /* @__PURE__ */ jsxs(Form$1.Text, { id: "ignore-history-limit-help", muted: true, children: [
        "When enabled, this will ignore the History limit sent by radarr/sonarr and always reply with all History items. ",
        /* @__PURE__ */ jsx("a", { href: "https://github.com/Sonarr/Sonarr/issues/5452", children: "See here" }),
        "."
      ] })
    ] })
  ] });
}
function isSabnzbdSettingsUpdated(config, newConfig) {
  return config["api.key"] !== newConfig["api.key"] || config["api.categories"] !== newConfig["api.categories"] || config["rclone.mount-dir"] !== newConfig["rclone.mount-dir"] || config["api.max-queue-connections"] !== newConfig["api.max-queue-connections"] || config["api.ensure-importable-video"] !== newConfig["api.ensure-importable-video"] || config["api.ensure-article-existence"] !== newConfig["api.ensure-article-existence"] || config["api.ignore-history-limit"] !== newConfig["api.ignore-history-limit"] || config["api.duplicate-nzb-behavior"] !== newConfig["api.duplicate-nzb-behavior"];
}
function isSabnzbdSettingsValid(newConfig) {
  return isValidCategories(newConfig["api.categories"]) && isValidQueueConnections(newConfig["api.max-queue-connections"]);
}
function generateNewApiKey() {
  return crypto.randomUUID().toString().replaceAll("-", "");
}
function isValidCategories(categories) {
  if (categories === "") return true;
  var parts = categories.split(",");
  return parts.map((x) => x.trim()).every((x) => isAlphaNumericWithDashes(x));
}
function isAlphaNumericWithDashes(input2) {
  const regex = /^[A-Za-z0-9-]+$/;
  return regex.test(input2);
}
function isValidQueueConnections(maxQueueConnections) {
  return maxQueueConnections === "" || isPositiveInteger(maxQueueConnections);
}
const container$e = "_container_wc504_1";
const input$2 = "_input_wc504_5";
const error$2 = "_error_wc504_13";
const styles$h = {
  container: container$e,
  input: input$2,
  error: error$2
};
function WebdavSettings({ config, setNewConfig }) {
  return /* @__PURE__ */ jsxs("div", { className: styles$h.container, children: [
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(Form$1.Label, { htmlFor: "webdav-user-input", children: "WebDAV User" }),
      /* @__PURE__ */ jsx(
        Form$1.Control,
        {
          ...className([styles$h.input, !isValidUser(config["webdav.user"]) && styles$h.error]),
          type: "text",
          id: "webdav-user-input",
          "aria-describedby": "webdav-user-help",
          placeholder: "admin",
          value: config["webdav.user"],
          onChange: (e) => setNewConfig({ ...config, "webdav.user": e.target.value })
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "webdav-user-help", muted: true, children: "Use this user to connect to the webdav. Only letters, numbers, dashes, and underscores allowed." })
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(Form$1.Label, { htmlFor: "webdav-pass-input", children: "WebDAV Password" }),
      /* @__PURE__ */ jsx(
        Form$1.Control,
        {
          className: styles$h.input,
          type: "password",
          id: "webdav-pass-input",
          "aria-describedby": "webdav-pass-help",
          value: config["webdav.pass"],
          onChange: (e) => setNewConfig({ ...config, "webdav.pass": e.target.value })
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "webdav-pass-help", muted: true, children: "Use this password to connect to the webdav." })
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(
        Form$1.Check,
        {
          className: styles$h.input,
          type: "checkbox",
          id: "readonly-checkbox",
          "aria-describedby": "readonly-help",
          label: `Enforce Read-Only`,
          checked: config["webdav.enforce-readonly"] === "true",
          onChange: (e) => setNewConfig({ ...config, "webdav.enforce-readonly": "" + e.target.checked })
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "readonly-help", muted: true, children: "The WebDAV `/content` folder will be readonly when checked. WebDAV clients will not be able to delete files within this directory." })
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(
        Form$1.Check,
        {
          className: styles$h.input,
          type: "checkbox",
          id: "show-hidden-files-checkbox",
          "aria-describedby": "show-hidden-files-help",
          label: `Show hidden files on Dav Explorer`,
          checked: config["webdav.show-hidden-files"] === "true",
          onChange: (e) => setNewConfig({ ...config, "webdav.show-hidden-files": "" + e.target.checked })
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "show-hidden-files-help", muted: true, children: "Hidden files or directories are those whose names are prefixed by a period." })
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(
        Form$1.Check,
        {
          className: styles$h.input,
          type: "checkbox",
          id: "preview-par2-files-checkbox",
          "aria-describedby": "preview-par2-files-help",
          label: `Preview par2 files on Dav Explorer`,
          checked: config["webdav.preview-par2-files"] === "true",
          onChange: (e) => setNewConfig({ ...config, "webdav.preview-par2-files": "" + e.target.checked })
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "preview-par2-files-help", muted: true, children: "When enabled, par2 files will be rendered as text files on the Dav Explorer page, displaying all File-Descriptor entries." })
    ] })
  ] });
}
function isWebdavSettingsUpdated(config, newConfig) {
  return config["webdav.user"] !== newConfig["webdav.user"] || config["webdav.pass"] !== newConfig["webdav.pass"] || config["webdav.show-hidden-files"] !== newConfig["webdav.show-hidden-files"] || config["webdav.enforce-readonly"] !== newConfig["webdav.enforce-readonly"] || config["webdav.preview-par2-files"] !== newConfig["webdav.preview-par2-files"];
}
function isWebdavSettingsValid(newConfig) {
  return isValidUser(newConfig["webdav.user"]);
}
function isValidUser(user) {
  const regex = /^[A-Za-z0-9_-]+$/;
  return regex.test(user);
}
const container$d = "_container_uicqh_1";
const section$2 = "_section_uicqh_5";
const sectionHeader = "_sectionHeader_uicqh_9";
const instanceCard = "_instanceCard_uicqh_25";
const closeButton = "_closeButton_uicqh_37";
const input$1 = "_input_uicqh_58";
const alertMessage = "_alertMessage_uicqh_74";
const listItem$1 = "_listItem_uicqh_83";
const statusMessage = "_statusMessage_uicqh_87";
const testButton = "_testButton_uicqh_91";
const styles$g = {
  container: container$d,
  section: section$2,
  sectionHeader,
  instanceCard,
  closeButton,
  input: input$1,
  alertMessage,
  listItem: listItem$1,
  statusMessage,
  testButton
};
const queueStatusMessages = [
  {
    display: "Found matching series via grab history, but release was matched to series by ID. Automatic import is not possible.",
    searchTerm: "Found matching series via grab history, but release was matched to series by ID. Automatic import is not possible."
  },
  {
    display: "Found matching movie via grab history, but release was matched to movie by ID. Manual Import required.",
    searchTerm: "Found matching movie via grab history, but release was matched to movie by ID. Manual Import required."
  },
  {
    display: "Episode was not found in the grabbed release",
    searchTerm: "was not found in the grabbed release"
  },
  {
    display: "Episode was unexpected considering the folder name",
    searchTerm: "was unexpected considering the"
  },
  {
    display: "Not an upgrade for existing episode file(s)",
    searchTerm: "Not an upgrade for existing episode file(s)"
  },
  {
    display: "Not an upgrade for existing movie file",
    searchTerm: "Not an upgrade for existing movie file"
  },
  {
    display: "Not a Custom Format upgrade",
    searchTerm: "Not a Custom Format upgrade"
  },
  {
    display: "No files found are eligible for import",
    searchTerm: "No files found are eligible for import"
  },
  {
    display: "Episode file already imported",
    searchTerm: "Episode file already imported"
  },
  {
    display: "No audio tracks detected",
    searchTerm: "No audio tracks detected"
  },
  {
    display: "Invalid season or episode",
    searchTerm: "Invalid season or episode"
  },
  {
    display: "Unable to determine if file is a sample",
    searchTerm: "Unable to determine if file is a sample"
  },
  {
    display: "Sample",
    searchTerm: "Sample"
  }
];
function ArrsSettings({ config, setNewConfig }) {
  const arrConfig = JSON.parse(config["arr.instances"]);
  const updateConfig = useCallback((newArrConfig) => {
    setNewConfig({ ...config, "arr.instances": JSON.stringify(newArrConfig) });
  }, [config, setNewConfig]);
  const addRadarrInstance = useCallback(() => {
    updateConfig({
      ...arrConfig,
      RadarrInstances: [
        ...arrConfig.RadarrInstances,
        { Host: "", ApiKey: "" }
      ]
    });
  }, [arrConfig, updateConfig]);
  const removeRadarrInstance = useCallback((index) => {
    updateConfig({
      ...arrConfig,
      RadarrInstances: arrConfig.RadarrInstances.filter((_, i) => i !== index)
    });
  }, [arrConfig, updateConfig]);
  const updateRadarrInstance = useCallback((index, field, value) => {
    updateConfig({
      ...arrConfig,
      RadarrInstances: arrConfig.RadarrInstances.map(
        (instance, i) => i === index ? { ...instance, [field]: value } : instance
      )
    });
  }, [arrConfig, updateConfig]);
  const addSonarrInstance = useCallback(() => {
    updateConfig({
      ...arrConfig,
      SonarrInstances: [
        ...arrConfig.SonarrInstances,
        { Host: "", ApiKey: "" }
      ]
    });
  }, [arrConfig, updateConfig]);
  const removeSonarrInstance = useCallback((index) => {
    updateConfig({
      ...arrConfig,
      SonarrInstances: arrConfig.SonarrInstances.filter((_, i) => i !== index)
    });
  }, [arrConfig, updateConfig]);
  const updateSonarrInstance = useCallback((index, field, value) => {
    updateConfig({
      ...arrConfig,
      SonarrInstances: arrConfig.SonarrInstances.map(
        (instance, i) => i === index ? { ...instance, [field]: value } : instance
      )
    });
  }, [arrConfig, updateConfig]);
  const updateQueueAction = useCallback((searchTerm, action2) => {
    var newQueueRules = (arrConfig.QueueRules || []).filter((queueRule) => queueStatusMessages.map((x) => x.searchTerm).includes(queueRule.Message)).map(
      (queueRule) => queueRule.Message == searchTerm ? { Message: searchTerm, Action: action2 } : queueRule
    );
    if (!newQueueRules.find((queueRule) => queueRule.Message == searchTerm))
      newQueueRules.push({ Message: searchTerm, Action: action2 });
    updateConfig({
      ...arrConfig,
      QueueRules: newQueueRules
    });
  }, [arrConfig, updateConfig]);
  return /* @__PURE__ */ jsxs("div", { className: styles$g.container, children: [
    /* @__PURE__ */ jsxs("div", { className: styles$g.section, children: [
      /* @__PURE__ */ jsxs("div", { className: styles$g.sectionHeader, children: [
        /* @__PURE__ */ jsx("div", { children: "Radarr Instances" }),
        /* @__PURE__ */ jsx(Button, { variant: "primary", size: "sm", onClick: addRadarrInstance, children: "Add" })
      ] }),
      arrConfig.RadarrInstances.length === 0 ? /* @__PURE__ */ jsx("p", { className: styles$g.alertMessage, children: 'No Radarr instances configured. Click on the "Add" button to get started.' }) : arrConfig.RadarrInstances.map(
        (instance, index) => /* @__PURE__ */ jsx(
          InstanceForm,
          {
            instance,
            index,
            type: "radarr",
            onUpdate: updateRadarrInstance,
            onRemove: removeRadarrInstance
          },
          index
        )
      )
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs("div", { className: styles$g.section, children: [
      /* @__PURE__ */ jsxs("div", { className: styles$g.sectionHeader, children: [
        /* @__PURE__ */ jsx("div", { children: "Sonarr Instances" }),
        /* @__PURE__ */ jsx(Button, { variant: "primary", size: "sm", onClick: addSonarrInstance, children: "Add" })
      ] }),
      arrConfig.SonarrInstances.length === 0 ? /* @__PURE__ */ jsx("p", { className: styles$g.alertMessage, children: 'No Sonarr instances configured. Click on the "Add" button to get started.' }) : arrConfig.SonarrInstances.map(
        (instance, index) => /* @__PURE__ */ jsx(
          InstanceForm,
          {
            instance,
            index,
            type: "sonarr",
            onUpdate: updateSonarrInstance,
            onRemove: removeSonarrInstance
          },
          index
        )
      )
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs("div", { className: styles$g.section, children: [
      /* @__PURE__ */ jsx("div", { className: styles$g.sectionHeader, children: /* @__PURE__ */ jsx("div", { children: "Automatic Queue Management" }) }),
      /* @__PURE__ */ jsx("p", { className: styles$g.alertMessage, children: "Configure what to do for items stuck in Radarr / Sonarr queues. Different actions can be configured for different status messages. Only `usenet` queue items will be acted upon." }),
      /* @__PURE__ */ jsx("ul", { children: queueStatusMessages.map(
        (queueStatusMessage, index) => {
          var _a;
          return /* @__PURE__ */ jsxs("li", { className: styles$g.listItem, children: [
            /* @__PURE__ */ jsx("div", { className: styles$g.statusMessage, children: queueStatusMessage.display }),
            /* @__PURE__ */ jsxs(
              Form$1.Select,
              {
                className: styles$g.input,
                value: ((_a = arrConfig.QueueRules.find((x) => x.Message == queueStatusMessage.searchTerm)) == null ? void 0 : _a.Action) ?? "0",
                onChange: (e) => updateQueueAction(queueStatusMessage.searchTerm, Number(e.target.value)),
                children: [
                  /* @__PURE__ */ jsx("option", { value: "0", children: "Do Nothing" }),
                  /* @__PURE__ */ jsx("option", { value: "1", children: "Remove" }),
                  /* @__PURE__ */ jsx("option", { value: "2", children: "Remove and Blocklist" }),
                  /* @__PURE__ */ jsx("option", { value: "3", children: "Remove, Blocklist, and Search" })
                ]
              }
            )
          ] }, index);
        }
      ) })
    ] })
  ] });
}
function InstanceForm({ instance, index, type, onUpdate, onRemove }) {
  const [connectionState, setConnectionState] = useState("idle");
  useEffect(() => {
    setConnectionState("idle");
  }, [instance.Host, instance.ApiKey]);
  const testConnection = useCallback(async (host, apiKey) => {
    if (!host.trim() || !apiKey.trim()) {
      return;
    }
    setConnectionState("testing");
    try {
      const formData = new FormData();
      formData.append("host", host);
      formData.append("apiKey", apiKey);
      const response = await fetch("/api/test-arr-connection", {
        method: "POST",
        body: formData
      });
      const result = await response.json();
      if (result.status && result.connected) {
        setConnectionState("success");
      } else {
        setConnectionState("error");
      }
    } catch (error2) {
      setConnectionState("error");
    }
  }, []);
  return /* @__PURE__ */ jsxs(Card, { className: styles$g.instanceCard, children: [
    /* @__PURE__ */ jsx(
      "button",
      {
        className: styles$g.closeButton,
        onClick: () => onRemove(index),
        "aria-label": "Remove instance",
        children: "×"
      }
    ),
    /* @__PURE__ */ jsxs(Card.Body, { children: [
      /* @__PURE__ */ jsxs(Form$1.Group, { children: [
        /* @__PURE__ */ jsx(Form$1.Label, { children: "Host" }),
        /* @__PURE__ */ jsxs(InputGroup, { className: styles$g.input, children: [
          /* @__PURE__ */ jsx(
            Form$1.Control,
            {
              type: "text",
              placeholder: type === "radarr" ? "http://localhost:7878" : "http://localhost:8989",
              value: instance.Host,
              onChange: (e) => onUpdate(index, "Host", e.target.value)
            }
          ),
          instance.Host.trim() && instance.ApiKey.trim() && /* @__PURE__ */ jsx(
            Button,
            {
              variant: connectionState === "success" ? "success" : connectionState === "error" ? "danger" : "secondary",
              onClick: () => testConnection(instance.Host, instance.ApiKey),
              disabled: connectionState === "testing",
              className: styles$g.testButton,
              children: connectionState === "testing" ? /* @__PURE__ */ jsx(Spinner, { animation: "border", size: "sm" }) : connectionState === "success" ? "✓" : connectionState === "error" ? "✗" : "Test Conn"
            }
          )
        ] })
      ] }),
      /* @__PURE__ */ jsxs(Form$1.Group, { children: [
        /* @__PURE__ */ jsx(Form$1.Label, { children: "API Key" }),
        /* @__PURE__ */ jsx(
          Form$1.Control,
          {
            type: "password",
            className: styles$g.input,
            value: instance.ApiKey,
            onChange: (e) => onUpdate(index, "ApiKey", e.target.value)
          }
        )
      ] })
    ] })
  ] });
}
function isArrsSettingsUpdated(config, newConfig) {
  return config["arr.instances"] !== newConfig["arr.instances"];
}
function isArrsSettingsValid(newConfig) {
  try {
    const arrConfig = JSON.parse(newConfig["arr.instances"] || "{}");
    for (const instance of arrConfig.RadarrInstances || []) {
      if (!isValidHost(instance.Host) || !isValidApiKey(instance.ApiKey)) {
        return false;
      }
    }
    for (const instance of arrConfig.SonarrInstances || []) {
      if (!isValidHost(instance.Host) || !isValidApiKey(instance.ApiKey)) {
        return false;
      }
    }
    return true;
  } catch {
    return false;
  }
}
function isValidHost(host) {
  if (host.trim().length === 0) return false;
  try {
    new URL(host);
    return true;
  } catch {
    return false;
  }
}
function isValidApiKey(apiKey) {
  return apiKey.trim().length > 0;
}
const container$c = "_container_1w3k2_1";
const task = "_task_1w3k2_5";
const run = "_run_1w3k2_13";
const list$1 = "_list_1w3k2_34";
const styles$f = {
  container: container$c,
  task,
  run,
  "run-button": "_run-button_1w3k2_21",
  "dryrun-button": "_dryrun-button_1w3k2_25",
  "task-progress": "_task-progress_1w3k2_29",
  list: list$1,
  "list-item": "_list-item_1w3k2_38"
};
const cleanupTaskTopic = { "ctp": "state" };
function Maintenance({ savedConfig }) {
  const [connected, setConnected] = useState(false);
  const [progress2, setProgress] = useState(null);
  const [isFetching, setIsFetching] = useState(false);
  const libraryDir = savedConfig["media.library-dir"];
  const isDone = progress2 == null ? void 0 : progress2.startsWith("Done");
  const isFinished = (progress2 == null ? void 0 : progress2.startsWith("Done")) || (progress2 == null ? void 0 : progress2.startsWith("Failed")) || (progress2 == null ? void 0 : progress2.startsWith("Aborted"));
  const isRunning = !isFinished && (isFetching || progress2 !== null);
  const isRunButtonEnabled = !!libraryDir && connected && !isRunning;
  const runButtonVariant = isRunButtonEnabled ? "success" : "secondary";
  const runButtonLabel = isRunning ? "⌛ Running.." : "▶ Run Task";
  useEffect(() => {
    let ws;
    let disposed = false;
    function connect() {
      ws = new WebSocket(window.location.origin.replace(/^http/, "ws"));
      ws.onmessage = receiveMessage((_, message) => setProgress(message));
      ws.onopen = () => {
        setConnected(true);
        ws.send(JSON.stringify(cleanupTaskTopic));
      };
      ws.onclose = () => {
        !disposed && setTimeout(() => connect(), 1e3);
        setProgress(null);
      };
      ws.onerror = () => {
        ws.close();
      };
      return () => {
        disposed = true;
        ws.close();
      };
    }
    return connect();
  }, [setProgress, setConnected]);
  const onRun = useCallback(async () => {
    setIsFetching(true);
    await fetch("/api/remove-unlinked-files");
    setIsFetching(false);
  }, [setIsFetching]);
  const onDryRun = useCallback(async (event) => {
    setIsFetching(true);
    await fetch("/api/remove-unlinked-files/dry-run");
    setIsFetching(false);
  }, [setIsFetching]);
  const dryRunButton = /* @__PURE__ */ jsx(
    Button,
    {
      className: styles$f["dryrun-button"],
      disabled: !isRunButtonEnabled,
      onClick: onDryRun,
      variant: "secondary",
      size: "sm",
      children: "perform a dry-run"
    }
  );
  return /* @__PURE__ */ jsxs("div", { className: styles$f.container, children: [
    !libraryDir && /* @__PURE__ */ jsxs(Alert, { variant: "warning", children: [
      "Warning",
      /* @__PURE__ */ jsx("ul", { className: styles$f.list, children: /* @__PURE__ */ jsx("li", { className: styles$f["list-item"], children: "You must first configure the Library Directory setting before running this task. Head over to the Repairs tab." }) })
    ] }),
    libraryDir && /* @__PURE__ */ jsxs(Alert, { variant: "danger", children: [
      /* @__PURE__ */ jsx("span", { style: { fontWeight: "bold" }, children: "Danger" }),
      /* @__PURE__ */ jsxs("ul", { className: styles$f.list, children: [
        /* @__PURE__ */ jsx("li", { className: styles$f["list-item"], children: "Make a backup of your NzbDAV database prior to running this task" }),
        /* @__PURE__ */ jsx("li", { className: styles$f["list-item"], children: "Files will be removed from the webdav and will not be recoverable without a backup" })
      ] })
    ] }),
    /* @__PURE__ */ jsx("div", { className: styles$f.task, children: /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(Form$1.Label, { className: styles$f.title, children: "Removed Unlinked Files" }),
      /* @__PURE__ */ jsxs("div", { className: styles$f.run, children: [
        /* @__PURE__ */ jsx(
          Button,
          {
            className: styles$f["run-button"],
            variant: runButtonVariant,
            onClick: onRun,
            disabled: !isRunButtonEnabled,
            children: runButtonLabel
          }
        ),
        /* @__PURE__ */ jsxs("div", { className: styles$f["task-progress"], children: [
          progress2,
          isDone && /* @__PURE__ */ jsxs(Fragment, { children: [
            " ",
            /* @__PURE__ */ jsx("a", { href: "/api/remove-unlinked-files/audit", children: "Audit." })
          ] })
        ] })
      ] }),
      /* @__PURE__ */ jsxs(Form$1.Text, { id: "cleanup-task-progress-help", muted: true, children: [
        /* @__PURE__ */ jsx("br", {}),
        "This task will scan your organized media library for all symlinked files. Any file on the webdav that is not pointed to by your library will be deleted. If you would like to see what would be deleted without running the task, you can ",
        dryRunButton,
        ". The dry-run will not delete anything."
      ] })
    ] }) })
  ] });
}
const container$b = "_container_1xywg_1";
const input = "_input_1xywg_5";
const error$1 = "_error_1xywg_13";
const styles$e = {
  container: container$b,
  input,
  error: error$1
};
function RepairsSettings({ config, setNewConfig }) {
  const libraryDirConfig = config["media.library-dir"];
  const arrConfig = JSON.parse(config["arr.instances"]);
  const areArrInstancesConfigured = arrConfig.RadarrInstances.length > 0 || arrConfig.SonarrInstances.length > 0;
  const canEnableRepairs = !!libraryDirConfig && areArrInstancesConfigured;
  var helpText = canEnableRepairs ? "When enabled, usenet items will be continuously monitored for health. Unhealthy items will be removed. If an unhealthy item is part of your Radarr/Sonarr library, a new search will be triggered to find a replacement." : "When enabled, usenet items will be continuously monitored for health. Unhealthy items will be removed and replaced. This setting can only be enabled once your Library-Directory and Radarr/Sonarr instances are configured.";
  return /* @__PURE__ */ jsxs("div", { className: styles$e.container, children: [
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(
        Form$1.Check,
        {
          className: styles$e.input,
          type: "checkbox",
          id: "enable-repairs-checkbox",
          "aria-describedby": "enable-repairs-help",
          label: `Enable Background Repairs`,
          checked: canEnableRepairs && config["repair.enable"] === "true",
          disabled: !canEnableRepairs,
          onChange: (e) => setNewConfig({ ...config, "repair.enable": "" + e.target.checked })
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "enable-repairs-help", muted: true, children: helpText })
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(Form$1.Label, { htmlFor: "library-dir-input", children: "Library Directory" }),
      /* @__PURE__ */ jsx(
        Form$1.Control,
        {
          className: styles$e.input,
          type: "text",
          id: "library-dir-input",
          "aria-describedby": "library-dir-help",
          value: config["media.library-dir"],
          onChange: (e) => setNewConfig({ ...config, "media.library-dir": e.target.value })
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "library-dir-help", muted: true, children: "The path to your organized media library that contains all your imported symlinks. Make sure this path is visible to your NzbDAV container." })
    ] }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsxs(Form$1.Group, { children: [
      /* @__PURE__ */ jsx(Form$1.Label, { htmlFor: "repairs-connections-input", children: "Max Connections for Health Checks" }),
      /* @__PURE__ */ jsx(
        Form$1.Control,
        {
          ...className([styles$e.input, !isValidRepairsConnections(config["repair.connections"]) && styles$e.error]),
          type: "text",
          id: "repairs-connections-input",
          "aria-describedby": "repairs-connections-help",
          placeholder: "All",
          value: config["repair.connections"] || "",
          onChange: (e) => setNewConfig({ ...config, "repair.connections": e.target.value })
        }
      ),
      /* @__PURE__ */ jsx(Form$1.Text, { id: "repairs-connections-help", muted: true, children: "The background health-check job will not use any more than this number of connections. Will default to your overall Max Connections if left empty." })
    ] })
  ] });
}
function isRepairsSettingsUpdated(config, newConfig) {
  return config["repair.enable"] !== newConfig["repair.enable"] || config["repair.connections"] !== newConfig["repair.connections"] || config["media.library-dir"] !== newConfig["media.library-dir"];
}
function isRepairsSettingsValid(newConfig) {
  return isValidRepairsConnections(newConfig["repair.connections"]);
}
function isValidRepairsConnections(repairsConnections) {
  return repairsConnections === "" || isNonNegativeInteger(repairsConnections);
}
function isNonNegativeInteger(value) {
  const num = Number(value);
  return Number.isInteger(num) && num >= 0 && value.trim() === num.toString();
}
const defaultConfig = {
  "api.key": "",
  "api.categories": "",
  "api.max-queue-connections": "",
  "api.ensure-importable-video": "true",
  "api.ensure-article-existence": "false",
  "api.ignore-history-limit": "true",
  "api.duplicate-nzb-behavior": "increment",
  "usenet.host": "",
  "usenet.port": "",
  "usenet.use-ssl": "false",
  "usenet.connections": "",
  "usenet.connections-per-stream": "",
  "usenet.user": "",
  "usenet.pass": "",
  "webdav.user": "",
  "webdav.pass": "",
  "webdav.show-hidden-files": "false",
  "webdav.enforce-readonly": "true",
  "webdav.preview-par2-files": "false",
  "rclone.mount-dir": "",
  "media.library-dir": "",
  "arr.instances": '{"RadarrInstances":[],"SonarrInstances":[],"QueueRules":[]}',
  "repair.connections": "",
  "repair.enable": "false"
};
async function loader$5({
  request
}) {
  var configItems = await backendClient.getConfig(Object.keys(defaultConfig));
  const config = defaultConfig;
  for (const item2 of configItems) {
    config[item2.configName] = item2.configValue;
  }
  return {
    config
  };
}
const route$4 = UNSAFE_withComponentProps(function Settings(props) {
  return /* @__PURE__ */ jsx(Body$1, {
    config: props.loaderData.config
  });
});
function Body$1(props) {
  const [config, setConfig] = React.useState(props.config);
  const [newConfig, setNewConfig] = React.useState(config);
  const [isUsenetSettingsReadyToSave, setIsUsenetSettingsReadyToSave] = React.useState(false);
  const [isSaving, setIsSaving] = React.useState(false);
  const [isSaved, setIsSaved] = React.useState(false);
  const [activeTab, setActiveTab] = React.useState("usenet");
  const iseUsenetUpdated = isUsenetSettingsUpdated(config, newConfig);
  const isSabnzbdUpdated = isSabnzbdSettingsUpdated(config, newConfig);
  const isWebdavUpdated = isWebdavSettingsUpdated(config, newConfig);
  const isArrsUpdated = isArrsSettingsUpdated(config, newConfig);
  const isRepairsUpdated = isRepairsSettingsUpdated(config, newConfig);
  const isUpdated = iseUsenetUpdated || isSabnzbdUpdated || isWebdavUpdated || isArrsUpdated || isRepairsUpdated;
  const usenetTitle = iseUsenetUpdated ? "✏️ Usenet" : "Usenet";
  const sabnzbdTitle = isSabnzbdUpdated ? "✏️ SABnzbd " : "SABnzbd";
  const webdavTitle = isWebdavUpdated ? "✏️ WebDAV" : "WebDAV";
  const arrsTitle = isArrsUpdated ? "✏️ Radarr/Sonarr" : "Radarr/Sonarr";
  const repairsTitle = isRepairsUpdated ? "✏️ Repairs" : "Repairs";
  const saveButtonLabel = isSaving ? "Saving..." : !isUpdated && isSaved ? "Saved ✅" : !isUpdated && !isSaved ? "There are no changes to save" : iseUsenetUpdated && !isUsenetSettingsReadyToSave ? "Must test the usenet connection to save" : isSabnzbdUpdated && !isSabnzbdSettingsValid(newConfig) ? "Invalid SABnzbd settings" : isWebdavUpdated && !isWebdavSettingsValid(newConfig) ? "Invalid WebDAV settings" : isArrsUpdated && !isArrsSettingsValid(newConfig) ? "Invalid Arrs settings" : isRepairsUpdated && !isRepairsSettingsValid(newConfig) ? "Invalid Repairs settings" : "Save";
  const saveButtonVariant = saveButtonLabel === "Save" ? "primary" : saveButtonLabel === "Saved ✅" ? "success" : "secondary";
  const isSaveButtonDisabled = saveButtonLabel !== "Save";
  const onClear = React.useCallback(() => {
    setNewConfig(config);
    setIsSaved(false);
  }, [config, setNewConfig]);
  const onUsenetSettingsReadyToSave = React.useCallback((isReadyToSave) => {
    setIsUsenetSettingsReadyToSave(isReadyToSave);
  }, [setIsUsenetSettingsReadyToSave]);
  const onSave = React.useCallback(async () => {
    setIsSaving(true);
    setIsSaved(false);
    const response = await fetch("/settings/update", {
      method: "POST",
      body: (() => {
        const form = new FormData();
        const changedConfig = getChangedConfig(config, newConfig);
        form.append("config", JSON.stringify(changedConfig));
        return form;
      })()
    });
    if (response.ok) {
      setConfig(newConfig);
    }
    setIsSaving(false);
    setIsSaved(true);
  }, [config, newConfig, setIsSaving, setIsSaved, setConfig]);
  return /* @__PURE__ */ jsxs("div", {
    className: styles$k.container,
    children: [/* @__PURE__ */ jsxs(Tabs, {
      activeKey: activeTab,
      onSelect: (x) => setActiveTab(x),
      className: styles$k.tabs,
      children: [/* @__PURE__ */ jsx(Tab, {
        eventKey: "usenet",
        title: usenetTitle,
        children: /* @__PURE__ */ jsx(UsenetSettings, {
          config: newConfig,
          setNewConfig,
          onReadyToSave: onUsenetSettingsReadyToSave
        })
      }), /* @__PURE__ */ jsx(Tab, {
        eventKey: "sabnzbd",
        title: sabnzbdTitle,
        children: /* @__PURE__ */ jsx(SabnzbdSettings, {
          config: newConfig,
          setNewConfig
        })
      }), /* @__PURE__ */ jsx(Tab, {
        eventKey: "webdav",
        title: webdavTitle,
        children: /* @__PURE__ */ jsx(WebdavSettings, {
          config: newConfig,
          setNewConfig
        })
      }), /* @__PURE__ */ jsx(Tab, {
        eventKey: "arrs",
        title: arrsTitle,
        children: /* @__PURE__ */ jsx(ArrsSettings, {
          config: newConfig,
          setNewConfig
        })
      }), /* @__PURE__ */ jsx(Tab, {
        eventKey: "repairs",
        title: repairsTitle,
        children: /* @__PURE__ */ jsx(RepairsSettings, {
          config: newConfig,
          setNewConfig
        })
      }), /* @__PURE__ */ jsx(Tab, {
        eventKey: "maintenance",
        title: "Maintenance",
        children: /* @__PURE__ */ jsx(Maintenance, {
          savedConfig: config
        })
      })]
    }), /* @__PURE__ */ jsx("hr", {}), isUpdated && /* @__PURE__ */ jsx(Button, {
      className: styles$k.button,
      variant: "secondary",
      disabled: !isUpdated,
      onClick: () => onClear(),
      children: "Clear"
    }), /* @__PURE__ */ jsx(Button, {
      className: styles$k.button,
      variant: saveButtonVariant,
      disabled: isSaveButtonDisabled,
      onClick: onSave,
      children: saveButtonLabel
    })]
  });
}
function getChangedConfig(config, newConfig) {
  let changedConfig = {};
  let configKeys = Object.keys(defaultConfig);
  for (const configKey of configKeys) {
    if (config[configKey] !== newConfig[configKey]) {
      changedConfig[configKey] = newConfig[configKey];
    }
  }
  return changedConfig;
}
const route2 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: route$4,
  loader: loader$5
}, Symbol.toStringTag, { value: "Module" }));
async function action$3({
  request
}) {
  let session = await sessionStorage.getSession(request.headers.get("cookie"));
  let user = session.get("user");
  if (!user) return redirect("/login");
  const formData = await request.formData();
  const configJson = formData.get("config").toString();
  const config = JSON.parse(configJson);
  const configItems = [];
  for (const [key, value] of Object.entries(config)) {
    configItems.push({
      configName: key,
      configValue: value
    });
  }
  await backendClient.updateConfig(configItems);
  return {
    config
  };
}
const route3 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action: action$3
}, Symbol.toStringTag, { value: "Module" }));
const container$a = "_container_137fq_1";
const home = "_home_137fq_11";
const separator = "_separator_137fq_28";
const directory = "_directory_137fq_38";
const styles$d = {
  container: container$a,
  home,
  "home-icon": "_home-icon_137fq_17",
  separator,
  directory
};
function Breadcrumbs({ parentDirectories }) {
  const navigate = useNavigate();
  const onClick = useCallback((index) => {
    if (index === -1) return navigate("/explore");
    navigate(`/explore/${parentDirectories.slice(0, index + 1).join("/")}`);
  }, [parentDirectories, navigate]);
  return /* @__PURE__ */ jsxs("div", { className: styles$d.container, children: [
    /* @__PURE__ */ jsxs("div", { ...className([styles$d.home, styles$d.directory]), onClick: () => onClick(-1), children: [
      /* @__PURE__ */ jsx("div", { className: styles$d["home-icon"] }),
      parentDirectories.length == 0 && /* @__PURE__ */ jsx("div", { children: "home" })
    ] }),
    parentDirectories.map(
      (parentDirectory, index) => /* @__PURE__ */ jsxs(React.Fragment, { children: [
        /* @__PURE__ */ jsx("div", { className: styles$d.separator }),
        /* @__PURE__ */ jsx("div", { className: styles$d.directory, onClick: () => onClick(index), children: parentDirectory })
      ] }, index)
    )
  ] });
}
const container$9 = "_container_4zugh_1";
const item = "_item_4zugh_12";
const loading = "_loading_4zugh_108";
const hidden = "_hidden_4zugh_115";
const styles$c = {
  container: container$9,
  item,
  "directory-icon": "_directory-icon_4zugh_51",
  "file-icon": "_file-icon_4zugh_61",
  "video-icon": "_video-icon_4zugh_71",
  "image-icon": "_image-icon_4zugh_80",
  "item-info": "_item-info_4zugh_89",
  "item-name": "_item-name_4zugh_97",
  "item-size": "_item-size_4zugh_102",
  loading,
  hidden
};
function getDownloadKey(path2) {
  var input2 = `${path2}_${process.env.FRONTEND_BACKEND_API_KEY}`;
  return createHash("sha256").update(input2).digest("hex");
}
function formatFileSize(bytes) {
  var suffix = "B";
  if (bytes === null || bytes === void 0) return "unknown size";
  if (bytes >= 1024) {
    bytes /= 1024;
    suffix = "KB";
  }
  if (bytes >= 1024) {
    bytes /= 1024;
    suffix = "MB";
  }
  if (bytes >= 1024) {
    bytes /= 1024;
    suffix = "GB";
  }
  if (bytes >= 1024) {
    bytes /= 1024;
    suffix = "TB";
  }
  if (bytes >= 1024) {
    bytes /= 1024;
    suffix = "PB";
  }
  return `${parseFloat(bytes.toFixed(2))} ${suffix}`;
}
async function loader$4({
  request
}) {
  if (request.url.endsWith("/")) return redirect(request.url.slice(0, -1));
  let path2 = getWebdavPathDecoded(new URL(request.url).pathname);
  return {
    parentDirectories: getParentDirectories(path2),
    items: (await backendClient.listWebdavDirectory(path2)).map((x) => {
      if (x.isDirectory) return x;
      return {
        ...x,
        mimeType: lookup(x.name),
        downloadKey: getDownloadKey(`${path2}/${x.name}`)
      };
    })
  };
}
const route$3 = UNSAFE_withComponentProps(function Explore({
  loaderData
}) {
  return /* @__PURE__ */ jsx(Body, {
    ...loaderData
  });
});
function Body(props) {
  const location = useLocation();
  const navigation = useNavigation();
  const isNavigating = Boolean(navigation.location);
  const items = props.items;
  const parentDirectories = isNavigating ? getParentDirectories(getWebdavPathDecoded(navigation.location.pathname)) : props.parentDirectories;
  const getDirectoryPath = useCallback((directoryName) => {
    return `${location.pathname}/${encodeURIComponent(directoryName)}`;
  }, [location.pathname]);
  const getFilePath = useCallback((file) => {
    var pathname = getWebdavPath(location.pathname);
    return `/view/${pathname}/${encodeURIComponent(file.name)}?downloadKey=${file.downloadKey}`;
  }, [location.pathname]);
  return /* @__PURE__ */ jsxs("div", {
    className: styles$c.container,
    children: [/* @__PURE__ */ jsx(Breadcrumbs, {
      parentDirectories
    }), !isNavigating && /* @__PURE__ */ jsxs("div", {
      children: [items.filter((x) => x.isDirectory).map((x, index) => /* @__PURE__ */ jsxs(Link, {
        to: getDirectoryPath(x.name),
        className: getClassName(x),
        children: [/* @__PURE__ */ jsx("div", {
          className: styles$c["directory-icon"]
        }), /* @__PURE__ */ jsx("div", {
          className: styles$c["item-name"],
          children: x.name
        })]
      }, `${index}_dir_item`)), items.filter((x) => !x.isDirectory).map((x, index) => /* @__PURE__ */ jsxs("a", {
        href: getFilePath(x),
        className: getClassName(x),
        children: [/* @__PURE__ */ jsx("div", {
          className: getIcon(x)
        }), /* @__PURE__ */ jsxs("div", {
          className: styles$c["item-info"],
          children: [/* @__PURE__ */ jsx("div", {
            className: styles$c["item-name"],
            children: x.name
          }), /* @__PURE__ */ jsx("div", {
            className: styles$c["item-size"],
            children: formatFileSize(x.size)
          })]
        })]
      }, `${index}_file_item`))]
    }), isNavigating && /* @__PURE__ */ jsx(Loading, {
      className: styles$c.loading
    })]
  });
}
function getIcon(file) {
  if (file.name.toLowerCase().endsWith(".mkv")) return styles$c["video-icon"];
  if (file.mimeType && file.mimeType.startsWith("video")) return styles$c["video-icon"];
  if (file.mimeType && file.mimeType.startsWith("image")) return styles$c["image-icon"];
  return styles$c["file-icon"];
}
function getWebdavPath(pathname) {
  if (pathname.startsWith("/")) pathname = pathname.slice(1);
  if (pathname.startsWith("explore")) pathname = pathname.slice(7);
  if (pathname.startsWith("/")) pathname = pathname.slice(1);
  return pathname;
}
function getWebdavPathDecoded(pathname) {
  return decodeURIComponent(getWebdavPath(pathname));
}
function getParentDirectories(webdavPath) {
  return webdavPath == "" ? [] : webdavPath.split("/");
}
function getClassName(item2) {
  let className2 = styles$c.item;
  if (item2.name.startsWith(".")) className2 += " " + styles$c.hidden;
  return className2;
}
const route10 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: route$3,
  loader: loader$4
}, Symbol.toStringTag, { value: "Module" }));
async function loader$3({
  request
}) {
  return redirect("/queue");
}
const route5 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  loader: loader$3
}, Symbol.toStringTag, { value: "Module" }));
const container$8 = "_container_10cc5_1";
const alert = "_alert_10cc5_9";
const list = "_list_10cc5_12";
const listItem = "_listItem_10cc5_16";
const section$1 = "_section_10cc5_21";
const styles$b = {
  container: container$8,
  alert,
  list,
  listItem,
  section: section$1
};
const container$7 = "_container_1hgi7_1";
const header$1 = "_header_1hgi7_11";
const title$2 = "_title_1hgi7_20";
const count = "_count_1hgi7_27";
const tableContainer = "_tableContainer_1hgi7_37";
const table = "_table_1hgi7_37";
const nameContainer = "_nameContainer_1hgi7_87";
const name = "_name_1hgi7_87";
const path = "_path_1hgi7_101";
const dateCell = "_dateCell_1hgi7_109";
const emptyState = "_emptyState_1hgi7_115";
const emptyIcon = "_emptyIcon_1hgi7_121";
const emptyTitle = "_emptyTitle_1hgi7_127";
const emptyDescription = "_emptyDescription_1hgi7_134";
const dateDetailsTable = "_dateDetailsTable_1hgi7_141";
const dateDetailsRow = "_dateDetailsRow_1hgi7_149";
const dateDetailsLabel = "_dateDetailsLabel_1hgi7_166";
const dateDetailsValue = "_dateDetailsValue_1hgi7_175";
const mobile$1 = "_mobile_1hgi7_184";
const dateBadge = "_dateBadge_1hgi7_188";
const desktop$1 = "_desktop_1hgi7_196";
const styles$a = {
  container: container$7,
  header: header$1,
  title: title$2,
  count,
  tableContainer,
  table,
  nameContainer,
  name,
  path,
  dateCell,
  emptyState,
  emptyIcon,
  emptyTitle,
  emptyDescription,
  dateDetailsTable,
  dateDetailsRow,
  dateDetailsLabel,
  dateDetailsValue,
  mobile: mobile$1,
  dateBadge,
  desktop: desktop$1
};
const truncate = "_truncate_3f6j8_1";
const styles$9 = {
  truncate
};
function Truncate({ children }) {
  return /* @__PURE__ */ jsx("div", { className: styles$9.truncate, children });
}
const container$6 = "_container_rctjm_1";
const badge = "_badge_rctjm_5";
const progress = "_progress_rctjm_25";
const gray = "_gray_rctjm_35";
const healthcheckProgress = "_healthcheckProgress_rctjm_40";
const styles$8 = {
  container: container$6,
  badge,
  "badge-text": "_badge-text_rctjm_21",
  progress,
  gray,
  healthcheckProgress,
  "failure-badge": "_failure-badge_rctjm_52"
};
function StatusBadge({ status, percentage, error: error2 }) {
  const statusLower = status == null ? void 0 : status.toLowerCase();
  const percentNum = statusLower === "downloading" ? Number(percentage) : 0;
  let color = "grey";
  if (statusLower === "completed") color = "rgba(var(--bs-success-rgb)";
  if (statusLower === "failed") color = "rgba(var(--bs-danger-rgb)";
  if (statusLower === "downloading" || percentNum > 0) color = `#333`;
  let badgeText = statusLower;
  if (statusLower === "downloading" || percentNum > 0)
    badgeText = `${percentNum > 100 ? percentNum - 100 : percentNum}%`;
  if (error2 == null ? void 0 : error2.startsWith("Article with message-id")) error2 = "Missing articles";
  const badgeClass = statusLower === "failed" ? styles$8["failure-badge"] : "";
  const overlay = statusLower == "failed" ? /* @__PURE__ */ jsx(Tooltip, { children: error2 }) : /* @__PURE__ */ jsx(Fragment, {});
  return /* @__PURE__ */ jsx(OverlayTrigger, { placement: "top", overlay, trigger: "click", children: /* @__PURE__ */ jsx("div", { className: styles$8.container, children: /* @__PURE__ */ jsx(ProgressBadge, { className: badgeClass, color, percentNum, children: badgeText }) }) });
}
function ProgressBadge(props) {
  const isHealthCheck = props.percentNum > 100;
  const progressOneClass = isHealthCheck ? `${styles$8.progress} ${styles$8.gray}` : styles$8.progress;
  const progressOneStyle = props.percentNum >= 0 ? { width: `${Math.min(props.percentNum, 100)}%` } : void 0;
  const progressTwoClass = `${styles$8.progress} ${styles$8.healthcheckProgress}`;
  const progressTwoStyle = isHealthCheck ? { width: `${Math.min(props.percentNum - 100, 100)}%` } : void 0;
  return /* @__PURE__ */ jsxs("div", { ...className([styles$8.badge, props.className]), style: { backgroundColor: props.color }, children: [
    /* @__PURE__ */ jsx("div", { className: progressOneClass, style: progressOneStyle }),
    /* @__PURE__ */ jsx("div", { className: progressTwoClass, style: progressTwoStyle }),
    /* @__PURE__ */ jsx("div", { className: styles$8["badge-text"], children: props.children })
  ] });
}
function HealthTable({ isEnabled, healthCheckItems }) {
  return /* @__PURE__ */ jsxs("div", { className: styles$a.container, children: [
    /* @__PURE__ */ jsxs("div", { className: styles$a.header, children: [
      /* @__PURE__ */ jsx("h3", { className: styles$a.title, children: "Health Check Queue" }),
      /* @__PURE__ */ jsxs("div", { className: styles$a.count, children: [
        "Only ",
        healthCheckItems.length,
        " shown"
      ] })
    ] }),
    !isEnabled ? /* @__PURE__ */ jsxs("div", { className: styles$a.emptyState, children: [
      /* @__PURE__ */ jsx("div", { className: styles$a.emptyIcon, children: "🩺💙💪" }),
      /* @__PURE__ */ jsx("div", { className: styles$a.emptyTitle, children: "Enable Repairs In Settings" }),
      /* @__PURE__ */ jsx("div", { className: styles$a.emptyDescription, children: "Once you enable repairs, all mounted usenet files will be queued for continuous health monitoring" })
    ] }) : healthCheckItems.length === 0 ? /* @__PURE__ */ jsxs("div", { className: styles$a.emptyState, children: [
      /* @__PURE__ */ jsx("div", { className: styles$a.emptyIcon, children: "🩺💙💪" }),
      /* @__PURE__ */ jsx("div", { className: styles$a.emptyTitle, children: "No Items To Health-Check" }),
      /* @__PURE__ */ jsx("div", { className: styles$a.emptyDescription, children: "Once you begin processing nzbs, the mounted usenet files will be queued for continuous health monitoring" })
    ] }) : /* @__PURE__ */ jsx("div", { className: styles$a.tableContainer, children: /* @__PURE__ */ jsxs(Table, { className: styles$a.table, responsive: true, children: [
      /* @__PURE__ */ jsx("thead", { className: styles$a.desktop, children: /* @__PURE__ */ jsxs("tr", { children: [
        /* @__PURE__ */ jsx("th", { children: "Name" }),
        /* @__PURE__ */ jsx("th", { className: styles$a.desktop, children: "Created" }),
        /* @__PURE__ */ jsx("th", { className: styles$a.desktop, children: "Last Check" }),
        /* @__PURE__ */ jsx("th", { className: styles$a.desktop, children: "Next Check" })
      ] }) }),
      /* @__PURE__ */ jsx("tbody", { children: healthCheckItems.map((item2) => /* @__PURE__ */ jsxs("tr", { className: styles$a.tableRow, children: [
        /* @__PURE__ */ jsx("td", { className: styles$a.nameCell, children: /* @__PURE__ */ jsxs("div", { className: styles$a.nameContainer, children: [
          /* @__PURE__ */ jsx("div", { className: styles$a.name, children: /* @__PURE__ */ jsx(Truncate, { children: item2.name }) }),
          /* @__PURE__ */ jsx("div", { className: styles$a.path, children: /* @__PURE__ */ jsx(Truncate, { children: item2.path }) }),
          /* @__PURE__ */ jsx("div", { className: styles$a.mobile, children: /* @__PURE__ */ jsx(DateDetailsTable, { item: item2 }) })
        ] }) }),
        /* @__PURE__ */ jsx("td", { className: `${styles$a.dateCell} ${styles$a.desktop}`, children: formatDateBadge(item2.releaseDate, "Unknown", "info") }),
        /* @__PURE__ */ jsx("td", { className: `${styles$a.dateCell} ${styles$a.desktop}`, children: formatDateBadge(item2.lastHealthCheck, "Never", "warning") }),
        /* @__PURE__ */ jsx("td", { className: `${styles$a.dateCell} ${styles$a.desktop}`, children: item2.progress > 0 ? /* @__PURE__ */ jsxs(ProgressBadge, { className: styles$a.dateBadge, color: "#333", percentNum: 100 + item2.progress, children: [
          item2.progress,
          "%"
        ] }) : formatDateBadge(item2.nextHealthCheck, "ASAP", "success") })
      ] }, item2.id)) })
    ] }) })
  ] });
}
function DateDetailsTable({ item: item2 }) {
  return /* @__PURE__ */ jsxs("div", { className: styles$a.dateDetailsTable, children: [
    /* @__PURE__ */ jsxs("div", { className: styles$a.dateDetailsRow, children: [
      /* @__PURE__ */ jsx("div", { className: styles$a.dateDetailsLabel, children: "Created" }),
      /* @__PURE__ */ jsx("div", { className: styles$a.dateDetailsValue, children: formatDateBadge(item2.releaseDate, "Unknown", "info") })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: styles$a.dateDetailsRow, children: [
      /* @__PURE__ */ jsx("div", { className: styles$a.dateDetailsLabel, children: "Last Health Check" }),
      /* @__PURE__ */ jsx("div", { className: styles$a.dateDetailsValue, children: formatDateBadge(item2.lastHealthCheck, "Never", "warning") })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: styles$a.dateDetailsRow, children: [
      /* @__PURE__ */ jsx("div", { className: styles$a.dateDetailsLabel, children: "Next Health Check" }),
      /* @__PURE__ */ jsx("div", { className: styles$a.dateDetailsValue, children: item2.progress > 0 ? /* @__PURE__ */ jsxs(ProgressBadge, { className: styles$a.dateBadge, color: "#333", percentNum: 100 + item2.progress, children: [
        item2.progress,
        "%"
      ] }) : formatDateBadge(item2.nextHealthCheck, "ASAP", "success") })
    ] })
  ] });
}
function formatDate(dateString, fallback) {
  try {
    if (!dateString) return fallback;
    const now = /* @__PURE__ */ new Date();
    const datetime = new Date(dateString);
    return isSameDate(datetime, now) ? datetime.toLocaleTimeString([], { hour: "numeric", minute: "2-digit" }) : datetime.toLocaleDateString();
  } catch {
    return "Unknown";
  }
}
function formatDateBadge(dateString, fallback, variant) {
  const dateText = formatDate(dateString, fallback);
  return /* @__PURE__ */ jsx(Badge, { bg: variant, className: styles$a.dateBadge, children: dateText });
}
function isSameDate(one, two) {
  return one.getFullYear() === two.getFullYear() && one.getMonth() === two.getMonth() && one.getDate() === two.getDate();
}
const container$5 = "_container_1yd34_1";
const header = "_header_1yd34_9";
const title$1 = "_title_1yd34_18";
const statusIndicator = "_statusIndicator_1yd34_25";
const statusLabel = "_statusLabel_1yd34_38";
const statsGrid = "_statsGrid_1yd34_44";
const statCard = "_statCard_1yd34_50";
const statNumber = "_statNumber_1yd34_59";
const statLabel = "_statLabel_1yd34_67";
const styles$7 = {
  container: container$5,
  header,
  title: title$1,
  statusIndicator,
  statusLabel,
  statsGrid,
  statCard,
  statNumber,
  statLabel
};
function HealthStats({ stats }) {
  const totalChecked = stats.reduce((sum, stat) => sum + stat.count, 0);
  const healthy = stats.filter(
    (stat) => stat.result === 0
    /* Healthy */
  ).reduce((sum, stat) => sum + stat.count, 0);
  const repaired = stats.filter(
    (stat) => stat.repairStatus === 1
    /* Repaired */
  ).reduce((sum, stat) => sum + stat.count, 0);
  const deleted = stats.filter(
    (stat) => stat.repairStatus === 2
    /* Deleted */
  ).reduce((sum, stat) => sum + stat.count, 0);
  const getPercentage = (count2) => {
    return totalChecked > 0 ? Math.round(count2 / totalChecked * 100) : 0;
  };
  return /* @__PURE__ */ jsxs("div", { className: styles$7.container, children: [
    /* @__PURE__ */ jsxs("div", { className: styles$7.header, children: [
      /* @__PURE__ */ jsx("h3", { className: styles$7.title, children: "Health Overview" }),
      /* @__PURE__ */ jsx("div", { className: styles$7.statusIndicator, children: /* @__PURE__ */ jsx("span", { className: styles$7.statusLabel, children: "Last 30 Days" }) })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: styles$7.statsGrid, children: [
      /* @__PURE__ */ jsxs("div", { className: styles$7.statCard, children: [
        /* @__PURE__ */ jsx("div", { className: styles$7.statNumber, children: totalChecked }),
        /* @__PURE__ */ jsx("div", { className: styles$7.statLabel, children: "Total Checked" })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: styles$7.statCard, children: [
        /* @__PURE__ */ jsx("div", { className: styles$7.statNumber, style: { color: "#198754" }, children: healthy }),
        /* @__PURE__ */ jsxs("div", { className: styles$7.statLabel, children: [
          "Healthy (",
          getPercentage(healthy),
          "%)"
        ] })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: styles$7.statCard, children: [
        /* @__PURE__ */ jsx("div", { className: styles$7.statNumber, style: { color: "#17a2b8" }, children: repaired }),
        /* @__PURE__ */ jsxs("div", { className: styles$7.statLabel, children: [
          "Repaired (",
          getPercentage(repaired),
          "%)"
        ] })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: styles$7.statCard, children: [
        /* @__PURE__ */ jsx("div", { className: styles$7.statNumber, style: { color: "#dc3545" }, children: deleted }),
        /* @__PURE__ */ jsxs("div", { className: styles$7.statLabel, children: [
          "Deleted (",
          getPercentage(deleted),
          "%)"
        ] })
      ] })
    ] })
  ] });
}
const topicNames$1 = {
  healthItemStatus: "hs",
  healthItemProgress: "hp"
};
const topicSubscriptions$1 = {
  [topicNames$1.healthItemStatus]: "event",
  [topicNames$1.healthItemProgress]: "event"
};
async function loader$2() {
  const enabledKey = "repair.enable";
  const [queueData, historyData, config] = await Promise.all([backendClient.getHealthCheckQueue(30), backendClient.getHealthCheckHistory(), backendClient.getConfig([enabledKey])]);
  return {
    uncheckedCount: queueData.uncheckedCount,
    queueItems: queueData.items,
    historyStats: historyData.stats,
    historyItems: historyData.items,
    isEnabled: config.filter((x) => x.configName === enabledKey).filter((x) => x.configValue.toLowerCase() === "true").length > 0
  };
}
const route$2 = UNSAFE_withComponentProps(function Health({
  loaderData
}) {
  const {
    isEnabled
  } = loaderData;
  const [historyStats, setHistoryStats] = useState(loaderData.historyStats);
  const [queueItems, setQueueItems] = useState(loaderData.queueItems);
  const [uncheckedCount, setUncheckedCount] = useState(loaderData.uncheckedCount);
  useEffect(() => {
    if (queueItems.length >= 15) return;
    const refetchData = async () => {
      var response = await fetch("/api/get-health-check-queue?pageSize=30");
      if (response.ok) {
        const healthCheckQueue = await response.json();
        setQueueItems(healthCheckQueue.items);
        setUncheckedCount(healthCheckQueue.uncheckedCount);
      }
    };
    refetchData();
  }, [queueItems, setQueueItems]);
  const onHealthItemStatus = useCallback(async (message) => {
    const [davItemId, healthResult, repairAction] = message.split("|");
    setQueueItems((x) => x.filter((item2) => item2.id !== davItemId));
    setUncheckedCount((x) => x - 1);
    setHistoryStats((x) => {
      const healthResultNum = Number(healthResult);
      const repairActionNum = Number(repairAction);
      let updated = false;
      const newStats = x.map((stat) => {
        if (stat.result === healthResultNum && stat.repairStatus === repairActionNum) {
          updated = true;
          return {
            ...stat,
            count: stat.count + 1
          };
        }
        return stat;
      });
      if (!updated) {
        return [...x, {
          result: healthResultNum,
          repairStatus: repairActionNum,
          count: 1
        }];
      }
      return newStats;
    });
  }, [setQueueItems, setHistoryStats]);
  const onHealthItemProgress = useCallback((message) => {
    const [davItemId, progress2] = message.split("|");
    if (progress2 === "done") return;
    setQueueItems((queueItems2) => {
      var index = queueItems2.findIndex((x) => x.id === davItemId);
      if (index === -1) return queueItems2;
      return queueItems2.filter((_, i) => i >= index).map((item2) => item2.id === davItemId ? {
        ...item2,
        progress: Number(progress2)
      } : item2);
    });
  }, [setQueueItems]);
  const onWebsocketMessage = useCallback((topic, message) => {
    if (topic == topicNames$1.healthItemStatus) onHealthItemStatus(message);
    else if (topic == topicNames$1.healthItemProgress) onHealthItemProgress(message);
  }, [onHealthItemStatus, onHealthItemProgress]);
  useEffect(() => {
    let ws;
    let disposed = false;
    function connect() {
      ws = new WebSocket(window.location.origin.replace(/^http/, "ws"));
      ws.onmessage = receiveMessage(onWebsocketMessage);
      ws.onopen = () => {
        ws.send(JSON.stringify(topicSubscriptions$1));
      };
      ws.onclose = () => {
        !disposed && setTimeout(() => connect(), 1e3);
      };
      ws.onerror = () => {
        ws.close();
      };
      return () => {
        disposed = true;
        ws.close();
      };
    }
    return connect();
  }, [onWebsocketMessage]);
  return /* @__PURE__ */ jsxs("div", {
    className: styles$b.container,
    children: [/* @__PURE__ */ jsx("div", {
      className: styles$b.section,
      children: /* @__PURE__ */ jsx(HealthStats, {
        stats: historyStats
      })
    }), isEnabled && uncheckedCount > 20 && /* @__PURE__ */ jsxs(Alert, {
      className: styles$b.alert,
      variant: "warning",
      children: [/* @__PURE__ */ jsx("b", {
        children: "Attention"
      }), /* @__PURE__ */ jsxs("ul", {
        className: styles$b.list,
        children: [/* @__PURE__ */ jsxs("li", {
          className: styles$b.listItem,
          children: ["You have ~", uncheckedCount, " files whose health has never been determined."]
        }), /* @__PURE__ */ jsx("li", {
          className: styles$b.listItem,
          children: "The queue will run an initial health check of these files."
        }), /* @__PURE__ */ jsx("li", {
          className: styles$b.listItem,
          children: "Under normal operation, health checks will occur much less frequently."
        })]
      })]
    }), /* @__PURE__ */ jsx("div", {
      className: styles$b.section,
      children: /* @__PURE__ */ jsx(HealthTable, {
        isEnabled,
        healthCheckItems: queueItems.filter((_, index) => index < 10)
      })
    })]
  });
});
const route6 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  default: route$2,
  loader: loader$2
}, Symbol.toStringTag, { value: "Module" }));
async function action$2({
  request
}) {
  var _a;
  let session = await sessionStorage.getSession(request.headers.get("cookie"));
  let user = session.get("user");
  if (!user) return redirect("/login");
  const formData = await request.formData();
  const confirm = (_a = formData.get("confirm")) == null ? void 0 : _a.toString();
  if (confirm !== "true") return redirect("/");
  session.unset("user");
  return redirect("/login", {
    headers: {
      "Set-Cookie": await sessionStorage.commitSession(session)
    }
  });
}
const route7 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action: action$2
}, Symbol.toStringTag, { value: "Module" }));
const container$4 = "_container_1rge5_1";
const logo = "_logo_1rge5_13";
const title = "_title_1rge5_17";
const error = "_error_1rge5_25";
const styles$6 = {
  container: container$4,
  logo,
  title,
  error
};
async function loader$1({
  request
}) {
  let session = await sessionStorage.getSession(request.headers.get("cookie"));
  let user = session.get("user");
  if (user) return redirect("/");
  const isOnboarding = await backendClient.isOnboarding();
  if (isOnboarding) return redirect("/onboarding");
  return {
    loginError: null
  };
}
const route$1 = UNSAFE_withComponentProps(function Index2({
  loaderData,
  actionData
}) {
  const navigation = useNavigation();
  const isLoading = navigation.state == "submitting";
  const pageData = actionData || loaderData;
  const showError = !!pageData.loginError;
  const submitButtonDisabled = isLoading;
  const submitButtonText = isLoading ? "Logging in..." : "Login";
  return /* @__PURE__ */ jsxs(Form, {
    className: styles$6["container"],
    method: "POST",
    children: [/* @__PURE__ */ jsx("img", {
      className: styles$6["logo"],
      src: "/logo.svg"
    }), /* @__PURE__ */ jsx("div", {
      className: styles$6["title"],
      children: "Nzb DAV"
    }), /* @__PURE__ */ jsx(Alert, {
      className: styles$6["error"],
      show: showError,
      variant: "danger",
      children: pageData.loginError
    }), /* @__PURE__ */ jsx(Form$1.Control, {
      name: "username",
      type: "text",
      placeholder: "Username",
      autoFocus: true
    }), /* @__PURE__ */ jsx(Form$1.Control, {
      name: "password",
      type: "password",
      placeholder: "Password"
    }), /* @__PURE__ */ jsx(Button, {
      type: "submit",
      variant: "primary",
      disabled: submitButtonDisabled,
      children: submitButtonText
    })]
  });
});
async function action$1({
  request
}) {
  try {
    let user = await authenticate(request);
    let session = await sessionStorage.getSession(request.headers.get("cookie"));
    session.set("user", user);
    return redirect("/", {
      headers: {
        "Set-Cookie": await sessionStorage.commitSession(session)
      }
    });
  } catch (error2) {
    if (error2 instanceof Error) {
      return {
        loginError: error2.message
      };
    }
    throw error2;
  }
}
const route8 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action: action$1,
  default: route$1,
  loader: loader$1
}, Symbol.toStringTag, { value: "Module" }));
const container$3 = "_container_1grcp_1";
const section = "_section_1grcp_9";
const styles$5 = {
  container: container$3,
  section,
  "section-title": "_section-title_1grcp_13"
};
const container$2 = "_container_opxzb_1";
const styles$4 = {
  container: container$2,
  "upload-icon": "_upload-icon_opxzb_22",
  "drop-icon": "_drop-icon_opxzb_31",
  "drag-active": "_drag-active_opxzb_40"
};
function EmptyQueue() {
  const fetcher = useFetcher();
  const formRef = useRef(null);
  const inputRef = useRef(null);
  const isSubmitting = fetcher.state === "submitting";
  const { getRootProps, getInputProps, isDragActive } = useDropzone({
    accept: { "application/x-nzb": [".nzb"] },
    onDrop: useCallback((acceptedFiles) => {
      const dataTransfer = new DataTransfer();
      acceptedFiles.forEach((file) => {
        const newFile = new File([file], file.name, {
          type: "application/x-nzb",
          lastModified: file.lastModified
        });
        dataTransfer.items.add(newFile);
      });
      if (inputRef == null ? void 0 : inputRef.current) {
        inputRef.current.files = dataTransfer.files;
        fetcher.submit(formRef.current);
      }
    }, [])
  });
  return /* @__PURE__ */ jsxs(fetcher.Form, { ref: formRef, method: "POST", encType: "multipart/form-data", children: [
    /* @__PURE__ */ jsx("div", { className: styles$5["section-title"], children: /* @__PURE__ */ jsx("h3", { children: "Queue" }) }),
    /* @__PURE__ */ jsxs("div", { ...className([styles$4.container, isDragActive && styles$4["drag-active"]]), ...getRootProps(), children: [
      /* @__PURE__ */ jsx("input", { ...getInputProps() }),
      /* @__PURE__ */ jsx("input", { ref: inputRef, name: "nzbFile", type: "file", style: { display: "none" } }),
      isSubmitting && /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsx("div", { children: "Uploading..." }) }),
      !isSubmitting && !isDragActive && /* @__PURE__ */ jsxs(Fragment, { children: [
        /* @__PURE__ */ jsx("div", { className: styles$4["upload-icon"] }),
        /* @__PURE__ */ jsx("br", {}),
        /* @__PURE__ */ jsx("div", { children: "Queue is empty." }),
        /* @__PURE__ */ jsx("div", { children: "Upload an *.nzb file" })
      ] }),
      !isSubmitting && isDragActive && /* @__PURE__ */ jsxs(Fragment, { children: [
        /* @__PURE__ */ jsx("div", { className: styles$4["drop-icon"] }),
        /* @__PURE__ */ jsx("br", {}),
        /* @__PURE__ */ jsx("div", { children: "Drop your *.nzb file" })
      ] })
    ] })
  ] });
}
const text = "_text_yz69u_36";
const styles$3 = {
  "action-button": "_action-button_yz69u_1",
  "trash-icon": "_trash-icon_yz69u_12",
  "directory-icon": "_directory-icon_yz69u_16",
  text
};
function ActionButton({ type, text: text2, disabled, onClick }) {
  const variant = type === "delete" ? "outline-danger" : "outline-warning";
  return /* @__PURE__ */ jsxs(
    Button,
    {
      className: styles$3["action-button"],
      variant,
      onClick,
      disabled,
      children: [
        type === "delete" && /* @__PURE__ */ jsx(TrashIcon, {}),
        type === "explore" && /* @__PURE__ */ jsx(DirectoryIcon, {}),
        text2 && /* @__PURE__ */ jsx("div", { className: styles$3.text, children: text2 })
      ]
    }
  );
}
function DirectoryIcon() {
  return /* @__PURE__ */ jsx("svg", { className: styles$3["directory-icon"], xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 22 24", children: /* @__PURE__ */ jsx("path", { d: "M2 4.75C2 3.784 2.784 3 3.75 3h4.971c.58 0 1.12.286 1.447.765l1.404 2.063a.25.25 0 0 0 .207.11h6.224c.966 0 1.75.783 1.75 1.75v.117H5.408a.848.848 0 0 0 0 1.695h15.484a1 1 0 0 1 .995 1.102L21 19.25c-.106 1.05-.784 1.75-1.75 1.75H3.75A1.75 1.75 0 0 1 2 19.25z" }) });
}
function TrashIcon() {
  return /* @__PURE__ */ jsx("svg", { className: styles$3["trash-icon"], xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 22 24", children: /* @__PURE__ */ jsx("path", { d: "M16.313 4V2.144C16.313.96 15.353 0 14.169 0H7.831A2.14 2.14 0 0 0 5.69 2.189v-.002V4H0v2h.575c.196.023.372.099.515.214l-.002-.002c.119.157.203.346.239.552l.001.008l1.187 15.106c.094 1.84.094 2.118 2.25 2.118h12.462c2.16 0 2.16-.275 2.25-2.113l1.187-15.1c.036-.217.12-.409.242-.572l-.002.003a1 1 0 0 1 .508-.212h.58v-2h-5.687zM7 2.187c0-.6.487-.938 1.106-.938h5.734c.618 0 1.162.344 1.162.938V4h-8zM6.469 20l-.64-12h1.269l.656 12zm5.225 0H10.32V8h1.375zm3.85 0h-1.275l.656-12h1.269z" }) });
}
const container$1 = "_container_ybcdo_1";
const removing = "_removing_ybcdo_68";
const badges = "_badges_ybcdo_73";
const actions = "_actions_ybcdo_80";
const mobile = "_mobile_ybcdo_90";
const desktop = "_desktop_ybcdo_101";
const styles$2 = {
  container: container$1,
  "page-table": "_page-table_ybcdo_5",
  removing,
  badges,
  actions,
  mobile,
  desktop
};
const container = "_container_12mvz_1";
const checkbox = "_checkbox_12mvz_8";
const styles$1 = {
  container,
  checkbox
};
function TriCheckbox({ state, onChange, children }) {
  const checkboxRef = useRef(null);
  useEffect(() => {
    if (checkboxRef && checkboxRef.current) {
      checkboxRef.current.indeterminate = state === "some";
    }
  }, [checkboxRef, state]);
  return /* @__PURE__ */ jsxs("div", { className: styles$1.container, children: [
    /* @__PURE__ */ jsx("div", { className: styles$1.checkbox, children: /* @__PURE__ */ jsx(
      Form$1.Check,
      {
        ref: checkboxRef,
        checked: state === "all" || state === true,
        onChange: (e) => onChange && onChange(e.target.checked)
      }
    ) }),
    /* @__PURE__ */ jsx("div", { children })
  ] });
}
function PageTable({ striped, children, headerCheckboxState, onHeaderCheckboxChange: onTitleCheckboxChange }) {
  return /* @__PURE__ */ jsx("div", { className: styles$2.container, children: /* @__PURE__ */ jsxs(Table, { className: styles$2["page-table"], responsive: true, striped, children: [
    /* @__PURE__ */ jsx("thead", { children: /* @__PURE__ */ jsxs("tr", { children: [
      /* @__PURE__ */ jsx("th", { children: /* @__PURE__ */ jsx(TriCheckbox, { state: headerCheckboxState, onChange: onTitleCheckboxChange, children: "Name" }) }),
      /* @__PURE__ */ jsx("th", { className: styles$2.desktop, children: "Category" }),
      /* @__PURE__ */ jsx("th", { className: styles$2.desktop, children: "Status" }),
      /* @__PURE__ */ jsx("th", { className: styles$2.desktop, children: "Size" }),
      /* @__PURE__ */ jsx("th", { children: "Actions" })
    ] }) }),
    /* @__PURE__ */ jsx("tbody", { children })
  ] }) });
}
function PageRow(props) {
  return /* @__PURE__ */ jsxs("tr", { className: props.isRemoving ? styles$2.removing : void 0, children: [
    /* @__PURE__ */ jsx("td", { children: /* @__PURE__ */ jsxs(TriCheckbox, { state: props.isSelected, onChange: props.onRowSelectionChanged, children: [
      /* @__PURE__ */ jsx(Truncate, { children: props.name }),
      /* @__PURE__ */ jsxs("div", { className: styles$2.mobile, children: [
        /* @__PURE__ */ jsxs("div", { className: styles$2.badges, children: [
          /* @__PURE__ */ jsx(StatusBadge, { status: props.status, percentage: props.percentage, error: props.error }),
          /* @__PURE__ */ jsx(CategoryBadge, { category: props.category })
        ] }),
        /* @__PURE__ */ jsx("div", { children: formatFileSize(props.fileSizeBytes) })
      ] })
    ] }) }),
    /* @__PURE__ */ jsx("td", { className: styles$2.desktop, children: /* @__PURE__ */ jsx(CategoryBadge, { category: props.category }) }),
    /* @__PURE__ */ jsx("td", { className: styles$2.desktop, children: /* @__PURE__ */ jsx(StatusBadge, { status: props.status, percentage: props.percentage, error: props.error }) }),
    /* @__PURE__ */ jsx("td", { className: styles$2.desktop, children: formatFileSize(props.fileSizeBytes) }),
    /* @__PURE__ */ jsx("td", { children: /* @__PURE__ */ jsx("div", { className: styles$2.actions, children: props.actions }) })
  ] });
}
function CategoryBadge({ category }) {
  const categoryLower = category == null ? void 0 : category.toLowerCase();
  let variant = "secondary";
  if (categoryLower === "movies") variant = "primary";
  if (categoryLower === "tv") variant = "info";
  return /* @__PURE__ */ jsx(Badge, { bg: variant, style: { width: "85px" }, children: categoryLower });
}
const styles = {
  "word-wrap": "_word-wrap_yx34a_1"
};
function WordWrap({ children }) {
  return /* @__PURE__ */ jsx("div", { className: styles["word-wrap"], children });
}
function ConfirmModal(props) {
  const [isCheckboxChecked, setIsCheckboxChecked] = useState(false);
  const onConfirm = useCallback((isChecked) => {
    props.onConfirm(isChecked);
    setIsCheckboxChecked(false);
  }, [props.onConfirm, setIsCheckboxChecked]);
  const onCancel = useCallback(() => {
    props.onCancel();
    setIsCheckboxChecked(false);
  }, [props.onCancel, setIsCheckboxChecked]);
  return /* @__PURE__ */ jsxs(Modal, { show: props.show, onHide: onCancel, centered: true, scrollable: true, children: [
    /* @__PURE__ */ jsx(Modal.Header, { closeButton: true, children: /* @__PURE__ */ jsx(Modal.Title, { children: props.title }) }),
    /* @__PURE__ */ jsx(Modal.Body, { children: /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx("div", { style: { fontSize: "12px" }, children: /* @__PURE__ */ jsx(WordWrap, { children: props.message }) }),
      props.checkboxMessage && /* @__PURE__ */ jsx(
        Form$1.Check,
        {
          type: "checkbox",
          id: "modal-checkbox",
          style: { marginTop: "12px" },
          label: props.checkboxMessage,
          checked: isCheckboxChecked,
          onChange: (e) => setIsCheckboxChecked(Boolean(e.target.checked))
        }
      )
    ] }) }),
    /* @__PURE__ */ jsxs(Modal.Footer, { children: [
      /* @__PURE__ */ jsx(Button, { variant: "secondary", onClick: onCancel, children: props.cancelText || "Close" }),
      /* @__PURE__ */ jsx(Button, { variant: "danger", onClick: () => onConfirm(isCheckboxChecked), children: props.confirmText || "Confirm Removal" })
    ] })
  ] });
}
function getLeafDirectoryName(fullPath) {
  let normalizedPath = fullPath.replace(/[/\\]$/, "");
  const lastSlash = normalizedPath.lastIndexOf("/");
  const lastBackslash = normalizedPath.lastIndexOf("\\");
  const lastSeparatorIndex = Math.max(lastSlash, lastBackslash);
  const leafName = normalizedPath.substring(lastSeparatorIndex + 1);
  if (leafName.length === 0) {
    return normalizedPath;
  }
  return leafName;
}
function HistoryTable({ historySlots, onIsSelectedChanged, onIsRemovingChanged, onRemoved }) {
  const [isConfirmingRemoval, setIsConfirmingRemoval] = useState(false);
  var selectedCount = historySlots.filter((x) => !!x.isSelected).length;
  var headerCheckboxState = selectedCount === 0 ? "none" : selectedCount === historySlots.length ? "all" : "some";
  const onSelectAll = useCallback((isSelected) => {
    onIsSelectedChanged(new Set(historySlots.map((x) => x.nzo_id)), isSelected);
  }, [historySlots, onIsSelectedChanged]);
  const onRemove = useCallback(() => {
    setIsConfirmingRemoval(true);
  }, [setIsConfirmingRemoval]);
  const onCancelRemoval = useCallback(() => {
    setIsConfirmingRemoval(false);
  }, [setIsConfirmingRemoval]);
  const onConfirmRemoval = useCallback(async (deleteCompletedFiles) => {
    var nzo_ids = new Set(historySlots.filter((x) => !!x.isSelected).map((x) => x.nzo_id));
    setIsConfirmingRemoval(false);
    onIsRemovingChanged(nzo_ids, true);
    try {
      const url = `/api?mode=history&name=delete&del_completed_files=${deleteCompletedFiles ? 1 : 0}`;
      const response = await fetch(url, {
        method: "POST",
        headers: {
          "Content-Type": "application/json;charset=UTF-8"
        },
        body: JSON.stringify({ nzo_ids: Array.from(nzo_ids) })
      });
      if (response.ok) {
        const data = await response.json();
        if (data.status === true) {
          onRemoved(nzo_ids);
          return;
        }
      }
    } catch {
    }
    onIsRemovingChanged(nzo_ids, false);
  }, [historySlots, setIsConfirmingRemoval, onIsRemovingChanged, onRemoved]);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs("div", { className: styles$5["section-title"], children: [
      /* @__PURE__ */ jsx("h3", { children: "History" }),
      headerCheckboxState !== "none" && /* @__PURE__ */ jsx(ActionButton, { type: "delete", onClick: onRemove })
    ] }),
    /* @__PURE__ */ jsx(PageTable, { headerCheckboxState, onHeaderCheckboxChange: onSelectAll, children: historySlots.map(
      (slot) => /* @__PURE__ */ jsx(
        HistoryRow,
        {
          slot,
          onIsSelectedChanged: (id, isSelected) => onIsSelectedChanged(/* @__PURE__ */ new Set([id]), isSelected),
          onIsRemovingChanged: (id, isRemoving) => onIsRemovingChanged(/* @__PURE__ */ new Set([id]), isRemoving),
          onRemoved: (id) => onRemoved(/* @__PURE__ */ new Set([id]))
        },
        slot.nzo_id
      )
    ) }),
    /* @__PURE__ */ jsx(
      ConfirmModal,
      {
        show: isConfirmingRemoval,
        title: "Remove From History?",
        message: `${selectedCount} item(s) will be removed`,
        checkboxMessage: "Delete mounted files",
        onConfirm: onConfirmRemoval,
        onCancel: onCancelRemoval
      }
    )
  ] });
}
function HistoryRow({ slot, onIsSelectedChanged, onIsRemovingChanged, onRemoved }) {
  const [isConfirmingRemoval, setIsConfirmingRemoval] = useState(false);
  const onRemove = useCallback(() => {
    setIsConfirmingRemoval(true);
  }, [setIsConfirmingRemoval]);
  const onCancelRemoval = useCallback(() => {
    setIsConfirmingRemoval(false);
  }, [setIsConfirmingRemoval]);
  const onConfirmRemoval = useCallback(async (deleteCompletedFiles) => {
    setIsConfirmingRemoval(false);
    onIsRemovingChanged(slot.nzo_id, true);
    try {
      const url = `/api?mode=history&name=delete&value=${encodeURIComponent(slot.nzo_id)}&del_completed_files=${deleteCompletedFiles ? 1 : 0}`;
      const response = await fetch(url);
      if (response.ok) {
        const data = await response.json();
        if (data.status === true) {
          onRemoved(slot.nzo_id);
          return;
        }
      }
    } catch {
    }
    onIsRemovingChanged(slot.nzo_id, false);
  }, [slot.nzo_id, setIsConfirmingRemoval, onIsRemovingChanged, onRemoved]);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      PageRow,
      {
        isSelected: !!slot.isSelected,
        isRemoving: !!slot.isRemoving,
        name: slot.name,
        category: slot.category,
        status: slot.status,
        error: slot.fail_message,
        fileSizeBytes: slot.bytes,
        actions: /* @__PURE__ */ jsx(Actions, { slot, onRemove }),
        onRowSelectionChanged: (isSelected) => onIsSelectedChanged(slot.nzo_id, isSelected)
      }
    ),
    /* @__PURE__ */ jsx(
      ConfirmModal,
      {
        show: isConfirmingRemoval,
        title: "Remove From History?",
        message: slot.nzb_name,
        checkboxMessage: "Delete mounted files",
        onConfirm: onConfirmRemoval,
        onCancel: onCancelRemoval
      }
    )
  ] });
}
function Actions({ slot, onRemove }) {
  var downloadFolder = slot.storage && getLeafDirectoryName(slot.storage);
  const encodedCategory = downloadFolder && encodeURIComponent(slot.category);
  const encodedDownloadFolder = downloadFolder && encodeURIComponent(downloadFolder);
  var folderLink = downloadFolder && `/explore/content/${encodedCategory}/${encodedDownloadFolder}`;
  var isFolderDisabled = !downloadFolder || !!slot.isRemoving || !!slot.fail_message;
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    !isFolderDisabled && /* @__PURE__ */ jsx(Link, { to: folderLink, children: /* @__PURE__ */ jsx(ActionButton, { type: "explore" }) }),
    isFolderDisabled && /* @__PURE__ */ jsx(ActionButton, { type: "explore", disabled: true }),
    /* @__PURE__ */ jsx(ActionButton, { type: "delete", disabled: !!slot.isRemoving, onClick: onRemove })
  ] });
}
function QueueTable({ queueSlots, onIsSelectedChanged, onIsRemovingChanged, onRemoved }) {
  const [isConfirmingRemoval, setIsConfirmingRemoval] = useState(false);
  var selectedCount = queueSlots.filter((x) => !!x.isSelected).length;
  var headerCheckboxState = selectedCount === 0 ? "none" : selectedCount === queueSlots.length ? "all" : "some";
  const onSelectAll = useCallback((isSelected) => {
    onIsSelectedChanged(new Set(queueSlots.map((x) => x.nzo_id)), isSelected);
  }, [queueSlots, onIsSelectedChanged]);
  const onRemove = useCallback(() => {
    setIsConfirmingRemoval(true);
  }, [setIsConfirmingRemoval]);
  const onCancelRemoval = useCallback(() => {
    setIsConfirmingRemoval(false);
  }, [setIsConfirmingRemoval]);
  const onConfirmRemoval = useCallback(async () => {
    var nzo_ids = new Set(queueSlots.filter((x) => !!x.isSelected).map((x) => x.nzo_id));
    setIsConfirmingRemoval(false);
    onIsRemovingChanged(nzo_ids, true);
    try {
      const url = `/api?mode=queue&name=delete`;
      const response = await fetch(url, {
        method: "POST",
        headers: {
          "Content-Type": "application/json;charset=UTF-8"
        },
        body: JSON.stringify({ nzo_ids: Array.from(nzo_ids) })
      });
      if (response.ok) {
        const data = await response.json();
        if (data.status === true) {
          onRemoved(nzo_ids);
          return;
        }
      }
    } catch {
    }
    onIsRemovingChanged(nzo_ids, false);
  }, [queueSlots, setIsConfirmingRemoval, onIsRemovingChanged, onRemoved]);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs("div", { className: styles$5["section-title"], children: [
      /* @__PURE__ */ jsx("h3", { children: "Queue" }),
      headerCheckboxState !== "none" && /* @__PURE__ */ jsx(ActionButton, { type: "delete", onClick: onRemove })
    ] }),
    /* @__PURE__ */ jsx("div", { style: { minHeight: "300px" }, children: /* @__PURE__ */ jsx(PageTable, { headerCheckboxState, onHeaderCheckboxChange: onSelectAll, striped: true, children: queueSlots.map(
      (slot) => /* @__PURE__ */ jsx(
        QueueRow,
        {
          slot,
          onIsSelectedChanged: (id, isSelected) => onIsSelectedChanged(/* @__PURE__ */ new Set([id]), isSelected),
          onIsRemovingChanged: (id, isRemoving) => onIsRemovingChanged(/* @__PURE__ */ new Set([id]), isRemoving),
          onRemoved: (id) => onRemoved(/* @__PURE__ */ new Set([id]))
        },
        slot.nzo_id
      )
    ) }) }),
    /* @__PURE__ */ jsx(
      ConfirmModal,
      {
        show: isConfirmingRemoval,
        title: "Remove From Queue?",
        message: `${selectedCount} item(s) will be removed`,
        onConfirm: onConfirmRemoval,
        onCancel: onCancelRemoval
      }
    )
  ] });
}
function QueueRow({ slot, onIsSelectedChanged, onIsRemovingChanged, onRemoved }) {
  const [isConfirmingRemoval, setIsConfirmingRemoval] = useState(false);
  const onRemove = useCallback(() => {
    setIsConfirmingRemoval(true);
  }, [setIsConfirmingRemoval]);
  const onCancelRemoval = useCallback(() => {
    setIsConfirmingRemoval(false);
  }, [setIsConfirmingRemoval]);
  const onConfirmRemoval = useCallback(async () => {
    setIsConfirmingRemoval(false);
    onIsRemovingChanged(slot.nzo_id, true);
    try {
      const url = `/api?mode=queue&name=delete&value=${encodeURIComponent(slot.nzo_id)}`;
      const response = await fetch(url);
      if (response.ok) {
        const data = await response.json();
        if (data.status === true) {
          onRemoved(slot.nzo_id);
          return;
        }
      }
    } catch {
    }
    onIsRemovingChanged(slot.nzo_id, false);
  }, [slot.nzo_id, setIsConfirmingRemoval, onIsRemovingChanged, onRemoved]);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      PageRow,
      {
        isSelected: !!slot.isSelected,
        isRemoving: !!slot.isRemoving,
        name: slot.filename,
        category: slot.cat,
        status: slot.status,
        percentage: slot.true_percentage,
        fileSizeBytes: Number(slot.mb) * 1024 * 1024,
        actions: /* @__PURE__ */ jsx(ActionButton, { type: "delete", disabled: !!slot.isRemoving, onClick: onRemove }),
        onRowSelectionChanged: (isSelected) => onIsSelectedChanged(slot.nzo_id, isSelected)
      }
    ),
    /* @__PURE__ */ jsx(
      ConfirmModal,
      {
        show: isConfirmingRemoval,
        title: "Remove From Queue?",
        message: slot.filename,
        onConfirm: onConfirmRemoval,
        onCancel: onCancelRemoval
      }
    )
  ] });
}
const topicNames = {
  queueItemStatus: "qs",
  queueItemPercentage: "qp",
  queueItemAdded: "qa",
  queueItemRemoved: "qr",
  historyItemAdded: "ha",
  historyItemRemoved: "hr"
};
const topicSubscriptions = {
  [topicNames.queueItemStatus]: "state",
  [topicNames.queueItemPercentage]: "state",
  [topicNames.queueItemAdded]: "event",
  [topicNames.queueItemRemoved]: "event",
  [topicNames.historyItemAdded]: "event",
  [topicNames.historyItemRemoved]: "event"
};
async function loader({
  request
}) {
  var queuePromise = backendClient.getQueue();
  var historyPromise = backendClient.getHistory();
  var queue = await queuePromise;
  var history = await historyPromise;
  return {
    queueSlots: (queue == null ? void 0 : queue.slots) || [],
    historySlots: (history == null ? void 0 : history.slots) || []
  };
}
const route = UNSAFE_withComponentProps(function Queue(props) {
  var _a;
  const [queueSlots, setQueueSlots] = useState(props.loaderData.queueSlots);
  const [historySlots, setHistorySlots] = useState(props.loaderData.historySlots);
  const error2 = (_a = props.actionData) == null ? void 0 : _a.error;
  const onAddQueueSlot = useCallback((queueSlot) => {
    setQueueSlots((slots) => [...slots, queueSlot]);
  }, [setQueueSlots]);
  const onSelectQueueSlots = useCallback((ids, isSelected) => {
    setQueueSlots((slots) => slots.map((x) => ids.has(x.nzo_id) ? {
      ...x,
      isSelected
    } : x));
  }, [setQueueSlots]);
  const onRemovingQueueSlots = useCallback((ids, isRemoving) => {
    setQueueSlots((slots) => slots.map((x) => ids.has(x.nzo_id) ? {
      ...x,
      isRemoving
    } : x));
  }, [setQueueSlots]);
  const onRemoveQueueSlots = useCallback((ids) => {
    setQueueSlots((slots) => slots.filter((x) => !ids.has(x.nzo_id)));
  }, [setQueueSlots]);
  const onChangeQueueSlotStatus = useCallback((message) => {
    const [nzo_id, status] = message.split("|");
    setQueueSlots((slots) => slots.map((x) => x.nzo_id === nzo_id ? {
      ...x,
      status
    } : x));
  }, [setQueueSlots]);
  const onChangeQueueSlotPercentage = useCallback((message) => {
    const [nzo_id, true_percentage] = message.split("|");
    setQueueSlots((slots) => slots.map((x) => x.nzo_id === nzo_id ? {
      ...x,
      true_percentage
    } : x));
  }, [setQueueSlots]);
  const onAddHistorySlot = useCallback((historySlot) => {
    setHistorySlots((slots) => [historySlot, ...slots]);
  }, [setHistorySlots]);
  const onSelectHistorySlots = useCallback((ids, isSelected) => {
    setHistorySlots((slots) => slots.map((x) => ids.has(x.nzo_id) ? {
      ...x,
      isSelected
    } : x));
  }, [setHistorySlots]);
  const onRemovingHistorySlots = useCallback((ids, isRemoving) => {
    setHistorySlots((slots) => slots.map((x) => ids.has(x.nzo_id) ? {
      ...x,
      isRemoving
    } : x));
  }, [setHistorySlots]);
  const onRemoveHistorySlots = useCallback((ids) => {
    setHistorySlots((slots) => slots.filter((x) => !ids.has(x.nzo_id)));
  }, [setHistorySlots]);
  const onWebsocketMessage = useCallback((topic, message) => {
    if (topic == topicNames.queueItemAdded) onAddQueueSlot(JSON.parse(message));
    else if (topic == topicNames.queueItemRemoved) onRemoveQueueSlots(new Set(message.split(",")));
    else if (topic == topicNames.queueItemStatus) onChangeQueueSlotStatus(message);
    else if (topic == topicNames.queueItemPercentage) onChangeQueueSlotPercentage(message);
    else if (topic == topicNames.historyItemAdded) onAddHistorySlot(JSON.parse(message));
    else if (topic == topicNames.historyItemRemoved) onRemoveHistorySlots(new Set(message.split(",")));
  }, [onAddQueueSlot, onRemoveQueueSlots, onChangeQueueSlotStatus, onChangeQueueSlotPercentage, onAddHistorySlot, onRemoveHistorySlots]);
  useEffect(() => {
    let ws;
    let disposed = false;
    function connect() {
      ws = new WebSocket(window.location.origin.replace(/^http/, "ws"));
      ws.onmessage = receiveMessage(onWebsocketMessage);
      ws.onopen = () => {
        ws.send(JSON.stringify(topicSubscriptions));
      };
      ws.onclose = () => {
        !disposed && setTimeout(() => connect(), 1e3);
      };
      ws.onerror = () => {
        ws.close();
      };
      return () => {
        disposed = true;
        ws.close();
      };
    }
    return connect();
  }, [onWebsocketMessage]);
  return /* @__PURE__ */ jsxs("div", {
    className: styles$5.container,
    children: [error2 && /* @__PURE__ */ jsx(Alert, {
      variant: "danger",
      children: error2
    }), /* @__PURE__ */ jsx("div", {
      className: styles$5.section,
      children: queueSlots.length > 0 ? /* @__PURE__ */ jsx(QueueTable, {
        queueSlots,
        onIsSelectedChanged: onSelectQueueSlots,
        onIsRemovingChanged: onRemovingQueueSlots,
        onRemoved: onRemoveQueueSlots
      }) : /* @__PURE__ */ jsx(EmptyQueue, {})
    }), historySlots.length > 0 && /* @__PURE__ */ jsx("div", {
      className: styles$5.section,
      children: /* @__PURE__ */ jsx(HistoryTable, {
        historySlots,
        onIsSelectedChanged: onSelectHistorySlots,
        onIsRemovingChanged: onRemovingHistorySlots,
        onRemoved: onRemoveHistorySlots
      })
    })]
  });
});
async function action({
  request
}) {
  let session = await sessionStorage.getSession(request.headers.get("cookie"));
  let user = session.get("user");
  if (!user) return redirect("/login");
  try {
    const formData = await request.formData();
    const nzbFile = formData.get("nzbFile");
    if (nzbFile instanceof File) {
      await backendClient.addNzb(nzbFile);
    } else {
      return {
        error: "Error uploading nzb."
      };
    }
  } catch (error2) {
    if (error2 instanceof Error) {
      return {
        error: error2.message
      };
    }
    throw error2;
  }
}
const route9 = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  action,
  default: route,
  loader
}, Symbol.toStringTag, { value: "Module" }));
const serverManifest = { "entry": { "module": "/assets/entry.client-Ce6sbkUo.js", "imports": ["/assets/chunk-ZYFC6VSF-z8IE3_1-.js", "/assets/index-COBxQf2g.js"], "css": [] }, "routes": { "root": { "id": "root", "parentId": void 0, "path": "", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasClientMiddleware": false, "hasErrorBoundary": false, "module": "/assets/root-DhAW7H7r.js", "imports": ["/assets/chunk-ZYFC6VSF-z8IE3_1-.js", "/assets/index-COBxQf2g.js", "/assets/styling-DnO0kxqo.js", "/assets/websocket-util-BsyLhgYe.js", "/assets/loading-CBcZx78b.js"], "css": ["/assets/root-ClYCoc6r.css", "/assets/loading-2XOk63ol.css"], "clientActionModule": void 0, "clientLoaderModule": void 0, "clientMiddlewareModule": void 0, "hydrateFallbackModule": void 0 }, "routes/onboarding": { "id": "routes/onboarding", "parentId": "root", "path": "onboarding", "index": void 0, "caseSensitive": void 0, "hasAction": true, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasClientMiddleware": false, "hasErrorBoundary": false, "module": "/assets/route-B11uVXfQ.js", "imports": ["/assets/chunk-ZYFC6VSF-z8IE3_1-.js", "/assets/warning-CpwKX0PM.js", "/assets/Form-R7324AJ1.js", "/assets/index-COBxQf2g.js"], "css": ["/assets/route-B1iwM870.css"], "clientActionModule": void 0, "clientLoaderModule": void 0, "clientMiddlewareModule": void 0, "hydrateFallbackModule": void 0 }, "routes/settings": { "id": "routes/settings", "parentId": "root", "path": "settings", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasClientMiddleware": false, "hasErrorBoundary": false, "module": "/assets/route-DoOUoj0X.js", "imports": ["/assets/chunk-ZYFC6VSF-z8IE3_1-.js", "/assets/Form-R7324AJ1.js", "/assets/styling-DnO0kxqo.js", "/assets/warning-CpwKX0PM.js", "/assets/websocket-util-BsyLhgYe.js", "/assets/NoopTransition-DrjS-s1f.js", "/assets/DataKey-COGXBUcQ.js", "/assets/index-COBxQf2g.js"], "css": ["/assets/route-Deof_iU6.css"], "clientActionModule": void 0, "clientLoaderModule": void 0, "clientMiddlewareModule": void 0, "hydrateFallbackModule": void 0 }, "routes/settings.update": { "id": "routes/settings.update", "parentId": "routes/settings", "path": "update", "index": void 0, "caseSensitive": void 0, "hasAction": true, "hasLoader": false, "hasClientAction": false, "hasClientLoader": false, "hasClientMiddleware": false, "hasErrorBoundary": false, "module": "/assets/route-l0sNRNKZ.js", "imports": [], "css": [], "clientActionModule": void 0, "clientLoaderModule": void 0, "clientMiddlewareModule": void 0, "hydrateFallbackModule": void 0 }, "routes/explore": { "id": "routes/explore", "parentId": "root", "path": "explore", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasClientMiddleware": false, "hasErrorBoundary": false, "module": "/assets/route-LAGwNsu3.js", "imports": ["/assets/chunk-ZYFC6VSF-z8IE3_1-.js", "/assets/styling-DnO0kxqo.js", "/assets/loading-CBcZx78b.js", "/assets/file-size-D4fYM2D7.js"], "css": ["/assets/route-93PFcB8b.css", "/assets/loading-2XOk63ol.css"], "clientActionModule": void 0, "clientLoaderModule": void 0, "clientMiddlewareModule": void 0, "hydrateFallbackModule": void 0 }, "routes/_index": { "id": "routes/_index", "parentId": "root", "path": void 0, "index": true, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasClientMiddleware": false, "hasErrorBoundary": false, "module": "/assets/route-DP2rzg_V.js", "imports": [], "css": [], "clientActionModule": void 0, "clientLoaderModule": void 0, "clientMiddlewareModule": void 0, "hydrateFallbackModule": void 0 }, "routes/health": { "id": "routes/health", "parentId": "root", "path": "health", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasClientMiddleware": false, "hasErrorBoundary": false, "module": "/assets/route-CpgfMZxh.js", "imports": ["/assets/chunk-ZYFC6VSF-z8IE3_1-.js", "/assets/status-badge-mcfJLL_O.js", "/assets/websocket-util-BsyLhgYe.js", "/assets/warning-CpwKX0PM.js", "/assets/styling-DnO0kxqo.js", "/assets/index-COBxQf2g.js", "/assets/NoopTransition-DrjS-s1f.js"], "css": ["/assets/route-BMiyxP6W.css", "/assets/status-badge--3nldvA4.css"], "clientActionModule": void 0, "clientLoaderModule": void 0, "clientMiddlewareModule": void 0, "hydrateFallbackModule": void 0 }, "routes/logout": { "id": "routes/logout", "parentId": "root", "path": "logout", "index": void 0, "caseSensitive": void 0, "hasAction": true, "hasLoader": false, "hasClientAction": false, "hasClientLoader": false, "hasClientMiddleware": false, "hasErrorBoundary": false, "module": "/assets/route-K6Dvbx-E.js", "imports": [], "css": [], "clientActionModule": void 0, "clientLoaderModule": void 0, "clientMiddlewareModule": void 0, "hydrateFallbackModule": void 0 }, "routes/login": { "id": "routes/login", "parentId": "root", "path": "login", "index": void 0, "caseSensitive": void 0, "hasAction": true, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasClientMiddleware": false, "hasErrorBoundary": false, "module": "/assets/route-FoRijL5Y.js", "imports": ["/assets/chunk-ZYFC6VSF-z8IE3_1-.js", "/assets/warning-CpwKX0PM.js", "/assets/Form-R7324AJ1.js", "/assets/index-COBxQf2g.js"], "css": ["/assets/route-S1ASkuxe.css"], "clientActionModule": void 0, "clientLoaderModule": void 0, "clientMiddlewareModule": void 0, "hydrateFallbackModule": void 0 }, "routes/queue": { "id": "routes/queue", "parentId": "root", "path": "queue", "index": void 0, "caseSensitive": void 0, "hasAction": true, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasClientMiddleware": false, "hasErrorBoundary": false, "module": "/assets/route-BnDOUP5S.js", "imports": ["/assets/chunk-ZYFC6VSF-z8IE3_1-.js", "/assets/warning-CpwKX0PM.js", "/assets/styling-DnO0kxqo.js", "/assets/Form-R7324AJ1.js", "/assets/status-badge-mcfJLL_O.js", "/assets/file-size-D4fYM2D7.js", "/assets/index-COBxQf2g.js", "/assets/DataKey-COGXBUcQ.js", "/assets/websocket-util-BsyLhgYe.js", "/assets/NoopTransition-DrjS-s1f.js"], "css": ["/assets/route-KKRJByVy.css", "/assets/status-badge--3nldvA4.css"], "clientActionModule": void 0, "clientLoaderModule": void 0, "clientMiddlewareModule": void 0, "hydrateFallbackModule": void 0 }, "routes/explore/route": { "id": "routes/explore/route", "parentId": "root", "path": "/explore/*", "index": void 0, "caseSensitive": void 0, "hasAction": false, "hasLoader": true, "hasClientAction": false, "hasClientLoader": false, "hasClientMiddleware": false, "hasErrorBoundary": false, "module": "/assets/route-LAGwNsu3.js", "imports": ["/assets/chunk-ZYFC6VSF-z8IE3_1-.js", "/assets/styling-DnO0kxqo.js", "/assets/loading-CBcZx78b.js", "/assets/file-size-D4fYM2D7.js"], "css": ["/assets/route-93PFcB8b.css", "/assets/loading-2XOk63ol.css"], "clientActionModule": void 0, "clientLoaderModule": void 0, "clientMiddlewareModule": void 0, "hydrateFallbackModule": void 0 } }, "url": "/assets/manifest-b89d7e8c.js", "version": "b89d7e8c", "sri": void 0 };
const assetsBuildDirectory = "build/client";
const basename = "/";
const future = { "unstable_middleware": false, "unstable_optimizeDeps": false, "unstable_splitRouteModules": false, "unstable_subResourceIntegrity": false, "unstable_viteEnvironmentApi": false };
const ssr = true;
const isSpaMode = false;
const prerender = [];
const routeDiscovery = { "mode": "lazy", "manifestPath": "/__manifest" };
const publicPath = "/";
const entry = { module: entryServer };
const routes = {
  "root": {
    id: "root",
    parentId: void 0,
    path: "",
    index: void 0,
    caseSensitive: void 0,
    module: route0
  },
  "routes/onboarding": {
    id: "routes/onboarding",
    parentId: "root",
    path: "onboarding",
    index: void 0,
    caseSensitive: void 0,
    module: route1
  },
  "routes/settings": {
    id: "routes/settings",
    parentId: "root",
    path: "settings",
    index: void 0,
    caseSensitive: void 0,
    module: route2
  },
  "routes/settings.update": {
    id: "routes/settings.update",
    parentId: "routes/settings",
    path: "update",
    index: void 0,
    caseSensitive: void 0,
    module: route3
  },
  "routes/explore": {
    id: "routes/explore",
    parentId: "root",
    path: "explore",
    index: void 0,
    caseSensitive: void 0,
    module: route10
  },
  "routes/_index": {
    id: "routes/_index",
    parentId: "root",
    path: void 0,
    index: true,
    caseSensitive: void 0,
    module: route5
  },
  "routes/health": {
    id: "routes/health",
    parentId: "root",
    path: "health",
    index: void 0,
    caseSensitive: void 0,
    module: route6
  },
  "routes/logout": {
    id: "routes/logout",
    parentId: "root",
    path: "logout",
    index: void 0,
    caseSensitive: void 0,
    module: route7
  },
  "routes/login": {
    id: "routes/login",
    parentId: "root",
    path: "login",
    index: void 0,
    caseSensitive: void 0,
    module: route8
  },
  "routes/queue": {
    id: "routes/queue",
    parentId: "root",
    path: "queue",
    index: void 0,
    caseSensitive: void 0,
    module: route9
  },
  "routes/explore/route": {
    id: "routes/explore/route",
    parentId: "root",
    path: "/explore/*",
    index: void 0,
    caseSensitive: void 0,
    module: route10
  }
};
export {
  serverManifest as assets,
  assetsBuildDirectory,
  basename,
  entry,
  future,
  isSpaMode,
  prerender,
  publicPath,
  routeDiscovery,
  routes,
  ssr
};
