//#region src/utils/encryption-utils.ts
function arrayBufferToString(buffer) {
	const bytes = new Uint8Array(buffer);
	const len = bytes.byteLength;
	if (len < 65535) return String.fromCharCode.apply(null, bytes);
	let binary = "";
	for (let i = 0; i < len; i++) binary += String.fromCharCode(bytes[i]);
	return binary;
}
function stringToUint8Array(binary) {
	const len = binary.length;
	const arr = new Uint8Array(len);
	for (let i = 0; i < len; i++) arr[i] = binary.charCodeAt(i);
	return arr;
}
function concatArray(chunks) {
	let total = 0;
	for (const chunk of chunks) total += chunk.length;
	const result = new Uint8Array(total);
	let offset = 0;
	for (const chunk of chunks) {
		result.set(chunk, offset);
		offset += chunk.length;
	}
	return result;
}
async function concatArrayStream(stream) {
	const chunks = [];
	await stream.pipeTo(new WritableStream({ write(chunk) {
		chunks.push(chunk);
	} }));
	return concatArray(chunks);
}
function arrayToStream(data) {
	return new ReadableStream({ start(controller) {
		controller.enqueue(data);
		controller.close();
	} });
}
function toBase64(buffer) {
	return btoa(arrayBufferToString(buffer));
}
function fromBase64(data) {
	return stringToUint8Array(atob(data));
}
async function generateEncryptionKey() {
	const key = await crypto.subtle.generateKey({
		name: "AES-GCM",
		length: 256
	}, true, ["encrypt", "decrypt"]);
	const exported = await crypto.subtle.exportKey("raw", key);
	return new Uint8Array(exported);
}
async function encryptBuffer(data, key) {
	const iv = crypto.getRandomValues(new Uint8Array(16));
	const encrypted = await crypto.subtle.encrypt({
		name: "AES-GCM",
		iv
	}, key, data);
	return toBase64(concatArray([iv, new Uint8Array(encrypted)]));
}
async function decryptBuffer(encryptedString, key) {
	const concatenated = fromBase64(encryptedString);
	const iv = concatenated.slice(0, 16);
	const encrypted = concatenated.slice(16);
	return crypto.subtle.decrypt({
		name: "AES-GCM",
		iv
	}, key, encrypted);
}

//#endregion
export { arrayToStream, concatArrayStream, decryptBuffer, encryptBuffer, fromBase64, generateEncryptionKey, toBase64 };