import * as Vite from 'vite';
import { R as RouteManifest, a as RouteManifestEntry, b as RouteConfigEntry } from './routes-CZR-bKRt.js';
import 'valibot';

declare const excludedConfigPresetKeys: readonly ["presets"];
type ExcludedConfigPresetKey = (typeof excludedConfigPresetKeys)[number];
type ConfigPreset = Omit<ReactRouterConfig, ExcludedConfigPresetKey>;
type Preset = {
    name: string;
    reactRouterConfig?: (args: {
        reactRouterUserConfig: ReactRouterConfig;
    }) => ConfigPreset | Promise<ConfigPreset>;
    reactRouterConfigResolved?: (args: {
        reactRouterConfig: ResolvedReactRouterConfig;
    }) => void | Promise<void>;
};
declare const branchRouteProperties: readonly ["id", "path", "file", "index"];
type BranchRoute = Pick<RouteManifestEntry, (typeof branchRouteProperties)[number]>;
type ServerBundlesFunction = (args: {
    branch: BranchRoute[];
}) => string | Promise<string>;
type BaseBuildManifest = {
    routes: RouteManifest;
};
type DefaultBuildManifest = BaseBuildManifest & {
    serverBundles?: never;
    routeIdToServerBundleId?: never;
};
type ServerBundlesBuildManifest = BaseBuildManifest & {
    serverBundles: {
        [serverBundleId: string]: {
            id: string;
            file: string;
        };
    };
    routeIdToServerBundleId: Record<string, string>;
};
type ServerModuleFormat = "esm" | "cjs";
interface FutureConfig {
    /**
     * Enable route middleware
     */
    unstable_middleware: boolean;
    unstable_optimizeDeps: boolean;
    /**
     * Automatically split route modules into multiple chunks when possible.
     */
    unstable_splitRouteModules: boolean | "enforce";
    unstable_subResourceIntegrity: boolean;
    /**
     * Use Vite Environment API (experimental)
     */
    unstable_viteEnvironmentApi: boolean;
}
type BuildManifest = DefaultBuildManifest | ServerBundlesBuildManifest;
type BuildEndHook = (args: {
    buildManifest: BuildManifest | undefined;
    reactRouterConfig: ResolvedReactRouterConfig;
    viteConfig: Vite.ResolvedConfig;
}) => void | Promise<void>;
/**
 * Config to be exported via the default export from `react-router.config.ts`.
 */
type ReactRouterConfig = {
    /**
     * The path to the `app` directory, relative to the root directory. Defaults
     * to `"app"`.
     */
    appDirectory?: string;
    /**
     * The output format of the server build. Defaults to "esm".
     */
    serverModuleFormat?: ServerModuleFormat;
    /**
     * Enabled future flags
     */
    future?: [keyof FutureConfig] extends [never] ? {
        [key: string]: never;
    } : Partial<FutureConfig>;
    /**
     * The React Router app basename.  Defaults to `"/"`.
     */
    basename?: string;
    /**
     * The path to the build directory, relative to the project. Defaults to
     * `"build"`.
     */
    buildDirectory?: string;
    /**
     * A function that is called after the full React Router build is complete.
     */
    buildEnd?: BuildEndHook;
    /**
     * An array of URLs to prerender to HTML files at build time.  Can also be a
     * function returning an array to dynamically generate URLs.
     */
    prerender?: boolean | Array<string> | ((args: {
        getStaticPaths: () => string[];
    }) => Array<string> | Promise<Array<string>>);
    /**
     * An array of React Router plugin config presets to ease integration with
     * other platforms and tools.
     */
    presets?: Array<Preset>;
    /**
     * Control the "Lazy Route Discovery" behavior
     *
     * - `routeDiscovery.mode`: By default, this resolves to `lazy` which will
     *   lazily discover routes as the user navigates around your application.
     *   You can set this to `initial` to opt-out of this behavior and load all
     *   routes with the initial HTML document load.
     * - `routeDiscovery.manifestPath`: The path to serve the manifest file from.
     *    Only applies to `mode: "lazy"` and defaults to `/__manifest`.
     */
    routeDiscovery?: {
        mode: "lazy";
        manifestPath?: string;
    } | {
        mode: "initial";
    };
    /**
     * The file name of the server build output. This file
     * should end in a `.js` extension and should be deployed to your server.
     * Defaults to `"index.js"`.
     */
    serverBuildFile?: string;
    /**
     * A function for assigning routes to different server bundles. This
     * function should return a server bundle ID which will be used as the
     * bundle's directory name within the server build directory.
     */
    serverBundles?: ServerBundlesFunction;
    /**
     * Enable server-side rendering for your application. Disable to use "SPA
     * Mode", which will request the `/` path at build-time and save it as an
     * `index.html` file with your assets so your application can be deployed as a
     * SPA without server-rendering. Default's to `true`.
     */
    ssr?: boolean;
};
type ResolvedReactRouterConfig = Readonly<{
    /**
     * The absolute path to the application source directory.
     */
    appDirectory: string;
    /**
     * The React Router app basename.  Defaults to `"/"`.
     */
    basename: string;
    /**
     * The absolute path to the build directory.
     */
    buildDirectory: string;
    /**
     * A function that is called after the full React Router build is complete.
     */
    buildEnd?: BuildEndHook;
    /**
     * Enabled future flags
     */
    future: FutureConfig;
    /**
     * An array of URLs to prerender to HTML files at build time.  Can also be a
     * function returning an array to dynamically generate URLs.
     */
    prerender: ReactRouterConfig["prerender"];
    /**
     * Control the "Lazy Route Discovery" behavior
     *
     * - `routeDiscovery.mode`: By default, this resolves to `lazy` which will
     *   lazily discover routes as the user navigates around your application.
     *   You can set this to `initial` to opt-out of this behavior and load all
     *   routes with the initial HTML document load.
     * - `routeDiscovery.manifestPath`: The path to serve the manifest file from.
     *    Only applies to `mode: "lazy"` and defaults to `/__manifest`.
     */
    routeDiscovery: ReactRouterConfig["routeDiscovery"];
    /**
     * An object of all available routes, keyed by route id.
     */
    routes: RouteManifest;
    /**
     * The file name of the server build output. This file
     * should end in a `.js` extension and should be deployed to your server.
     * Defaults to `"index.js"`.
     */
    serverBuildFile: string;
    /**
     * A function for assigning routes to different server bundles. This
     * function should return a server bundle ID which will be used as the
     * bundle's directory name within the server build directory.
     */
    serverBundles?: ServerBundlesFunction;
    /**
     * The output format of the server build. Defaults to "esm".
     */
    serverModuleFormat: ServerModuleFormat;
    /**
     * Enable server-side rendering for your application. Disable to use "SPA
     * Mode", which will request the `/` path at build-time and save it as an
     * `index.html` file with your assets so your application can be deployed as a
     * SPA without server-rendering. Default's to `true`.
     */
    ssr: boolean;
    /**
     * The resolved array of route config entries exported from `routes.ts`
     */
    unstable_routeConfig: RouteConfigEntry[];
}>;

export type { BuildManifest, ReactRouterConfig as Config, Preset, ServerBundlesFunction };
