import $7Gzdi$intlStringsmodulejs from "./intlStrings.module.js";
import {useDatePickerGroup as $3dfb0f96be0d6a08$export$4a931266a3838b86} from "./useDatePickerGroup.module.js";
import {createFocusManager as $7Gzdi$createFocusManager} from "@react-aria/focus";
import {useDescription as $7Gzdi$useDescription, mergeProps as $7Gzdi$mergeProps, useFormReset as $7Gzdi$useFormReset, filterDOMProps as $7Gzdi$filterDOMProps} from "@react-aria/utils";
import {useRef as $7Gzdi$useRef, useMemo as $7Gzdi$useMemo, useEffect as $7Gzdi$useEffect} from "react";
import {useField as $7Gzdi$useField} from "@react-aria/label";
import {useFocusWithin as $7Gzdi$useFocusWithin} from "@react-aria/interactions";
import {useFormValidation as $7Gzdi$useFormValidation} from "@react-aria/form";
import {useLocalizedStringFormatter as $7Gzdi$useLocalizedStringFormatter} from "@react-aria/i18n";


function $parcel$interopDefault(a) {
  return a && a.__esModule ? a.default : a;
}
/*
 * Copyright 2020 Adobe. All rights reserved.
 * This file is licensed to you under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under
 * the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 * OF ANY KIND, either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */ 








const $16f0b7bb276bc17e$export$653eddfc964b0f8a = new WeakMap();
const $16f0b7bb276bc17e$export$300019f83c56d282 = '__role_' + Date.now();
const $16f0b7bb276bc17e$export$7b3062cd49e80452 = '__focusManager_' + Date.now();
function $16f0b7bb276bc17e$export$5591b0b878c1a989(props, state, ref) {
    var _state_value;
    let { isInvalid: isInvalid, validationErrors: validationErrors, validationDetails: validationDetails } = state.displayValidation;
    let { labelProps: labelProps, fieldProps: fieldProps, descriptionProps: descriptionProps, errorMessageProps: errorMessageProps } = (0, $7Gzdi$useField)({
        ...props,
        labelElementType: 'span',
        isInvalid: isInvalid,
        errorMessage: props.errorMessage || validationErrors
    });
    let valueOnFocus = (0, $7Gzdi$useRef)(null);
    let { focusWithinProps: focusWithinProps } = (0, $7Gzdi$useFocusWithin)({
        ...props,
        onFocusWithin (e) {
            var _props_onFocus;
            valueOnFocus.current = state.value;
            (_props_onFocus = props.onFocus) === null || _props_onFocus === void 0 ? void 0 : _props_onFocus.call(props, e);
        },
        onBlurWithin: (e)=>{
            var _props_onBlur;
            state.confirmPlaceholder();
            if (state.value !== valueOnFocus.current) state.commitValidation();
            (_props_onBlur = props.onBlur) === null || _props_onBlur === void 0 ? void 0 : _props_onBlur.call(props, e);
        },
        onFocusWithinChange: props.onFocusChange
    });
    let stringFormatter = (0, $7Gzdi$useLocalizedStringFormatter)((0, ($parcel$interopDefault($7Gzdi$intlStringsmodulejs))), '@react-aria/datepicker');
    let message = state.maxGranularity === 'hour' ? 'selectedTimeDescription' : 'selectedDateDescription';
    let field = state.maxGranularity === 'hour' ? 'time' : 'date';
    let description = state.value ? stringFormatter.format(message, {
        [field]: state.formatValue({
            month: 'long'
        })
    }) : '';
    let descProps = (0, $7Gzdi$useDescription)(description);
    // If within a date picker or date range picker, the date field will have role="presentation" and an aria-describedby
    // will be passed in that references the value (e.g. entire range). Otherwise, add the field's value description.
    let describedBy = props[$16f0b7bb276bc17e$export$300019f83c56d282] === 'presentation' ? fieldProps['aria-describedby'] : [
        descProps['aria-describedby'],
        fieldProps['aria-describedby']
    ].filter(Boolean).join(' ') || undefined;
    let propsFocusManager = props[$16f0b7bb276bc17e$export$7b3062cd49e80452];
    let focusManager = (0, $7Gzdi$useMemo)(()=>propsFocusManager || (0, $7Gzdi$createFocusManager)(ref), [
        propsFocusManager,
        ref
    ]);
    let groupProps = (0, $3dfb0f96be0d6a08$export$4a931266a3838b86)(state, ref, props[$16f0b7bb276bc17e$export$300019f83c56d282] === 'presentation');
    // Pass labels and other information to segments.
    $16f0b7bb276bc17e$export$653eddfc964b0f8a.set(state, {
        ariaLabel: props['aria-label'],
        ariaLabelledBy: [
            labelProps.id,
            props['aria-labelledby']
        ].filter(Boolean).join(' ') || undefined,
        ariaDescribedBy: describedBy,
        focusManager: focusManager
    });
    let autoFocusRef = (0, $7Gzdi$useRef)(props.autoFocus);
    // When used within a date picker or date range picker, the field gets role="presentation"
    // rather than role="group". Since the date picker/date range picker already has a role="group"
    // with a label and description, and the segments are already labeled by this as well, this
    // avoids very verbose duplicate announcements.
    let fieldDOMProps;
    if (props[$16f0b7bb276bc17e$export$300019f83c56d282] === 'presentation') fieldDOMProps = {
        role: 'presentation'
    };
    else fieldDOMProps = (0, $7Gzdi$mergeProps)(fieldProps, {
        role: 'group',
        'aria-disabled': props.isDisabled || undefined,
        'aria-describedby': describedBy
    });
    (0, $7Gzdi$useEffect)(()=>{
        if (autoFocusRef.current) focusManager.focusFirst();
        autoFocusRef.current = false;
    }, [
        focusManager
    ]);
    (0, $7Gzdi$useFormReset)(props.inputRef, state.value, state.setValue);
    (0, $7Gzdi$useFormValidation)({
        ...props,
        focus () {
            focusManager.focusFirst();
        }
    }, state, props.inputRef);
    let inputProps = {
        type: 'hidden',
        name: props.name,
        value: ((_state_value = state.value) === null || _state_value === void 0 ? void 0 : _state_value.toString()) || ''
    };
    if (props.validationBehavior === 'native') {
        // Use a hidden <input type="text"> rather than <input type="hidden">
        // so that an empty value blocks HTML form submission when the field is required.
        inputProps.type = 'text';
        inputProps.hidden = true;
        inputProps.required = props.isRequired;
        // Ignore react warning.
        inputProps.onChange = ()=>{};
    }
    let domProps = (0, $7Gzdi$filterDOMProps)(props);
    return {
        labelProps: {
            ...labelProps,
            onClick: ()=>{
                focusManager.focusFirst();
            }
        },
        fieldProps: (0, $7Gzdi$mergeProps)(domProps, fieldDOMProps, groupProps, focusWithinProps, {
            onKeyDown (e) {
                if (props.onKeyDown) props.onKeyDown(e);
            },
            onKeyUp (e) {
                if (props.onKeyUp) props.onKeyUp(e);
            }
        }),
        inputProps: inputProps,
        descriptionProps: descriptionProps,
        errorMessageProps: errorMessageProps,
        isInvalid: isInvalid,
        validationErrors: validationErrors,
        validationDetails: validationDetails
    };
}
function $16f0b7bb276bc17e$export$4c842f6a241dc825(props, state, ref) {
    var _state_timeValue;
    let res = $16f0b7bb276bc17e$export$5591b0b878c1a989(props, state, ref);
    res.inputProps.value = ((_state_timeValue = state.timeValue) === null || _state_timeValue === void 0 ? void 0 : _state_timeValue.toString()) || '';
    return res;
}


export {$16f0b7bb276bc17e$export$653eddfc964b0f8a as hookData, $16f0b7bb276bc17e$export$300019f83c56d282 as roleSymbol, $16f0b7bb276bc17e$export$7b3062cd49e80452 as focusManagerSymbol, $16f0b7bb276bc17e$export$5591b0b878c1a989 as useDateField, $16f0b7bb276bc17e$export$4c842f6a241dc825 as useTimeField};
//# sourceMappingURL=useDateField.module.js.map
