"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
require("reflect-metadata");
const api_1 = require("@opentelemetry/api");
const sdk_trace_node_1 = require("@opentelemetry/sdk-trace-node");
const common_1 = require("@nestjs/common");
const span_1 = require("./span");
const TestDecoratorThatSetsMetadata = () => (0, common_1.SetMetadata)('some-metadata', true);
const symbol = Symbol('testSymbol');
class TestSpan {
    singleSpan() { }
    doubleSpan() {
        return this.singleSpan();
    }
    fooProducerSpan() { }
    error() {
        throw new Error('hello world');
    }
    metadata() { }
    [_a = symbol]() { }
}
tslib_1.__decorate([
    (0, span_1.Span)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestSpan.prototype, "singleSpan", null);
tslib_1.__decorate([
    (0, span_1.Span)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestSpan.prototype, "doubleSpan", null);
tslib_1.__decorate([
    (0, span_1.Span)('foo', { kind: api_1.SpanKind.PRODUCER }),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestSpan.prototype, "fooProducerSpan", null);
tslib_1.__decorate([
    (0, span_1.Span)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestSpan.prototype, "error", null);
tslib_1.__decorate([
    (0, span_1.Span)(),
    TestDecoratorThatSetsMetadata(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestSpan.prototype, "metadata", null);
tslib_1.__decorate([
    (0, span_1.Span)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestSpan.prototype, _a, null);
describe('Span', () => {
    let instance;
    let traceExporter;
    let spanProcessor;
    let provider;
    beforeAll(async () => {
        instance = new TestSpan();
        traceExporter = new sdk_trace_node_1.InMemorySpanExporter();
        spanProcessor = new sdk_trace_node_1.SimpleSpanProcessor(traceExporter);
        provider = new sdk_trace_node_1.NodeTracerProvider();
        provider.addSpanProcessor(spanProcessor);
        provider.register();
    });
    afterEach(async () => {
        spanProcessor.forceFlush();
        traceExporter.reset();
    });
    afterAll(async () => {
        await provider.shutdown();
    });
    it('should maintain reflect metadataa', async () => {
        expect(Reflect.getMetadata('some-metadata', instance.metadata)).toEqual(true);
    });
    it('should set correct span', async () => {
        instance.singleSpan();
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(1);
        expect(spans.map(span => span.name)).toEqual(['TestSpan.singleSpan']);
    });
    it('should set correct span options', async () => {
        instance.fooProducerSpan();
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(1);
        expect(spans.map(span => span.kind)).toEqual([api_1.SpanKind.PRODUCER]);
    });
    it('should set correct span even when calling other method with Span decorator', async () => {
        instance.doubleSpan();
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(2);
        expect(spans.map(span => span.name)).toEqual(['TestSpan.singleSpan', 'TestSpan.doubleSpan']);
    });
    it('should propagate errors', () => {
        expect(instance.error).toThrowError('hello world');
    });
    it('should set setStatus to ERROR and message to error message', async () => {
        expect(instance.error).toThrowError('hello world');
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(1);
        expect(spans[0].status).toEqual({ code: api_1.SpanStatusCode.ERROR, message: 'hello world' });
    });
    it('should set recordException with error', () => {
        expect(instance.error).toThrowError('hello world');
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(1);
        // Contain one exception event
        expect(spans[0].events).toHaveLength(1);
        expect(spans[0].events[0]).toEqual({
            name: 'exception',
            attributes: expect.anything(),
            droppedAttributesCount: 0,
            time: expect.anything(),
        });
    });
    it('should handle symbols', () => {
        instance[symbol]();
        const spans = traceExporter.getFinishedSpans();
        expect(spans).toHaveLength(1);
        expect(spans.map(span => span.name)).toEqual(['TestSpan.Symbol(testSymbol)']);
    });
});
