"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Span = Span;
const api_1 = require("@opentelemetry/api");
const opentelemetry_utils_1 = require("../../opentelemetry.utils");
const recordException = (span, error) => {
    span.recordException(error);
    span.setStatus({ code: api_1.SpanStatusCode.ERROR, message: error.message });
};
function Span(name, options = {}) {
    return (target, propertyKey, propertyDescriptor) => {
        const originalFunction = propertyDescriptor.value;
        const wrappedFunction = function PropertyDescriptor(...args) {
            const tracer = api_1.trace.getTracer('default');
            const spanName = name || `${target.constructor.name}.${String(propertyKey)}`;
            return tracer.startActiveSpan(spanName, options, span => {
                if (originalFunction.constructor.name === 'AsyncFunction') {
                    return (originalFunction
                        // @ts-ignore
                        .apply(this, args)
                        // @ts-ignore
                        .catch(error => {
                        recordException(span, error);
                        // Throw error to propagate it further
                        throw error;
                    })
                        .finally(() => {
                        span.end();
                    }));
                }
                try {
                    // @ts-ignore
                    return originalFunction.apply(this, args);
                }
                catch (error) {
                    recordException(span, error);
                    // Throw error to propagate it further
                    throw error;
                }
                finally {
                    span.end();
                }
            });
        };
        propertyDescriptor.value = wrappedFunction;
        (0, opentelemetry_utils_1.copyMetadataFromFunctionToFunction)(originalFunction, wrappedFunction);
    };
}
