"use strict";
var OpenTelemetryModule_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenTelemetryModule = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@nestjs/common");
const opentelemetry_core_module_1 = require("./opentelemetry-core.module");
/**
 * The NestJS module for OpenTelemetry
 *
 * @publicApi
 */
let OpenTelemetryModule = OpenTelemetryModule_1 = class OpenTelemetryModule {
    /**
     * Bootstraps the OpenTelemetry Module synchronously
     * @param options The options for the OpenTelemetry Module
     */
    static forRoot(options) {
        return {
            module: OpenTelemetryModule_1,
            imports: [opentelemetry_core_module_1.OpenTelemetryCoreModule.forRoot(options)],
        };
    }
    /**
     * Bootstrap the OpenTelemetry Module asynchronously
     * @see https://dev.to/nestjs/advanced-nestjs-how-to-build-completely-dynamic-nestjs-modules-1370
     * @param options The options for the OpenTelemetry module
     */
    static forRootAsync(options) {
        return {
            module: OpenTelemetryModule_1,
            imports: [opentelemetry_core_module_1.OpenTelemetryCoreModule.forRootAsync(options)],
        };
    }
};
exports.OpenTelemetryModule = OpenTelemetryModule;
exports.OpenTelemetryModule = OpenTelemetryModule = OpenTelemetryModule_1 = tslib_1.__decorate([
    (0, common_1.Module)({})
], OpenTelemetryModule);
