"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMiddlewareMountPoint = getMiddlewareMountPoint;
const feature_detection_utils_1 = require("./feature-detection.utils");
const MOUNT_POINT_EXPRESS_5 = '/';
const MOUNT_POINT_EXPRESS_4 = '*';
const MOUNT_POINT_FASTIFY_5 = '{*path}';
const MOUNT_POINT_FASTIFY_4 = '(.*)';
function getMiddlewareMountPoint(adapter) {
    const features = (0, feature_detection_utils_1.detectHttpAdapterTypeAndVersion)(adapter);
    if (features.adapterType === feature_detection_utils_1.HttpAdapterType.FASTIFY) {
        if (features.version === feature_detection_utils_1.FastifyVersion.V5) {
            return MOUNT_POINT_FASTIFY_5;
        }
        return MOUNT_POINT_FASTIFY_4;
    }
    else {
        if (features.version === feature_detection_utils_1.ExpressVersion.V5) {
            return MOUNT_POINT_EXPRESS_5;
        }
        return MOUNT_POINT_EXPRESS_4;
    }
}
