"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MetricService = void 0;
const tslib_1 = require("tslib");
const common_1 = require("@nestjs/common");
const metric_data_1 = require("./metric-data");
let MetricService = class MetricService {
    getCounter(name, options) {
        return (0, metric_data_1.getOrCreateCounter)(name, options);
    }
    getUpDownCounter(name, options) {
        return (0, metric_data_1.getOrCreateUpDownCounter)(name, options);
    }
    getHistogram(name, options) {
        return (0, metric_data_1.getOrCreateHistogram)(name, options);
    }
    getObservableCounter(name, options) {
        return (0, metric_data_1.getOrCreateObservableCounter)(name, options);
    }
    getObservableGauge(name, options) {
        return (0, metric_data_1.getOrCreateObservableGauge)(name, options);
    }
    getObservableUpDownCounter(name, options) {
        return (0, metric_data_1.getOrCreateObservableUpDownCounter)(name, options);
    }
};
exports.MetricService = MetricService;
exports.MetricService = MetricService = tslib_1.__decorate([
    (0, common_1.Injectable)()
], MetricService);
