"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.meterData = exports.MetricType = void 0;
exports.getOrCreateHistogram = getOrCreateHistogram;
exports.getOrCreateCounter = getOrCreateCounter;
exports.getOrCreateUpDownCounter = getOrCreateUpDownCounter;
exports.getOrCreateObservableGauge = getOrCreateObservableGauge;
exports.getOrCreateObservableCounter = getOrCreateObservableCounter;
exports.getOrCreateObservableUpDownCounter = getOrCreateObservableUpDownCounter;
const api_1 = require("@opentelemetry/api");
const opentelemetry_constants_1 = require("../opentelemetry.constants");
var MetricType;
(function (MetricType) {
    MetricType["Counter"] = "Counter";
    MetricType["UpDownCounter"] = "UpDownCounter";
    MetricType["Histogram"] = "Histogram";
    MetricType["ObservableGauge"] = "ObservableGauge";
    MetricType["ObservableCounter"] = "ObservableCounter";
    MetricType["ObservableUpDownCounter"] = "ObservableUpDownCounter";
})(MetricType || (exports.MetricType = MetricType = {}));
exports.meterData = new Map();
function getOrCreate(name, options = {}, type) {
    const nameWithPrefix = options.prefix ? `${options.prefix}.${name}` : name;
    let metric = exports.meterData.get(nameWithPrefix);
    if (metric === undefined) {
        const meter = api_1.metrics.getMeterProvider().getMeter(opentelemetry_constants_1.OTEL_METER_NAME);
        metric = meter[`create${type}`](nameWithPrefix, options);
        exports.meterData.set(nameWithPrefix, metric);
    }
    return metric;
}
function getOrCreateHistogram(name, options = {}) {
    return getOrCreate(name, options, MetricType.Histogram);
}
function getOrCreateCounter(name, options = {}) {
    return getOrCreate(name, options, MetricType.Counter);
}
function getOrCreateUpDownCounter(name, options = {}) {
    return getOrCreate(name, options, MetricType.UpDownCounter);
}
function getOrCreateObservableGauge(name, options = {}) {
    return getOrCreate(name, options, MetricType.ObservableGauge);
}
function getOrCreateObservableCounter(name, options = {}) {
    return getOrCreate(name, options, MetricType.ObservableCounter);
}
function getOrCreateObservableUpDownCounter(name, options = {}) {
    return getOrCreate(name, options, MetricType.ObservableUpDownCounter);
}
