import { Counter, UpDownCounter, Histogram, ObservableGauge, ObservableCounter, ObservableUpDownCounter } from '@opentelemetry/api';
import { OtelMetricOptions } from '../interfaces/metric-options.interface';
export type GenericMetric = Counter | UpDownCounter | Histogram | ObservableGauge | ObservableCounter | ObservableUpDownCounter;
export declare enum MetricType {
    'Counter' = "Counter",
    'UpDownCounter' = "UpDownCounter",
    'Histogram' = "Histogram",
    'ObservableGauge' = "ObservableGauge",
    'ObservableCounter' = "ObservableCounter",
    'ObservableUpDownCounter' = "ObservableUpDownCounter"
}
export declare const meterData: Map<string, GenericMetric>;
export declare function getOrCreateHistogram(name: string, options?: OtelMetricOptions): Histogram;
export declare function getOrCreateCounter(name: string, options?: OtelMetricOptions): Counter;
export declare function getOrCreateUpDownCounter(name: string, options?: OtelMetricOptions): UpDownCounter;
export declare function getOrCreateObservableGauge(name: string, options?: OtelMetricOptions): ObservableGauge;
export declare function getOrCreateObservableCounter(name: string, options?: OtelMetricOptions): ObservableCounter;
export declare function getOrCreateObservableUpDownCounter(name: string, options?: OtelMetricOptions): ObservableUpDownCounter;
