"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OtelObservableUpDownCounter = exports.OtelObservableCounter = exports.OtelObservableGauge = exports.OtelHistogram = exports.OtelUpDownCounter = exports.OtelCounter = void 0;
const common_1 = require("@nestjs/common");
const metric_data_1 = require("../metric-data");
function createMetricParamDecorator(type, getOrCreateMetric) {
    return (name, options) => {
        return (0, common_1.createParamDecorator)(() => {
            if (!name || name.length === 0) {
                throw new Error(`${type} need a name argument`);
            }
            return getOrCreateMetric(name, options);
        })();
    };
}
exports.OtelCounter = createMetricParamDecorator('OtelCounter', metric_data_1.getOrCreateCounter);
exports.OtelUpDownCounter = createMetricParamDecorator('OtelUpDownCounter', metric_data_1.getOrCreateCounter);
exports.OtelHistogram = createMetricParamDecorator('OtelHistogram', metric_data_1.getOrCreateHistogram);
exports.OtelObservableGauge = createMetricParamDecorator('OtelObservableGauge', metric_data_1.getOrCreateObservableGauge);
exports.OtelObservableCounter = createMetricParamDecorator('OtelObservableCounter', metric_data_1.getOrCreateObservableCounter);
exports.OtelObservableUpDownCounter = createMetricParamDecorator('OtelObservableUpDownCounter', metric_data_1.getOrCreateObservableUpDownCounter);
