"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
require("reflect-metadata");
const common_1 = require("@nestjs/common");
const common_2 = require("./common");
const TestDecoratorThatSetsMetadata = () => (0, common_1.SetMetadata)('some-metadata', true);
let TestClass = class TestClass {
    method() { }
};
tslib_1.__decorate([
    TestDecoratorThatSetsMetadata(),
    (0, common_2.OtelMethodCounter)(),
    tslib_1.__metadata("design:type", Function),
    tslib_1.__metadata("design:paramtypes", []),
    tslib_1.__metadata("design:returntype", void 0)
], TestClass.prototype, "method", null);
TestClass = tslib_1.__decorate([
    (0, common_2.OtelInstanceCounter)(),
    TestDecoratorThatSetsMetadata()
], TestClass);
describe('OtelInstanceCounter', () => {
    let instance;
    beforeEach(() => {
        instance = new TestClass();
    });
    it('should maintain reflect metadata', async () => {
        expect(Reflect.getMetadata('some-metadata', instance.constructor)).toEqual(true);
    });
});
describe('OtelMethodCounter', () => {
    let instance;
    beforeEach(() => {
        instance = new TestClass();
    });
    it('should maintain reflect metadata', async () => {
        expect(Reflect.getMetadata('some-metadata', instance.method)).toEqual(true);
    });
});
