"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const feature_detection_utils_1 = require("./feature-detection.utils");
function useNest10() {
    jest.mock('@nestjs/testing', () => jest.requireActual('@nestjs/testing10'));
    jest.mock('@nestjs/common', () => jest.requireActual('@nestjs/common10'));
    jest.mock('@nestjs/core', () => jest.requireActual('@nestjs/core10'));
    jest.mock('@nestjs/platform-express', () => jest.requireActual('@nestjs/platform-express10'));
    jest.mock('@nestjs/platform-fastify', () => jest.requireActual('@nestjs/platform-fastify10'));
}
function useNest11() {
    jest.unmock('@nestjs/testing');
    jest.unmock('@nestjs/common');
    jest.unmock('@nestjs/core');
    jest.unmock('@nestjs/platform-express');
    jest.unmock('@nestjs/platform-fastify');
}
describe('FeatureDetectionUtils', () => {
    describe('When using Express adapter', () => {
        async function getExpressApp() {
            const { Module } = await Promise.resolve().then(() => tslib_1.__importStar(require('@nestjs/common')));
            const { Test } = await Promise.resolve().then(() => tslib_1.__importStar(require('@nestjs/testing')));
            let TestModule = class TestModule {
            };
            TestModule = tslib_1.__decorate([
                Module({})
            ], TestModule);
            const module = await Test.createTestingModule({
                imports: [TestModule],
            }).compile();
            return module.createNestApplication();
        }
        it('should detect Express version 4 on Nest 10', async () => {
            useNest10();
            const app = await getExpressApp();
            const features = (0, feature_detection_utils_1.detectHttpAdapterTypeAndVersion)(app.getHttpAdapter());
            expect(features).toEqual({
                adapterType: feature_detection_utils_1.HttpAdapterType.EXPRESS,
                version: feature_detection_utils_1.ExpressVersion.V4,
            });
        });
        it('should detect Express version 5 on Nest 11', async () => {
            useNest11();
            const app = await getExpressApp();
            const features = (0, feature_detection_utils_1.detectHttpAdapterTypeAndVersion)(app.getHttpAdapter());
            expect(features).toEqual({
                adapterType: feature_detection_utils_1.HttpAdapterType.EXPRESS,
                version: feature_detection_utils_1.ExpressVersion.V5,
            });
        });
    });
    describe('When using Fastify adapter', () => {
        async function getFastifyApp() {
            const { Module } = await Promise.resolve().then(() => tslib_1.__importStar(require('@nestjs/common')));
            const { Test } = await Promise.resolve().then(() => tslib_1.__importStar(require('@nestjs/testing')));
            const { FastifyAdapter } = await Promise.resolve().then(() => tslib_1.__importStar(require('@nestjs/platform-fastify')));
            let TestModule = class TestModule {
            };
            TestModule = tslib_1.__decorate([
                Module({})
            ], TestModule);
            const module = await Test.createTestingModule({
                imports: [TestModule],
            }).compile();
            return module.createNestApplication(new FastifyAdapter());
        }
        it('should detect Fastify version 4 on Nest 10', async () => {
            useNest10();
            const app = await getFastifyApp();
            const features = (0, feature_detection_utils_1.detectHttpAdapterTypeAndVersion)(app.getHttpAdapter());
            expect(features).toEqual({
                adapterType: feature_detection_utils_1.HttpAdapterType.FASTIFY,
                version: feature_detection_utils_1.FastifyVersion.V4,
            });
        });
        it('should detect Fastify version 5 on Nest 11', async () => {
            useNest11();
            const app = await getFastifyApp();
            const features = (0, feature_detection_utils_1.detectHttpAdapterTypeAndVersion)(app.getHttpAdapter());
            expect(features).toEqual({
                adapterType: feature_detection_utils_1.HttpAdapterType.FASTIFY,
                version: feature_detection_utils_1.FastifyVersion.V5,
            });
        });
    });
});
