"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpAdapterType = exports.FastifyVersion = exports.ExpressVersion = void 0;
exports.detectHttpAdapterTypeAndVersion = detectHttpAdapterTypeAndVersion;
var ExpressVersion;
(function (ExpressVersion) {
    ExpressVersion["V4"] = "4.x";
    ExpressVersion["V5"] = "5.x";
})(ExpressVersion || (exports.ExpressVersion = ExpressVersion = {}));
var FastifyVersion;
(function (FastifyVersion) {
    FastifyVersion["V4"] = "4.x";
    FastifyVersion["V5"] = "5.x";
})(FastifyVersion || (exports.FastifyVersion = FastifyVersion = {}));
var HttpAdapterType;
(function (HttpAdapterType) {
    HttpAdapterType["EXPRESS"] = "express";
    HttpAdapterType["FASTIFY"] = "fastify";
})(HttpAdapterType || (exports.HttpAdapterType = HttpAdapterType = {}));
function detectHttpAdapterTypeAndVersion(httpAdapter) {
    const adapterType = detectHttpAdapterType(httpAdapter);
    if (adapterType === HttpAdapterType.FASTIFY) {
        return {
            adapterType: HttpAdapterType.FASTIFY,
            version: detectFastifyVersion(httpAdapter.getInstance()),
        };
    }
    else {
        return {
            adapterType: HttpAdapterType.EXPRESS,
            version: detectExpressVersion(httpAdapter.getInstance()),
        };
    }
}
function detectHttpAdapterType(httpAdapter) {
    if (httpAdapter.constructor.name === 'FastifyAdapter') {
        return HttpAdapterType.FASTIFY;
    }
    return HttpAdapterType.EXPRESS;
}
function detectExpressVersion(expressApp) {
    // feature detection based on https://expressjs.com/en/guide/migrating-5.html
    if (
    // app.del is removed in Express 5
    typeof expressApp.del === 'undefined') {
        return ExpressVersion.V5;
    }
    return ExpressVersion.V4;
}
function detectFastifyVersion(fastifyApp) {
    // feature detection based on https://fastify.dev/docs/v5.1.x/Guides/Migration-Guide-V5/
    if (
    // these methods are removed in Fastify 5
    typeof fastifyApp.getDefaultRoute === 'undefined' &&
        typeof fastifyApp.setDefaultRoute === 'undefined') {
        return FastifyVersion.V5;
    }
    return FastifyVersion.V4;
}
