import { HttpServer } from '@nestjs/common';
export declare enum ExpressVersion {
    V4 = "4.x",
    V5 = "5.x"
}
export declare enum FastifyVersion {
    V4 = "4.x",
    V5 = "5.x"
}
export declare enum HttpAdapterType {
    EXPRESS = "express",
    FASTIFY = "fastify"
}
type HttpExpresAdapterResponse = {
    adapterType: HttpAdapterType.EXPRESS;
    version: ExpressVersion;
};
type HttpFastifyAdapterResponse = {
    adapterType: HttpAdapterType.FASTIFY;
    version: FastifyVersion;
};
type HttpAdapterTypeAndVersion = HttpExpresAdapterResponse | HttpFastifyAdapterResponse;
export declare function detectHttpAdapterTypeAndVersion(httpAdapter: HttpServer): HttpAdapterTypeAndVersion;
export {};
