import { DynamicModule, MiddlewareConsumer, NestModule, OnModuleInit, Type } from '@nestjs/common';
import { HttpAdapterHost, ModuleRef } from '@nestjs/core';
import { ClsModuleAsyncOptions, ClsModuleOptions } from '../cls.options';
/**
 * This module contains logic for configuring the CLS module in the root.
 */
export declare class ClsRootModule implements NestModule, OnModuleInit {
    private readonly adapterHost;
    private readonly moduleRef;
    private static logger;
    constructor(adapterHost: HttpAdapterHost, moduleRef: ModuleRef);
    configure(consumer: MiddlewareConsumer): void;
    onModuleInit(): void;
    /**
     * @internal
     * Called by ClsModule.forRoot.
     *
     */
    static forRoot(options?: ClsModuleOptions): DynamicModule;
    /**
     * @internal
     * Called by ClsModule.forRootAsync.
     */
    static forRootAsync(asyncOptions: ClsModuleAsyncOptions): DynamicModule;
    /**
     * @internal
     * Called by this modules's forRoot/Async abd ClsModule.forFeature
     */
    static createProxyClassProviders(proxyProviderClasses?: Array<Type>): import("@nestjs/common").FactoryProvider<any>[];
    private static getProviders;
    private static clsMiddlewareOptionsFactory;
    private static clsGuardOptionsFactory;
    private static clsInterceptorOptionsFactory;
    private static clsGuardFactory;
    private static clsInterceptorFactory;
}
//# sourceMappingURL=cls-root.module.d.ts.map