import { Zone } from "luxon";
import { CapturedAtTagNames } from "./CapturedAtTagNames";
import { ExifToolOptions } from "./ExifToolOptions";
import { Maybe } from "./Maybe";
import { Tags } from "./Tags";
declare const ValidTimezoneOffsets: readonly ["-11:00", "-10:00", "-09:30", "-09:00", "-08:30", "-08:00", "-07:00", "-06:00", "-05:00", "-04:30", "-04:00", "-03:30", "-03:00", "-02:30", "-02:00", "-01:00", "+00:00", "+01:00", "+02:00", "+03:00", "+03:30", "+04:00", "+04:30", "+05:00", "+05:30", "+05:45", "+06:00", "+06:30", "+07:00", "+07:30", "+08:00", "+08:30", "+08:45", "+09:00", "+09:30", "+09:45", "+10:00", "+10:30", "+11:00", "+12:00", "+12:45", "+13:00", "+13:45", "+14:00"];
export type TimezoneOffset = (typeof ValidTimezoneOffsets)[number];
/**
 * Zone instances with this offset are a placeholder for being "unset".
 */
export declare const UnsetZoneOffsetMinutes = -1;
/**
 * This is a placeholder for dates where the zone is unknown/unset, because
 * Luxon doesn't officially support "unset" zones.
 */
export declare const UnsetZone: Zone<boolean>;
/**
 * Zone instances with this name are a placeholder for being "unset".
 */
export declare const UnsetZoneName: string;
export declare function isUTC(zone: Maybe<Zone | string | number>): boolean;
export declare function isZoneValid(zone: Maybe<Zone>): zone is Zone;
/**
 * If `tzSource` matches this value, the tags are from a video, and we had to
 * resort to assuming time fields are in UTC.
 * @see https://github.com/photostructure/exiftool-vendored.js/issues/113
 */
export declare const defaultVideosToUTC = "defaultVideosToUTC";
/**
 * @param input must be either a number, which is the offset in minutes, or a
 * string in the format "UTC+H" or "UTC+HH:mm"
 */
export declare function normalizeZone(input: Maybe<string | number | Zone>): Maybe<Zone>;
/**
 * @param ts must be provided if the zone is not a fixed offset
 * @return the zone offset (in "±HH:MM" format) for the given zone, or "" if
 * the zone is invalid
 */
export declare function zoneToShortOffset(zone: Maybe<string | number | Zone>, ts?: number): string;
export declare function validTzOffsetMinutes(tzOffsetMinutes: Maybe<number>): tzOffsetMinutes is number;
/**
 * Returns a "zone name" (used by `luxon`) that encodes the given offset.
 */
export declare function offsetMinutesToZoneName(offsetMinutes: Maybe<number>): Maybe<string>;
export interface TzSrc {
    tz: string;
    /**
     * If given a string, this is the remaining string left after extracting the
     * timezone
     */
    leftovers?: string;
    src: string;
}
/**
 * Parse a timezone offset and return the offset minutes
 *
 * @param opts.stripTZA If false, do not strip off the timezone abbreviation
 * (TZA) from the value. Defaults to true.
 *
 * @return undefined if the value cannot be parsed as a valid timezone offset
 */
export declare function extractZone(value: any, opts?: {
    stripTZA?: boolean;
}): Maybe<TzSrc>;
export declare const TimezoneOffsetTagnames: readonly ["TimeZone", "OffsetTime", "OffsetTimeOriginal", "OffsetTimeDigitized", "TimeZoneOffset", "GeolocationTimeZone"];
export declare function incrementZone(z: string | Zone | number, minutes: number): Maybe<Zone>;
export declare function extractTzOffsetFromTags(t: Tags, opts?: Pick<ExifToolOptions, "adjustTimeZoneIfDaylightSavings">): Maybe<TzSrc>;
export declare function extractTzOffsetFromDatestamps(t: Tags, opts: Partial<Pick<ExifToolOptions, "inferTimezoneFromDatestamps" | "inferTimezoneFromDatestampTags">>): Maybe<TzSrc>;
export declare function extractTzOffsetFromTimeStamp(t: Tags, opts: Partial<Pick<ExifToolOptions, "inferTimezoneFromTimeStamp" | "inferTimezoneFromDatestampTags">>): Maybe<TzSrc>;
export declare function inferLikelyOffsetMinutes(deltaMinutes: number): Maybe<number>;
export declare function extractTzOffsetFromUTCOffset(t: Pick<Tags, (typeof CapturedAtTagNames)[number] | "GPSDateTime" | "DateTimeUTC" | "GPSDateStamp" | "GPSTimeStamp" | "SonyDateTime2">): Maybe<TzSrc>;
export declare function equivalentZones(a: Maybe<string | number | Zone>, b: Maybe<string | number | Zone>): boolean;
export declare function getZoneName(args?: {
    zone?: Zone;
    zoneName?: Maybe<string>;
    tzoffsetMinutes?: Maybe<number>;
}): Maybe<string>;
export {};
