"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _ReadTask_instances, _ReadTask_raw, _ReadTask_rawDegrouped, _ReadTask_tags, _ReadTask_isVideo, _ReadTask_defaultToUTC, _ReadTask_tagName, _ReadTask_parseTags, _ReadTask_lat, _ReadTask_lon, _ReadTask_extractTzOffsetFromGps, _ReadTask_extractGpsMetadata, _ReadTask_parseLocation, _ReadTask_tz, _ReadTask_extractTzOffset, _ReadTask_parseTag;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ReadTask = exports.DefaultReadTaskOptions = exports.ReadTaskOptionFields = void 0;
exports.nullish = nullish;
const batch_cluster_1 = require("batch-cluster");
const _path = __importStar(require("node:path"));
const Array_1 = require("./Array");
const BinaryField_1 = require("./BinaryField");
const DefaultExifToolOptions_1 = require("./DefaultExifToolOptions");
const ErrorsAndWarnings_1 = require("./ErrorsAndWarnings");
const ExifDate_1 = require("./ExifDate");
const ExifDateTime_1 = require("./ExifDateTime");
const ExifTime_1 = require("./ExifTime");
const ExifToolOptions_1 = require("./ExifToolOptions");
const ExifToolTask_1 = require("./ExifToolTask");
const FilenameCharsetArgs_1 = require("./FilenameCharsetArgs");
const GeolocationTags_1 = require("./GeolocationTags");
const Lazy_1 = require("./Lazy");
const Number_1 = require("./Number");
const OnlyZerosRE_1 = require("./OnlyZerosRE");
const Pick_1 = require("./Pick");
const String_1 = require("./String");
const Timezones_1 = require("./Timezones");
/**
 * tag names we don't need to muck with, but name conventions (like including
 * "date") suggest they might be date/time tags
 */
const PassthroughTags = [
    "ExifToolVersion",
    "DateStampMode",
    "Sharpness",
    "Firmware",
    "DateDisplayFormat",
];
exports.ReadTaskOptionFields = [
    "backfillTimezones",
    "defaultVideosToUTC",
    "geolocation",
    "geoTz",
    "ignoreMinorErrors",
    "ignoreZeroZeroLatLon",
    "imageHashType",
    "includeImageDataMD5",
    "inferTimezoneFromDatestamps",
    "inferTimezoneFromDatestampTags",
    "inferTimezoneFromTimeStamp",
    "numericTags",
    "useMWG",
    "struct",
    "readArgs",
    "adjustTimeZoneIfDaylightSavings",
    "preferTimezoneInferenceFromGps",
];
const NullIsh = ["undef", "null", "undefined"];
function nullish(s) {
    return s == null || ((0, String_1.isString)(s) && NullIsh.includes(s.trim()));
}
exports.DefaultReadTaskOptions = {
    ...(0, Pick_1.pick)(DefaultExifToolOptions_1.DefaultExifToolOptions, ...exports.ReadTaskOptionFields),
};
const MaybeDateOrTimeRe = /when|date|time|subsec|creat|modif/i;
class ReadTask extends ExifToolTask_1.ExifToolTask {
    /**
     * @param sourceFile the file to read
     * @param args the full arguments to pass to exiftool that take into account
     * the flags in `options`
     */
    constructor(sourceFile, args, options) {
        super(args, options);
        _ReadTask_instances.add(this);
        this.sourceFile = sourceFile;
        this.args = args;
        this.options = options;
        _ReadTask_raw.set(this, {});
        _ReadTask_rawDegrouped.set(this, {});
        _ReadTask_tags.set(this, {}
        /**
         * @param sourceFile the file to read
         * @param args the full arguments to pass to exiftool that take into account
         * the flags in `options`
         */
        );
        _ReadTask_lat.set(this, (0, Lazy_1.lazy)(() => { var _a; return (_a = __classPrivateFieldGet(this, _ReadTask_extractGpsMetadata, "f").call(this)) === null || _a === void 0 ? void 0 : _a.lat; }));
        _ReadTask_lon.set(this, (0, Lazy_1.lazy)(() => { var _a; return (_a = __classPrivateFieldGet(this, _ReadTask_extractGpsMetadata, "f").call(this)) === null || _a === void 0 ? void 0 : _a.lon; }));
        _ReadTask_extractTzOffsetFromGps.set(this, (0, Lazy_1.lazy)(() => { var _a; return (_a = __classPrivateFieldGet(this, _ReadTask_extractGpsMetadata, "f").call(this)) === null || _a === void 0 ? void 0 : _a.tz; }));
        _ReadTask_extractGpsMetadata.set(this, (0, Lazy_1.lazy)(() => {
            let lat = __classPrivateFieldGet(this, _ReadTask_instances, "m", _ReadTask_parseLocation).call(this, {
                tagName: "GPSLatitude",
                positiveRef: "N",
                negativeRef: "S",
                maxValid: 90,
            });
            let lon = __classPrivateFieldGet(this, _ReadTask_instances, "m", _ReadTask_parseLocation).call(this, {
                tagName: "GPSLongitude",
                positiveRef: "E",
                negativeRef: "W",
                maxValid: 180,
            });
            let invalid = false;
            if (this.options.ignoreZeroZeroLatLon && lat === 0 && lon === 0) {
                lat = undefined;
                lon = undefined;
                invalid = true;
            }
            let tz;
            if (!invalid && !(0, String_1.blank)(__classPrivateFieldGet(this, _ReadTask_rawDegrouped, "f").GeolocationTimeZone)) {
                const geolocTz = (0, Timezones_1.normalizeZone)(__classPrivateFieldGet(this, _ReadTask_rawDegrouped, "f").GeolocationTimeZone);
                if (geolocTz != null) {
                    tz = {
                        tz: geolocTz.name,
                        src: "GeolocationTimeZone",
                    };
                }
                else {
                    this.warnings.push("Failed to determine timezone from GeolocationTimeZone value: " +
                        __classPrivateFieldGet(this, _ReadTask_rawDegrouped, "f").GeolocationTimeZone);
                }
            }
            if (tz == null && !invalid && lat != null && lon != null) {
                try {
                    const geoTz = this.options.geoTz(lat, lon);
                    const zone = (0, Timezones_1.normalizeZone)(geoTz);
                    if (zone != null) {
                        tz = {
                            tz: zone.name,
                            src: "GPSLatitude/GPSLongitude",
                        };
                    }
                }
                catch (error) {
                    this.warnings.push("Failed to determine timezone from GPS coordinates: " + error);
                    invalid = true;
                    lat = undefined;
                    lon = undefined;
                }
            }
            if (this.options.geolocation && invalid) {
                if (__classPrivateFieldGet(this, _ReadTask_tags, "f").GPSLatitude != null || __classPrivateFieldGet(this, _ReadTask_tags, "f").GPSLongitude != null) {
                    // don't complain unless there was a GPS value:
                    this.warnings.push("Invalid GPSLatitude or GPSLongitude. Deleting geolocation tags.");
                }
                for (const key of GeolocationTags_1.GeolocationTagNames) {
                    delete __classPrivateFieldGet(this, _ReadTask_tags, "f")[key];
                    delete __classPrivateFieldGet(this, _ReadTask_raw, "f")[key];
                    delete __classPrivateFieldGet(this, _ReadTask_rawDegrouped, "f")[key];
                }
            }
            return {
                lat,
                lon,
                invalid,
                tz,
            };
        }));
        _ReadTask_tz.set(this, (0, Lazy_1.lazy)(() => { var _a; return (_a = __classPrivateFieldGet(this, _ReadTask_extractTzOffset, "f").call(this)) === null || _a === void 0 ? void 0 : _a.tz; }));
        _ReadTask_extractTzOffset.set(this, (0, Lazy_1.lazy)(() => {
            var _a, _b, _c, _d, _e;
            if (true === this.options.preferTimezoneInferenceFromGps) {
                const fromGps = __classPrivateFieldGet(this, _ReadTask_extractTzOffsetFromGps, "f").call(this);
                if (fromGps != null) {
                    return fromGps;
                }
            }
            return ((_e = (_d = (_c = (_b = (_a = (0, Timezones_1.extractTzOffsetFromTags)(__classPrivateFieldGet(this, _ReadTask_rawDegrouped, "f"), this.options)) !== null && _a !== void 0 ? _a : __classPrivateFieldGet(this, _ReadTask_extractTzOffsetFromGps, "f").call(this)) !== null && _b !== void 0 ? _b : (0, Timezones_1.extractTzOffsetFromDatestamps)(__classPrivateFieldGet(this, _ReadTask_rawDegrouped, "f"), this.options)) !== null && _c !== void 0 ? _c : 
            // See https://github.com/photostructure/exiftool-vendored.js/issues/113
            // and https://github.com/photostructure/exiftool-vendored.js/issues/156
            // Videos are frequently encoded in UTC, but don't include the
            // timezone offset in their datetime stamps.
            (__classPrivateFieldGet(this, _ReadTask_instances, "m", _ReadTask_defaultToUTC).call(this)
                ? {
                    tz: "UTC",
                    src: "defaultVideosToUTC",
                }
                : // not applicable:
                    undefined)) !== null && _d !== void 0 ? _d : 
            // This is a last-ditch estimation heuristic:
            (0, Timezones_1.extractTzOffsetFromUTCOffset)(__classPrivateFieldGet(this, _ReadTask_rawDegrouped, "f"))) !== null && _e !== void 0 ? _e : 
            // No, really, this is the even worse than UTC offset heuristics:
            (0, Timezones_1.extractTzOffsetFromTimeStamp)(__classPrivateFieldGet(this, _ReadTask_rawDegrouped, "f"), this.options));
        }));
        // See https://github.com/photostructure/exiftool-vendored.js/issues/147#issuecomment-1642580118
        this.degroup = this.args.includes("-G");
        __classPrivateFieldSet(this, _ReadTask_tags, { SourceFile: sourceFile }, "f");
        __classPrivateFieldGet(this, _ReadTask_tags, "f").errors = this.errors;
    }
    static for(filename, options) {
        const opts = (0, ExifToolOptions_1.handleDeprecatedOptions)({
            ...exports.DefaultReadTaskOptions,
            ...options,
        });
        const sourceFile = _path.resolve(filename);
        const args = [...FilenameCharsetArgs_1.Utf8FilenameCharsetArgs, "-json", ...(0, Array_1.toA)(opts.readArgs)];
        // "-api struct=undef" doesn't work: but it's the same as struct=0:
        args.push("-api", "struct=" + ((0, Number_1.isNumber)(opts.struct) ? opts.struct : "0"));
        if (opts.useMWG) {
            args.push("-use", "MWG");
        }
        if (opts.imageHashType != null && opts.imageHashType !== false) {
            // See https://exiftool.org/forum/index.php?topic=14706.msg79218#msg79218
            args.push("-api", "requesttags=imagedatahash");
            args.push("-api", "imagehashtype=" + opts.imageHashType);
        }
        if (true === opts.geolocation) {
            args.push("-api", "geolocation");
        }
        // IMPORTANT: "-all" must be after numeric tag references, as the first
        // reference in wins
        args.push(...opts.numericTags.map((ea) => "-" + ea + "#"));
        // We have to add a -all or else we'll only get the numericTags. sad.
        // TODO: Do you need -xmp:all, -all, or -all:all? Is -* better?
        args.push("-all", sourceFile);
        return new ReadTask(sourceFile, args, opts);
    }
    toString() {
        return "ReadTask" + this.sourceFile + ")";
    }
    // only exposed for tests
    parse(data, err) {
        try {
            __classPrivateFieldSet(this, _ReadTask_raw, JSON.parse(data)[0], "f");
        }
        catch (jsonError) {
            // TODO: should restart exiftool?
            (0, batch_cluster_1.logger)().warn("ExifTool.ReadTask(): Invalid JSON", {
                data,
                err,
                jsonError,
            });
            throw err !== null && err !== void 0 ? err : jsonError;
        }
        // ExifTool does "humorous" things to paths, like flip path separators. resolve() undoes that.
        const SourceFile = _path.resolve(__classPrivateFieldGet(this, _ReadTask_raw, "f").SourceFile);
        // Sanity check that the result is for the file we want:
        if (SourceFile !== this.sourceFile) {
            // Throw an error rather than add an errors string because this is *really* bad:
            throw new Error(`Internal error: unexpected SourceFile of ${__classPrivateFieldGet(this, _ReadTask_raw, "f").SourceFile} for file ${this.sourceFile}`);
        }
        return __classPrivateFieldGet(this, _ReadTask_instances, "m", _ReadTask_parseTags).call(this);
    }
}
exports.ReadTask = ReadTask;
_ReadTask_raw = new WeakMap(), _ReadTask_rawDegrouped = new WeakMap(), _ReadTask_tags = new WeakMap(), _ReadTask_lat = new WeakMap(), _ReadTask_lon = new WeakMap(), _ReadTask_extractTzOffsetFromGps = new WeakMap(), _ReadTask_extractGpsMetadata = new WeakMap(), _ReadTask_tz = new WeakMap(), _ReadTask_extractTzOffset = new WeakMap(), _ReadTask_instances = new WeakSet(), _ReadTask_isVideo = function _ReadTask_isVideo() {
    var _a;
    return String((_a = __classPrivateFieldGet(this, _ReadTask_rawDegrouped, "f")) === null || _a === void 0 ? void 0 : _a.MIMEType).startsWith("video/");
}, _ReadTask_defaultToUTC = function _ReadTask_defaultToUTC() {
    return __classPrivateFieldGet(this, _ReadTask_instances, "m", _ReadTask_isVideo).call(this) && this.options.defaultVideosToUTC;
}, _ReadTask_tagName = function _ReadTask_tagName(k) {
    var _a;
    return this.degroup ? ((_a = k.split(":")[1]) !== null && _a !== void 0 ? _a : k) : k;
}, _ReadTask_parseTags = function _ReadTask_parseTags() {
    if (this.degroup) {
        __classPrivateFieldSet(this, _ReadTask_rawDegrouped, {}, "f");
        for (const [key, value] of Object.entries(__classPrivateFieldGet(this, _ReadTask_raw, "f"))) {
            const k = __classPrivateFieldGet(this, _ReadTask_instances, "m", _ReadTask_tagName).call(this, key);
            __classPrivateFieldGet(this, _ReadTask_rawDegrouped, "f")[k] = value;
        }
    }
    else {
        __classPrivateFieldSet(this, _ReadTask_rawDegrouped, __classPrivateFieldGet(this, _ReadTask_raw, "f"), "f");
    }
    // avoid casting `this.tags as any` for the rest of the function:
    const tags = __classPrivateFieldGet(this, _ReadTask_tags, "f");
    const tzSrc = __classPrivateFieldGet(this, _ReadTask_extractTzOffset, "f").call(this);
    if (tzSrc) {
        tags.tz = tzSrc.tz;
        tags.tzSource = tzSrc.src;
    }
    for (const [key, value] of Object.entries(__classPrivateFieldGet(this, _ReadTask_raw, "f"))) {
        const k = __classPrivateFieldGet(this, _ReadTask_instances, "m", _ReadTask_tagName).call(this, key);
        const v = __classPrivateFieldGet(this, _ReadTask_instances, "m", _ReadTask_parseTag).call(this, k, value);
        // Note that we set `key` (which may include a group prefix):
        tags[key] = v;
    }
    // we could `return {...tags, ...errorsAndWarnings(this, tags)}` but tags is
    // a chonky monster, and we don't want to double the work for the poor
    // garbage collector.
    const { errors, warnings } = (0, ErrorsAndWarnings_1.errorsAndWarnings)(this, tags);
    tags.errors = errors;
    tags.warnings = warnings;
    return tags;
}, _ReadTask_parseLocation = function _ReadTask_parseLocation({ tagName, positiveRef, negativeRef, maxValid, }) {
    const tagValue = __classPrivateFieldGet(this, _ReadTask_rawDegrouped, "f")[tagName];
    const refKey = tagName + "Ref";
    const ref = __classPrivateFieldGet(this, _ReadTask_rawDegrouped, "f")[refKey];
    const result = (0, Number_1.toFloat)(tagValue);
    if (result == null) {
        return undefined;
    }
    else if (Math.abs(result) > maxValid) {
        this.warnings.push(`Invalid ${tagName}: ${JSON.stringify(tagValue)}`);
        return undefined;
    }
    else if ((0, String_1.blank)(ref)) {
        // Videos may not have a GPSLatitudeRef or GPSLongitudeRef: if this is the case, assume the given sign is correct.
        return result;
    }
    else {
        // See https://github.com/photostructure/exiftool-vendored.js/issues/165
        // and https://www.exiftool.org/TagNames/GPS.html
        const expectedPositive = ref.toUpperCase().startsWith(positiveRef) || ((0, Number_1.isNumber)(ref) && ref >= 0);
        const expectedNegative = ref.toUpperCase().startsWith(negativeRef) || ((0, Number_1.isNumber)(ref) && ref < 0);
        if (expectedPositive && result < 0) {
            this.warnings.push(`Invalid ${tagName} or ${refKey}: expected ${ref} ${tagName} > 0 but got ${result}`);
        }
        else if (expectedNegative && result > 0) {
            this.warnings.push(`Invalid ${tagName} or ${refKey}: expected ${ref} ${tagName} < 0 but got ${result}`);
        }
        return result;
    }
}, _ReadTask_parseTag = function _ReadTask_parseTag(tagName, value) {
    var _a, _b, _c;
    if (nullish(value))
        return undefined;
    try {
        if (PassthroughTags.indexOf(tagName) >= 0) {
            return value;
        }
        if (tagName === "GPSLatitude") {
            return __classPrivateFieldGet(this, _ReadTask_lat, "f").call(this);
        }
        if (tagName === "GPSLongitude") {
            return __classPrivateFieldGet(this, _ReadTask_lon, "f").call(this);
        }
        if (Array.isArray(value)) {
            return value.map((ea) => __classPrivateFieldGet(this, _ReadTask_instances, "m", _ReadTask_parseTag).call(this, tagName, ea));
        }
        if (typeof value === "object") {
            const result = {};
            for (const [k, v] of Object.entries(value)) {
                result[k] = __classPrivateFieldGet(this, _ReadTask_instances, "m", _ReadTask_parseTag).call(this, tagName + "." + k, v);
            }
            return result;
        }
        if (typeof value === "string") {
            const b = BinaryField_1.BinaryField.fromRawValue(value);
            if (b != null)
                return b;
            if (MaybeDateOrTimeRe.test(tagName) &&
                // Reject date/time keys that are "0" or "00" (found in Canon
                // SubSecTime values)
                !OnlyZerosRE_1.OnlyZerosRE.test(value)) {
                // if #defaultToUTC() is true, _we actually think zoneless
                // datestamps are all in UTC_, rather than being in `this.tz` (which
                // may be from GPS or other heuristics). See issue #153.
                const tz = isUtcTagName(tagName) || __classPrivateFieldGet(this, _ReadTask_instances, "m", _ReadTask_defaultToUTC).call(this)
                    ? "UTC"
                    : this.options.backfillTimezones
                        ? __classPrivateFieldGet(this, _ReadTask_tz, "f").call(this)
                        : undefined;
                // Time-only tags have "time" but not "date" in their name:
                const keyIncludesTime = /subsec|time/i.test(tagName);
                const keyIncludesDate = /date/i.test(tagName);
                const keyIncludesWhen = /when/i.test(tagName); // < ResourceEvent.When
                const result = (_c = (_b = (_a = (keyIncludesTime || keyIncludesDate || keyIncludesWhen
                    ? ExifDateTime_1.ExifDateTime.from(value, tz)
                    : undefined)) !== null && _a !== void 0 ? _a : (keyIncludesTime || keyIncludesWhen
                    ? ExifTime_1.ExifTime.fromEXIF(value, tz)
                    : undefined)) !== null && _b !== void 0 ? _b : (keyIncludesDate || keyIncludesWhen
                    ? ExifDate_1.ExifDate.from(value)
                    : undefined)) !== null && _c !== void 0 ? _c : value;
                const defaultTz = __classPrivateFieldGet(this, _ReadTask_tz, "f").call(this);
                if (this.options.backfillTimezones &&
                    result != null &&
                    defaultTz != null &&
                    result instanceof ExifDateTime_1.ExifDateTime &&
                    __classPrivateFieldGet(this, _ReadTask_instances, "m", _ReadTask_defaultToUTC).call(this) &&
                    !isUtcTagName(tagName) &&
                    true === result.inferredZone) {
                    return result.setZone(defaultTz);
                }
                return result;
            }
        }
        // Trust that ExifTool rendered the value with the correct type in JSON:
        return value;
    }
    catch (e) {
        this.warnings.push(`Failed to parse ${tagName} with value ${JSON.stringify(value)}: ${e}`);
        return value;
    }
};
function isUtcTagName(tagName) {
    return tagName.includes("UTC") || tagName.startsWith("GPS");
}
//# sourceMappingURL=ReadTask.js.map