import { DateTime } from "luxon";
import { Maybe } from "./Maybe";
/**
 * Encodes an ExifDate
 */
export declare class ExifDate {
    readonly year: number;
    readonly month: number;
    readonly day: number;
    readonly rawValue?: string | undefined;
    static from(exifOrIso: string): Maybe<ExifDate>;
    static fromISO(text: string): Maybe<ExifDate>;
    private static fromPatterns;
    static fromExifStrict(text: string): Maybe<ExifDate>;
    static fromExifLoose(text: string): Maybe<ExifDate>;
    static fromEXIF(text: string): Maybe<ExifDate>;
    static fromDateTime(dt: DateTime, rawValue?: string): Maybe<ExifDate>;
    constructor(year: number, // full year (probably 2019-ish, but maybe Japanese 30-ish). See https://ericasadun.com/2018/12/25/iso-8601-yyyy-yyyy-and-why-your-year-may-be-wrong/
    month: number, // 1-12, (no crazy 0-11 nonsense from Date!)
    day: number, // 1-31
    rawValue?: string | undefined);
    toDate(): Date;
    /**
     * @param deltaMs defaults to 12 hours, so toMillis() is in the middle of the day.
     *
     * @return the epoch milliseconds for this day in UTC, plus `deltaMs` milliseconds.
     */
    toMillis(deltaMs?: number): number;
    toISOString(): string;
    toExifString(): string;
    toString(sep?: string): string;
    toJSON(): {
        _ctor: string;
        year: number;
        month: number;
        day: number;
        rawValue: string | undefined;
    };
    static fromJSON(json: ReturnType<ExifDate["toJSON"]>): ExifDate;
}
