import { ExifToolTask } from "./ExifToolTask";
export interface ErrorsAndWarnings {
    /**
     * This is a list of all critical errors raised by ExifTool during the read
     * process.
     */
    errors?: string[];
    /**
     * This is a list of all non-critical errors raised by ExifTool during the
     * read process.
     *
     * Invalid field values are considered warnings and not errors, for example.
     */
    warnings?: string[];
}
export declare function errorsAndWarnings(task: ExifToolTask<any>, t?: {
    Error?: string;
    Warning?: string;
}): Required<ErrorsAndWarnings>;
