"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.omit = exports.fromEntries = exports.orElse = exports.isFunction = exports.map = void 0;
/**
 * Only call and return the result of `f` if `obj` is defined (not null nor
 * undefined)
 */
function map(obj, f) {
    return obj != null ? f(obj) : undefined;
}
exports.map = map;
function isFunction(obj) {
    return typeof obj === "function";
}
exports.isFunction = isFunction;
function orElse(obj, defaultValue) {
    return obj != null
        ? obj
        : isFunction(defaultValue)
            ? defaultValue()
            : defaultValue;
}
exports.orElse = orElse;
function fromEntries(arr) {
    const o = {};
    for (const [key, value] of arr) {
        if (key != null) {
            o[key] = value;
        }
    }
    return o;
}
exports.fromEntries = fromEntries;
function omit(t, ...keysToOmit) {
    const result = { ...t };
    for (const ea of keysToOmit) {
        delete result[ea];
    }
    return result;
}
exports.omit = omit;
//# sourceMappingURL=Object.js.map