"use strict";
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var _Deferred_resolve, _Deferred_reject, _Deferred_state, _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Deferred = void 0;
/**
 * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Promise
 */
var State;
(function (State) {
    State[State["pending"] = 0] = "pending";
    State[State["fulfilled"] = 1] = "fulfilled";
    State[State["rejected"] = 2] = "rejected";
})(State || (State = {}));
/**
 * Enables a Promise to be resolved or rejected at a future time, outside of
 * the context of the Promise construction. Also exposes the `pending`,
 * `fulfilled`, or `rejected` state of the promise.
 */
class Deferred {
    constructor() {
        this[_a] = "Deferred";
        _Deferred_resolve.set(this, void 0);
        _Deferred_reject.set(this, void 0);
        _Deferred_state.set(this, State.pending);
        this.promise = new Promise((resolve, reject) => {
            __classPrivateFieldSet(this, _Deferred_resolve, resolve, "f");
            __classPrivateFieldSet(this, _Deferred_reject, reject, "f");
        });
    }
    /**
     * @return `true` iff neither `resolve` nor `rejected` have been invoked
     */
    get pending() {
        return __classPrivateFieldGet(this, _Deferred_state, "f") === State.pending;
    }
    /**
     * @return `true` iff `resolve` has been invoked
     */
    get fulfilled() {
        return __classPrivateFieldGet(this, _Deferred_state, "f") === State.fulfilled;
    }
    /**
     * @return `true` iff `rejected` has been invoked
     */
    get rejected() {
        return __classPrivateFieldGet(this, _Deferred_state, "f") === State.rejected;
    }
    /**
     * @return `true` iff `resolve` or `rejected` have been invoked
     */
    get settled() {
        return __classPrivateFieldGet(this, _Deferred_state, "f") !== State.pending;
    }
    then(onfulfilled, onrejected) {
        return this.promise.then(onfulfilled, onrejected);
    }
    catch(onrejected) {
        return this.promise.catch(onrejected);
    }
    resolve(value) {
        if (this.settled) {
            return false;
        }
        else {
            __classPrivateFieldSet(this, _Deferred_state, State.fulfilled, "f");
            __classPrivateFieldGet(this, _Deferred_resolve, "f").call(this, value);
            return true;
        }
    }
    reject(reason) {
        const wasSettled = this.settled;
        // This isn't great: the wrapped Promise may be in a different state than
        // #state: but the caller wanted to reject, so even if it already was
        // resolved, let's try to respect that.
        __classPrivateFieldSet(this, _Deferred_state, State.rejected, "f");
        if (wasSettled) {
            return false;
        }
        else {
            __classPrivateFieldGet(this, _Deferred_reject, "f").call(this, reason);
            return true;
        }
    }
    observe(p) {
        void observe(this, p);
        return this;
    }
    observeQuietly(p) {
        void observeQuietly(this, p);
        return this;
    }
}
exports.Deferred = Deferred;
_Deferred_resolve = new WeakMap(), _Deferred_reject = new WeakMap(), _Deferred_state = new WeakMap(), _a = Symbol.toStringTag;
async function observe(d, p) {
    try {
        d.resolve(await p);
    }
    catch (err) {
        d.reject(err);
    }
}
async function observeQuietly(d, p) {
    try {
        d.resolve(await p);
    }
    catch {
        d.resolve(undefined);
    }
}
//# sourceMappingURL=Deferred.js.map